/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.search.searches;

import com.intellij.openapi.application.DumbAwareSearchParameters;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.PsiSearchHelper;
import com.intellij.psi.search.QuerySearchRequest;
import com.intellij.psi.search.SearchRequestCollector;
import com.intellij.psi.search.SearchRequestQuery;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.SearchSession;
import com.intellij.psi.search.searches.ExtensibleQueryFactory;
import com.intellij.psi.search.searches.ReferenceDescriptor;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.MergeQuery;
import com.intellij.util.PairProcessor;
import com.intellij.util.Processor;
import com.intellij.util.Query;
import com.intellij.util.QueryExecutor;
import com.intellij.util.UniqueResultsQuery;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ReferencesSearch
extends ExtensibleQueryFactory<PsiReference, SearchParameters> {
    public static final ExtensionPointName<QueryExecutor<PsiReference, SearchParameters>> EP_NAME = ExtensionPointName.create("com.intellij.referencesSearch");
    private static final ReferencesSearch INSTANCE = new ReferencesSearch();

    private ReferencesSearch() {
        super(EP_NAME);
    }

    @NotNull
    public static Query<PsiReference> search(@NotNull PsiElement element) {
        if (element == null) {
            ReferencesSearch.$$$reportNull$$$0(0);
        }
        return ReferencesSearch.search(element, GlobalSearchScope.allScope(PsiUtilCore.getProjectInReadAction(element)), false);
    }

    @NotNull
    public static Query<PsiReference> search(@NotNull PsiElement element, @NotNull SearchScope searchScope) {
        if (element == null) {
            ReferencesSearch.$$$reportNull$$$0(1);
        }
        if (searchScope == null) {
            ReferencesSearch.$$$reportNull$$$0(2);
        }
        return ReferencesSearch.search(element, searchScope, false);
    }

    @NotNull
    public static Query<PsiReference> search(@NotNull PsiElement element, @NotNull SearchScope searchScope, boolean ignoreAccessScope) {
        if (element == null) {
            ReferencesSearch.$$$reportNull$$$0(3);
        }
        if (searchScope == null) {
            ReferencesSearch.$$$reportNull$$$0(4);
        }
        return ReferencesSearch.search(new SearchParameters(element, searchScope, ignoreAccessScope));
    }

    @NotNull
    public static Query<PsiReference> search(@NotNull SearchParameters parameters) {
        if (parameters == null) {
            ReferencesSearch.$$$reportNull$$$0(5);
        }
        Query result2 = INSTANCE.createQuery(parameters);
        if (parameters.isSharedOptimizer) {
            return ReferencesSearch.uniqueResults(result2);
        }
        SearchRequestCollector requests = parameters.getOptimizer();
        return ReferencesSearch.uniqueResults(new MergeQuery<PsiReference>(result2, new SearchRequestQuery(parameters.getProject(), requests)));
    }

    @NotNull
    private static Query<PsiReference> uniqueResults(@NotNull Query<? extends PsiReference> composite) {
        if (composite == null) {
            ReferencesSearch.$$$reportNull$$$0(6);
        }
        return new UniqueResultsQuery<PsiReference, ReferenceDescriptor>(composite, ReferenceDescriptor.MAPPER);
    }

    public static void searchOptimized(@NotNull PsiElement element, @NotNull SearchScope searchScope, boolean ignoreAccessScope, @NotNull SearchRequestCollector collector, @NotNull Processor<? super PsiReference> processor) {
        if (element == null) {
            ReferencesSearch.$$$reportNull$$$0(7);
        }
        if (searchScope == null) {
            ReferencesSearch.$$$reportNull$$$0(8);
        }
        if (collector == null) {
            ReferencesSearch.$$$reportNull$$$0(9);
        }
        if (processor == null) {
            ReferencesSearch.$$$reportNull$$$0(10);
        }
        ReferencesSearch.searchOptimized(element, searchScope, ignoreAccessScope, collector, false, (psiReference, collector1) -> processor.process((PsiReference)psiReference));
    }

    public static void searchOptimized(@NotNull PsiElement element, @NotNull SearchScope searchScope, boolean ignoreAccessScope, @NotNull SearchRequestCollector collector, boolean inReadAction, @NotNull PairProcessor<? super PsiReference, ? super SearchRequestCollector> processor) {
        if (element == null) {
            ReferencesSearch.$$$reportNull$$$0(11);
        }
        if (searchScope == null) {
            ReferencesSearch.$$$reportNull$$$0(12);
        }
        if (collector == null) {
            ReferencesSearch.$$$reportNull$$$0(13);
        }
        if (processor == null) {
            ReferencesSearch.$$$reportNull$$$0(14);
        }
        SearchRequestCollector nested = new SearchRequestCollector(collector.getSearchSession());
        Query<PsiReference> query = ReferencesSearch.search(new SearchParameters(element, searchScope, ignoreAccessScope, nested));
        collector.searchQuery(new QuerySearchRequest(query, nested, inReadAction, processor));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: 
            case 4: 
            case 8: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "searchScope";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "composite";
                break;
            }
            case 9: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "collector";
                break;
            }
            case 10: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
        }
        objectArray2[1] = "com/intellij/psi/search/searches/ReferencesSearch";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "search";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "uniqueResults";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[2] = "searchOptimized";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static class SearchParameters
    implements DumbAwareSearchParameters,
    com.intellij.model.search.SearchParameters<PsiReference> {
        private final PsiElement myElementToSearch;
        private final SearchScope myScope;
        private volatile SearchScope myEffectiveScope;
        private final boolean myIgnoreAccessScope;
        private final SearchRequestCollector myOptimizer;
        private final Project myProject;
        private final boolean isSharedOptimizer;

        public SearchParameters(@NotNull PsiElement elementToSearch, @NotNull SearchScope scope, boolean ignoreAccessScope, @Nullable SearchRequestCollector optimizer) {
            if (elementToSearch == null) {
                SearchParameters.$$$reportNull$$$0(0);
            }
            if (scope == null) {
                SearchParameters.$$$reportNull$$$0(1);
            }
            this.myElementToSearch = elementToSearch;
            this.myScope = scope;
            this.myIgnoreAccessScope = ignoreAccessScope;
            this.isSharedOptimizer = optimizer != null;
            this.myOptimizer = optimizer == null ? new SearchRequestCollector(new SearchSession(elementToSearch)) : optimizer;
            this.myProject = PsiUtilCore.getProjectInReadAction(elementToSearch);
        }

        public SearchParameters(@NotNull PsiElement elementToSearch, @NotNull SearchScope scope, boolean ignoreAccessScope) {
            if (elementToSearch == null) {
                SearchParameters.$$$reportNull$$$0(2);
            }
            if (scope == null) {
                SearchParameters.$$$reportNull$$$0(3);
            }
            this(elementToSearch, scope, ignoreAccessScope, null);
        }

        @Override
        public final boolean areValid() {
            return this.isQueryValid();
        }

        @Override
        public boolean isQueryValid() {
            return this.myElementToSearch.isValid();
        }

        @Override
        @NotNull
        public Project getProject() {
            Project project = this.myProject;
            if (project == null) {
                SearchParameters.$$$reportNull$$$0(4);
            }
            return project;
        }

        @NotNull
        public PsiElement getElementToSearch() {
            PsiElement psiElement = this.myElementToSearch;
            if (psiElement == null) {
                SearchParameters.$$$reportNull$$$0(5);
            }
            return psiElement;
        }

        public SearchScope getScopeDeterminedByUser() {
            return this.myScope;
        }

        @Deprecated(forRemoval=true)
        @NotNull
        public SearchScope getScope() {
            SearchScope searchScope = this.myScope;
            if (searchScope == null) {
                SearchParameters.$$$reportNull$$$0(6);
            }
            return searchScope;
        }

        public boolean isIgnoreAccessScope() {
            return this.myIgnoreAccessScope;
        }

        @NotNull
        public SearchRequestCollector getOptimizer() {
            SearchRequestCollector searchRequestCollector = this.myOptimizer;
            if (searchRequestCollector == null) {
                SearchParameters.$$$reportNull$$$0(7);
            }
            return searchRequestCollector;
        }

        @NotNull
        public SearchScope getEffectiveSearchScope() {
            if (this.myIgnoreAccessScope) {
                SearchScope searchScope = this.myScope;
                if (searchScope == null) {
                    SearchParameters.$$$reportNull$$$0(8);
                }
                return searchScope;
            }
            SearchScope scope = this.myEffectiveScope;
            if (scope == null) {
                if (!this.myElementToSearch.isValid()) {
                    LocalSearchScope localSearchScope = LocalSearchScope.EMPTY;
                    if (localSearchScope == null) {
                        SearchParameters.$$$reportNull$$$0(9);
                    }
                    return localSearchScope;
                }
                SearchScope useScope = PsiSearchHelper.getInstance(this.myElementToSearch.getProject()).getUseScope(this.myElementToSearch);
                this.myEffectiveScope = scope = this.myScope.intersectWith(useScope);
            }
            SearchScope searchScope = scope;
            if (searchScope == null) {
                SearchParameters.$$$reportNull$$$0(10);
            }
            return searchScope;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string2;
            switch (n) {
                default: {
                    string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: {
                    string2 = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "elementToSearch";
                    break;
                }
                case 1: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "scope";
                    break;
                }
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/psi/search/searches/ReferencesSearch$SearchParameters";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/psi/search/searches/ReferencesSearch$SearchParameters";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getProject";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getElementToSearch";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getScope";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getOptimizer";
                    break;
                }
                case 8: 
                case 9: 
                case 10: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getEffectiveSearchScope";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: {
                    break;
                }
            }
            String string3 = String.format(string2, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string3);
                    break;
                }
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: {
                    runtimeException = new IllegalStateException(string3);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

