/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.stubs;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.impl.DebugUtil;
import com.intellij.psi.stubs.SerializedStubTree;
import com.intellij.psi.stubs.SerializerNotFoundException;
import com.intellij.psi.stubs.StubIndex;
import com.intellij.psi.stubs.StubIndexEx;
import com.intellij.psi.stubs.StubIndexKey;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.indexing.FileBasedIndexEx;
import com.intellij.util.indexing.StorageException;
import com.intellij.util.indexing.impl.DirectInputDataDiffBuilder;
import com.intellij.util.indexing.impl.IndexDebugProperties;
import com.intellij.util.indexing.impl.KeyValueUpdateProcessor;
import com.intellij.util.indexing.impl.RemovedKeyProcessor;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class StubCumulativeInputDiffBuilder
extends DirectInputDataDiffBuilder<Integer, SerializedStubTree> {
    private static final Logger LOG = Logger.getInstance(SerializedStubTree.class);
    @Nullable
    private final SerializedStubTree myCurrentTree;

    StubCumulativeInputDiffBuilder(int inputId, @Nullable SerializedStubTree currentTree) {
        super(inputId);
        this.myCurrentTree = currentTree;
    }

    @Override
    public boolean differentiate(@NotNull Map<Integer, SerializedStubTree> newData, @NotNull KeyValueUpdateProcessor<? super Integer, ? super SerializedStubTree> addProcessor, @NotNull KeyValueUpdateProcessor<? super Integer, ? super SerializedStubTree> updateProcessor, @NotNull RemovedKeyProcessor<? super Integer> removeProcessor) throws StorageException {
        if (newData == null) {
            StubCumulativeInputDiffBuilder.$$$reportNull$$$0(0);
        }
        if (addProcessor == null) {
            StubCumulativeInputDiffBuilder.$$$reportNull$$$0(1);
        }
        if (updateProcessor == null) {
            StubCumulativeInputDiffBuilder.$$$reportNull$$$0(2);
        }
        if (removeProcessor == null) {
            StubCumulativeInputDiffBuilder.$$$reportNull$$$0(3);
        }
        if (!newData.isEmpty()) {
            SerializedStubTree newSerializedStubTree = newData.values().iterator().next();
            if (this.myCurrentTree != null) {
                if (StubCumulativeInputDiffBuilder.treesAreEqual(newSerializedStubTree, this.myCurrentTree)) {
                    return false;
                }
                removeProcessor.process((Integer)this.myInputId, this.myInputId);
            }
            addProcessor.process((Integer)this.myInputId, newSerializedStubTree, this.myInputId);
            this.updateStubIndices(newSerializedStubTree);
        } else {
            removeProcessor.process((Integer)this.myInputId, this.myInputId);
            this.updateStubIndices(null);
        }
        return true;
    }

    @Nullable
    SerializedStubTree getSerializedStubTree() {
        return this.myCurrentTree;
    }

    @Override
    @NotNull
    public Collection<Integer> getKeys() {
        Set<Integer> set = this.myCurrentTree != null ? Collections.singleton(this.myInputId) : Collections.emptySet();
        if (set == null) {
            StubCumulativeInputDiffBuilder.$$$reportNull$$$0(4);
        }
        return set;
    }

    private static boolean treesAreEqual(@NotNull SerializedStubTree newSerializedStubTree, @NotNull SerializedStubTree currentTree) {
        if (newSerializedStubTree == null) {
            StubCumulativeInputDiffBuilder.$$$reportNull$$$0(5);
        }
        if (currentTree == null) {
            StubCumulativeInputDiffBuilder.$$$reportNull$$$0(6);
        }
        return Arrays.equals(currentTree.getTreeHash(), newSerializedStubTree.getTreeHash()) && StubCumulativeInputDiffBuilder.treesAreReallyEqual(newSerializedStubTree, currentTree);
    }

    private static boolean treesAreReallyEqual(@NotNull SerializedStubTree newSerializedStubTree, @NotNull SerializedStubTree currentTree) {
        if (newSerializedStubTree == null) {
            StubCumulativeInputDiffBuilder.$$$reportNull$$$0(7);
        }
        if (currentTree == null) {
            StubCumulativeInputDiffBuilder.$$$reportNull$$$0(8);
        }
        if (newSerializedStubTree.equals(currentTree)) {
            return true;
        }
        if (IndexDebugProperties.DEBUG) {
            StubCumulativeInputDiffBuilder.reportStubTreeHashCollision(newSerializedStubTree, currentTree);
        }
        return false;
    }

    private void updateStubIndices(@Nullable SerializedStubTree newTree) {
        try {
            Map oldForwardIndex = this.myCurrentTree == null ? Collections.emptyMap() : this.myCurrentTree.getStubIndicesValueMap();
            Map<Object, Object> newForwardIndex = newTree == null ? Collections.emptyMap() : newTree.getStubIndicesValueMap();
            Set<Object> affectedIndexes = ContainerUtil.union(oldForwardIndex.keySet(), newForwardIndex.keySet());
            StubIndexEx stubIndex = (StubIndexEx)StubIndex.getInstance();
            if (FileBasedIndexEx.DO_TRACE_STUB_INDEX_UPDATE) {
                stubIndex.getLogger().info("stub indexes " + (newTree == null ? "deletion" : "update") + ": file = " + this.myInputId + " indexes " + affectedIndexes);
            }
            for (StubIndexKey stubIndexKey : affectedIndexes) {
                Set oldKeys = oldForwardIndex.getOrDefault(stubIndexKey, Collections.emptyMap()).keySet();
                Set newKeys = newForwardIndex.getOrDefault(stubIndexKey, Collections.emptyMap()).keySet();
                stubIndex.updateIndex(stubIndexKey, this.myInputId, oldKeys, newKeys);
            }
        }
        catch (ProcessCanceledException e) {
            LOG.error("ProcessCanceledException is not expected here", e);
            throw e;
        }
    }

    private static void reportStubTreeHashCollision(@NotNull SerializedStubTree newTree, @NotNull SerializedStubTree existingTree) {
        if (newTree == null) {
            StubCumulativeInputDiffBuilder.$$$reportNull$$$0(9);
        }
        if (existingTree == null) {
            StubCumulativeInputDiffBuilder.$$$reportNull$$$0(10);
        }
        String oldTreeDump = "\nexisting tree " + StubCumulativeInputDiffBuilder.dumpStub(existingTree);
        String newTreeDump = "\nnew tree " + StubCumulativeInputDiffBuilder.dumpStub(newTree);
        byte[] hash = newTree.getTreeHash();
        LOG.info("Stub tree hashing collision. Different trees have the same hash = " + StringUtil.toHexString(hash) + ". " + oldTreeDump + newTreeDump, new Exception());
    }

    @NotNull
    private static String dumpStub(@NotNull SerializedStubTree tree) {
        String deserialized;
        if (tree == null) {
            StubCumulativeInputDiffBuilder.$$$reportNull$$$0(11);
        }
        try {
            deserialized = "stub: " + DebugUtil.stubTreeToString(tree.getStub());
        }
        catch (SerializerNotFoundException e) {
            LOG.error(e);
            deserialized = "error while stub deserialization: " + e.getMessage();
        }
        String string2 = deserialized + "\n bytes: " + StringUtil.toHexString(tree.myTreeBytes);
        if (string2 == null) {
            StubCumulativeInputDiffBuilder.$$$reportNull$$$0(12);
        }
        return string2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 12: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 12: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newData";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "addProcessor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "updateProcessor";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "removeProcessor";
                break;
            }
            case 4: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/stubs/StubCumulativeInputDiffBuilder";
                break;
            }
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newSerializedStubTree";
                break;
            }
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "currentTree";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newTree";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "existingTree";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tree";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/stubs/StubCumulativeInputDiffBuilder";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getKeys";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "dumpStub";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "differentiate";
                break;
            }
            case 4: 
            case 12: {
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "treesAreEqual";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "treesAreReallyEqual";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "reportStubTreeHashCollision";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "dumpStub";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 4: 
            case 12: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

