/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.openapi.util.Couple;
import java.awt.Color;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;

public final class MixedColorProducer
implements Supplier<Color> {
    private final Couple<Color> couple;
    private double mixer;
    private Color cached;
    private int argb0;
    private int argb1;

    public MixedColorProducer(@NotNull Color color0, @NotNull Color color1) {
        if (color0 == null) {
            MixedColorProducer.$$$reportNull$$$0(0);
        }
        if (color1 == null) {
            MixedColorProducer.$$$reportNull$$$0(1);
        }
        this.couple = Couple.of(color0, color1);
    }

    public MixedColorProducer(@NotNull Color color0, @NotNull Color color1, double mixer) {
        if (color0 == null) {
            MixedColorProducer.$$$reportNull$$$0(2);
        }
        if (color1 == null) {
            MixedColorProducer.$$$reportNull$$$0(3);
        }
        this(color0, color1);
        this.setMixer(mixer);
    }

    public void setMixer(double value) {
        if (Double.isNaN(value) || value < 0.0 || 1.0 < value) {
            throw new IllegalArgumentException("mixer[0..1] is " + value);
        }
        if (this.mixer != value) {
            this.mixer = value;
            this.cached = null;
        }
    }

    private void updateFirstARGB() {
        int value = ((Color)this.couple.first).getRGB();
        if (this.argb0 != value) {
            this.argb0 = value;
            this.cached = null;
        }
    }

    private void updateSecondARGB() {
        int value = ((Color)this.couple.second).getRGB();
        if (this.argb1 != value) {
            this.argb1 = value;
            this.cached = null;
        }
    }

    private int mix(int pos) {
        int value0 = 0xFF & this.argb0 >> pos;
        int value1 = 0xFF & this.argb1 >> pos;
        if (value0 == value1) {
            return value0;
        }
        return value0 + (int)Math.round(this.mixer * (double)(value1 - value0));
    }

    @NotNull
    public Color produce(double mixer) {
        this.setMixer(mixer);
        Color color = this.get();
        if (color == null) {
            MixedColorProducer.$$$reportNull$$$0(4);
        }
        return color;
    }

    @Override
    @NotNull
    public Color get() {
        if (this.mixer <= 0.0) {
            Color color = (Color)this.couple.first;
            if (color == null) {
                MixedColorProducer.$$$reportNull$$$0(5);
            }
            return color;
        }
        if (this.mixer >= 1.0) {
            Color color = (Color)this.couple.second;
            if (color == null) {
                MixedColorProducer.$$$reportNull$$$0(6);
            }
            return color;
        }
        this.updateFirstARGB();
        this.updateSecondARGB();
        if (this.cached == null) {
            this.cached = new Color(this.mix(16), this.mix(8), this.mix(0), this.mix(24));
        }
        Color color = this.cached;
        if (color == null) {
            MixedColorProducer.$$$reportNull$$$0(7);
        }
        return color;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "color0";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "color1";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ui/MixedColorProducer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ui/MixedColorProducer";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "produce";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "get";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

