/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.ui.scale.ScaleType;
import com.intellij.ui.scale.UserScaleContext;
import com.intellij.util.IconUtil;
import com.intellij.util.ui.JBCachingScalableIcon;
import java.awt.Component;
import java.awt.Graphics;
import java.util.Objects;
import javax.swing.Icon;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public final class OffsetIcon
extends JBCachingScalableIcon<OffsetIcon> {
    public static final int REGULAR_OFFSET = 20;
    private int myWidth;
    private int myHeight;
    private final int myOffset;
    private final Icon myIcon;
    private Icon myScaledIcon;
    private int myScaledOffset;

    @Contract(value="null->null;!null->!null")
    public static Icon getOriginalIcon(Icon icon2) {
        return icon2 instanceof OffsetIcon ? ((OffsetIcon)icon2).myIcon : icon2;
    }

    public OffsetIcon(@NotNull Icon icon2) {
        if (icon2 == null) {
            OffsetIcon.$$$reportNull$$$0(0);
        }
        this(20, icon2);
    }

    public OffsetIcon(int offset, @NotNull Icon icon2) {
        if (icon2 == null) {
            OffsetIcon.$$$reportNull$$$0(1);
        }
        ((UserScaleContext)this.getScaleContext()).addUpdateListener(this::updateSize);
        this.setAutoUpdateScaleContext(false);
        this.myOffset = offset;
        this.myIcon = icon2;
        this.updateSize();
    }

    private OffsetIcon(@NotNull OffsetIcon icon2) {
        if (icon2 == null) {
            OffsetIcon.$$$reportNull$$$0(2);
        }
        super(icon2);
        ((UserScaleContext)this.getScaleContext()).addUpdateListener(this::updateSize);
        this.setAutoUpdateScaleContext(false);
        this.myWidth = icon2.myWidth;
        this.myHeight = icon2.myHeight;
        this.myOffset = icon2.myOffset;
        this.myIcon = icon2.myIcon;
        this.myScaledIcon = null;
        this.myScaledOffset = icon2.myScaledOffset;
    }

    @Override
    @NotNull
    public OffsetIcon copy() {
        return new OffsetIcon(this);
    }

    @NotNull
    public Icon getIcon() {
        Icon icon2 = this.myIcon;
        if (icon2 == null) {
            OffsetIcon.$$$reportNull$$$0(3);
        }
        return icon2;
    }

    public int hashCode() {
        return this.myOffset + this.myIcon.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof OffsetIcon) {
            OffsetIcon icon2 = (OffsetIcon)obj;
            return icon2.myOffset == this.myOffset && Objects.equals(icon2.myIcon, this.myIcon);
        }
        return false;
    }

    @Override
    public void paintIcon(Component c, Graphics g, int x, int y) {
        ((UserScaleContext)this.getScaleContext()).update();
        if (this.myScaledIcon == null) {
            float scale = this.getScale();
            this.myScaledIcon = scale == 1.0f ? this.myIcon : IconUtil.scale(this.myIcon, null, scale);
        }
        this.myScaledIcon.paintIcon(c, g, this.myScaledOffset + x, y);
    }

    @Override
    public int getIconWidth() {
        ((UserScaleContext)this.getScaleContext()).update();
        return (int)Math.ceil(this.scaleVal((double)this.myWidth, ScaleType.OBJ_SCALE)) + this.myScaledOffset;
    }

    @Override
    public int getIconHeight() {
        ((UserScaleContext)this.getScaleContext()).update();
        return (int)Math.ceil(this.scaleVal((double)this.myHeight, ScaleType.OBJ_SCALE));
    }

    private void updateSize() {
        this.myWidth = this.myIcon.getIconWidth();
        this.myHeight = this.myIcon.getIconHeight();
        this.myScaledOffset = (int)Math.ceil(this.scaleVal(this.myOffset));
    }

    @Override
    public String toString() {
        return "OffsetIcon: offset=" + this.myOffset + "; icon=" + this.myIcon;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "icon";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ui/OffsetIcon";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ui/OffsetIcon";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getIcon";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 3: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

