/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.ui.ColoredText;
import com.intellij.ui.ColoredTextContainer;
import com.intellij.ui.SimpleTextAttributes;
import java.util.ArrayList;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class SimpleColoredText
implements ColoredTextContainer {
    private final ArrayList<@Nls String> myTexts;
    private final ArrayList<SimpleTextAttributes> myAttributes;
    @NlsSafe
    private String myCachedToString;

    public SimpleColoredText() {
        this.myCachedToString = null;
        this.myTexts = new ArrayList(3);
        this.myAttributes = new ArrayList(3);
    }

    public SimpleColoredText(@NotNull @NlsContexts.Label String fragment, @NotNull SimpleTextAttributes attributes) {
        if (fragment == null) {
            SimpleColoredText.$$$reportNull$$$0(0);
        }
        if (attributes == null) {
            SimpleColoredText.$$$reportNull$$$0(1);
        }
        this();
        this.append(fragment, attributes);
    }

    @Override
    public void append(@NotNull @Nls String fragment, @NotNull SimpleTextAttributes attributes) {
        if (fragment == null) {
            SimpleColoredText.$$$reportNull$$$0(2);
        }
        if (attributes == null) {
            SimpleColoredText.$$$reportNull$$$0(3);
        }
        this.myTexts.add(fragment);
        this.myCachedToString = null;
        this.myAttributes.add(attributes);
    }

    public void insert(int index2, @NotNull @Nls String fragment, @NotNull SimpleTextAttributes attributes) {
        if (fragment == null) {
            SimpleColoredText.$$$reportNull$$$0(4);
        }
        if (attributes == null) {
            SimpleColoredText.$$$reportNull$$$0(5);
        }
        this.myTexts.add(index2, fragment);
        this.myCachedToString = null;
        this.myAttributes.add(index2, attributes);
    }

    public void clear() {
        this.myTexts.clear();
        this.myCachedToString = null;
        this.myAttributes.clear();
    }

    public void appendToComponent(@NotNull ColoredTextContainer component) {
        if (component == null) {
            SimpleColoredText.$$$reportNull$$$0(6);
        }
        int size = this.myTexts.size();
        for (int i = 0; i < size; ++i) {
            String text = this.myTexts.get(i);
            SimpleTextAttributes attribute = this.myAttributes.get(i);
            component.append(text, attribute);
        }
    }

    @Nls
    public String toString() {
        if (this.myCachedToString == null) {
            this.myCachedToString = String.join((CharSequence)"", this.myTexts);
        }
        return this.myCachedToString;
    }

    public ArrayList<@Nls String> getTexts() {
        return this.myTexts;
    }

    public ArrayList<SimpleTextAttributes> getAttributes() {
        return this.myAttributes;
    }

    public SimpleColoredText derive(SimpleTextAttributes attributes, boolean override) {
        SimpleColoredText result2 = new SimpleColoredText();
        for (int i = 0; i < this.myTexts.size(); ++i) {
            SimpleTextAttributes overridden = override ? SimpleTextAttributes.merge(this.myAttributes.get(i), attributes) : SimpleTextAttributes.merge(attributes, this.myAttributes.get(i));
            result2.append(this.myTexts.get(i), overridden);
        }
        return result2;
    }

    @NotNull
    public ColoredText toColoredText() {
        if (this.myTexts.isEmpty()) {
            ColoredText coloredText = ColoredText.empty();
            if (coloredText == null) {
                SimpleColoredText.$$$reportNull$$$0(7);
            }
            return coloredText;
        }
        if (this.myTexts.size() == 1) {
            ColoredText coloredText = ColoredText.singleFragment(this.myTexts.get(0), this.myAttributes.get(0));
            if (coloredText == null) {
                SimpleColoredText.$$$reportNull$$$0(8);
            }
            return coloredText;
        }
        ColoredText.Builder builder = ColoredText.builder();
        for (int i = 0; i < this.myTexts.size(); ++i) {
            builder.append(this.myTexts.get(i), this.myAttributes.get(i));
        }
        ColoredText coloredText = builder.build();
        if (coloredText == null) {
            SimpleColoredText.$$$reportNull$$$0(9);
        }
        return coloredText;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fragment";
                break;
            }
            case 1: 
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attributes";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ui/SimpleColoredText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ui/SimpleColoredText";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "toColoredText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "append";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "insert";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "appendToComponent";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

