/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.workspaceModel.storage.impl;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.workspaceModel.storage.EntitySource;
import com.intellij.workspaceModel.storage.WorkspaceEntity;
import com.intellij.workspaceModel.storage.impl.ChangeEntry;
import com.intellij.workspaceModel.storage.impl.ChildEntityId;
import com.intellij.workspaceModel.storage.impl.ConnectionId;
import com.intellij.workspaceModel.storage.impl.EntityIdKt;
import com.intellij.workspaceModel.storage.impl.ParentEntityId;
import com.intellij.workspaceModel.storage.impl.WorkspaceEntityData;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\b\u0006\u0018\u0000 32\u00020\u0001:\u00013B\u0005\u00a2\u0006\u0002\u0010\u0002J1\u0010\u0010\u001a\u00020\u0011\"\b\b\u0000\u0010\u0012*\u00020\u00132\n\u0010\u0014\u001a\u00060\u0005j\u0002`\u00062\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u0002H\u00120\u0016H\u0000\u00a2\u0006\u0002\b\u0017J9\u0010\u0018\u001a\u00020\u0011\"\b\b\u0000\u0010\u0012*\u00020\u00132\n\u0010\u0019\u001a\u00060\u0005j\u0002`\u00062\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u0002H\u00120\u00162\u0006\u0010\u001b\u001a\u00020\u001cH\u0000\u00a2\u0006\u0002\b\u001dJ;\u0010\u001e\u001a\u00020\u00112\n\u0010\u001f\u001a\u00060\u0005j\u0002`\u00062\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00130\u00162\u0012\u0010!\u001a\u000e\u0012\u0004\u0012\u00020#\u0012\u0004\u0012\u00020$0\"H\u0000\u00a2\u0006\u0002\b%J\u0097\u0001\u0010&\u001a\u00020\u00112\n\u0010\u0019\u001a\u00060\u0005j\u0002`\u00062\u000e\u0010\u001a\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00130\u00162\u000e\u0010'\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00130\u00162\u0012\u0010(\u001a\u000e\u0012\u0004\u0012\u00020#\u0012\u0004\u0012\u00020$0\"2\u0018\u0010)\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020#\u0012\u0004\u0012\u00020,0+0*2\u0018\u0010-\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020#\u0012\u0004\u0012\u00020,0+0.2\u0014\u0010/\u001a\u0010\u0012\u0004\u0012\u00020#\u0012\u0006\u0012\u0004\u0018\u00010$0\"H\u0000\u00a2\u0006\u0002\b0J\r\u00101\u001a\u00020\u0011H\u0000\u00a2\u0006\u0002\b2R(\u0010\u0003\u001a\u0016\u0012\b\u0012\u00060\u0005j\u0002`\u0006\u0012\u0004\u0012\u00020\u00070\u0004j\u0002`\bX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u001a\u0010\u000b\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000f\u00a8\u00064"}, d2={"Lcom/intellij/workspaceModel/storage/impl/WorkspaceBuilderChangeLog;", "", "()V", "changeLog", "", "", "Lcom/intellij/workspaceModel/storage/impl/EntityId;", "Lcom/intellij/workspaceModel/storage/impl/ChangeEntry;", "Lcom/intellij/workspaceModel/storage/impl/ChangeLog;", "getChangeLog$intellij_platform_workspaceModel_storage", "()Ljava/util/Map;", "modificationCount", "getModificationCount", "()J", "setModificationCount", "(J)V", "addAddEvent", "", "T", "Lcom/intellij/workspaceModel/storage/WorkspaceEntity;", "pid", "pEntityData", "Lcom/intellij/workspaceModel/storage/impl/WorkspaceEntityData;", "addAddEvent$intellij_platform_workspaceModel_storage", "addChangeSourceEvent", "entityId", "copiedData", "originalSource", "Lcom/intellij/workspaceModel/storage/EntitySource;", "addChangeSourceEvent$intellij_platform_workspaceModel_storage", "addRemoveEvent", "removedEntityId", "originalData", "oldParents", "", "Lcom/intellij/workspaceModel/storage/impl/ConnectionId;", "Lcom/intellij/workspaceModel/storage/impl/ParentEntityId;", "addRemoveEvent$intellij_platform_workspaceModel_storage", "addReplaceEvent", "originalEntity", "originalParents", "addedChildren", "", "Lkotlin/Pair;", "Lcom/intellij/workspaceModel/storage/impl/ChildEntityId;", "removedChildren", "", "parentsMapRes", "addReplaceEvent$intellij_platform_workspaceModel_storage", "clear", "clear$intellij_platform_workspaceModel_storage", "Companion", "intellij.platform.workspaceModel.storage"})
public final class WorkspaceBuilderChangeLog {
    private long modificationCount;
    @NotNull
    private final Map<Long, ChangeEntry> changeLog = new LinkedHashMap();
    @NotNull
    private static final Logger LOG;
    @NotNull
    public static final Companion Companion;

    public final long getModificationCount() {
        return this.modificationCount;
    }

    public final void setModificationCount(long l) {
        this.modificationCount = l;
    }

    @NotNull
    public final Map<Long, ChangeEntry> getChangeLog$intellij_platform_workspaceModel_storage() {
        return this.changeLog;
    }

    public final void clear$intellij_platform_workspaceModel_storage() {
        long l = this.modificationCount;
        this.modificationCount = l + 1L;
        this.changeLog.clear();
    }

    public final void addReplaceEvent$intellij_platform_workspaceModel_storage(long entityId, @NotNull WorkspaceEntityData<? extends WorkspaceEntity> copiedData, @NotNull WorkspaceEntityData<? extends WorkspaceEntity> originalEntity, @NotNull Map<ConnectionId, ParentEntityId> originalParents, @NotNull List<Pair<ConnectionId, ChildEntityId>> addedChildren, @NotNull Set<Pair<ConnectionId, ChildEntityId>> removedChildren, @NotNull Map<ConnectionId, ParentEntityId> parentsMapRes) {
        Intrinsics.checkNotNullParameter(copiedData, (String)"copiedData");
        Intrinsics.checkNotNullParameter(originalEntity, (String)"originalEntity");
        Intrinsics.checkNotNullParameter(originalParents, (String)"originalParents");
        Intrinsics.checkNotNullParameter(addedChildren, (String)"addedChildren");
        Intrinsics.checkNotNullParameter(removedChildren, (String)"removedChildren");
        Intrinsics.checkNotNullParameter(parentsMapRes, (String)"parentsMapRes");
        long l = this.modificationCount;
        this.modificationCount = l + 1L;
        ChangeEntry existingChange = this.changeLog.get(entityId);
        ChangeEntry.ReplaceEntity replaceEvent = new ChangeEntry.ReplaceEntity(originalEntity, originalParents, copiedData, addedChildren, CollectionsKt.toList((Iterable)removedChildren), parentsMapRes);
        Function1 makeReplaceEvent2 = (Function1)new Function1<ChangeEntry.ReplaceEntity, ChangeEntry.ReplaceEntity>(addedChildren, removedChildren, parentsMapRes, originalParents, originalEntity, copiedData){
            final /* synthetic */ List $addedChildren;
            final /* synthetic */ Set $removedChildren;
            final /* synthetic */ Map $parentsMapRes;
            final /* synthetic */ Map $originalParents;
            final /* synthetic */ WorkspaceEntityData $originalEntity;
            final /* synthetic */ WorkspaceEntityData $copiedData;

            /*
             * WARNING - void declaration
             */
            @Nullable
            public final ChangeEntry.ReplaceEntity invoke(@NotNull ChangeEntry.ReplaceEntity replaceEntity) {
                Intrinsics.checkNotNullParameter((Object)replaceEntity, (String)"replaceEntity");
                Set addedChildrenSet = CollectionsKt.toSet((Iterable)this.$addedChildren);
                List newAddedChildren = CollectionsKt.toList((Iterable)SetsKt.plus((Set)SetsKt.minus((Set)CollectionsKt.toSet((Iterable)replaceEntity.getNewChildren()), (Iterable)this.$removedChildren), (Iterable)SetsKt.minus((Set)addedChildrenSet, (Iterable)CollectionsKt.toSet((Iterable)replaceEntity.getRemovedChildren()))));
                List newRemovedChildren = CollectionsKt.toList((Iterable)SetsKt.plus((Set)SetsKt.minus((Set)CollectionsKt.toSet((Iterable)replaceEntity.getRemovedChildren()), (Iterable)addedChildrenSet), (Iterable)SetsKt.minus((Set)this.$removedChildren, (Iterable)CollectionsKt.toSet((Iterable)replaceEntity.getNewChildren()))));
                Map newChangedParents = MapsKt.toMutableMap((Map)MapsKt.plus(replaceEntity.getModifiedParents(), (Map)this.$parentsMapRes));
                Map $this$forEach$iv = this.$originalParents;
                boolean $i$f$forEach = false;
                Iterator<Map.Entry<K, V>> iterator = $this$forEach$iv.entrySet().iterator();
                while (iterator.hasNext()) {
                    void key;
                    Map.Entry<K, V> element$iv;
                    Map.Entry<K, V> $dstr$key$value = element$iv = iterator.next();
                    boolean bl = false;
                    Map.Entry<K, V> entry = $dstr$key$value;
                    ConnectionId connectionId = (ConnectionId)entry.getKey();
                    entry = $dstr$key$value;
                    ParentEntityId value = (ParentEntityId)entry.getValue();
                    newChangedParents.remove(key, value);
                }
                return this.$originalEntity.equalsIgnoringEntitySource(this.$copiedData) && newAddedChildren.isEmpty() && newRemovedChildren.isEmpty() && newChangedParents.isEmpty() ? null : new ChangeEntry.ReplaceEntity(this.$originalEntity, this.$originalParents, this.$copiedData, newAddedChildren, newRemovedChildren, newChangedParents);
            }
            {
                this.$addedChildren = list;
                this.$removedChildren = set;
                this.$parentsMapRes = map2;
                this.$originalParents = map3;
                this.$originalEntity = workspaceEntityData;
                this.$copiedData = workspaceEntityData2;
                super(1);
            }
        };
        if (existingChange == null) {
            if (!(originalEntity.equalsIgnoringEntitySource(copiedData) && addedChildren.isEmpty() && removedChildren.isEmpty() && parentsMapRes.isEmpty())) {
                this.changeLog.put(entityId, replaceEvent);
            }
        } else {
            Unit unit;
            ChangeEntry changeEntry = existingChange;
            if (changeEntry instanceof ChangeEntry.AddEntity) {
                this.changeLog.put(entityId, new ChangeEntry.AddEntity(copiedData, EntityIdKt.getClazz(entityId)));
                unit = Unit.INSTANCE;
            } else if (changeEntry instanceof ChangeEntry.RemoveEntity) {
                LOG.error("Trying to update removed entity. Skip change event. " + copiedData);
                unit = Unit.INSTANCE;
            } else if (changeEntry instanceof ChangeEntry.ChangeEntitySource) {
                this.changeLog.put(entityId, ChangeEntry.ReplaceAndChangeSource.Companion.from(replaceEvent, (ChangeEntry.ChangeEntitySource)existingChange));
                unit = Unit.INSTANCE;
            } else if (changeEntry instanceof ChangeEntry.ReplaceEntity) {
                ChangeEntry.ReplaceEntity event = (ChangeEntry.ReplaceEntity)makeReplaceEvent2.invoke((Object)existingChange);
                if (event != null) {
                    this.changeLog.put(entityId, event);
                } else {
                    this.changeLog.remove(entityId);
                }
                unit = Unit.INSTANCE;
            } else if (changeEntry instanceof ChangeEntry.ReplaceAndChangeSource) {
                ChangeEntry.ReplaceEntity newReplaceEvent = (ChangeEntry.ReplaceEntity)makeReplaceEvent2.invoke((Object)((ChangeEntry.ReplaceAndChangeSource)existingChange).getDataChange());
                if (newReplaceEvent != null) {
                    this.changeLog.put(entityId, ChangeEntry.ReplaceAndChangeSource.Companion.from(newReplaceEvent, ((ChangeEntry.ReplaceAndChangeSource)existingChange).getSourceChange()));
                    unit = Unit.INSTANCE;
                } else {
                    this.changeLog.put(entityId, ((ChangeEntry.ReplaceAndChangeSource)existingChange).getSourceChange());
                    unit = Unit.INSTANCE;
                }
            } else {
                throw new NoWhenBranchMatchedException();
            }
            ChangeEntry it = changeEntry = unit;
            boolean bl = false;
        }
    }

    public final <T extends WorkspaceEntity> void addAddEvent$intellij_platform_workspaceModel_storage(long pid, @NotNull WorkspaceEntityData<T> pEntityData) {
        Intrinsics.checkNotNullParameter(pEntityData, (String)"pEntityData");
        long l = this.modificationCount;
        this.modificationCount = l + 1L;
        this.changeLog.put(pid, new ChangeEntry.AddEntity(pEntityData, EntityIdKt.getClazz(pid)));
    }

    public final <T extends WorkspaceEntity> void addChangeSourceEvent$intellij_platform_workspaceModel_storage(long entityId, @NotNull WorkspaceEntityData<T> copiedData, @NotNull EntitySource originalSource) {
        Intrinsics.checkNotNullParameter(copiedData, (String)"copiedData");
        Intrinsics.checkNotNullParameter((Object)originalSource, (String)"originalSource");
        long l = this.modificationCount;
        this.modificationCount = l + 1L;
        ChangeEntry existingChange = this.changeLog.get(entityId);
        ChangeEntry.ChangeEntitySource changeSourceEvent = new ChangeEntry.ChangeEntitySource(originalSource, copiedData);
        if (existingChange == null) {
            if (Intrinsics.areEqual((Object)copiedData.getEntitySource(), (Object)originalSource) ^ true) {
                this.changeLog.put(entityId, changeSourceEvent);
            }
        } else {
            Unit unit;
            ChangeEntry changeEntry = existingChange;
            if (changeEntry instanceof ChangeEntry.AddEntity) {
                this.changeLog.put(entityId, new ChangeEntry.AddEntity(copiedData, EntityIdKt.getClazz(entityId)));
                unit = Unit.INSTANCE;
            } else if (changeEntry instanceof ChangeEntry.RemoveEntity) {
                LOG.error("Trying to update removed entity. Skip change event. " + copiedData);
                unit = Unit.INSTANCE;
            } else if (changeEntry instanceof ChangeEntry.ChangeEntitySource) {
                if (Intrinsics.areEqual((Object)copiedData.getEntitySource(), (Object)originalSource) ^ true) {
                    this.changeLog.put(entityId, changeSourceEvent);
                } else {
                    this.changeLog.remove(entityId);
                }
                unit = Unit.INSTANCE;
            } else if (changeEntry instanceof ChangeEntry.ReplaceEntity) {
                if (Intrinsics.areEqual((Object)copiedData.getEntitySource(), (Object)originalSource) ^ true) {
                    this.changeLog.put(entityId, ChangeEntry.ReplaceAndChangeSource.Companion.from((ChangeEntry.ReplaceEntity)existingChange, changeSourceEvent));
                }
                unit = Unit.INSTANCE;
            } else if (changeEntry instanceof ChangeEntry.ReplaceAndChangeSource) {
                if (Intrinsics.areEqual((Object)copiedData.getEntitySource(), (Object)originalSource) ^ true) {
                    this.changeLog.put(entityId, ChangeEntry.ReplaceAndChangeSource.Companion.from(((ChangeEntry.ReplaceAndChangeSource)existingChange).getDataChange(), changeSourceEvent));
                    unit = Unit.INSTANCE;
                } else {
                    this.changeLog.put(entityId, ((ChangeEntry.ReplaceAndChangeSource)existingChange).getDataChange());
                    unit = Unit.INSTANCE;
                }
            } else {
                throw new NoWhenBranchMatchedException();
            }
            ChangeEntry it = changeEntry = unit;
            boolean bl = false;
        }
    }

    public final void addRemoveEvent$intellij_platform_workspaceModel_storage(long removedEntityId, @NotNull WorkspaceEntityData<WorkspaceEntity> originalData, @NotNull Map<ConnectionId, ParentEntityId> oldParents) {
        Intrinsics.checkNotNullParameter(originalData, (String)"originalData");
        Intrinsics.checkNotNullParameter(oldParents, (String)"oldParents");
        long l = this.modificationCount;
        this.modificationCount = l + 1L;
        ChangeEntry existingChange = this.changeLog.get(removedEntityId);
        ChangeEntry.RemoveEntity removeEvent = new ChangeEntry.RemoveEntity(originalData, oldParents, removedEntityId);
        if (existingChange == null) {
            this.changeLog.put(removedEntityId, removeEvent);
        } else {
            ChangeEntry changeEntry = existingChange;
            if (changeEntry instanceof ChangeEntry.AddEntity) {
                this.changeLog.remove(removedEntityId);
            } else if (changeEntry instanceof ChangeEntry.ChangeEntitySource) {
                this.changeLog.put(removedEntityId, removeEvent);
            } else if (changeEntry instanceof ChangeEntry.ReplaceEntity) {
                this.changeLog.put(removedEntityId, removeEvent);
            } else if (changeEntry instanceof ChangeEntry.ReplaceAndChangeSource) {
                this.changeLog.put(removedEntityId, removeEvent);
            } else if (!(changeEntry instanceof ChangeEntry.RemoveEntity)) {
                // empty if block
            }
        }
    }

    static {
        Companion = new Companion(null);
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(WorkspaceBuilderChangeLog.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"Logger.getInstance(T::class.java)");
        LOG = logger;
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/intellij/workspaceModel/storage/impl/WorkspaceBuilderChangeLog$Companion;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "getLOG", "()Lcom/intellij/openapi/diagnostic/Logger;", "intellij.platform.workspaceModel.storage"})
    public static final class Companion {
        @NotNull
        public final Logger getLOG() {
            return LOG;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

