/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight;

import com.intellij.codeInsight.TailType;
import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.openapi.editor.Editor;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class CharTailType
extends TailType {
    private final char myChar;
    private final boolean myOverwrite;

    public CharTailType(char aChar) {
        this(aChar, true);
    }

    public CharTailType(char aChar, boolean overwrite) {
        this.myChar = aChar;
        this.myOverwrite = overwrite;
    }

    @Override
    public boolean isApplicable(@NotNull InsertionContext context2) {
        if (context2 == null) {
            CharTailType.$$$reportNull$$$0(0);
        }
        return !context2.shouldAddCompletionChar() || context2.getCompletionChar() != this.myChar;
    }

    @Override
    public int processTail(Editor editor, int tailOffset) {
        return CharTailType.insertChar(editor, tailOffset, this.myChar, this.myOverwrite);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CharTailType)) {
            return false;
        }
        CharTailType that = (CharTailType)o;
        return this.myChar == that.myChar;
    }

    public int hashCode() {
        return this.myChar;
    }

    @NonNls
    public String toString() {
        return "CharTailType:'" + this.myChar + "'";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/codeInsight/CharTailType", "isApplicable"));
    }
}

