/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.completion;

import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementDecorator;
import com.intellij.openapi.util.ClassConditionKey;

public final class PrioritizedLookupElement<T extends LookupElement>
extends LookupElementDecorator<T> {
    public static final ClassConditionKey<PrioritizedLookupElement> CLASS_CONDITION_KEY = ClassConditionKey.create(PrioritizedLookupElement.class);
    private final double myPriority;
    private final int myExplicitProximity;
    private final int myGrouping;

    private PrioritizedLookupElement(T delegate2, double priority, int explicitProximity, int grouping) {
        super(delegate2);
        this.myPriority = priority;
        this.myExplicitProximity = explicitProximity;
        this.myGrouping = grouping;
    }

    public double getPriority() {
        return this.myPriority;
    }

    public int getGrouping() {
        return this.myGrouping;
    }

    public int getExplicitProximity() {
        return this.myExplicitProximity;
    }

    public static LookupElement withPriority(LookupElement element, double priority) {
        PrioritizedLookupElement prioritized = element.as(CLASS_CONDITION_KEY);
        LookupElement finalElement = prioritized != element ? element : prioritized.getDelegate();
        int proximity = prioritized == null ? 0 : prioritized.getExplicitProximity();
        int grouping = prioritized == null ? 0 : prioritized.getGrouping();
        return new PrioritizedLookupElement<LookupElement>(finalElement, priority, proximity, grouping);
    }

    public static LookupElement withGrouping(LookupElement element, int grouping) {
        PrioritizedLookupElement prioritized = element.as(CLASS_CONDITION_KEY);
        LookupElement finalElement = prioritized != element ? element : prioritized.getDelegate();
        double priority = prioritized == null ? 0.0 : prioritized.getPriority();
        int proximity = prioritized == null ? 0 : prioritized.getExplicitProximity();
        return new PrioritizedLookupElement<LookupElement>(finalElement, priority, proximity, grouping);
    }

    public static LookupElement withExplicitProximity(LookupElement element, int explicitProximity) {
        PrioritizedLookupElement prioritized = element.as(CLASS_CONDITION_KEY);
        double priority = prioritized == null ? 0.0 : prioritized.getPriority();
        int grouping = prioritized == null ? 0 : prioritized.getGrouping();
        LookupElement finalElement = prioritized != element ? element : prioritized.getDelegate();
        return new PrioritizedLookupElement<LookupElement>(finalElement, priority, explicitProximity, grouping);
    }
}

