/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl;

import com.intellij.codeInsight.daemon.HighlightDisplayKey;
import com.intellij.codeInsight.daemon.impl.AnnotationHolderImpl;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.LocalQuickFixAsIntentionAdapter;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.diagnostic.PluginException;
import com.intellij.lang.ASTNode;
import com.intellij.lang.annotation.Annotation;
import com.intellij.lang.annotation.AnnotationBuilder;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.lang.annotation.ProblemGroup;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ex.ApplicationManagerEx;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.editor.markup.GutterIconRenderer;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.objectTree.ThrowableInterner;
import com.intellij.psi.PsiElement;
import com.intellij.xml.util.XmlStringUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

class B
implements AnnotationBuilder {
    @NotNull
    private final AnnotationHolderImpl myHolder;
    @Nls
    private final String message;
    @NotNull
    private final PsiElement myCurrentElement;
    @NotNull
    private final Object myCurrentAnnotator;
    @NotNull
    private final HighlightSeverity severity;
    private TextRange range;
    private Boolean afterEndOfLine;
    private Boolean fileLevel;
    private GutterIconRenderer gutterIconRenderer;
    private ProblemGroup problemGroup;
    private TextAttributes enforcedAttributes;
    private TextAttributesKey textAttributesKey;
    private ProblemHighlightType highlightType;
    private Boolean needsUpdateOnTyping;
    private @NlsContexts.Tooltip String tooltip;
    private List<FixB> fixes;
    private boolean created;
    private final Throwable myDebugCreationPlace;

    B(@NotNull AnnotationHolderImpl holder, @NotNull HighlightSeverity severity, @Nls String message2, @NotNull PsiElement currentElement, @NotNull Object currentAnnotator) {
        if (holder == null) {
            B.$$$reportNull$$$0(0);
        }
        if (severity == null) {
            B.$$$reportNull$$$0(1);
        }
        if (currentElement == null) {
            B.$$$reportNull$$$0(2);
        }
        if (currentAnnotator == null) {
            B.$$$reportNull$$$0(3);
        }
        this.myHolder = holder;
        this.severity = severity;
        this.message = message2;
        this.myCurrentElement = currentElement;
        this.myCurrentAnnotator = currentAnnotator;
        holder.annotationBuilderCreated(this);
        Application app = ApplicationManager.getApplication();
        this.myDebugCreationPlace = app.isUnitTestMode() && !ApplicationManagerEx.isInStressTest() || app.isInternal() ? ThrowableInterner.intern(new Throwable()) : null;
    }

    private void assertNotSet(Object o, String description) {
        if (o != null) {
            this.markNotAbandoned();
            throw new IllegalStateException(description + " was set already");
        }
    }

    private void markNotAbandoned() {
        this.created = true;
    }

    @Override
    @NotNull
    public AnnotationBuilder withFix(@NotNull IntentionAction fix) {
        if (fix == null) {
            B.$$$reportNull$$$0(4);
        }
        AnnotationBuilder annotationBuilder = this.newFix(fix).registerFix();
        if (annotationBuilder == null) {
            B.$$$reportNull$$$0(5);
        }
        return annotationBuilder;
    }

    @Override
    @NotNull
    public AnnotationBuilder.FixBuilder newFix(@NotNull IntentionAction fix) {
        if (fix == null) {
            B.$$$reportNull$$$0(6);
        }
        return new FixB(fix);
    }

    @Override
    @NotNull
    public AnnotationBuilder.FixBuilder newLocalQuickFix(@NotNull LocalQuickFix fix, @NotNull ProblemDescriptor problemDescriptor) {
        if (fix == null) {
            B.$$$reportNull$$$0(7);
        }
        if (problemDescriptor == null) {
            B.$$$reportNull$$$0(8);
        }
        return new FixB(new LocalQuickFixAsIntentionAdapter(fix, problemDescriptor));
    }

    @Override
    @NotNull
    public AnnotationBuilder range(@NotNull TextRange range) {
        if (range == null) {
            B.$$$reportNull$$$0(9);
        }
        this.assertNotSet(this.range, "range");
        TextRange currentElementRange = this.myCurrentElement.getTextRange();
        if (!currentElementRange.contains(range)) {
            this.markNotAbandoned();
            String message2 = "Range must be inside element being annotated: " + currentElementRange + "; but got: " + range;
            throw PluginException.createByClass(message2, null, this.myCurrentElement.getClass());
        }
        this.range = range;
        B b = this;
        if (b == null) {
            B.$$$reportNull$$$0(10);
        }
        return b;
    }

    @Override
    @NotNull
    public AnnotationBuilder range(@NotNull ASTNode element) {
        if (element == null) {
            B.$$$reportNull$$$0(11);
        }
        AnnotationBuilder annotationBuilder = this.range(element.getTextRange());
        if (annotationBuilder == null) {
            B.$$$reportNull$$$0(12);
        }
        return annotationBuilder;
    }

    @Override
    @NotNull
    public AnnotationBuilder range(@NotNull PsiElement element) {
        if (element == null) {
            B.$$$reportNull$$$0(13);
        }
        AnnotationBuilder annotationBuilder = this.range(element.getTextRange());
        if (annotationBuilder == null) {
            B.$$$reportNull$$$0(14);
        }
        return annotationBuilder;
    }

    @Override
    @NotNull
    public AnnotationBuilder afterEndOfLine() {
        this.assertNotSet(this.afterEndOfLine, "afterEndOfLine");
        this.afterEndOfLine = true;
        B b = this;
        if (b == null) {
            B.$$$reportNull$$$0(15);
        }
        return b;
    }

    @Override
    @NotNull
    public AnnotationBuilder fileLevel() {
        this.assertNotSet(this.fileLevel, "fileLevel");
        this.fileLevel = true;
        B b = this;
        if (b == null) {
            B.$$$reportNull$$$0(16);
        }
        return b;
    }

    @Override
    @NotNull
    public AnnotationBuilder gutterIconRenderer(@NotNull GutterIconRenderer gutterIconRenderer) {
        if (gutterIconRenderer == null) {
            B.$$$reportNull$$$0(17);
        }
        this.assertNotSet(this.gutterIconRenderer, "gutterIconRenderer");
        this.gutterIconRenderer = gutterIconRenderer;
        B b = this;
        if (b == null) {
            B.$$$reportNull$$$0(18);
        }
        return b;
    }

    @Override
    @NotNull
    public AnnotationBuilder problemGroup(@NotNull ProblemGroup problemGroup) {
        if (problemGroup == null) {
            B.$$$reportNull$$$0(19);
        }
        this.assertNotSet(this.problemGroup, "problemGroup");
        this.problemGroup = problemGroup;
        B b = this;
        if (b == null) {
            B.$$$reportNull$$$0(20);
        }
        return b;
    }

    @Override
    @NotNull
    public AnnotationBuilder enforcedTextAttributes(@NotNull TextAttributes enforcedAttributes) {
        if (enforcedAttributes == null) {
            B.$$$reportNull$$$0(21);
        }
        this.assertNotSet(this.enforcedAttributes, "enforcedAttributes");
        this.enforcedAttributes = enforcedAttributes;
        B b = this;
        if (b == null) {
            B.$$$reportNull$$$0(22);
        }
        return b;
    }

    @Override
    @NotNull
    public AnnotationBuilder textAttributes(@NotNull TextAttributesKey textAttributes) {
        if (textAttributes == null) {
            B.$$$reportNull$$$0(23);
        }
        this.assertNotSet(this.textAttributesKey, "textAttributes");
        this.textAttributesKey = textAttributes;
        B b = this;
        if (b == null) {
            B.$$$reportNull$$$0(24);
        }
        return b;
    }

    @Override
    @NotNull
    public AnnotationBuilder highlightType(@NotNull ProblemHighlightType highlightType) {
        if (highlightType == null) {
            B.$$$reportNull$$$0(25);
        }
        this.assertNotSet((Object)this.highlightType, "highlightType");
        this.highlightType = highlightType;
        B b = this;
        if (b == null) {
            B.$$$reportNull$$$0(26);
        }
        return b;
    }

    @Override
    @NotNull
    public AnnotationBuilder needsUpdateOnTyping() {
        AnnotationBuilder annotationBuilder = this.needsUpdateOnTyping(true);
        if (annotationBuilder == null) {
            B.$$$reportNull$$$0(27);
        }
        return annotationBuilder;
    }

    @Override
    @NotNull
    public AnnotationBuilder needsUpdateOnTyping(boolean value) {
        this.assertNotSet(this.needsUpdateOnTyping, "needsUpdateOnTyping");
        this.needsUpdateOnTyping = value;
        B b = this;
        if (b == null) {
            B.$$$reportNull$$$0(28);
        }
        return b;
    }

    @Override
    @NotNull
    public AnnotationBuilder tooltip(@NotNull String tooltip) {
        if (tooltip == null) {
            B.$$$reportNull$$$0(29);
        }
        this.assertNotSet(this.tooltip, "tooltip");
        this.tooltip = tooltip;
        B b = this;
        if (b == null) {
            B.$$$reportNull$$$0(30);
        }
        return b;
    }

    @Override
    public void create() {
        if (this.created) {
            throw new IllegalStateException("Must not call .create() twice");
        }
        this.created = true;
        if (this.range == null) {
            this.range = this.myCurrentElement.getTextRange();
        }
        if (this.tooltip == null && this.message != null) {
            this.tooltip = XmlStringUtil.wrapInHtml(XmlStringUtil.escapeString(this.message));
        }
        Annotation annotation = new Annotation(this.range.getStartOffset(), this.range.getEndOffset(), this.severity, this.message, this.tooltip);
        if (this.needsUpdateOnTyping != null) {
            annotation.setNeedsUpdateOnTyping(this.needsUpdateOnTyping);
        }
        if (this.highlightType != null) {
            annotation.setHighlightType(this.highlightType);
        }
        if (this.textAttributesKey != null) {
            annotation.setTextAttributes(this.textAttributesKey);
        }
        if (this.enforcedAttributes != null) {
            annotation.setEnforcedTextAttributes(this.enforcedAttributes);
        }
        if (this.problemGroup != null) {
            annotation.setProblemGroup(this.problemGroup);
        }
        if (this.gutterIconRenderer != null) {
            annotation.setGutterIconRenderer(this.gutterIconRenderer);
        }
        if (this.fileLevel != null) {
            annotation.setFileLevelAnnotation(this.fileLevel);
        }
        if (this.afterEndOfLine != null) {
            annotation.setAfterEndOfLine(this.afterEndOfLine);
        }
        if (this.fixes != null) {
            for (FixB fb : this.fixes) {
                TextRange finalRange;
                IntentionAction fix = fb.fix;
                TextRange textRange = finalRange = fb.range == null ? this.range : fb.range;
                if (fb.batch != null && fb.batch.booleanValue()) {
                    B.registerBatchFix(annotation, fix, finalRange, fb.key);
                    continue;
                }
                if (fb.universal != null && fb.universal.booleanValue()) {
                    B.registerBatchFix(annotation, fix, finalRange, fb.key);
                    annotation.registerFix(fix, finalRange, fb.key);
                    continue;
                }
                annotation.registerFix(fix, finalRange, fb.key);
            }
        }
        this.myHolder.add(annotation);
        this.myHolder.queueToUpdateIncrementally();
        this.myHolder.annotationCreatedFrom(this);
    }

    private static <T extends IntentionAction & LocalQuickFix> void registerBatchFix(@NotNull Annotation annotation, @NotNull Object fix, @NotNull TextRange range, HighlightDisplayKey key) {
        if (annotation == null) {
            B.$$$reportNull$$$0(31);
        }
        if (fix == null) {
            B.$$$reportNull$$$0(32);
        }
        if (range == null) {
            B.$$$reportNull$$$0(33);
        }
        annotation.registerBatchFix((IntentionAction)fix, range, key);
    }

    void assertAnnotationCreated() {
        if (!this.created) {
            throw new IllegalStateException("Abandoned AnnotationBuilder - its 'create()' method was never called: " + this + (this.myDebugCreationPlace == null ? "" : "\nSee cause for the AnnotationBuilder creation stacktrace"), this.myDebugCreationPlace);
        }
    }

    @NotNull
    private static String omitIfEmpty(Object o, String name) {
        Object object = o == null ? "" : ", " + name + "=" + o;
        if (object == null) {
            B.$$$reportNull$$$0(34);
        }
        return object;
    }

    public String toString() {
        return "Builder{message='" + this.message + "', myCurrentElement=" + this.myCurrentElement + " (" + this.myCurrentElement.getClass() + "), myCurrentAnnotator=" + this.myCurrentAnnotator + ", severity=" + this.severity + ", range=" + (Serializable)(this.range == null ? "(implicit)" + this.myCurrentElement.getTextRange() : this.range) + B.omitIfEmpty(this.afterEndOfLine, "afterEndOfLine") + B.omitIfEmpty(this.fileLevel, "fileLevel") + B.omitIfEmpty(this.gutterIconRenderer, "gutterIconRenderer") + B.omitIfEmpty(this.problemGroup, "problemGroup") + B.omitIfEmpty(this.enforcedAttributes, "enforcedAttributes") + B.omitIfEmpty(this.textAttributesKey, "textAttributesKey") + B.omitIfEmpty((Object)this.highlightType, "highlightType") + B.omitIfEmpty(this.needsUpdateOnTyping, "needsUpdateOnTyping") + B.omitIfEmpty(this.tooltip, "tooltip") + B.omitIfEmpty(this.fixes, "fixes") + "}";
    }

    @Override
    public Annotation createAnnotation() {
        PluginException.reportDeprecatedUsage("AnnotationBuilder#createAnnotation", "Use `#create()` instead");
        if (this.range == null) {
            this.range = this.myCurrentElement.getTextRange();
        }
        if (this.tooltip == null && this.message != null) {
            this.tooltip = XmlStringUtil.wrapInHtml(XmlStringUtil.escapeString(this.message));
        }
        Annotation annotation = new Annotation(this.range.getStartOffset(), this.range.getEndOffset(), this.severity, this.message, this.tooltip);
        if (this.needsUpdateOnTyping != null) {
            annotation.setNeedsUpdateOnTyping(this.needsUpdateOnTyping);
        }
        if (this.highlightType != null) {
            annotation.setHighlightType(this.highlightType);
        }
        if (this.textAttributesKey != null) {
            annotation.setTextAttributes(this.textAttributesKey);
        }
        if (this.enforcedAttributes != null) {
            annotation.setEnforcedTextAttributes(this.enforcedAttributes);
        }
        if (this.problemGroup != null) {
            annotation.setProblemGroup(this.problemGroup);
        }
        if (this.gutterIconRenderer != null) {
            annotation.setGutterIconRenderer(this.gutterIconRenderer);
        }
        if (this.fileLevel != null) {
            annotation.setFileLevelAnnotation(this.fileLevel);
        }
        if (this.afterEndOfLine != null) {
            annotation.setAfterEndOfLine(this.afterEndOfLine);
        }
        if (this.fixes != null) {
            for (FixB fb : this.fixes) {
                TextRange finalRange;
                IntentionAction fix = fb.fix;
                TextRange textRange = finalRange = fb.range == null ? this.range : fb.range;
                if (fb.batch != null && fb.batch.booleanValue()) {
                    B.registerBatchFix(annotation, fix, finalRange, fb.key);
                    continue;
                }
                if (fb.universal != null && fb.universal.booleanValue()) {
                    B.registerBatchFix(annotation, fix, finalRange, fb.key);
                    annotation.registerFix(fix, finalRange, fb.key);
                    continue;
                }
                annotation.registerFix(fix, finalRange, fb.key);
            }
        }
        this.myHolder.add(annotation);
        this.myHolder.annotationCreatedFrom(this);
        return annotation;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 10: 
            case 12: 
            case 14: 
            case 15: 
            case 16: 
            case 18: 
            case 20: 
            case 22: 
            case 24: 
            case 26: 
            case 27: 
            case 28: 
            case 30: 
            case 34: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 10: 
            case 12: 
            case 14: 
            case 15: 
            case 16: 
            case 18: 
            case 20: 
            case 22: 
            case 24: 
            case 26: 
            case 27: 
            case 28: 
            case 30: 
            case 34: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "severity";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "currentElement";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "currentAnnotator";
                break;
            }
            case 4: 
            case 6: 
            case 7: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fix";
                break;
            }
            case 5: 
            case 10: 
            case 12: 
            case 14: 
            case 15: 
            case 16: 
            case 18: 
            case 20: 
            case 22: 
            case 24: 
            case 26: 
            case 27: 
            case 28: 
            case 30: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/daemon/impl/B";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "problemDescriptor";
                break;
            }
            case 9: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "range";
                break;
            }
            case 11: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "gutterIconRenderer";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "problemGroup";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "enforcedAttributes";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "textAttributes";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "highlightType";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tooltip";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "annotation";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/daemon/impl/B";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "withFix";
                break;
            }
            case 10: 
            case 12: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "range";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "afterEndOfLine";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "fileLevel";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "gutterIconRenderer";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "problemGroup";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "enforcedTextAttributes";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "textAttributes";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "highlightType";
                break;
            }
            case 27: 
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "needsUpdateOnTyping";
                break;
            }
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "tooltip";
                break;
            }
            case 34: {
                objectArray = objectArray2;
                objectArray2[1] = "omitIfEmpty";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "withFix";
                break;
            }
            case 5: 
            case 10: 
            case 12: 
            case 14: 
            case 15: 
            case 16: 
            case 18: 
            case 20: 
            case 22: 
            case 24: 
            case 26: 
            case 27: 
            case 28: 
            case 30: 
            case 34: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "newFix";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "newLocalQuickFix";
                break;
            }
            case 9: 
            case 11: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "range";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "gutterIconRenderer";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "problemGroup";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "enforcedTextAttributes";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "textAttributes";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "highlightType";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "tooltip";
                break;
            }
            case 31: 
            case 32: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "registerBatchFix";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 5: 
            case 10: 
            case 12: 
            case 14: 
            case 15: 
            case 16: 
            case 18: 
            case 20: 
            case 22: 
            case 24: 
            case 26: 
            case 27: 
            case 28: 
            case 30: 
            case 34: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }

    private class FixB
    implements AnnotationBuilder.FixBuilder {
        @NotNull
        IntentionAction fix;
        TextRange range;
        HighlightDisplayKey key;
        Boolean batch;
        Boolean universal;

        FixB(IntentionAction fix) {
            if (fix == null) {
                FixB.$$$reportNull$$$0(0);
            }
            this.fix = fix;
        }

        @Override
        @NotNull
        public AnnotationBuilder.FixBuilder range(@NotNull TextRange range) {
            if (range == null) {
                FixB.$$$reportNull$$$0(1);
            }
            B.this.assertNotSet(this.range, "range");
            this.range = range;
            FixB fixB = this;
            if (fixB == null) {
                FixB.$$$reportNull$$$0(2);
            }
            return fixB;
        }

        @Override
        @NotNull
        public AnnotationBuilder.FixBuilder key(@NotNull HighlightDisplayKey key) {
            if (key == null) {
                FixB.$$$reportNull$$$0(3);
            }
            B.this.assertNotSet(this.key, "key");
            this.key = key;
            FixB fixB = this;
            if (fixB == null) {
                FixB.$$$reportNull$$$0(4);
            }
            return fixB;
        }

        @Override
        @NotNull
        public AnnotationBuilder.FixBuilder batch() {
            B.this.assertNotSet(this.universal, "universal");
            B.this.assertNotSet(this.batch, "batch");
            this.assertLQF();
            this.batch = true;
            FixB fixB = this;
            if (fixB == null) {
                FixB.$$$reportNull$$$0(5);
            }
            return fixB;
        }

        private void assertLQF() {
            if (!(this.fix instanceof LocalQuickFix) && !(this.fix instanceof LocalQuickFixAsIntentionAdapter)) {
                B.this.markNotAbandoned();
                throw new IllegalArgumentException("Fix " + this.fix + " must be instance of LocalQuickFix to be registered as batch");
            }
        }

        @Override
        @NotNull
        public AnnotationBuilder.FixBuilder universal() {
            B.this.assertNotSet(this.universal, "universal");
            B.this.assertNotSet(this.batch, "batch");
            this.assertLQF();
            this.universal = true;
            FixB fixB = this;
            if (fixB == null) {
                FixB.$$$reportNull$$$0(6);
            }
            return fixB;
        }

        @Override
        @NotNull
        public AnnotationBuilder registerFix() {
            if (B.this.fixes == null) {
                B.this.fixes = new ArrayList<FixB>();
            }
            B.this.fixes.add(this);
            B b = B.this;
            if (b == null) {
                FixB.$$$reportNull$$$0(7);
            }
            return b;
        }

        public String toString() {
            return this.fix + (String)(this.range == null ? "" : " at " + this.range) + (this.batch == null ? "" : " batch") + (this.universal == null ? "" : " universal");
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string2;
            switch (n) {
                default: {
                    string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    string2 = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "fix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "range";
                    break;
                }
                case 2: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInsight/daemon/impl/B$FixB";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "key";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInsight/daemon/impl/B$FixB";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "range";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "key";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "batch";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "universal";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "registerFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "range";
                    break;
                }
                case 2: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "key";
                    break;
                }
            }
            String string3 = String.format(string2, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string3);
                    break;
                }
                case 2: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    runtimeException = new IllegalStateException(string3);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

