/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl;

import com.intellij.codeHighlighting.BackgroundEditorHighlighter;
import com.intellij.codeHighlighting.TextEditorHighlightingPass;
import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.codeInsight.daemon.impl.TextEditorHighlightingPassRegistrarEx;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiCompiledFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.PsiDocumentManagerBase;
import com.intellij.psi.impl.PsiFileEx;
import com.intellij.util.ArrayUtilRt;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TextEditorBackgroundHighlighter
implements BackgroundEditorHighlighter {
    private static final Logger LOG = Logger.getInstance(TextEditorBackgroundHighlighter.class);
    private static final int[] IGNORE_FOR_COMPILED = new int[]{1, 3, 7, 12, 8};
    private final Project myProject;
    private final Editor myEditor;
    private final Document myDocument;

    public TextEditorBackgroundHighlighter(@NotNull Project project, @NotNull Editor editor) {
        if (project == null) {
            TextEditorBackgroundHighlighter.$$$reportNull$$$0(0);
        }
        if (editor == null) {
            TextEditorBackgroundHighlighter.$$$reportNull$$$0(1);
        }
        this.myProject = project;
        this.myEditor = editor;
        this.myDocument = this.myEditor.getDocument();
    }

    @Nullable
    private PsiFile renewFile() {
        PsiFile file2 = PsiDocumentManager.getInstance(this.myProject).getPsiFile(this.myDocument);
        if (file2 != null) {
            file2.putUserData(PsiFileEx.BATCH_REFERENCE_PROCESSING, Boolean.TRUE);
        }
        return file2;
    }

    @NotNull
    List<TextEditorHighlightingPass> getPasses(int @NotNull [] passesToIgnore) {
        PsiFile file2;
        if (passesToIgnore == null) {
            TextEditorBackgroundHighlighter.$$$reportNull$$$0(2);
        }
        if (this.myProject.isDisposed()) {
            List<TextEditorHighlightingPass> list = Collections.emptyList();
            if (list == null) {
                TextEditorBackgroundHighlighter.$$$reportNull$$$0(3);
            }
            return list;
        }
        PsiDocumentManagerBase documentManager = (PsiDocumentManagerBase)PsiDocumentManager.getInstance(this.myProject);
        if (!documentManager.isCommitted(this.myDocument)) {
            LOG.error(this.myDocument + "; " + documentManager.someDocumentDebugInfo(this.myDocument));
        }
        if ((file2 = this.renewFile()) == null) {
            List<TextEditorHighlightingPass> list = Collections.emptyList();
            if (list == null) {
                TextEditorBackgroundHighlighter.$$$reportNull$$$0(4);
            }
            return list;
        }
        boolean compiled = file2 instanceof PsiCompiledFile;
        if (compiled) {
            file2 = ((PsiCompiledFile)file2).getDecompiledPsiFile();
            passesToIgnore = IGNORE_FOR_COMPILED;
        } else if (!DaemonCodeAnalyzer.getInstance(this.myProject).isHighlightingAvailable(file2)) {
            List<TextEditorHighlightingPass> list = Collections.emptyList();
            if (list == null) {
                TextEditorBackgroundHighlighter.$$$reportNull$$$0(5);
            }
            return list;
        }
        TextEditorHighlightingPassRegistrarEx passRegistrar = TextEditorHighlightingPassRegistrarEx.getInstanceEx(this.myProject);
        List<TextEditorHighlightingPass> list = passRegistrar.instantiatePasses(file2, this.myEditor, passesToIgnore);
        if (list == null) {
            TextEditorBackgroundHighlighter.$$$reportNull$$$0(6);
        }
        return list;
    }

    public TextEditorHighlightingPass @NotNull [] createPassesForEditor() {
        List<TextEditorHighlightingPass> passes = this.getPasses(ArrayUtilRt.EMPTY_INT_ARRAY);
        TextEditorHighlightingPass[] textEditorHighlightingPassArray = passes.isEmpty() ? TextEditorHighlightingPass.EMPTY_ARRAY : passes.toArray(TextEditorHighlightingPass.EMPTY_ARRAY);
        if (textEditorHighlightingPassArray == null) {
            TextEditorBackgroundHighlighter.$$$reportNull$$$0(7);
        }
        return textEditorHighlightingPassArray;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "passesToIgnore";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/daemon/impl/TextEditorBackgroundHighlighter";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/daemon/impl/TextEditorBackgroundHighlighter";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getPasses";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "createPassesForEditor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getPasses";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

