/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.template.impl;

import com.intellij.codeInsight.template.Expression;
import com.intellij.codeInsight.template.Template;
import com.intellij.codeInsight.template.impl.MacroCallNode;
import com.intellij.codeInsight.template.impl.TemplateBase;
import com.intellij.codeInsight.template.impl.TemplateContext;
import com.intellij.codeInsight.template.impl.TemplateOptionalProcessor;
import com.intellij.codeInsight.template.impl.Variable;
import com.intellij.codeInsight.template.impl.VariableNode;
import com.intellij.openapi.options.SchemeElement;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TemplateImpl
extends TemplateBase
implements SchemeElement {
    @NlsSafe
    private String myKey;
    private @NlsContexts.DetailedDescription String myDescription;
    private String myGroupName;
    private char myShortcutChar;
    private final List<Variable> myVariables;
    @NonNls
    private String myId;
    private boolean isToReformat;
    private boolean isToShortenLongNames;
    private TemplateContext myTemplateContext;
    @NonNls
    private static final String SELECTION_START = "SELECTION_START";
    @NonNls
    private static final String SELECTION_END = "SELECTION_END";
    @NonNls
    public static final String ARG = "ARG";
    public static final Set<String> INTERNAL_VARS_SET = ContainerUtil.set("END", "SELECTION", "SELECTION_START", "SELECTION_END");
    private boolean isDeactivated;
    private boolean isToIndent;
    private boolean myIsInline;

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof TemplateImpl)) {
            return false;
        }
        TemplateImpl template = (TemplateImpl)o;
        if (this.myId != null && this.myId.equals(template.myId)) {
            return true;
        }
        if (this.isToReformat != template.isToReformat) {
            return false;
        }
        if (this.isToShortenLongNames != template.isToShortenLongNames) {
            return false;
        }
        if (this.myShortcutChar != template.myShortcutChar) {
            return false;
        }
        return Objects.equals(this.myDescription, template.myDescription) && Objects.equals(this.myGroupName, template.myGroupName) && Objects.equals(this.myKey, template.myKey) && this.string().equals(template.string()) && (this.templateText() != null ? this.templateText().equals(template.templateText()) : template.templateText() == null) && new HashSet<Variable>(this.myVariables).equals(new HashSet<Variable>(template.myVariables)) && this.isDeactivated == template.isDeactivated;
    }

    public int hashCode() {
        if (this.myId != null) {
            return this.myId.hashCode();
        }
        int result2 = this.myKey.hashCode();
        result2 = 29 * result2 + this.string().hashCode();
        result2 = 29 * result2 + this.myGroupName.hashCode();
        return result2;
    }

    public boolean isInline() {
        return this.myIsInline;
    }

    @Override
    public void setInline(boolean isInline) {
        this.myIsInline = isInline;
    }

    public TemplateImpl(@NotNull @NlsSafe String key, @NotNull @NonNls String group) {
        if (key == null) {
            TemplateImpl.$$$reportNull$$$0(0);
        }
        if (group == null) {
            TemplateImpl.$$$reportNull$$$0(1);
        }
        this(key, null, group);
        this.setToParseSegments(false);
        this.setTemplateText("");
        this.setSegments(new SmartList<TemplateBase.Segment>());
    }

    public TemplateImpl(@NotNull @NlsSafe String key, @Nullable @NlsSafe String string2, @NotNull @NonNls String group) {
        if (key == null) {
            TemplateImpl.$$$reportNull$$$0(2);
        }
        if (group == null) {
            TemplateImpl.$$$reportNull$$$0(3);
        }
        this(key, string2, group, true);
    }

    TemplateImpl(@NotNull @NlsSafe String key, @NlsSafe String string2, @NotNull @NonNls String group, boolean storeBuildingStacktrace) {
        if (key == null) {
            TemplateImpl.$$$reportNull$$$0(4);
        }
        if (group == null) {
            TemplateImpl.$$$reportNull$$$0(5);
        }
        this.myShortcutChar = (char)68;
        this.myVariables = new SmartList<Variable>();
        this.isToShortenLongNames = true;
        this.myTemplateContext = new TemplateContext();
        this.isToIndent = true;
        this.myKey = key;
        this.setString(StringUtil.convertLineSeparators(StringUtil.notNullize(string2)));
        this.myGroupName = group;
        this.setBuildingTemplateTrace(storeBuildingStacktrace ? new Throwable() : null);
    }

    @Override
    @NotNull
    public Variable addVariable(@NotNull Expression expression, boolean isAlwaysStopAt) {
        if (expression == null) {
            TemplateImpl.$$$reportNull$$$0(6);
        }
        Variable variable = this.addVariable("__Variable" + this.myVariables.size(), expression, isAlwaysStopAt);
        if (variable == null) {
            TemplateImpl.$$$reportNull$$$0(7);
        }
        return variable;
    }

    @Override
    @NotNull
    public Variable addVariable(@NotNull @NlsSafe String name, Expression expression, Expression defaultValueExpression, boolean isAlwaysStopAt, boolean skipOnStart) {
        if (name == null) {
            TemplateImpl.$$$reportNull$$$0(8);
        }
        if (this.getSegments() != null) {
            this.addVariableSegment(name);
        }
        Variable variable = new Variable(name, expression, defaultValueExpression, isAlwaysStopAt, skipOnStart);
        this.myVariables.add(variable);
        Variable variable2 = variable;
        if (variable2 == null) {
            TemplateImpl.$$$reportNull$$$0(9);
        }
        return variable2;
    }

    @Override
    @NotNull
    public Variable addVariable(@NotNull @NlsSafe String name, @NlsSafe String expression, @NlsSafe String defaultValue, boolean isAlwaysStopAt) {
        if (name == null) {
            TemplateImpl.$$$reportNull$$$0(10);
        }
        Variable variable = new Variable(name, expression, defaultValue, isAlwaysStopAt);
        this.myVariables.add(variable);
        Variable variable2 = variable;
        if (variable2 == null) {
            TemplateImpl.$$$reportNull$$$0(11);
        }
        return variable2;
    }

    @Override
    public void addVariable(@NotNull Variable variable) {
        if (variable == null) {
            TemplateImpl.$$$reportNull$$$0(12);
        }
        this.myVariables.add(variable);
    }

    @Override
    public void addEndVariable() {
        this.addVariableSegment("END");
    }

    @Override
    public void addSelectionStartVariable() {
        this.addVariableSegment(SELECTION_START);
    }

    @Override
    public void addSelectionEndVariable() {
        this.addVariableSegment(SELECTION_END);
    }

    @Override
    @NonNls
    public String getId() {
        return this.myId;
    }

    @Override
    @NotNull
    public TemplateImpl copy() {
        TemplateImpl template = new TemplateImpl(this.myKey, this.string(), this.myGroupName);
        template.resetFrom(this);
        TemplateImpl templateImpl = template;
        if (templateImpl == null) {
            TemplateImpl.$$$reportNull$$$0(13);
        }
        return templateImpl;
    }

    public void resetFrom(TemplateImpl another) {
        this.removeAllParsed();
        this.setToParseSegments(another.isToParseSegments());
        this.myKey = another.getKey();
        this.setString(another.string());
        this.setTemplateText(another.templateText());
        this.myGroupName = another.myGroupName;
        this.myId = another.myId;
        this.myDescription = another.myDescription;
        this.myShortcutChar = another.myShortcutChar;
        this.isToReformat = another.isToReformat;
        this.isToShortenLongNames = another.isToShortenLongNames;
        this.myIsInline = another.myIsInline;
        this.myTemplateContext = another.myTemplateContext.createCopy();
        this.isDeactivated = another.isDeactivated;
        for (Template.Property property : Template.Property.values()) {
            boolean value = another.getValue(property);
            if (value == Template.getDefaultValue(property)) continue;
            this.setValue(property, true);
        }
        for (Variable variable : another.myVariables) {
            this.myVariables.add(new Variable(variable));
        }
    }

    @Override
    public boolean isToReformat() {
        return this.isToReformat;
    }

    @Override
    public void setToReformat(boolean toReformat) {
        this.isToReformat = toReformat;
    }

    @Override
    public void setToIndent(boolean toIndent) {
        this.isToIndent = toIndent;
    }

    public boolean isToIndent() {
        return this.isToIndent;
    }

    @Override
    public boolean isToShortenLongNames() {
        return this.isToShortenLongNames;
    }

    @Override
    public void setToShortenLongNames(boolean toShortenLongNames) {
        this.isToShortenLongNames = toShortenLongNames;
    }

    public void setDeactivated(boolean isDeactivated) {
        this.isDeactivated = isDeactivated;
    }

    public boolean isDeactivated() {
        return this.isDeactivated;
    }

    @NotNull
    public TemplateContext getTemplateContext() {
        TemplateContext templateContext = this.myTemplateContext;
        if (templateContext == null) {
            TemplateImpl.$$$reportNull$$$0(14);
        }
        return templateContext;
    }

    public int getEndSegmentNumber() {
        return this.getVariableSegmentNumber("END");
    }

    int getSelectionStartSegmentNumber() {
        return this.getVariableSegmentNumber(SELECTION_START);
    }

    int getSelectionEndSegmentNumber() {
        return this.getVariableSegmentNumber(SELECTION_END);
    }

    public void removeAllParsed() {
        this.myVariables.clear();
        this.setSegments(null);
        this.setToParseSegments(true);
        this.setBuildingTemplateTrace(new Throwable());
    }

    public void removeVariable(int i) {
        this.myVariables.remove(i);
    }

    public int getVariableCount() {
        return this.myVariables.size();
    }

    @NotNull
    @NlsSafe
    public String getVariableNameAt(int i) {
        String string2 = this.myVariables.get(i).getName();
        if (string2 == null) {
            TemplateImpl.$$$reportNull$$$0(15);
        }
        return string2;
    }

    @NotNull
    @NlsSafe
    public String getExpressionStringAt(int i) {
        String string2 = this.myVariables.get(i).getExpressionString();
        if (string2 == null) {
            TemplateImpl.$$$reportNull$$$0(16);
        }
        return string2;
    }

    @NotNull
    Expression getExpressionAt(int i) {
        Expression expression = this.myVariables.get(i).getExpression();
        if (expression == null) {
            TemplateImpl.$$$reportNull$$$0(17);
        }
        return expression;
    }

    @NotNull
    @NlsSafe
    public String getDefaultValueStringAt(int i) {
        String string2 = this.myVariables.get(i).getDefaultValueString();
        if (string2 == null) {
            TemplateImpl.$$$reportNull$$$0(18);
        }
        return string2;
    }

    @NotNull
    Expression getDefaultValueAt(int i) {
        Expression expression = this.myVariables.get(i).getDefaultValueExpression();
        if (expression == null) {
            TemplateImpl.$$$reportNull$$$0(19);
        }
        return expression;
    }

    public boolean isAlwaysStopAt(int i) {
        return this.myVariables.get(i).isAlwaysStopAt();
    }

    @Override
    @NlsSafe
    public String getKey() {
        return this.myKey;
    }

    public void setKey(@NlsSafe String key) {
        this.myKey = key;
    }

    @Override
    @NlsContexts.DetailedDescription
    public String getDescription() {
        return this.myDescription;
    }

    public void setDescription(@NlsContexts.DetailedDescription @Nullable String value) {
        if (!StringUtil.equals(value = StringUtil.notNullize(value).trim(), this.myDescription)) {
            this.myDescription = value;
        }
    }

    public char getShortcutChar() {
        return this.myShortcutChar;
    }

    public void setShortcutChar(char shortcutChar) {
        this.myShortcutChar = shortcutChar;
    }

    @NonNls
    public String getGroupName() {
        return this.myGroupName;
    }

    @Override
    public void setGroupName(@NotNull @NonNls String groupName) {
        if (groupName == null) {
            TemplateImpl.$$$reportNull$$$0(20);
        }
        this.myGroupName = groupName;
    }

    public boolean isSelectionTemplate() {
        this.parseSegments();
        for (TemplateBase.Segment v2 : this.getSegments()) {
            if (!"SELECTION".equals(v2.name)) continue;
            return true;
        }
        return ContainerUtil.exists(this.getVariables(), v -> TemplateImpl.containsSelection(v.getExpression()) || TemplateImpl.containsSelection(v.getDefaultValueExpression()));
    }

    private static boolean containsSelection(Expression expression) {
        if (expression instanceof VariableNode) {
            return "SELECTION".equals(((VariableNode)expression).getName());
        }
        if (expression instanceof MacroCallNode) {
            return ContainerUtil.exists(((MacroCallNode)expression).getParameters(), TemplateImpl::containsSelection);
        }
        return false;
    }

    public boolean hasArgument() {
        for (Variable v : this.myVariables) {
            if (!v.getName().equals(ARG)) continue;
            return true;
        }
        return false;
    }

    public void setId(@Nullable String id) {
        this.myId = id;
    }

    public Map<TemplateOptionalProcessor, Boolean> createOptions() {
        LinkedHashMap<TemplateOptionalProcessor, Boolean> context2 = new LinkedHashMap<TemplateOptionalProcessor, Boolean>();
        for (TemplateOptionalProcessor processor : TemplateOptionalProcessor.EP_NAME.getExtensionList()) {
            context2.put(processor, processor.isEnabled(this));
        }
        return context2;
    }

    public TemplateContext createContext() {
        return this.getTemplateContext().createCopy();
    }

    boolean contextsEqual(TemplateImpl defaultTemplate) {
        return this.getTemplateContext().getDifference(defaultTemplate.getTemplateContext()) == null;
    }

    public void applyOptions(Map<TemplateOptionalProcessor, Boolean> context2) {
        for (Map.Entry<TemplateOptionalProcessor, Boolean> entry : context2.entrySet()) {
            entry.getKey().setEnabled(this, entry.getValue());
        }
    }

    public void applyContext(TemplateContext context2) {
        this.myTemplateContext = context2.createCopy();
    }

    boolean skipOnStart(int i) {
        return this.myVariables.get(i).skipOnStart();
    }

    public ArrayList<Variable> getVariables() {
        return new ArrayList<Variable>(this.myVariables);
    }

    void dropParsedData() {
        for (Variable variable : this.myVariables) {
            variable.dropParsedData();
        }
    }

    public void setPrimarySegment(int segmentNumber) {
        Collections.swap(this.getSegments(), 0, segmentNumber);
    }

    public String toString() {
        return this.myGroupName + "/" + this.myKey;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: 
            case 9: 
            case 11: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 7: 
            case 9: 
            case 11: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 1: 
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "group";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 7: 
            case 9: 
            case 11: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/template/impl/TemplateImpl";
                break;
            }
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variable";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "groupName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/template/impl/TemplateImpl";
                break;
            }
            case 7: 
            case 9: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "addVariable";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "copy";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getTemplateContext";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getVariableNameAt";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getExpressionStringAt";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getExpressionAt";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultValueStringAt";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultValueAt";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 6: 
            case 8: 
            case 10: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "addVariable";
                break;
            }
            case 7: 
            case 9: 
            case 11: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "setGroupName";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 7: 
            case 9: 
            case 11: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

