/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.find;

import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.search.SearchScope;
import com.intellij.util.PatternUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FindModel
extends UserDataHolderBase
implements Cloneable {
    private final List<FindModelObserver> myObservers = ContainerUtil.createLockFreeCopyOnWriteList();
    private String myStringToFind = "";
    private String myStringToReplace = "";
    private boolean isSearchHighlighters;
    private boolean isReplaceState;
    private boolean isWholeWordsOnly;
    private SearchContext searchContext = SearchContext.ANY;
    private boolean isFromCursor = true;
    private boolean isForward = true;
    private boolean isGlobal = true;
    private boolean isRegularExpressions;
    private boolean isCaseSensitive;
    private boolean isMultipleFiles;
    private boolean isPromptOnReplace = true;
    private boolean isReplaceAll;
    private boolean isProjectScope = true;
    private boolean isFindAll;
    private boolean isFindAllEnabled;
    private String moduleName;
    private String directoryName;
    private boolean isWithSubdirectories = true;
    private String fileFilter;
    @Nls
    private String customScopeName;
    private SearchScope customScope;
    private boolean isCustomScope;
    private boolean isMultiline;
    private boolean mySearchInProjectFiles;
    private boolean isPreserveCase;
    private Pattern myPattern = PatternUtil.NOTHING;

    public static void initStringToFind(FindModel findModel, String s) {
        if (!StringUtil.isEmpty(s)) {
            if (findModel.isMultiline() || !s.contains("\r") && !s.contains("\n")) {
                findModel.setStringToFind(s);
            } else {
                findModel.setStringToFind(StringUtil.escapeToRegexp(s));
                findModel.setRegularExpressions(true);
            }
        }
    }

    public void addObserver(@NotNull FindModelObserver observer) {
        if (observer == null) {
            FindModel.$$$reportNull$$$0(0);
        }
        this.myObservers.add(observer);
    }

    public void removeObserver(@NotNull FindModelObserver observer) {
        if (observer == null) {
            FindModel.$$$reportNull$$$0(1);
        }
        this.myObservers.remove(observer);
    }

    private void notifyObservers() {
        for (FindModelObserver observer : this.myObservers) {
            observer.findModelChanged(this);
        }
    }

    public boolean isMultiline() {
        return this.isMultiline;
    }

    public void setMultiline(boolean multiline) {
        if (multiline != this.isMultiline) {
            this.isMultiline = multiline;
            FindModel.initStringToFind(this, this.getStringToFind());
            this.notifyObservers();
        }
    }

    public boolean isPreserveCase() {
        return this.isPreserveCase;
    }

    public void setPreserveCase(boolean preserveCase) {
        boolean changed2 = this.isPreserveCase != preserveCase;
        this.isPreserveCase = preserveCase;
        if (changed2) {
            this.notifyObservers();
        }
    }

    public void copyFrom(FindModel model) {
        boolean changed2 = !this.equals(model);
        this.myStringToFind = model.myStringToFind;
        this.myStringToReplace = model.myStringToReplace;
        this.isReplaceState = model.isReplaceState;
        this.isWholeWordsOnly = model.isWholeWordsOnly;
        this.isFromCursor = model.isFromCursor;
        this.isForward = model.isForward;
        this.isGlobal = model.isGlobal;
        this.isRegularExpressions = model.isRegularExpressions;
        this.isCaseSensitive = model.isCaseSensitive;
        this.isMultipleFiles = model.isMultipleFiles;
        this.isPromptOnReplace = model.isPromptOnReplace;
        this.isReplaceAll = model.isReplaceAll;
        this.isProjectScope = model.isProjectScope;
        this.directoryName = model.directoryName;
        this.isWithSubdirectories = model.isWithSubdirectories;
        this.isPreserveCase = model.isPreserveCase;
        this.fileFilter = model.fileFilter;
        this.moduleName = model.moduleName;
        this.customScopeName = model.customScopeName;
        this.customScope = model.customScope;
        this.isCustomScope = model.isCustomScope;
        this.isFindAll = model.isFindAll;
        this.searchContext = model.searchContext;
        this.isMultiline = model.isMultiline;
        this.mySearchInProjectFiles = model.mySearchInProjectFiles;
        if (changed2) {
            this.notifyObservers();
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FindModel findModel = (FindModel)o;
        if (this.isCaseSensitive != findModel.isCaseSensitive) {
            return false;
        }
        if (this.isCustomScope != findModel.isCustomScope) {
            return false;
        }
        if (this.isFindAll != findModel.isFindAll) {
            return false;
        }
        if (this.isFindAllEnabled != findModel.isFindAllEnabled) {
            return false;
        }
        if (this.isForward != findModel.isForward) {
            return false;
        }
        if (this.isFromCursor != findModel.isFromCursor) {
            return false;
        }
        if (this.isGlobal != findModel.isGlobal) {
            return false;
        }
        if (this.searchContext != findModel.searchContext) {
            return false;
        }
        if (this.isMultiline != findModel.isMultiline) {
            return false;
        }
        if (this.isMultipleFiles != findModel.isMultipleFiles) {
            return false;
        }
        if (this.isPreserveCase != findModel.isPreserveCase) {
            return false;
        }
        if (this.isProjectScope != findModel.isProjectScope) {
            return false;
        }
        if (this.isPromptOnReplace != findModel.isPromptOnReplace) {
            return false;
        }
        if (this.isRegularExpressions != findModel.isRegularExpressions) {
            return false;
        }
        if (this.isReplaceAll != findModel.isReplaceAll) {
            return false;
        }
        if (this.isReplaceState != findModel.isReplaceState) {
            return false;
        }
        if (this.isSearchHighlighters != findModel.isSearchHighlighters) {
            return false;
        }
        if (this.isWholeWordsOnly != findModel.isWholeWordsOnly) {
            return false;
        }
        if (this.isWithSubdirectories != findModel.isWithSubdirectories) {
            return false;
        }
        if (this.customScope != null ? !this.customScope.equals(findModel.customScope) : findModel.customScope != null) {
            return false;
        }
        if (this.customScopeName != null ? !this.customScopeName.equals(findModel.customScopeName) : findModel.customScopeName != null) {
            return false;
        }
        if (this.directoryName != null ? !this.directoryName.equals(findModel.directoryName) : findModel.directoryName != null) {
            return false;
        }
        if (this.fileFilter != null ? !this.fileFilter.equals(findModel.fileFilter) : findModel.fileFilter != null) {
            return false;
        }
        if (this.moduleName != null ? !this.moduleName.equals(findModel.moduleName) : findModel.moduleName != null) {
            return false;
        }
        if (this.myStringToFind != null ? !this.myStringToFind.equals(findModel.myStringToFind) : findModel.myStringToFind != null) {
            return false;
        }
        if (this.myStringToReplace != null ? !this.myStringToReplace.equals(findModel.myStringToReplace) : findModel.myStringToReplace != null) {
            return false;
        }
        return this.mySearchInProjectFiles == findModel.mySearchInProjectFiles;
    }

    public int hashCode() {
        int result2 = 0;
        result2 = 31 * result2 + (this.myStringToFind != null ? this.myStringToFind.hashCode() : 0);
        result2 = 31 * result2 + (this.myStringToReplace != null ? this.myStringToReplace.hashCode() : 0);
        result2 = 31 * result2 + (this.isSearchHighlighters ? 1 : 0);
        result2 = 31 * result2 + (this.isReplaceState ? 1 : 0);
        result2 = 31 * result2 + (this.isWholeWordsOnly ? 1 : 0);
        result2 = 31 * result2 + this.searchContext.ordinal();
        result2 = 31 * result2 + (this.isFromCursor ? 1 : 0);
        result2 = 31 * result2 + (this.isForward ? 1 : 0);
        result2 = 31 * result2 + (this.isGlobal ? 1 : 0);
        result2 = 31 * result2 + (this.isRegularExpressions ? 1 : 0);
        result2 = 31 * result2 + (this.isCaseSensitive ? 1 : 0);
        result2 = 31 * result2 + (this.isMultipleFiles ? 1 : 0);
        result2 = 31 * result2 + (this.isPromptOnReplace ? 1 : 0);
        result2 = 31 * result2 + (this.isReplaceAll ? 1 : 0);
        result2 = 31 * result2 + (this.isProjectScope ? 1 : 0);
        result2 = 31 * result2 + (this.isFindAll ? 1 : 0);
        result2 = 31 * result2 + (this.isFindAllEnabled ? 1 : 0);
        result2 = 31 * result2 + (this.moduleName != null ? this.moduleName.hashCode() : 0);
        result2 = 31 * result2 + (this.directoryName != null ? this.directoryName.hashCode() : 0);
        result2 = 31 * result2 + (this.isWithSubdirectories ? 1 : 0);
        result2 = 31 * result2 + (this.fileFilter != null ? this.fileFilter.hashCode() : 0);
        result2 = 31 * result2 + (this.customScopeName != null ? this.customScopeName.hashCode() : 0);
        result2 = 31 * result2 + (this.customScope != null ? this.customScope.hashCode() : 0);
        result2 = 31 * result2 + (this.isCustomScope ? 1 : 0);
        result2 = 31 * result2 + (this.isMultiline ? 1 : 0);
        result2 = 31 * result2 + (this.isPreserveCase ? 1 : 0);
        result2 = 31 * result2 + (this.mySearchInProjectFiles ? 1 : 0);
        result2 = 31 * result2 + (this.myPattern != null ? this.myPattern.hashCode() : 0);
        return result2;
    }

    @NotNull
    public String getStringToFind() {
        String string2 = this.myStringToFind;
        if (string2 == null) {
            FindModel.$$$reportNull$$$0(2);
        }
        return string2;
    }

    public void setStringToFind(@NotNull String s) {
        if (s == null) {
            FindModel.$$$reportNull$$$0(3);
        }
        boolean changed2 = !StringUtil.equals(s, this.myStringToFind);
        this.myStringToFind = s;
        this.myPattern = PatternUtil.NOTHING;
        if (changed2) {
            this.notifyObservers();
        }
    }

    @NotNull
    public String getStringToReplace() {
        String string2 = this.myStringToReplace;
        if (string2 == null) {
            FindModel.$$$reportNull$$$0(4);
        }
        return string2;
    }

    public void setStringToReplace(@NotNull String s) {
        if (s == null) {
            FindModel.$$$reportNull$$$0(5);
        }
        boolean changed2 = !StringUtil.equals(s, this.myStringToReplace);
        this.myStringToReplace = s;
        if (changed2) {
            this.notifyObservers();
        }
    }

    public boolean isReplaceState() {
        return this.isReplaceState;
    }

    public void setReplaceState(boolean val) {
        boolean changed2 = val != this.isReplaceState;
        this.isReplaceState = val;
        if (changed2) {
            this.notifyObservers();
        }
    }

    public boolean isFromCursor() {
        return this.isFromCursor;
    }

    public void setFromCursor(boolean val) {
        boolean changed2 = val != this.isFromCursor;
        this.isFromCursor = val;
        if (changed2) {
            this.notifyObservers();
        }
    }

    public boolean isForward() {
        return this.isForward;
    }

    public void setForward(boolean val) {
        boolean changed2 = val != this.isForward;
        this.isForward = val;
        if (changed2) {
            this.notifyObservers();
        }
    }

    public boolean isRegularExpressions() {
        return this.isRegularExpressions;
    }

    public void setRegularExpressions(boolean val) {
        boolean changed2 = val != this.isRegularExpressions;
        this.isRegularExpressions = val;
        if (changed2) {
            this.notifyObservers();
        }
    }

    public boolean isCaseSensitive() {
        return this.isCaseSensitive;
    }

    public void setCaseSensitive(boolean val) {
        boolean changed2 = val != this.isCaseSensitive;
        this.isCaseSensitive = val;
        if (changed2) {
            this.myPattern = PatternUtil.NOTHING;
            this.notifyObservers();
        }
    }

    public boolean isMultipleFiles() {
        return this.isMultipleFiles;
    }

    public void setMultipleFiles(boolean val) {
        boolean changed2 = val != this.isMultipleFiles;
        this.isMultipleFiles = val;
        if (changed2) {
            this.notifyObservers();
        }
    }

    public boolean isPromptOnReplace() {
        return this.isPromptOnReplace;
    }

    public void setPromptOnReplace(boolean val) {
        boolean changed2 = val != this.isPromptOnReplace;
        this.isPromptOnReplace = val;
        if (changed2) {
            this.notifyObservers();
        }
    }

    public boolean isWholeWordsOnly() {
        return this.isWholeWordsOnly;
    }

    public void setWholeWordsOnly(boolean isWholeWordsOnly) {
        boolean changed2 = isWholeWordsOnly != this.isWholeWordsOnly;
        this.isWholeWordsOnly = isWholeWordsOnly;
        if (changed2) {
            this.notifyObservers();
        }
    }

    public boolean isGlobal() {
        return this.isGlobal;
    }

    public void setGlobal(boolean isGlobal) {
        boolean changed2 = this.isGlobal != isGlobal;
        this.isGlobal = isGlobal;
        if (changed2) {
            this.notifyObservers();
        }
    }

    public boolean isReplaceAll() {
        return this.isReplaceAll;
    }

    public void setReplaceAll(boolean replaceAll) {
        this.isReplaceAll = replaceAll;
        this.notifyObservers();
    }

    @Deprecated(forRemoval=true)
    public void setOpenInNewTab(boolean showInNewTab) {
    }

    @Deprecated(forRemoval=true)
    public boolean isOpenInNewTabEnabled() {
        return true;
    }

    @Deprecated(forRemoval=true)
    public void setOpenInNewTabEnabled(boolean showInNewTabEnabled) {
    }

    @Deprecated(forRemoval=true)
    public boolean isOpenInNewTabVisible() {
        return true;
    }

    @Deprecated(forRemoval=true)
    public void setOpenInNewTabVisible(boolean showInNewTabVisible) {
    }

    @Nullable
    @NlsSafe
    public String getDirectoryName() {
        return this.directoryName;
    }

    public void setDirectoryName(@NlsSafe @Nullable String directoryName) {
        String path;
        boolean changed2 = !StringUtil.equals(directoryName, directoryName);
        this.directoryName = directoryName;
        if (changed2) {
            this.notifyObservers();
        }
        if (directoryName != null && ((path = FileUtil.toSystemIndependentName(directoryName)).endsWith("/.idea") || path.contains("/.idea/"))) {
            this.setSearchInProjectFiles(true);
        }
    }

    public boolean isWithSubdirectories() {
        return this.isWithSubdirectories;
    }

    public void setWithSubdirectories(boolean withSubdirectories) {
        boolean changed2 = withSubdirectories != this.isWithSubdirectories;
        this.isWithSubdirectories = withSubdirectories;
        if (changed2) {
            this.notifyObservers();
        }
    }

    public boolean isProjectScope() {
        return this.isProjectScope;
    }

    public void setProjectScope(boolean projectScope) {
        boolean changed2 = projectScope != this.isProjectScope;
        this.isProjectScope = projectScope;
        if (changed2) {
            this.notifyObservers();
        }
    }

    @Override
    public FindModel clone() {
        return (FindModel)super.clone();
    }

    @Override
    public String toString() {
        return "--- FIND MODEL ---\nmyStringToFind =" + this.myStringToFind + "\nmyStringToReplace =" + this.myStringToReplace + "\nisReplaceState =" + this.isReplaceState + "\nisWholeWordsOnly =" + this.isWholeWordsOnly + "\nsearchContext =" + this.searchContext + "\nisFromCursor =" + this.isFromCursor + "\nisForward =" + this.isForward + "\nisGlobal =" + this.isGlobal + "\nisRegularExpressions =" + this.isRegularExpressions + "\nisCaseSensitive =" + this.isCaseSensitive + "\nisMultipleFiles =" + this.isMultipleFiles + "\nisPromptOnReplace =" + this.isPromptOnReplace + "\nisReplaceAll =" + this.isReplaceAll + "\nisProjectScope =" + this.isProjectScope + "\ndirectoryName =" + this.directoryName + "\nisWithSubdirectories =" + this.isWithSubdirectories + "\nfileFilter =" + this.fileFilter + "\nmoduleName =" + this.moduleName + "\ncustomScopeName =" + this.customScopeName + "\nsearchInProjectFiles =" + this.mySearchInProjectFiles + "\n";
    }

    public boolean searchHighlighters() {
        return this.isSearchHighlighters;
    }

    public void setSearchHighlighters(boolean search) {
        boolean changed2 = search != this.isSearchHighlighters;
        this.isSearchHighlighters = search;
        if (changed2) {
            this.notifyObservers();
        }
    }

    public String getFileFilter() {
        return this.fileFilter;
    }

    public void setFileFilter(@Nullable String fileFilter) {
        List<String> split;
        boolean changed2 = !StringUtil.equals(fileFilter, this.fileFilter);
        this.fileFilter = fileFilter;
        if (changed2) {
            this.notifyObservers();
        }
        if (fileFilter != null && ContainerUtil.exists(split = StringUtil.split(fileFilter, ","), s -> s.endsWith("*.iml") || s.endsWith("*.ipr") || s.endsWith("*.iws"))) {
            this.setSearchInProjectFiles(true);
        }
    }

    @Nullable
    @NlsSafe
    public String getModuleName() {
        return this.moduleName;
    }

    public void setModuleName(@NlsSafe String moduleName) {
        boolean changed2 = !StringUtil.equals(moduleName, this.moduleName);
        this.moduleName = moduleName;
        if (changed2) {
            this.notifyObservers();
        }
    }

    public boolean isFindAll() {
        return this.isFindAll;
    }

    public void setFindAll(boolean findAll) {
        boolean changed2 = this.isFindAll != findAll;
        this.isFindAll = findAll;
        if (changed2) {
            this.notifyObservers();
        }
    }

    public boolean isFindAllEnabled() {
        return this.isFindAllEnabled;
    }

    public void setFindAllEnabled(boolean findAllEnabled) {
        boolean changed2 = this.isFindAllEnabled != findAllEnabled;
        this.isFindAllEnabled = findAllEnabled;
        if (changed2) {
            this.notifyObservers();
        }
    }

    @Nls
    public String getCustomScopeName() {
        return this.customScopeName;
    }

    public void setCustomScopeName(@Nls String customScopeName) {
        boolean changed2 = !StringUtil.equals(customScopeName, this.customScopeName);
        this.customScopeName = customScopeName;
        if (changed2) {
            this.notifyObservers();
        }
    }

    public SearchScope getCustomScope() {
        return this.customScope;
    }

    public void setCustomScope(SearchScope customScope) {
        boolean changed2 = this.customScope != null ? this.customScope.equals(customScope) : customScope != null;
        this.customScope = customScope;
        if (changed2) {
            this.notifyObservers();
        }
    }

    public boolean isCustomScope() {
        return this.isCustomScope;
    }

    public void setCustomScope(boolean customScope) {
        boolean changed2 = this.isCustomScope != customScope;
        this.isCustomScope = customScope;
        if (changed2) {
            this.notifyObservers();
        }
    }

    public boolean isInStringLiteralsOnly() {
        return this.searchContext == SearchContext.IN_STRING_LITERALS;
    }

    public boolean isExceptComments() {
        return this.searchContext == SearchContext.EXCEPT_COMMENTS;
    }

    public boolean isExceptStringLiterals() {
        return this.searchContext == SearchContext.EXCEPT_STRING_LITERALS;
    }

    public boolean isInCommentsOnly() {
        return this.searchContext == SearchContext.IN_COMMENTS;
    }

    public boolean isExceptCommentsAndStringLiterals() {
        return this.searchContext == SearchContext.EXCEPT_COMMENTS_AND_STRING_LITERALS;
    }

    @Deprecated
    public void setInCommentsOnly(boolean inCommentsOnly) {
        this.doApplyContextChange(inCommentsOnly, SearchContext.IN_COMMENTS);
    }

    @Deprecated
    public void setInStringLiteralsOnly(boolean inStringLiteralsOnly) {
        this.doApplyContextChange(inStringLiteralsOnly, SearchContext.IN_STRING_LITERALS);
    }

    private void doApplyContextChange(boolean newOptionValue, SearchContext option) {
        boolean changed2 = false;
        if (newOptionValue) {
            changed2 = this.searchContext != option;
            this.searchContext = option;
        } else if (this.searchContext == option) {
            changed2 = true;
            this.searchContext = SearchContext.ANY;
        }
        if (changed2) {
            this.notifyObservers();
        }
    }

    @NotNull
    public SearchContext getSearchContext() {
        SearchContext searchContext = this.searchContext;
        if (searchContext == null) {
            FindModel.$$$reportNull$$$0(6);
        }
        return searchContext;
    }

    public void setSearchContext(@NotNull SearchContext _searchContext) {
        if (_searchContext == null) {
            FindModel.$$$reportNull$$$0(7);
        }
        this.doSetContext(_searchContext);
    }

    private void doSetContext(SearchContext newSearchContext) {
        boolean changed2 = newSearchContext != this.searchContext;
        this.searchContext = newSearchContext;
        if (changed2) {
            this.notifyObservers();
        }
    }

    public boolean isSearchInProjectFiles() {
        return this.mySearchInProjectFiles;
    }

    public void setSearchInProjectFiles(boolean searchInProjectFiles) {
        boolean changed2 = this.mySearchInProjectFiles != searchInProjectFiles;
        this.mySearchInProjectFiles = searchInProjectFiles;
        if (changed2) {
            this.notifyObservers();
        }
    }

    public Pattern compileRegExp() {
        String toFind = this.getStringToFind();
        Pattern pattern = this.myPattern;
        if (pattern == PatternUtil.NOTHING) {
            int flags;
            int n = flags = this.isCaseSensitive() ? 8 : 74;
            if (toFind.contains("\\n") && Registry.is("jdk.regex.soe.workaround")) {
                String modifiedStringToFind = StringUtil.replace(toFind, "\\n|.", ".");
                if (!(modifiedStringToFind = StringUtil.replace(modifiedStringToFind, ".|\\n", ".")).equals(toFind)) {
                    flags |= 0x20;
                    toFind = modifiedStringToFind;
                }
            }
            try {
                this.myPattern = pattern = Pattern.compile(toFind, flags);
            }
            catch (PatternSyntaxException e) {
                pattern = null;
                this.myPattern = null;
            }
        }
        return pattern;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 4: 
            case 6: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 4: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "observer";
                break;
            }
            case 2: 
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/find/FindModel";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "s";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "_searchContext";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/find/FindModel";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getStringToFind";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getStringToReplace";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getSearchContext";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "addObserver";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "removeObserver";
                break;
            }
            case 2: 
            case 4: 
            case 6: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "setStringToFind";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "setStringToReplace";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "setSearchContext";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 2: 
            case 4: 
            case 6: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }

    public static enum SearchContext {
        ANY,
        IN_STRING_LITERALS,
        IN_COMMENTS,
        EXCEPT_STRING_LITERALS,
        EXCEPT_COMMENTS,
        EXCEPT_COMMENTS_AND_STRING_LITERALS;

    }

    @FunctionalInterface
    public static interface FindModelObserver {
        public void findModelChanged(FindModel var1);
    }
}

