/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.paths;

import com.intellij.analysis.AnalysisBundle;
import com.intellij.codeInsight.daemon.EmptyResolveMessageProvider;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.LocalQuickFixProvider;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementResolveResult;
import com.intellij.psi.PsiPolyVariantReference;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceBase;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.impl.source.resolve.reference.impl.PsiMultiReference;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReference;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReferenceOwner;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.PsiFileReference;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PsiDynaReference<T extends PsiElement>
extends PsiReferenceBase<T>
implements FileReferenceOwner,
PsiPolyVariantReference,
LocalQuickFixProvider,
EmptyResolveMessageProvider {
    private final List<PsiReference> myReferences = new ArrayList<PsiReference>();
    private int myChosenOne = -1;
    private ResolveResult[] myCachedResult;
    @Nullable
    private TextRange myPredefinedRange = null;

    public PsiDynaReference(T psiElement) {
        super(psiElement, true);
    }

    public void addReferences(Collection<? extends PsiReference> references) {
        this.myReferences.addAll(references);
        for (PsiReference psiReference : references) {
            if (psiReference.isSoft()) continue;
            this.mySoft = false;
        }
    }

    public List<PsiReference> getReferences() {
        return this.myReferences;
    }

    public void addReference(PsiReference reference) {
        this.myReferences.add(reference);
        if (!reference.isSoft()) {
            this.mySoft = false;
        }
    }

    @Override
    public void setRangeInElement(TextRange rangeInElement) {
        super.setRangeInElement(rangeInElement);
        this.myPredefinedRange = rangeInElement;
    }

    @Override
    @NotNull
    public TextRange getRangeInElement() {
        PsiReference resolved = null;
        PsiReference reference = this.myReferences.get(0);
        if (reference.resolve() != null) {
            resolved = reference;
        }
        TextRange range = reference.getRangeInElement();
        int start = range.getStartOffset();
        int end = range.getEndOffset();
        for (int i = 1; i < this.myReferences.size(); ++i) {
            reference = this.myReferences.get(i);
            TextRange textRange = PsiMultiReference.getReferenceRange(reference, this.myElement);
            start = Math.min(start, textRange.getStartOffset());
            if (resolved != null) continue;
            end = Math.max(end, textRange.getEndOffset());
        }
        if (this.myPredefinedRange != null && this.myPredefinedRange.containsRange(start, end)) {
            TextRange textRange = this.myPredefinedRange;
            if (textRange == null) {
                PsiDynaReference.$$$reportNull$$$0(0);
            }
            return textRange;
        }
        return new TextRange(start, end);
    }

    @Override
    public PsiElement resolve() {
        ResolveResult[] resolveResults = this.multiResolve(false);
        return resolveResults.length == 1 ? resolveResults[0].getElement() : null;
    }

    @Override
    @NotNull
    public String getCanonicalText() {
        PsiReference reference = this.chooseReference();
        String string2 = reference == null ? this.myReferences.get(0).getCanonicalText() : reference.getCanonicalText();
        if (string2 == null) {
            PsiDynaReference.$$$reportNull$$$0(1);
        }
        return string2;
    }

    @Override
    public PsiElement handleElementRename(@NotNull String newElementName) throws IncorrectOperationException {
        PsiReference reference;
        if (newElementName == null) {
            PsiDynaReference.$$$reportNull$$$0(2);
        }
        if ((reference = this.chooseReference()) != null) {
            return reference.handleElementRename(newElementName);
        }
        return this.myElement;
    }

    @Override
    public PsiElement bindToElement(@NotNull PsiElement element) throws IncorrectOperationException {
        if (element == null) {
            PsiDynaReference.$$$reportNull$$$0(3);
        }
        for (PsiReference reference : this.myReferences) {
            if (!(reference instanceof FileReference)) continue;
            return reference.bindToElement(element);
        }
        return this.myElement;
    }

    @Override
    public boolean isReferenceTo(@NotNull PsiElement element) {
        if (element == null) {
            PsiDynaReference.$$$reportNull$$$0(4);
        }
        for (PsiReference reference : this.myReferences) {
            if (!reference.isReferenceTo(element)) continue;
            return true;
        }
        return false;
    }

    @Override
    public ResolveResult @NotNull [] multiResolve(boolean incompleteCode) {
        if (this.myCachedResult == null) {
            this.myCachedResult = this.innerResolve(incompleteCode);
        }
        if (this.myCachedResult == null) {
            PsiDynaReference.$$$reportNull$$$0(5);
        }
        return this.myCachedResult;
    }

    protected ResolveResult[] innerResolve(boolean incompleteCode) {
        LinkedHashSet<ResolveResult> result2 = new LinkedHashSet<ResolveResult>();
        for (PsiReference reference : this.myReferences) {
            if (reference instanceof PsiPolyVariantReference) {
                for (ResolveResult rr : ((PsiPolyVariantReference)reference).multiResolve(incompleteCode)) {
                    if (!rr.isValidResult()) continue;
                    result2.add(rr);
                }
                continue;
            }
            PsiElement resolved = reference.resolve();
            if (resolved == null) continue;
            result2.add(new PsiElementResolveResult(resolved));
        }
        return result2.toArray(ResolveResult.EMPTY_ARRAY);
    }

    @Nullable
    private PsiReference chooseReference() {
        if (this.myChosenOne != -1) {
            return this.myReferences.get(this.myChosenOne);
        }
        boolean flag = false;
        for (int i = 0; i < this.myReferences.size(); ++i) {
            PsiReference reference = this.myReferences.get(i);
            if (reference.isSoft() && flag) continue;
            if (!reference.isSoft() && !flag) {
                this.myChosenOne = i;
                flag = true;
                continue;
            }
            if (reference.resolve() == null) continue;
            this.myChosenOne = i;
        }
        return this.myChosenOne >= 0 ? this.myReferences.get(this.myChosenOne) : null;
    }

    @Override
    @NotNull
    public String getUnresolvedMessagePattern() {
        PsiReference reference = this.chooseReference();
        String string2 = reference instanceof EmptyResolveMessageProvider ? ((EmptyResolveMessageProvider)((Object)reference)).getUnresolvedMessagePattern() : AnalysisBundle.message("cannot.resolve.symbol", new Object[0]);
        if (string2 == null) {
            PsiDynaReference.$$$reportNull$$$0(6);
        }
        return string2;
    }

    @Override
    public LocalQuickFix[] getQuickFixes() {
        ArrayList list = new ArrayList();
        for (PsiReference ref : this.myReferences) {
            if (!(ref instanceof LocalQuickFixProvider)) continue;
            ContainerUtil.addAll(list, ((LocalQuickFixProvider)((Object)ref)).getQuickFixes());
        }
        return list.toArray(LocalQuickFix.EMPTY_ARRAY);
    }

    @Override
    public String toString() {
        return "PsiDynaReference containing " + this.myReferences.toString();
    }

    @Override
    public PsiFileReference getLastFileReference() {
        for (PsiReference reference : this.myReferences) {
            if (!(reference instanceof FileReferenceOwner)) continue;
            return ((FileReferenceOwner)((Object)reference)).getLastFileReference();
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/paths/PsiDynaReference";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newElementName";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getRangeInElement";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getCanonicalText";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/paths/PsiDynaReference";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "multiResolve";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getUnresolvedMessagePattern";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "handleElementRename";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "bindToElement";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isReferenceTo";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

