/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.project;

import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectCoreUtil;
import com.intellij.openapi.project.ProjectLocator;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.SmartList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class ProjectLocatorImpl
extends ProjectLocator {
    ProjectLocatorImpl() {
    }

    @Override
    @Nullable
    public Project guessProjectForFile(@Nullable(value="for plugin compatibility only; actually it should have been notnull") @Nullable(value="for plugin compatibility only; actually it should have been notnull") VirtualFile file2) {
        if (file2 == null) {
            return null;
        }
        Project project = ProjectCoreUtil.theOnlyOpenProject();
        if (project != null && !project.isDisposed()) {
            return project;
        }
        project = ProjectLocatorImpl.getPreferredProject(file2);
        if (project != null) {
            return project;
        }
        ProjectManager projectManager = ProjectManager.getInstanceIfCreated();
        if (projectManager == null) {
            return null;
        }
        Project[] openProjects = projectManager.getOpenProjects();
        if (openProjects.length == 1) {
            return openProjects[0];
        }
        return ReadAction.compute(() -> {
            for (Project openProject : projectManager.getOpenProjects()) {
                if (!ProjectLocatorImpl.isUnder(openProject, file2)) continue;
                return openProject;
            }
            return null;
        });
    }

    private static boolean isUnder(@NotNull Project project, @NotNull VirtualFile file2) {
        ProjectFileIndex fileIndex;
        if (project == null) {
            ProjectLocatorImpl.$$$reportNull$$$0(0);
        }
        if (file2 == null) {
            ProjectLocatorImpl.$$$reportNull$$$0(1);
        }
        return (fileIndex = ProjectRootManager.getInstance(project).getFileIndex()).isInContent(file2) || fileIndex.isExcluded(file2);
    }

    @Override
    @NotNull
    public Collection<Project> getProjectsForFile(@NotNull VirtualFile file2) {
        ProjectManager projectManager;
        if (file2 == null) {
            ProjectLocatorImpl.$$$reportNull$$$0(2);
        }
        if ((projectManager = ProjectManager.getInstanceIfCreated()) == null) {
            List<Project> list = Collections.emptyList();
            if (list == null) {
                ProjectLocatorImpl.$$$reportNull$$$0(3);
            }
            return list;
        }
        SmartList<Project> result2 = new SmartList<Project>();
        ReadAction.run(() -> {
            for (Project project : projectManager.getOpenProjects()) {
                if (!ProjectLocatorImpl.isUnder(project, file2)) continue;
                result2.add(project);
            }
        });
        SmartList<Project> smartList = result2;
        if (smartList == null) {
            ProjectLocatorImpl.$$$reportNull$$$0(4);
        }
        return smartList;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/project/ProjectLocatorImpl";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/project/ProjectLocatorImpl";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getProjectsForFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isUnder";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getProjectsForFile";
                break;
            }
            case 3: 
            case 4: {
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

