/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.CommonClassNames;
import com.intellij.util.ArrayUtil;
import com.intellij.util.CharTable;
import com.intellij.util.ReflectionUtil;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.lang.reflect.Field;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class CharTableImpl
implements CharTable {
    private static final int INTERN_THRESHOLD = 40;
    private static final StringHashToCharSequencesMap STATIC_ENTRIES = CharTableImpl.newStaticSet();
    private final StringHashToCharSequencesMap entries = new StringHashToCharSequencesMap(10, 0.9f);

    @Override
    @NotNull
    public CharSequence intern(@NotNull CharSequence text) {
        if (text == null) {
            CharTableImpl.$$$reportNull$$$0(0);
        }
        CharSequence charSequence = text.length() > 40 ? CharTableImpl.createSequence(text) : this.doIntern(text);
        if (charSequence == null) {
            CharTableImpl.$$$reportNull$$$0(1);
        }
        return charSequence;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    private CharSequence doIntern(@NotNull CharSequence text, int startOffset, int endOffset) {
        if (text == null) {
            CharTableImpl.$$$reportNull$$$0(2);
        }
        int hashCode = CharTableImpl.subSequenceHashCode(text, startOffset, endOffset);
        StringHashToCharSequencesMap stringHashToCharSequencesMap = STATIC_ENTRIES;
        // MONITORENTER : stringHashToCharSequencesMap
        CharSequence interned = CharTableImpl.STATIC_ENTRIES.getSubSequenceWithHashCode(hashCode, text, startOffset, endOffset);
        // MONITOREXIT : stringHashToCharSequencesMap
        if (interned != null) {
            CharSequence charSequence = interned;
            if (charSequence != null) return charSequence;
            CharTableImpl.$$$reportNull$$$0(3);
            return charSequence;
        }
        stringHashToCharSequencesMap = this.entries;
        // MONITORENTER : stringHashToCharSequencesMap
        CharSequence charSequence = this.entries.getOrAddSubSequenceWithHashCode(hashCode, text, startOffset, endOffset);
        // MONITOREXIT : stringHashToCharSequencesMap
        if (charSequence != null) return charSequence;
        CharTableImpl.$$$reportNull$$$0(4);
        return charSequence;
    }

    @NotNull
    public CharSequence doIntern(@NotNull CharSequence text) {
        if (text == null) {
            CharTableImpl.$$$reportNull$$$0(5);
        }
        return this.doIntern(text, 0, text.length());
    }

    @Override
    @NotNull
    public CharSequence intern(@NotNull CharSequence baseText, int startOffset, int endOffset) {
        if (baseText == null) {
            CharTableImpl.$$$reportNull$$$0(6);
        }
        CharSequence result2 = endOffset - startOffset == baseText.length() ? this.intern(baseText) : (endOffset - startOffset > 40 ? CharTableImpl.createSequence(baseText, startOffset, endOffset) : this.doIntern(baseText, startOffset, endOffset));
        CharSequence charSequence = result2;
        if (charSequence == null) {
            CharTableImpl.$$$reportNull$$$0(7);
        }
        return charSequence;
    }

    @NotNull
    private static String createSequence(@NotNull CharSequence text) {
        if (text == null) {
            CharTableImpl.$$$reportNull$$$0(8);
        }
        return CharTableImpl.createSequence(text, 0, text.length());
    }

    @NotNull
    private static String createSequence(@NotNull CharSequence text, int startOffset, int endOffset) {
        if (text == null) {
            CharTableImpl.$$$reportNull$$$0(9);
        }
        if (text instanceof String) {
            String string2 = ((String)text).substring(startOffset, endOffset);
            if (string2 == null) {
                CharTableImpl.$$$reportNull$$$0(10);
            }
            return string2;
        }
        String string3 = text.subSequence(startOffset, endOffset).toString();
        if (string3 == null) {
            CharTableImpl.$$$reportNull$$$0(11);
        }
        return string3;
    }

    @Nullable
    public static CharSequence getStaticInterned(@NotNull CharSequence text) {
        if (text == null) {
            CharTableImpl.$$$reportNull$$$0(12);
        }
        return CharTableImpl.STATIC_ENTRIES.get(text);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void staticIntern(@NotNull String text) {
        if (text == null) {
            CharTableImpl.$$$reportNull$$$0(13);
        }
        StringHashToCharSequencesMap stringHashToCharSequencesMap = STATIC_ENTRIES;
        synchronized (stringHashToCharSequencesMap) {
            CharTableImpl.STATIC_ENTRIES.add(text);
        }
    }

    @NotNull
    private static StringHashToCharSequencesMap newStaticSet() {
        StringHashToCharSequencesMap r = new StringHashToCharSequencesMap(10, 0.9f);
        r.add("==");
        r.add("!=");
        r.add("||");
        r.add("++");
        r.add("--");
        r.add("<");
        r.add("<=");
        r.add("<<=");
        r.add("<<");
        r.add(">");
        r.add("&");
        r.add("&&");
        r.add("+=");
        r.add("-=");
        r.add("*=");
        r.add("/=");
        r.add("&=");
        r.add("|=");
        r.add("^=");
        r.add("%=");
        r.add("(");
        r.add(")");
        r.add("{");
        r.add("}");
        r.add("[");
        r.add("]");
        r.add(";");
        r.add(",");
        r.add("...");
        r.add(".");
        r.add("=");
        r.add("!");
        r.add("~");
        r.add("?");
        r.add(":");
        r.add("+");
        r.add("-");
        r.add("*");
        r.add("/");
        r.add("|");
        r.add("^");
        r.add("%");
        r.add("@");
        r.add(" ");
        r.add("  ");
        r.add("   ");
        r.add("    ");
        r.add("     ");
        r.add("      ");
        r.add("       ");
        r.add("        ");
        r.add("         ");
        r.add("          ");
        r.add("           ");
        r.add("            ");
        r.add("             ");
        r.add("              ");
        r.add("               ");
        r.add("\n");
        r.add("\n  ");
        r.add("\n    ");
        r.add("\n      ");
        r.add("\n        ");
        r.add("\n          ");
        r.add("\n            ");
        r.add("\n              ");
        r.add("\n                ");
        r.add("<");
        r.add(">");
        r.add("</");
        r.add("/>");
        r.add("\"");
        r.add("'");
        r.add("<![CDATA[");
        r.add("]]>");
        r.add("<!--");
        r.add("-->");
        r.add("<!DOCTYPE");
        r.add("SYSTEM");
        r.add("PUBLIC");
        r.add("<?");
        r.add("?>");
        r.add("<%");
        r.add("%>");
        r.add("<%=");
        r.add("<%@");
        r.add("${");
        r.add("");
        StringHashToCharSequencesMap stringHashToCharSequencesMap = r;
        if (stringHashToCharSequencesMap == null) {
            CharTableImpl.$$$reportNull$$$0(14);
        }
        return stringHashToCharSequencesMap;
    }

    public static void addStringsFromClassToStatics(@NotNull Class<?> aClass) {
        if (aClass == null) {
            CharTableImpl.$$$reportNull$$$0(15);
        }
        for (Field field : aClass.getDeclaredFields()) {
            String typeName;
            if ((field.getModifiers() & 8) == 0 || (field.getModifiers() & 1) == 0 || !String.class.equals(field.getType()) || (typeName = ReflectionUtil.getStaticFieldValue(aClass, String.class, field.getName())) == null) continue;
            CharTableImpl.staticIntern(typeName);
        }
    }

    private static int subSequenceHashCode(@NotNull CharSequence sequence, int startOffset, int endOffset) {
        if (sequence == null) {
            CharTableImpl.$$$reportNull$$$0(16);
        }
        if (startOffset == 0 && endOffset == sequence.length()) {
            return StringUtil.stringHashCode(sequence);
        }
        return StringUtil.stringHashCode(sequence, startOffset, endOffset);
    }

    static {
        CharTableImpl.addStringsFromClassToStatics(CommonClassNames.class);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 7: 
            case 10: 
            case 11: 
            case 14: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 7: 
            case 10: 
            case 11: 
            case 14: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 7: 
            case 10: 
            case 11: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/impl/source/CharTableImpl";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "baseText";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sequence";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/impl/source/CharTableImpl";
                break;
            }
            case 1: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "intern";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "doIntern";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "createSequence";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "newStaticSet";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "intern";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 7: 
            case 10: 
            case 11: 
            case 14: {
                break;
            }
            case 2: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "doIntern";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "createSequence";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getStaticInterned";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "staticIntern";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "addStringsFromClassToStatics";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "subSequenceHashCode";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 7: 
            case 10: 
            case 11: 
            case 14: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }

    private static final class StringHashToCharSequencesMap
    extends Int2ObjectOpenHashMap<Object> {
        private StringHashToCharSequencesMap(int capacity, float loadFactor) {
            super(capacity, loadFactor);
        }

        private CharSequence get(@NotNull CharSequence sequence, int startOffset, int endOffset) {
            if (sequence == null) {
                StringHashToCharSequencesMap.$$$reportNull$$$0(0);
            }
            return this.getSubSequenceWithHashCode(CharTableImpl.subSequenceHashCode(sequence, startOffset, endOffset), sequence, startOffset, endOffset);
        }

        private CharSequence getSubSequenceWithHashCode(int hashCode, @NotNull CharSequence sequence, int startOffset, int endOffset) {
            Object o;
            if (sequence == null) {
                StringHashToCharSequencesMap.$$$reportNull$$$0(1);
            }
            if ((o = this.get(hashCode)) == null) {
                return null;
            }
            if (o instanceof CharSequence) {
                if (StringHashToCharSequencesMap.charSequenceSubSequenceEquals((CharSequence)o, sequence, startOffset, endOffset)) {
                    return (CharSequence)o;
                }
                return null;
            }
            if (o instanceof CharSequence[]) {
                for (CharSequence cs : (CharSequence[])o) {
                    if (!StringHashToCharSequencesMap.charSequenceSubSequenceEquals(cs, sequence, startOffset, endOffset)) continue;
                    return cs;
                }
                return null;
            }
            assert (false) : o.getClass();
            return null;
        }

        private static boolean charSequenceSubSequenceEquals(@NotNull CharSequence cs, @NotNull CharSequence baseSequence, int startOffset, int endOffset) {
            if (cs == null) {
                StringHashToCharSequencesMap.$$$reportNull$$$0(2);
            }
            if (baseSequence == null) {
                StringHashToCharSequencesMap.$$$reportNull$$$0(3);
            }
            if (cs.length() != endOffset - startOffset) {
                return false;
            }
            if (cs == baseSequence && startOffset == 0) {
                return true;
            }
            int len = cs.length();
            for (int i = 0; i < len; ++i) {
                if (cs.charAt(i) == baseSequence.charAt(startOffset + i)) continue;
                return false;
            }
            return true;
        }

        private CharSequence get(@NotNull CharSequence sequence) {
            if (sequence == null) {
                StringHashToCharSequencesMap.$$$reportNull$$$0(4);
            }
            return this.get(sequence, 0, sequence.length());
        }

        private void add(@NotNull CharSequence sequence) {
            if (sequence == null) {
                StringHashToCharSequencesMap.$$$reportNull$$$0(5);
            }
            int endOffset = sequence.length();
            int hashCode = CharTableImpl.subSequenceHashCode(sequence, 0, endOffset);
            this.getOrAddSubSequenceWithHashCode(hashCode, sequence, 0, endOffset);
        }

        @NotNull
        private CharSequence getOrAddSubSequenceWithHashCode(int hashCode, @NotNull CharSequence sequence, int startOffset, int endOffset) {
            String addedSequence;
            Object value;
            if (sequence == null) {
                StringHashToCharSequencesMap.$$$reportNull$$$0(6);
            }
            if ((value = this.get(hashCode)) == null) {
                addedSequence = CharTableImpl.createSequence(sequence, startOffset, endOffset);
                this.put(hashCode, addedSequence);
            } else if (value instanceof CharSequence) {
                CharSequence existingSequence = (CharSequence)value;
                if (StringHashToCharSequencesMap.charSequenceSubSequenceEquals(existingSequence, sequence, startOffset, endOffset)) {
                    CharSequence charSequence = existingSequence;
                    if (charSequence == null) {
                        StringHashToCharSequencesMap.$$$reportNull$$$0(7);
                    }
                    return charSequence;
                }
                addedSequence = CharTableImpl.createSequence(sequence, startOffset, endOffset);
                this.put(hashCode, new CharSequence[]{existingSequence, addedSequence});
            } else if (value instanceof CharSequence[]) {
                CharSequence[] existingSequenceArray;
                for (CharSequence cs : existingSequenceArray = (CharSequence[])value) {
                    if (!StringHashToCharSequencesMap.charSequenceSubSequenceEquals(cs, sequence, startOffset, endOffset)) continue;
                    CharSequence charSequence = cs;
                    if (charSequence == null) {
                        StringHashToCharSequencesMap.$$$reportNull$$$0(8);
                    }
                    return charSequence;
                }
                addedSequence = CharTableImpl.createSequence(sequence, startOffset, endOffset);
                CharSequence[] newSequenceArray = ArrayUtil.append(existingSequenceArray, addedSequence, CharSequence[]::new);
                this.put(hashCode, newSequenceArray);
            } else {
                assert (false) : value.getClass();
                if (null == null) {
                    StringHashToCharSequencesMap.$$$reportNull$$$0(9);
                }
                return null;
            }
            String string2 = addedSequence;
            if (string2 == null) {
                StringHashToCharSequencesMap.$$$reportNull$$$0(10);
            }
            return string2;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string2;
            switch (n) {
                default: {
                    string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 7: 
                case 8: 
                case 9: 
                case 10: {
                    string2 = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 7: 
                case 8: 
                case 9: 
                case 10: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "sequence";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "cs";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "baseSequence";
                    break;
                }
                case 7: 
                case 8: 
                case 9: 
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/psi/impl/source/CharTableImpl$StringHashToCharSequencesMap";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/psi/impl/source/CharTableImpl$StringHashToCharSequencesMap";
                    break;
                }
                case 7: 
                case 8: 
                case 9: 
                case 10: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getOrAddSubSequenceWithHashCode";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "get";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "getSubSequenceWithHashCode";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "charSequenceSubSequenceEquals";
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "add";
                    break;
                }
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "getOrAddSubSequenceWithHashCode";
                    break;
                }
                case 7: 
                case 8: 
                case 9: 
                case 10: {
                    break;
                }
            }
            String string3 = String.format(string2, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string3);
                    break;
                }
                case 7: 
                case 8: 
                case 9: 
                case 10: {
                    runtimeException = new IllegalStateException(string3);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

