/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.search;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.UnloadedModuleDescription;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleFileIndex;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.indexing.IndexingBundle;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class ProjectAndLibrariesScope
extends GlobalSearchScope {
    protected final ProjectFileIndex myProjectFileIndex;
    @Nls
    private String myDisplayName;

    public ProjectAndLibrariesScope(@NotNull Project project) {
        if (project == null) {
            ProjectAndLibrariesScope.$$$reportNull$$$0(0);
        }
        super(project);
        this.myProjectFileIndex = ProjectRootManager.getInstance(project).getFileIndex();
    }

    @Deprecated(forRemoval=true)
    public ProjectAndLibrariesScope(Project project, boolean searchOutsideRootModel) {
        this(project);
    }

    @Override
    public boolean contains(@NotNull VirtualFile file2) {
        if (file2 == null) {
            ProjectAndLibrariesScope.$$$reportNull$$$0(1);
        }
        return this.myProjectFileIndex.isInContent(file2) || this.myProjectFileIndex.isInLibrary(file2);
    }

    @Override
    public int compare(@NotNull VirtualFile file1, @NotNull VirtualFile file2) {
        if (file1 == null) {
            ProjectAndLibrariesScope.$$$reportNull$$$0(2);
        }
        if (file2 == null) {
            ProjectAndLibrariesScope.$$$reportNull$$$0(3);
        }
        List<OrderEntry> entries1 = this.myProjectFileIndex.getOrderEntriesForFile(file1);
        List<OrderEntry> entries2 = this.myProjectFileIndex.getOrderEntriesForFile(file2);
        if (entries1.size() != entries2.size()) {
            return 0;
        }
        int res = 0;
        for (OrderEntry entry1 : entries1) {
            Module module = entry1.getOwnerModule();
            ModuleFileIndex moduleFileIndex = ModuleRootManager.getInstance(module).getFileIndex();
            OrderEntry entry2 = moduleFileIndex.getOrderEntryForFile(file2);
            if (entry2 == null) {
                return 0;
            }
            int aRes = entry2.compareTo(entry1);
            if (aRes == 0) {
                return 0;
            }
            if (res == 0) {
                res = aRes;
                continue;
            }
            if (res == aRes) continue;
            return 0;
        }
        return res;
    }

    @Override
    public boolean isSearchInModuleContent(@NotNull Module aModule) {
        if (aModule == null) {
            ProjectAndLibrariesScope.$$$reportNull$$$0(4);
        }
        return true;
    }

    @Override
    public boolean isSearchInLibraries() {
        return true;
    }

    @Override
    @NotNull
    public Collection<UnloadedModuleDescription> getUnloadedModulesBelongingToScope() {
        Project project = this.getProject();
        Collection<UnloadedModuleDescription> collection = project != null ? ModuleManager.getInstance(project).getUnloadedModuleDescriptions() : Collections.emptySet();
        if (collection == null) {
            ProjectAndLibrariesScope.$$$reportNull$$$0(5);
        }
        return collection;
    }

    @Override
    @NotNull
    public String getDisplayName() {
        String string2 = this.myDisplayName == null ? ProjectAndLibrariesScope.getNameText() : this.myDisplayName;
        if (string2 == null) {
            ProjectAndLibrariesScope.$$$reportNull$$$0(6);
        }
        return string2;
    }

    @NotNull
    @Nls
    public static String getNameText() {
        String string2 = IndexingBundle.message("psi.search.scope.project.and.libraries", new Object[0]);
        if (string2 == null) {
            ProjectAndLibrariesScope.$$$reportNull$$$0(7);
        }
        return string2;
    }

    public void setDisplayName(@NotNull @Nls String displayName) {
        if (displayName == null) {
            ProjectAndLibrariesScope.$$$reportNull$$$0(8);
        }
        this.myDisplayName = displayName;
    }

    public String toString() {
        return this.getDisplayName();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file1";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file2";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aModule";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/search/ProjectAndLibrariesScope";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "displayName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/search/ProjectAndLibrariesScope";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getUnloadedModulesBelongingToScope";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getNameText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "contains";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "compare";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isSearchInModuleContent";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "setDisplayName";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

