/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.stubs;

import com.intellij.openapi.util.io.BufferExposingByteArrayOutputStream;
import com.intellij.psi.stubs.ObjectStubBase;
import com.intellij.psi.stubs.ObjectStubSerializer;
import com.intellij.psi.stubs.ObjectStubTree;
import com.intellij.psi.stubs.PsiFileStub;
import com.intellij.psi.stubs.SerializationManagerEx;
import com.intellij.psi.stubs.SerializerNotFoundException;
import com.intellij.psi.stubs.Stub;
import com.intellij.psi.stubs.StubForwardIndexExternalizer;
import com.intellij.psi.stubs.StubIdList;
import com.intellij.psi.stubs.StubIndexKey;
import com.intellij.psi.stubs.StubIndexKeyDescriptorCache;
import com.intellij.psi.stubs.StubTree;
import com.intellij.psi.stubs.StubTreeSerializer;
import com.intellij.util.ArrayUtil;
import com.intellij.util.io.DigestUtil;
import com.intellij.util.io.UnsyncByteArrayInputStream;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public final class SerializedStubTree {
    final byte[] myTreeBytes;
    final int myTreeByteLength;
    final byte[] myIndexedStubBytes;
    final int myIndexedStubByteLength;
    private Map<StubIndexKey<?, ?>, Map<Object, StubIdList>> myIndexedStubs;
    @NotNull
    private final StubTreeSerializer mySerializationManager;
    @NotNull
    private final StubForwardIndexExternalizer<?> myStubIndexesExternalizer;
    private byte[] myTreeHash;
    public static final Stub NO_STUB = new Stub(){

        @Override
        public Stub getParentStub() {
            return null;
        }

        @Override
        @NotNull
        public List<? extends Stub> getChildrenStubs() {
            List list = Collections.emptyList();
            if (list == null) {
                1.$$$reportNull$$$0(0);
            }
            return list;
        }

        public ObjectStubSerializer<?, ?> getStubType() {
            return null;
        }

        public String toString() {
            return "<no stub>";
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/stubs/SerializedStubTree$1", "getChildrenStubs"));
        }
    };

    public SerializedStubTree(byte @NotNull [] treeBytes, int treeByteLength, byte @NotNull [] indexedStubBytes, int indexedStubByteLength, @Nullable Map<StubIndexKey<?, ?>, Map<Object, StubIdList>> indexedStubs, @NotNull StubForwardIndexExternalizer<?> stubIndexesExternalizer, @NotNull StubTreeSerializer serializationManager) {
        if (stubIndexesExternalizer == null) {
            SerializedStubTree.$$$reportNull$$$0(0);
        }
        if (serializationManager == null) {
            SerializedStubTree.$$$reportNull$$$0(1);
        }
        if (treeBytes == null) {
            SerializedStubTree.$$$reportNull$$$0(2);
        }
        if (indexedStubBytes == null) {
            SerializedStubTree.$$$reportNull$$$0(3);
        }
        this.myTreeBytes = treeBytes;
        this.myTreeByteLength = treeByteLength;
        this.myIndexedStubBytes = indexedStubBytes;
        this.myIndexedStubByteLength = indexedStubByteLength;
        this.myIndexedStubs = indexedStubs;
        this.myStubIndexesExternalizer = stubIndexesExternalizer;
        this.mySerializationManager = serializationManager;
    }

    @NotNull
    public static SerializedStubTree serializeStub(@NotNull Stub rootStub, @NotNull StubTreeSerializer serializationManager, @NotNull StubForwardIndexExternalizer<?> forwardIndexExternalizer) throws IOException {
        if (rootStub == null) {
            SerializedStubTree.$$$reportNull$$$0(4);
        }
        if (serializationManager == null) {
            SerializedStubTree.$$$reportNull$$$0(5);
        }
        if (forwardIndexExternalizer == null) {
            SerializedStubTree.$$$reportNull$$$0(6);
        }
        BufferExposingByteArrayOutputStream bytes = new BufferExposingByteArrayOutputStream();
        serializationManager.serialize(rootStub, bytes);
        byte[] treeBytes = bytes.getInternalBuffer();
        int treeByteLength = bytes.size();
        ObjectStubBase root = (ObjectStubBase)rootStub;
        Map<StubIndexKey<?, ?>, Map<Object, StubIdList>> indexedStubs = SerializedStubTree.indexTree(root);
        BufferExposingByteArrayOutputStream indexBytes = new BufferExposingByteArrayOutputStream();
        forwardIndexExternalizer.save((DataOutput)new DataOutputStream(indexBytes), indexedStubs);
        byte[] indexedStubBytes = indexBytes.getInternalBuffer();
        int indexedStubByteLength = indexBytes.size();
        return new SerializedStubTree(treeBytes, treeByteLength, indexedStubBytes, indexedStubByteLength, indexedStubs, forwardIndexExternalizer, serializationManager);
    }

    @NotNull
    public SerializedStubTree reSerialize(@NotNull StubTreeSerializer newSerializationManager, @NotNull StubForwardIndexExternalizer<?> newForwardIndexSerializer) throws IOException {
        int reSerializedIndexByteLength;
        byte[] reSerializedIndexBytes;
        if (newSerializationManager == null) {
            SerializedStubTree.$$$reportNull$$$0(7);
        }
        if (newForwardIndexSerializer == null) {
            SerializedStubTree.$$$reportNull$$$0(8);
        }
        BufferExposingByteArrayOutputStream outStub = new BufferExposingByteArrayOutputStream();
        ((SerializationManagerEx)this.mySerializationManager).reSerialize(new ByteArrayInputStream(this.myTreeBytes, 0, this.myTreeByteLength), outStub, newSerializationManager);
        if (this.myStubIndexesExternalizer == newForwardIndexSerializer) {
            reSerializedIndexBytes = this.myIndexedStubBytes;
            reSerializedIndexByteLength = this.myIndexedStubByteLength;
        } else {
            BufferExposingByteArrayOutputStream reSerializedStubIndices = new BufferExposingByteArrayOutputStream();
            newForwardIndexSerializer.save((DataOutput)new DataOutputStream(reSerializedStubIndices), this.getStubIndicesValueMap());
            reSerializedIndexBytes = reSerializedStubIndices.getInternalBuffer();
            reSerializedIndexByteLength = reSerializedStubIndices.size();
        }
        return new SerializedStubTree(outStub.getInternalBuffer(), outStub.size(), reSerializedIndexBytes, reSerializedIndexByteLength, this.myIndexedStubs, newForwardIndexSerializer, newSerializationManager);
    }

    @ApiStatus.Internal
    @NotNull
    public StubForwardIndexExternalizer<?> getStubIndexesExternalizer() {
        StubForwardIndexExternalizer<?> stubForwardIndexExternalizer = this.myStubIndexesExternalizer;
        if (stubForwardIndexExternalizer == null) {
            SerializedStubTree.$$$reportNull$$$0(9);
        }
        return stubForwardIndexExternalizer;
    }

    void restoreIndexedStubs() throws IOException {
        if (this.myIndexedStubs == null) {
            this.myIndexedStubs = this.myStubIndexesExternalizer.read(new DataInputStream(new ByteArrayInputStream(this.myIndexedStubBytes, 0, this.myIndexedStubByteLength)));
        }
    }

    <K> StubIdList restoreIndexedStubs(@NotNull StubIndexKey<K, ?> indexKey, @NotNull K key) throws IOException {
        Map<StubIndexKey<?, ?>, Map<Object, StubIdList>> incompleteMap;
        if (indexKey == null) {
            SerializedStubTree.$$$reportNull$$$0(10);
        }
        if (key == null) {
            SerializedStubTree.$$$reportNull$$$0(11);
        }
        if ((incompleteMap = this.myStubIndexesExternalizer.doRead(new DataInputStream(new ByteArrayInputStream(this.myIndexedStubBytes, 0, this.myIndexedStubByteLength)), indexKey, key)) == null) {
            return null;
        }
        Map<Object, StubIdList> map2 = incompleteMap.get(indexKey);
        return map2 == null ? null : map2.get(key);
    }

    @NotNull
    public Map<StubIndexKey<?, ?>, Map<Object, StubIdList>> getStubIndicesValueMap() {
        try {
            this.restoreIndexedStubs();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        Map<StubIndexKey<?, ?>, Map<Object, StubIdList>> map2 = this.myIndexedStubs;
        if (map2 == null) {
            SerializedStubTree.$$$reportNull$$$0(12);
        }
        return map2;
    }

    @NotNull
    public Stub getStub() throws SerializerNotFoundException {
        if (this.myTreeByteLength == 0) {
            Stub stub = NO_STUB;
            if (stub == null) {
                SerializedStubTree.$$$reportNull$$$0(13);
            }
            return stub;
        }
        Stub stub = this.mySerializationManager.deserialize(new UnsyncByteArrayInputStream(this.myTreeBytes, 0, this.myTreeByteLength));
        if (stub == null) {
            SerializedStubTree.$$$reportNull$$$0(14);
        }
        return stub;
    }

    @NotNull
    public SerializedStubTree withoutStub() {
        return new SerializedStubTree(ArrayUtil.EMPTY_BYTE_ARRAY, 0, this.myIndexedStubBytes, this.myIndexedStubByteLength, this.myIndexedStubs, this.myStubIndexesExternalizer, this.mySerializationManager);
    }

    public boolean equals(Object that) {
        if (this == that) {
            return true;
        }
        if (!(that instanceof SerializedStubTree)) {
            return false;
        }
        SerializedStubTree thatTree = (SerializedStubTree)that;
        int length = this.myTreeByteLength;
        if (length != thatTree.myTreeByteLength) {
            return false;
        }
        for (int i = 0; i < length; ++i) {
            if (this.myTreeBytes[i] == thatTree.myTreeBytes[i]) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int result2 = 1;
        for (int i = 0; i < this.myTreeByteLength; ++i) {
            result2 = 31 * result2 + this.myTreeBytes[i];
        }
        return result2;
    }

    @NotNull
    static Map<StubIndexKey<?, ?>, Map<Object, StubIdList>> indexTree(@NotNull Stub root) {
        if (root == null) {
            SerializedStubTree.$$$reportNull$$$0(15);
        }
        ObjectStubTree objectStubTree = root instanceof PsiFileStub ? new StubTree((PsiFileStub)root, false) : new ObjectStubTree((ObjectStubBase)root, false);
        Map<StubIndexKey<?, ?>, Map<Object, StubIdList>> map2 = objectStubTree.indexStubTree(k -> StubIndexKeyDescriptorCache.INSTANCE.getKeyHashingStrategy(k));
        for (StubIndexKey<?, ?> key : map2.keySet()) {
            Map<Object, StubIdList> value = map2.get(key);
            for (Object k2 : value.keySet()) {
                int[] ints = (int[])value.get(k2);
                StubIdList stubList = ints.length == 1 ? new StubIdList(ints[0]) : new StubIdList(ints, ints.length);
                value.put(k2, stubList);
            }
        }
        Map<StubIndexKey<?, ?>, Map<Object, StubIdList>> map3 = map2;
        if (map3 == null) {
            SerializedStubTree.$$$reportNull$$$0(16);
        }
        return map3;
    }

    public synchronized byte @NotNull [] getTreeHash() {
        if (this.myTreeHash == null) {
            MessageDigest digest = DigestUtil.sha256();
            digest.update(String.valueOf(this.myTreeByteLength).getBytes(StandardCharsets.UTF_8));
            digest.update("\u0000".getBytes(StandardCharsets.UTF_8));
            digest.update(this.myTreeBytes, 0, this.myTreeByteLength);
            this.myTreeHash = digest.digest();
        }
        if (this.myTreeHash == null) {
            SerializedStubTree.$$$reportNull$$$0(17);
        }
        return this.myTreeHash;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 9: 
            case 12: 
            case 13: 
            case 14: 
            case 16: 
            case 17: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 9: 
            case 12: 
            case 13: 
            case 14: 
            case 16: 
            case 17: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stubIndexesExternalizer";
                break;
            }
            case 1: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "serializationManager";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "treeBytes";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indexedStubBytes";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootStub";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "forwardIndexExternalizer";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newSerializationManager";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newForwardIndexSerializer";
                break;
            }
            case 9: 
            case 12: 
            case 13: 
            case 14: 
            case 16: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/stubs/SerializedStubTree";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indexKey";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/stubs/SerializedStubTree";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getStubIndexesExternalizer";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getStubIndicesValueMap";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getStub";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "indexTree";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getTreeHash";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "serializeStub";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "reSerialize";
                break;
            }
            case 9: 
            case 12: 
            case 13: 
            case 14: 
            case 16: 
            case 17: {
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "restoreIndexedStubs";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "indexTree";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 9: 
            case 12: 
            case 13: 
            case 14: 
            case 16: 
            case 17: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

