/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.util;

import com.intellij.model.BranchableUsageInfo;
import com.intellij.model.ModelBranch;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectoryContainer;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.SmartPsiFileRange;
import com.intellij.usageView.UsageInfo;
import com.intellij.util.BitUtil;
import com.intellij.util.Function;
import java.lang.reflect.Field;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MoveRenameUsageInfo
extends UsageInfo
implements BranchableUsageInfo,
Cloneable {
    private static final Logger LOG = Logger.getInstance(MoveRenameUsageInfo.class);
    private SmartPsiElementPointer<?> myReferencedElementPointer;
    private PsiElement myReferencedElement;
    private PsiReference myReference;
    private RangeMarker myReferenceRangeMarker;

    public MoveRenameUsageInfo(PsiReference reference, PsiElement referencedElement) {
        this(reference.getElement(), reference, referencedElement);
    }

    public MoveRenameUsageInfo(PsiElement element, PsiReference reference, PsiElement referencedElement) {
        super(element);
        this.init(element, reference, referencedElement);
    }

    public MoveRenameUsageInfo(PsiElement element, PsiReference reference, int startOffset, int endOffset, PsiElement referencedElement, boolean nonCodeUsage) {
        super(element, startOffset, endOffset, nonCodeUsage);
        this.init(element, reference, referencedElement);
    }

    private void init(PsiElement element, PsiReference reference, PsiElement referencedElement) {
        TextRange textRange;
        Project project = element.getProject();
        this.myReferencedElement = referencedElement;
        if (referencedElement != null) {
            this.myReferencedElementPointer = SmartPointerManager.getInstance(project).createSmartPsiElementPointer(referencedElement);
        }
        if (reference == null) {
            reference = element.getReference();
        }
        PsiFile containingFile = element.getContainingFile();
        if (reference == null && (textRange = element.getTextRange()) != null) {
            reference = containingFile.findReferenceAt(textRange.getStartOffset());
        }
        this.myReference = reference;
        if (reference != null) {
            Document document = PsiDocumentManager.getInstance(project).getDocument(containingFile);
            if (document != null) {
                TextRange rangeInElement;
                int elementStart = reference.getElement().getTextRange().getStartOffset();
                LOG.assertTrue(elementStart + (rangeInElement = reference.getRangeInElement()).getEndOffset() <= document.getTextLength(), reference);
                this.myReferenceRangeMarker = document.createRangeMarker(elementStart + rangeInElement.getStartOffset(), elementStart + rangeInElement.getEndOffset());
            }
            this.myDynamicUsage = reference.resolve() == null;
        }
    }

    @Nullable
    public PsiElement getUpToDateReferencedElement() {
        return this.myReferencedElementPointer == null ? null : (PsiElement)this.myReferencedElementPointer.getElement();
    }

    @Nullable
    public PsiElement getReferencedElement() {
        return this.myReferencedElement;
    }

    @Override
    @Nullable
    public PsiReference getReference() {
        PsiElement element;
        if (this.myReference != null && (element = this.myReference.getElement()).isValid()) {
            if (this.myReferenceRangeMarker == null) {
                return this.myReference;
            }
            PsiReference reference = this.checkReferenceRange(element, start -> this.myReference);
            if (reference != null) {
                return reference;
            }
        }
        if (this.myReferenceRangeMarker == null) {
            return null;
        }
        element = this.getElement();
        if (element == null || !element.isValid()) {
            return null;
        }
        return this.checkReferenceRange(element, start -> element.findReferenceAt((int)start));
    }

    @Nullable
    private PsiReference checkReferenceRange(PsiElement element, Function<? super Integer, ? extends PsiReference> fn) {
        int start = this.myReferenceRangeMarker.getStartOffset() - element.getTextRange().getStartOffset();
        int end = this.myReferenceRangeMarker.getEndOffset() - element.getTextRange().getStartOffset();
        PsiReference reference = fn.fun((Integer)start);
        if (reference == null) {
            return null;
        }
        TextRange rangeInElement = reference.getRangeInElement();
        if (rangeInElement.getStartOffset() != start || rangeInElement.getEndOffset() != end) {
            return null;
        }
        return reference;
    }

    @Override
    @NotNull
    public MoveRenameUsageInfo obtainBranchCopy(@NotNull ModelBranch branch) {
        MoveRenameUsageInfo moveRenameUsageInfo;
        if (branch == null) {
            MoveRenameUsageInfo.$$$reportNull$$$0(0);
        }
        try {
            MoveRenameUsageInfo copy2 = (MoveRenameUsageInfo)this.clone();
            for (Class<?> aClass = copy2.getClass(); aClass != null; aClass = aClass.getSuperclass()) {
                for (Field field : aClass.getDeclaredFields()) {
                    if (BitUtil.isSet(field.getModifiers(), 8)) continue;
                    field.setAccessible(true);
                    Object valueCopy = this.obtainBranchCopy(branch, field.get(copy2));
                    if (valueCopy == null) continue;
                    field.set(copy2, valueCopy);
                }
            }
            moveRenameUsageInfo = copy2;
        }
        catch (CloneNotSupportedException | IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        if (moveRenameUsageInfo == null) {
            MoveRenameUsageInfo.$$$reportNull$$$0(1);
        }
        return moveRenameUsageInfo;
    }

    private Object obtainBranchCopy(ModelBranch branch, Object fieldValue) {
        if (fieldValue instanceof PsiElement) {
            return MoveRenameUsageInfo.isPackage((PsiElement)((Object)fieldValue)) ? fieldValue : branch.obtainPsiCopy((PsiElement)((Object)fieldValue));
        }
        if (fieldValue instanceof PsiReference) {
            return branch.obtainReferenceCopy((PsiReference)((Object)fieldValue));
        }
        if (fieldValue instanceof SmartPsiFileRange) {
            return SmartPointerManager.getInstance(this.getProject()).createSmartPsiFileRangePointer(branch.obtainPsiCopy(Objects.requireNonNull(((SmartPsiFileRange)fieldValue).getContainingFile())), TextRange.create(Objects.requireNonNull(((SmartPsiFileRange)fieldValue).getRange())));
        }
        if (fieldValue instanceof SmartPsiElementPointer) {
            PsiElement element = (PsiElement)Objects.requireNonNull(((SmartPsiElementPointer)fieldValue).getElement());
            return MoveRenameUsageInfo.isPackage(element) ? fieldValue : SmartPointerManager.createPointer(branch.obtainPsiCopy(element));
        }
        if (fieldValue instanceof RangeMarker) {
            return MoveRenameUsageInfo.obtainMarkerCopy(branch, (RangeMarker)((Object)fieldValue));
        }
        return null;
    }

    private static boolean isPackage(PsiElement element) {
        return element instanceof PsiDirectoryContainer && element.getContainingFile() == null;
    }

    private static RangeMarker obtainMarkerCopy(@NotNull ModelBranch branch, RangeMarker original) {
        if (branch == null) {
            MoveRenameUsageInfo.$$$reportNull$$$0(2);
        }
        Document document = original.getDocument();
        VirtualFile file2 = FileDocumentManager.getInstance().getFile(document);
        VirtualFile fileCopy = branch.findFileCopy(Objects.requireNonNull(file2));
        Document docCopy = FileDocumentManager.getInstance().getDocument(Objects.requireNonNull(fileCopy));
        assert (docCopy != null);
        RangeMarker marker = docCopy.createRangeMarker(original.getStartOffset(), original.getEndOffset());
        marker.setGreedyToLeft(original.isGreedyToLeft());
        marker.setGreedyToRight(original.isGreedyToRight());
        return marker;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "branch";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/refactoring/util/MoveRenameUsageInfo";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/refactoring/util/MoveRenameUsageInfo";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "obtainBranchCopy";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "obtainBranchCopy";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "obtainMarkerCopy";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

