/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.EditableModel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.swing.AbstractListModel;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CollectionListModel<T>
extends AbstractListModel<T>
implements EditableModel {
    private final List<T> myItems;

    public CollectionListModel(@NotNull Collection<? extends T> items) {
        if (items == null) {
            CollectionListModel.$$$reportNull$$$0(0);
        }
        this.myItems = new ArrayList<T>(items);
    }

    public CollectionListModel(@NotNull List<T> items, boolean useListAsIs) {
        if (items == null) {
            CollectionListModel.$$$reportNull$$$0(1);
        }
        this.myItems = items;
    }

    public CollectionListModel(@NotNull List<? extends T> items) {
        if (items == null) {
            CollectionListModel.$$$reportNull$$$0(2);
        }
        this.myItems = new ArrayList<T>(items);
    }

    @SafeVarargs
    public CollectionListModel(T ... items) {
        if (items == null) {
            CollectionListModel.$$$reportNull$$$0(3);
        }
        this.myItems = ContainerUtil.newArrayList(items);
    }

    @NotNull
    protected final List<T> getInternalList() {
        List<T> list = this.myItems;
        if (list == null) {
            CollectionListModel.$$$reportNull$$$0(4);
        }
        return list;
    }

    @Override
    public int getSize() {
        return this.myItems.size();
    }

    @Override
    public T getElementAt(int index2) {
        return this.myItems.get(index2);
    }

    public void add(T element) {
        int i = this.myItems.size();
        this.myItems.add(element);
        this.fireIntervalAdded(this, i, i);
    }

    public void add(int i, T element) {
        this.myItems.add(i, element);
        this.fireIntervalAdded(this, i, i);
    }

    public void add(@NotNull List<? extends T> elements) {
        if (elements == null) {
            CollectionListModel.$$$reportNull$$$0(5);
        }
        this.addAll(this.myItems.size(), elements);
    }

    public void addAll(int index2, @NotNull List<? extends T> elements) {
        if (elements == null) {
            CollectionListModel.$$$reportNull$$$0(6);
        }
        if (elements.isEmpty()) {
            return;
        }
        this.myItems.addAll(index2, elements);
        this.fireIntervalAdded(this, index2, index2 + elements.size() - 1);
    }

    public void remove(@NotNull T element) {
        int index2;
        if (element == null) {
            CollectionListModel.$$$reportNull$$$0(7);
        }
        if ((index2 = this.getElementIndex(element)) != -1) {
            this.remove(index2);
        }
    }

    public void setElementAt(@NotNull T item, int index2) {
        if (item == null) {
            CollectionListModel.$$$reportNull$$$0(8);
        }
        this.itemReplaced(this.myItems.set(index2, item), item);
        this.fireContentsChanged(this, index2, index2);
    }

    protected void itemReplaced(@NotNull T existingItem, @Nullable T newItem) {
        if (existingItem == null) {
            CollectionListModel.$$$reportNull$$$0(9);
        }
    }

    public void remove(int index2) {
        T item = this.myItems.remove(index2);
        if (item != null) {
            this.itemReplaced(item, null);
        }
        this.fireIntervalRemoved(this, index2, index2);
    }

    public void removeAll() {
        int size = this.myItems.size();
        if (size > 0) {
            this.myItems.clear();
            this.fireIntervalRemoved(this, 0, size - 1);
        }
    }

    public void contentsChanged(@NotNull T element) {
        if (element == null) {
            CollectionListModel.$$$reportNull$$$0(10);
        }
        int i = this.myItems.indexOf(element);
        this.fireContentsChanged(this, i, i);
    }

    public void allContentsChanged() {
        this.fireContentsChanged(this, 0, this.myItems.size() - 1);
    }

    public void sort(Comparator<? super T> comparator) {
        this.myItems.sort(comparator);
    }

    @NotNull
    public List<T> getItems() {
        List<T> list = Collections.unmodifiableList(this.myItems);
        if (list == null) {
            CollectionListModel.$$$reportNull$$$0(11);
        }
        return list;
    }

    public void replaceAll(@NotNull List<? extends T> elements) {
        if (elements == null) {
            CollectionListModel.$$$reportNull$$$0(12);
        }
        this.removeAll();
        this.add(elements);
    }

    @Override
    public void addRow() {
    }

    @Override
    public void removeRow(int index2) {
        this.remove(index2);
    }

    @Override
    public void exchangeRows(int oldIndex, int newIndex) {
        Collections.swap(this.myItems, oldIndex, newIndex);
        this.fireContentsChanged(this, oldIndex, oldIndex);
        this.fireContentsChanged(this, newIndex, newIndex);
    }

    @Override
    public boolean canExchangeRows(int oldIndex, int newIndex) {
        return true;
    }

    @NonNls
    public String toString() {
        return this.getClass().getName() + " (" + this.getSize() + " elements)";
    }

    public List<T> toList() {
        return new ArrayList<T>(this.myItems);
    }

    public int getElementIndex(T item) {
        return this.myItems.indexOf(item);
    }

    public boolean isEmpty() {
        return this.myItems.isEmpty();
    }

    public boolean contains(T item) {
        return this.getElementIndex(item) >= 0;
    }

    public void removeRange(int fromIndex, int toIndex) {
        if (fromIndex > toIndex) {
            throw new IllegalArgumentException("fromIndex must be <= toIndex");
        }
        for (int i = toIndex; i >= fromIndex; --i) {
            this.itemReplaced(this.myItems.remove(i), null);
        }
        this.fireIntervalRemoved(this, fromIndex, toIndex);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 11: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 11: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "items";
                break;
            }
            case 4: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ui/CollectionListModel";
                break;
            }
            case 5: 
            case 6: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 7: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "item";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "existingItem";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ui/CollectionListModel";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getInternalList";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getItems";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 11: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "add";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "addAll";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "remove";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "setElementAt";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "itemReplaced";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "contentsChanged";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "replaceAll";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 4: 
            case 11: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

