/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.AbstractBundle;
import com.intellij.DynamicBundle;
import com.intellij.diagnostic.StartUpMeasurer;
import com.intellij.icons.AllIcons;
import com.intellij.ide.IconLayerProvider;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.util.Iconable;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.ScalableIcon;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.Strings;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.BadgeIcon;
import com.intellij.ui.CoreAwareIconManager;
import com.intellij.ui.IconDeferrer;
import com.intellij.ui.IconDescriptionBundleEP;
import com.intellij.ui.IconManager;
import com.intellij.ui.IconWithToolTip;
import com.intellij.ui.IconWrapperWithToolTip;
import com.intellij.ui.IconWrapperWithToolTipComposite;
import com.intellij.ui.LayeredIcon;
import com.intellij.ui.OffsetIcon;
import com.intellij.ui.RasterizedImageDataLoader;
import com.intellij.ui.ScalableIconWrapperWithToolTip;
import com.intellij.ui.icons.IconLoadMeasurer;
import com.intellij.ui.icons.ImageDataLoader;
import com.intellij.ui.icons.RowIcon;
import com.intellij.ui.mac.foundation.MacUtil;
import com.intellij.util.BitUtil;
import com.intellij.util.IconUtil;
import com.intellij.util.ui.EmptyIcon;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.ResourceBundle;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.swing.Icon;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public final class CoreIconManager
implements IconManager,
CoreAwareIconManager {
    private static final List<IconLayer> iconLayers = new CopyOnWriteArrayList<IconLayer>();
    private static final int FLAGS_LOCKED = 2048;
    private static final Logger LOG = Logger.getInstance(CoreIconManager.class);

    @Override
    @NotNull
    public Icon getStubIcon() {
        Icon icon2 = AllIcons.Actions.Stub;
        if (icon2 == null) {
            CoreIconManager.$$$reportNull$$$0(0);
        }
        return icon2;
    }

    @Override
    @NotNull
    public Icon getIcon(@NotNull String path, @NotNull Class<?> aClass) {
        if (path == null) {
            CoreIconManager.$$$reportNull$$$0(1);
        }
        if (aClass == null) {
            CoreIconManager.$$$reportNull$$$0(2);
        }
        Icon icon2 = IconLoader.getIcon(path, aClass);
        IconDescriptionLoader tooltip = new IconDescriptionLoader(path);
        if (icon2 instanceof ScalableIcon) {
            return new ScalableIconWrapperWithToolTip((ScalableIcon)icon2, (Supplier<String>)tooltip);
        }
        return new IconWrapperWithToolTip(icon2, tooltip);
    }

    @Override
    @NotNull
    public Icon loadRasterizedIcon(@NotNull String path, @NotNull ClassLoader classLoader, int cacheKey, int flags) {
        if (path == null) {
            CoreIconManager.$$$reportNull$$$0(3);
        }
        if (classLoader == null) {
            CoreIconManager.$$$reportNull$$$0(4);
        }
        assert (!path.isEmpty() && path.charAt(0) != '/');
        return new IconWithToolTipImpl(path, CoreIconManager.createRasterizedImageDataLoader(path, classLoader, cacheKey, flags));
    }

    @NotNull
    private static ImageDataLoader createRasterizedImageDataLoader(@NotNull String path, @NotNull ClassLoader classLoader, int cacheKey, int imageFlags) {
        if (path == null) {
            CoreIconManager.$$$reportNull$$$0(5);
        }
        if (classLoader == null) {
            CoreIconManager.$$$reportNull$$$0(6);
        }
        long startTime = StartUpMeasurer.getCurrentTimeIfEnabled();
        Pair<String, ClassLoader> patchedPath = IconLoader.patchPath(path, classLoader);
        WeakReference<ClassLoader> classLoaderWeakRef = new WeakReference<ClassLoader>(classLoader);
        ImageDataLoader resolver = patchedPath == null ? new RasterizedImageDataLoader(path, classLoaderWeakRef, path, classLoaderWeakRef, cacheKey, imageFlags) : RasterizedImageDataLoader.createPatched(path, classLoaderWeakRef, patchedPath, cacheKey, imageFlags);
        if (startTime != -1L) {
            IconLoadMeasurer.findIcon.end(startTime);
        }
        ImageDataLoader imageDataLoader = resolver;
        if (imageDataLoader == null) {
            CoreIconManager.$$$reportNull$$$0(7);
        }
        return imageDataLoader;
    }

    @Override
    @NotNull
    public Icon createEmptyIcon(@NotNull Icon icon2) {
        if (icon2 == null) {
            CoreIconManager.$$$reportNull$$$0(8);
        }
        EmptyIcon emptyIcon = EmptyIcon.create(icon2);
        if (emptyIcon == null) {
            CoreIconManager.$$$reportNull$$$0(9);
        }
        return emptyIcon;
    }

    @Override
    @NotNull
    public <T> Icon createDeferredIcon(@Nullable Icon base, T param, @NotNull Function<? super T, ? extends Icon> iconProducer) {
        if (iconProducer == null) {
            CoreIconManager.$$$reportNull$$$0(10);
        }
        Icon icon2 = IconDeferrer.getInstance().defer(base, param, iconProducer);
        if (icon2 == null) {
            CoreIconManager.$$$reportNull$$$0(11);
        }
        return icon2;
    }

    @Override
    public void registerIconLayer(int flagMask, @NotNull Icon icon2) {
        if (icon2 == null) {
            CoreIconManager.$$$reportNull$$$0(12);
        }
        for (IconLayer iconLayer : iconLayers) {
            if (iconLayer.flagMask != flagMask) continue;
            return;
        }
        iconLayers.add(new IconLayer(flagMask, icon2));
    }

    @Override
    @NotNull
    public Icon tooltipOnlyIfComposite(@NotNull Icon icon2) {
        if (icon2 == null) {
            CoreIconManager.$$$reportNull$$$0(13);
        }
        return new IconWrapperWithToolTipComposite(icon2);
    }

    @Override
    @NotNull
    public RowIcon createRowIcon(int iconCount, RowIcon.Alignment alignment) {
        return new com.intellij.ui.RowIcon(iconCount, alignment);
    }

    @Override
    @NotNull
    public RowIcon createRowIcon(Icon ... icons) {
        if (icons == null) {
            CoreIconManager.$$$reportNull$$$0(14);
        }
        return new com.intellij.ui.RowIcon(icons);
    }

    @Override
    @NotNull
    public com.intellij.ui.RowIcon createLayeredIcon(@NotNull Iconable instance, Icon icon2, int flags) {
        if (instance == null) {
            CoreIconManager.$$$reportNull$$$0(15);
        }
        ArrayList<Icon> layersFromProviders = new ArrayList<Icon>();
        for (IconLayerProvider iconLayerProvider : IconLayerProvider.EP_NAME.getExtensionList()) {
            Icon layerIcon = iconLayerProvider.getLayerIcon(instance, BitUtil.isSet(flags, 2048));
            if (layerIcon == null) continue;
            layersFromProviders.add(layerIcon);
        }
        if (flags != 0 || !layersFromProviders.isEmpty()) {
            ArrayList<Icon> iconLayers = new ArrayList<Icon>();
            for (IconLayer l : CoreIconManager.iconLayers) {
                if (!BitUtil.isSet(flags, l.flagMask)) continue;
                iconLayers.add(l.icon);
            }
            iconLayers.addAll(layersFromProviders);
            LayeredIcon layeredIcon = new LayeredIcon(1 + iconLayers.size());
            layeredIcon.setIcon(icon2, 0);
            for (int i = 0; i < iconLayers.size(); ++i) {
                Icon icon1 = (Icon)iconLayers.get(i);
                layeredIcon.setIcon(icon1, i + 1);
            }
            icon2 = layeredIcon;
        }
        com.intellij.ui.RowIcon baseIcon = new com.intellij.ui.RowIcon(2);
        baseIcon.setIcon(icon2, 0);
        com.intellij.ui.RowIcon rowIcon = baseIcon;
        if (rowIcon == null) {
            CoreIconManager.$$$reportNull$$$0(16);
        }
        return rowIcon;
    }

    @Override
    @NotNull
    public Icon createOffsetIcon(@NotNull Icon icon2) {
        if (icon2 == null) {
            CoreIconManager.$$$reportNull$$$0(17);
        }
        return new OffsetIcon(icon2);
    }

    @Override
    @NotNull
    public Icon colorize(Graphics2D g, @NotNull Icon source, @NotNull Color color) {
        if (source == null) {
            CoreIconManager.$$$reportNull$$$0(18);
        }
        if (color == null) {
            CoreIconManager.$$$reportNull$$$0(19);
        }
        Icon icon2 = IconUtil.colorize(g, source, color);
        if (icon2 == null) {
            CoreIconManager.$$$reportNull$$$0(20);
        }
        return icon2;
    }

    @Override
    @NotNull
    public Icon createLayered(Icon ... icons) {
        if (icons == null) {
            CoreIconManager.$$$reportNull$$$0(21);
        }
        return new LayeredIcon(icons);
    }

    @Override
    @NotNull
    public Icon getIcon(@NotNull VirtualFile file2, int flags, @Nullable Project project) {
        if (file2 == null) {
            CoreIconManager.$$$reportNull$$$0(22);
        }
        Icon icon2 = IconUtil.getIcon(file2, flags, project);
        if (icon2 == null) {
            CoreIconManager.$$$reportNull$$$0(23);
        }
        return icon2;
    }

    @Override
    @NotNull
    public Runnable wakeUpNeo(@NotNull Object reason) {
        if (reason == null) {
            CoreIconManager.$$$reportNull$$$0(24);
        }
        Runnable runnable = MacUtil.wakeUpNeo(reason);
        if (runnable == null) {
            CoreIconManager.$$$reportNull$$$0(25);
        }
        return runnable;
    }

    @Nullable
    private static String findIconDescription(@NotNull String path) {
        String pathWithoutExt;
        if (path == null) {
            CoreIconManager.$$$reportNull$$$0(26);
        }
        String key = "icon." + ((pathWithoutExt = Strings.trimEnd(path, ".svg")).startsWith("/") ? pathWithoutExt.substring(1) : pathWithoutExt).replace('/', '.') + ".tooltip";
        Ref result2 = new Ref();
        IconDescriptionBundleEP.EP_NAME.processWithPluginDescriptor((ep, descriptor) -> {
            ResourceBundle bundle;
            String description;
            ClassLoader classLoader;
            ClassLoader classLoader2 = classLoader = descriptor == null ? null : descriptor.getPluginClassLoader();
            if (classLoader == null) {
                classLoader = CoreIconManager.class.getClassLoader();
            }
            if ((description = AbstractBundle.messageOrNull(bundle = DynamicBundle.INSTANCE.getResourceBundle(ep.resourceBundle, classLoader), key, new Object[0])) != null) {
                result2.set(description);
            }
        });
        if (result2.get() == null && Registry.is("ide.icon.tooltips.trace.missing", false)) {
            LOG.info("Icon tooltip requested but not found for " + path);
        }
        return (String)result2.get();
    }

    @Override
    @NotNull
    public Icon withIconBadge(@NotNull Icon icon2, @NotNull Paint color) {
        if (icon2 == null) {
            CoreIconManager.$$$reportNull$$$0(27);
        }
        if (color == null) {
            CoreIconManager.$$$reportNull$$$0(28);
        }
        return new BadgeIcon(icon2, color);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 10: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 17: 
            case 18: 
            case 19: 
            case 21: 
            case 22: 
            case 24: 
            case 26: 
            case 27: 
            case 28: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 10: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 17: 
            case 18: 
            case 19: 
            case 21: 
            case 22: 
            case 24: 
            case 26: 
            case 27: 
            case 28: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ui/CoreIconManager";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classLoader";
                break;
            }
            case 8: 
            case 12: 
            case 13: 
            case 17: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "icon";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "iconProducer";
                break;
            }
            case 14: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "icons";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "instance";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 19: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "color";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reason";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getStubIcon";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 10: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 17: 
            case 18: 
            case 19: 
            case 21: 
            case 22: 
            case 24: 
            case 26: 
            case 27: 
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ui/CoreIconManager";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "createRasterizedImageDataLoader";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "createEmptyIcon";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "createDeferredIcon";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "createLayeredIcon";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "colorize";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "getIcon";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "wakeUpNeo";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "getIcon";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "loadRasterizedIcon";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "createRasterizedImageDataLoader";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "createEmptyIcon";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "createDeferredIcon";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "registerIconLayer";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "tooltipOnlyIfComposite";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "createRowIcon";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "createLayeredIcon";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "createOffsetIcon";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "colorize";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "createLayered";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "wakeUpNeo";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "findIconDescription";
                break;
            }
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "withIconBadge";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 10: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 17: 
            case 18: 
            case 19: 
            case 21: 
            case 22: 
            case 24: 
            case 26: 
            case 27: 
            case 28: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
        }
        throw runtimeException;
    }

    private static final class IconDescriptionLoader
    implements Supplier<String> {
        private final String path;
        private String result;
        private boolean isCalculated;

        private IconDescriptionLoader(String path) {
            this.path = path;
        }

        @Override
        public String get() {
            if (!this.isCalculated) {
                this.result = CoreIconManager.findIconDescription(this.path);
                this.isCalculated = true;
            }
            return this.result;
        }
    }

    private static final class IconLayer {
        private final int flagMask;
        @NotNull
        private final Icon icon;

        private IconLayer(int flagMask, @NotNull Icon icon2) {
            if (icon2 == null) {
                IconLayer.$$$reportNull$$$0(0);
            }
            BitUtil.assertOneBitMask(flagMask);
            this.flagMask = flagMask;
            this.icon = icon2;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "icon", "com/intellij/ui/CoreIconManager$IconLayer", "<init>"));
        }
    }

    private static final class IconWithToolTipImpl
    extends IconLoader.CachedImageIcon
    implements IconWithToolTip {
        private String result;
        private boolean isTooltipCalculated;

        IconWithToolTipImpl(@NotNull String originalPath, @NotNull ImageDataLoader resolver) {
            if (originalPath == null) {
                IconWithToolTipImpl.$$$reportNull$$$0(0);
            }
            if (resolver == null) {
                IconWithToolTipImpl.$$$reportNull$$$0(1);
            }
            super(originalPath, resolver, null, null);
        }

        @Override
        @NlsContexts.Tooltip
        @Nullable
        public String getToolTip(boolean composite) {
            if (!this.isTooltipCalculated) {
                this.result = CoreIconManager.findIconDescription(Objects.requireNonNull(this.getOriginalPath()));
                this.isTooltipCalculated = true;
            }
            return this.result;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "originalPath";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "resolver";
                    break;
                }
            }
            objectArray[1] = "com/intellij/ui/CoreIconManager$IconWithToolTipImpl";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

