/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.indexing;

import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.util.indexing.DataIndexer;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.FileContent;
import java.util.Collections;
import java.util.Map;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.OverrideOnly
public abstract class SingleEntryIndexer<V>
implements DataIndexer<Integer, V, FileContent> {
    private final boolean myAcceptNullValues;

    protected SingleEntryIndexer(boolean acceptNullValues) {
        this.myAcceptNullValues = acceptNullValues;
    }

    @Override
    @NotNull
    public final Map<Integer, V> map(@NotNull FileContent inputData) {
        V value;
        if (inputData == null) {
            SingleEntryIndexer.$$$reportNull$$$0(0);
        }
        if ((value = this.computeValue(inputData)) == null && !this.myAcceptNullValues) {
            Map map2 = Collections.emptyMap();
            if (map2 == null) {
                SingleEntryIndexer.$$$reportNull$$$0(1);
            }
            return map2;
        }
        VirtualFile file2 = inputData.getFile();
        int key = file2 instanceof LightVirtualFile ? -1 : Math.abs(FileBasedIndex.getFileId(file2));
        Map<Integer, V> map3 = Collections.singletonMap(key, value);
        if (map3 == null) {
            SingleEntryIndexer.$$$reportNull$$$0(2);
        }
        return map3;
    }

    @Nullable
    protected abstract V computeValue(@NotNull FileContent var1);

    @ApiStatus.Internal
    public boolean isAcceptNullValues() {
        return this.myAcceptNullValues;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inputData";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/indexing/SingleEntryIndexer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/indexing/SingleEntryIndexer";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "map";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "map";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

