/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.io;

import com.intellij.openapi.Forceable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.CommonProcessors;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.Processor;
import com.intellij.util.SystemProperties;
import com.intellij.util.indexing.impl.IndexDebugProperties;
import com.intellij.util.io.DataEnumeratorEx;
import com.intellij.util.io.DifferentSerializableBytesImplyNonEqualityPolicy;
import com.intellij.util.io.IOCancellationCallbackHolder;
import com.intellij.util.io.InlineKeyDescriptor;
import com.intellij.util.io.KeyDescriptor;
import com.intellij.util.io.PersistentEnumeratorCache;
import com.intellij.util.io.ResizeableMappedFile;
import com.intellij.util.io.SelfDiagnosing;
import com.intellij.util.io.VersionUpdatedException;
import com.intellij.util.io.keyStorage.AppendableObjectStorage;
import com.intellij.util.io.keyStorage.AppendableStorageBackedByResizableMappedFile;
import com.intellij.util.io.keyStorage.InlinedKeyStorage;
import com.intellij.util.io.keyStorage.NoDataException;
import java.io.Closeable;
import java.io.Flushable;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;

public abstract class PersistentEnumeratorBase<Data>
implements DataEnumeratorEx<Data>,
Forceable,
Closeable,
SelfDiagnosing {
    protected static final Logger LOG = Logger.getInstance(PersistentEnumeratorBase.class);
    protected static final int NULL_ID = 0;
    protected static final boolean USE_RW_LOCK = SystemProperties.getBooleanProperty("idea.persistent.data.use.read.write.lock", false);
    private static final int META_DATA_OFFSET = 4;
    static final int DATA_START = 20;
    protected final ResizeableMappedFile myStorage;
    @NotNull
    protected final AppendableObjectStorage<Data> myKeyStorage;
    final KeyDescriptor<Data> myDataDescriptor;
    protected final Path myFile;
    private final Version myVersion;
    private final boolean myDoCaching;
    private final ReentrantReadWriteLock myLock;
    private volatile boolean myDirtyStatusUpdateInProgress;
    private boolean myClosed;
    private boolean myDirty;
    private boolean myCorrupted;
    private RecordBufferHandler<PersistentEnumeratorBase<?>> myRecordHandler;
    @Nullable
    private Flushable myMarkCleanCallback;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PersistentEnumeratorBase(@NotNull Path file2, @NotNull ResizeableMappedFile storage, @NotNull KeyDescriptor<Data> dataDescriptor, int initialSize, @NotNull Version version, @NotNull RecordBufferHandler<? extends PersistentEnumeratorBase<?>> recordBufferHandler, boolean doCaching) throws IOException {
        boolean created;
        block26: {
            if (file2 == null) {
                PersistentEnumeratorBase.$$$reportNull$$$0(0);
            }
            if (storage == null) {
                PersistentEnumeratorBase.$$$reportNull$$$0(1);
            }
            if (dataDescriptor == null) {
                PersistentEnumeratorBase.$$$reportNull$$$0(2);
            }
            if (version == null) {
                PersistentEnumeratorBase.$$$reportNull$$$0(3);
            }
            if (recordBufferHandler == null) {
                PersistentEnumeratorBase.$$$reportNull$$$0(4);
            }
            this.myLock = new ReentrantReadWriteLock(true);
            this.myDataDescriptor = dataDescriptor;
            this.myFile = file2;
            this.myVersion = version;
            this.myRecordHandler = recordBufferHandler;
            this.myDoCaching = doCaching;
            if (!Files.exists(file2, new LinkOption[0])) {
                if (file2.getFileSystem().isReadOnly()) {
                    throw new IOException(file2 + " in " + file2.getFileSystem() + " is not exist");
                }
                FileUtil.delete(this.keyStreamFile());
                if (!FileUtil.createIfDoesntExist(file2.toFile())) {
                    throw new IOException("Cannot create empty file: " + file2);
                }
            }
            this.myStorage = storage;
            created = false;
            this.lockStorageWrite();
            try {
                int sign;
                if (this.myStorage.length() == 0L) {
                    try {
                        this.markDirty(true);
                        this.putMetaData(0L);
                        this.putMetaData2(0L);
                        this.setupEmptyFile();
                        this.doFlush();
                        created = true;
                        break block26;
                    }
                    catch (RuntimeException e) {
                        LOG.info(e);
                        this.myStorage.close();
                        if (e.getCause() instanceof IOException) {
                            throw (IOException)e.getCause();
                        }
                        throw e;
                    }
                    catch (IOException e) {
                        LOG.info(e);
                        this.myStorage.close();
                        throw e;
                    }
                    catch (Exception e) {
                        LOG.info(e);
                        this.myStorage.close();
                        throw new CorruptedException(file2);
                    }
                }
                try {
                    sign = this.myStorage.getInt(0L);
                }
                catch (Exception e) {
                    LOG.info(e);
                    sign = this.myVersion.dirtyMagic;
                }
                if (sign != this.myVersion.correctlyClosedMagic) {
                    this.myStorage.close();
                    if (sign != this.myVersion.dirtyMagic) {
                        throw new VersionUpdatedException(file2);
                    }
                    throw new CorruptedException(file2);
                }
            }
            finally {
                this.unlockStorageWrite();
            }
        }
        if (dataDescriptor instanceof InlineKeyDescriptor) {
            this.myKeyStorage = new InlinedKeyStorage((InlineKeyDescriptor)dataDescriptor);
        } else {
            try {
                this.myKeyStorage = new AppendableStorageBackedByResizableMappedFile<Data>(this.keyStreamFile(), initialSize, this.myStorage.getStorageLockContext(), 0x100000, false, dataDescriptor);
            }
            catch (Throwable e) {
                LOG.info(e);
                this.myStorage.close();
                throw new CorruptedException(file2);
            }
        }
        if (IndexDebugProperties.IS_UNIT_TEST_MODE) {
            LOG.info("PersistentEnumeratorBase at " + this.myFile + " has been open (new = " + created + ")");
        }
    }

    @NotNull
    protected Lock getWriteLock() {
        ReentrantReadWriteLock.WriteLock writeLock = this.myLock.writeLock();
        if (writeLock == null) {
            PersistentEnumeratorBase.$$$reportNull$$$0(5);
        }
        return writeLock;
    }

    @NotNull
    protected Lock getReadLock() {
        Lock lock = USE_RW_LOCK ? this.myLock.readLock() : this.myLock.writeLock();
        if (lock == null) {
            PersistentEnumeratorBase.$$$reportNull$$$0(6);
        }
        return lock;
    }

    void lockStorageRead() {
        this.myStorage.lockRead();
    }

    void unlockStorageRead() {
        this.myStorage.unlockRead();
    }

    void lockStorageWrite() {
        this.myStorage.lockWrite();
    }

    void unlockStorageWrite() {
        this.myStorage.unlockWrite();
    }

    protected abstract void setupEmptyFile() throws IOException;

    @NotNull
    final RecordBufferHandler<PersistentEnumeratorBase<?>> getRecordHandler() {
        RecordBufferHandler<PersistentEnumeratorBase<?>> recordBufferHandler = this.myRecordHandler;
        if (recordBufferHandler == null) {
            PersistentEnumeratorBase.$$$reportNull$$$0(7);
        }
        return recordBufferHandler;
    }

    public void setRecordHandler(@NotNull RecordBufferHandler<PersistentEnumeratorBase<?>> recordHandler) {
        if (recordHandler == null) {
            PersistentEnumeratorBase.$$$reportNull$$$0(8);
        }
        this.myRecordHandler = recordHandler;
    }

    void setMarkCleanCallback(@NotNull Flushable markCleanCallback) {
        if (markCleanCallback == null) {
            PersistentEnumeratorBase.$$$reportNull$$$0(9);
        }
        this.myMarkCleanCallback = markCleanCallback;
    }

    public Data getValue(int keyId, int processingKey) throws IOException {
        return this.valueOf(keyId);
    }

    @Override
    public int tryEnumerate(Data value) throws IOException {
        return this.doEnumerate(value, true, false);
    }

    private int doEnumerate(Data value, boolean onlyCheckForExisting, boolean saveNewValue) throws IOException {
        int cachedId;
        if (this.myDoCaching && !saveNewValue && (cachedId = PersistentEnumeratorCache.getCachedId(value, this)) != 0) {
            return cachedId;
        }
        int id = this.catchCorruption(() -> this.enumerateImpl(value, onlyCheckForExisting, saveNewValue));
        if (this.myDoCaching && id != 0) {
            PersistentEnumeratorCache.cacheId(value, id, this);
        }
        return id;
    }

    @Override
    public int enumerate(Data value) throws IOException {
        return this.doEnumerate(value, false, false);
    }

    protected void putMetaData(long data) throws IOException {
        this.lockStorageWrite();
        try {
            if (this.myStorage.length() < 12L || this.getMetaData() != data) {
                this.myStorage.putLong(4L, data);
            }
        }
        finally {
            this.unlockStorageWrite();
        }
    }

    protected long getMetaData() throws IOException {
        this.lockStorageRead();
        try {
            long l = this.myStorage.getLong(4L);
            return l;
        }
        finally {
            this.unlockStorageRead();
        }
    }

    void putMetaData2(long data) throws IOException {
        this.lockStorageWrite();
        try {
            if (this.myStorage.length() < 20L || this.getMetaData2() != data) {
                this.myStorage.putLong(12L, data);
            }
        }
        finally {
            this.unlockStorageWrite();
        }
    }

    long getMetaData2() throws IOException {
        this.lockStorageRead();
        try {
            long l = this.myStorage.getLong(12L);
            return l;
        }
        finally {
            this.unlockStorageRead();
        }
    }

    public boolean processAllDataObject(final @NotNull Processor<? super Data> processor, final @Nullable DataFilter filter2) throws IOException {
        if (processor == null) {
            PersistentEnumeratorBase.$$$reportNull$$$0(10);
        }
        return this.traverseAllRecords(new RecordsProcessor(){

            @Override
            public boolean process(int record) throws IOException {
                if (filter2 == null || filter2.accept(record)) {
                    return processor.process(PersistentEnumeratorBase.this.valueOf(record));
                }
                return true;
            }
        });
    }

    @NotNull
    public Collection<Data> getAllDataObjects(@Nullable DataFilter filter2) throws IOException {
        ArrayList values = new ArrayList();
        this.processAllDataObject(new CommonProcessors.CollectProcessor(values), filter2);
        ArrayList arrayList = values;
        if (arrayList == null) {
            PersistentEnumeratorBase.$$$reportNull$$$0(11);
        }
        return arrayList;
    }

    public abstract boolean traverseAllRecords(RecordsProcessor var1) throws IOException;

    protected abstract int enumerateImpl(Data var1, boolean var2, boolean var3) throws IOException;

    protected boolean isKeyAtIndex(Data value, int idx) throws IOException {
        if (this.myKeyStorage instanceof InlinedKeyStorage) {
            return false;
        }
        int addr = this.indexToAddr(idx);
        if (this.myKeyStorage.checkBytesAreTheSame(addr, value)) {
            return true;
        }
        if (this.myDataDescriptor instanceof DifferentSerializableBytesImplyNonEqualityPolicy) {
            return false;
        }
        return this.myDataDescriptor.isEqual(this.valueOf(idx), value);
    }

    protected int writeData(Data value, int hashCode) {
        try {
            this.markDirty(true);
            int dataOff = this.doWriteData(value);
            return this.setupValueId(hashCode, dataOff);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public int getLargestId() {
        return this.myKeyStorage.getCurrentLength();
    }

    protected int doWriteData(Data value) throws IOException {
        return this.myKeyStorage.append(value);
    }

    protected int setupValueId(int hashCode, int dataOff) throws IOException {
        byte[] buf = this.myRecordHandler.getRecordBuffer(this);
        this.myRecordHandler.setupRecord(this, hashCode, dataOff, buf);
        int pos = this.myRecordHandler.recordWriteOffset(this, buf);
        this.myStorage.put(pos, buf, 0, buf.length);
        return pos;
    }

    public boolean iterateData(@NotNull Processor<? super Data> processor) throws IOException {
        if (processor == null) {
            PersistentEnumeratorBase.$$$reportNull$$$0(12);
        }
        return this.doIterateData((offset, data) -> processor.process((Object)data));
    }

    protected boolean doIterateData(@NotNull AppendableObjectStorage.StorageObjectProcessor<? super Data> processor) throws IOException {
        if (processor == null) {
            PersistentEnumeratorBase.$$$reportNull$$$0(13);
        }
        this.lockStorageWrite();
        try {
            this.myKeyStorage.force();
        }
        finally {
            this.unlockStorageWrite();
        }
        return this.myKeyStorage.processAll(processor);
    }

    private Path keyStreamFile() {
        return this.myFile.resolveSibling(this.myFile.getFileName() + ".keystream");
    }

    @Override
    public Data valueOf(int idx) throws IOException {
        if (idx <= 0) {
            return null;
        }
        return (Data)this.catchCorruption(() -> this.findValueFor(idx));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Data findValueFor(int idx) throws IOException {
        this.lockStorageRead();
        try {
            int addr = this.indexToAddr(idx);
            Data Data2 = this.myKeyStorage.read(addr);
            return Data2;
        }
        finally {
            this.unlockStorageRead();
        }
    }

    int reEnumerate(Data key) throws IOException {
        if (!this.canReEnumerate()) {
            throw new IncorrectOperationException();
        }
        return this.doEnumerate(key, false, true);
    }

    boolean canReEnumerate() {
        return false;
    }

    protected abstract int indexToAddr(int var1) throws IOException;

    @Override
    public void close() throws IOException {
        this.getWriteLock().lock();
        try {
            this.lockStorageWrite();
            try {
                if (!this.myClosed) {
                    this.myClosed = true;
                    this.doClose();
                    if (IndexDebugProperties.IS_UNIT_TEST_MODE) {
                        LOG.info("PersistentEnumeratorBase at " + this.myFile + " has been closed");
                    }
                }
            }
            finally {
                this.unlockStorageWrite();
            }
        }
        finally {
            this.getWriteLock().unlock();
        }
    }

    protected void doClose() throws IOException {
        IOCancellationCallbackHolder.interactWithUI();
        this.lockStorageWrite();
        try {
            try {
                this.force();
                this.myKeyStorage.close();
            }
            finally {
                this.myStorage.close();
            }
        }
        finally {
            this.unlockStorageWrite();
        }
    }

    public boolean isClosed() {
        this.getReadLock().lock();
        try {
            boolean bl = this.myClosed;
            return bl;
        }
        finally {
            this.getReadLock().unlock();
        }
    }

    @Override
    public boolean isDirty() {
        this.lockStorageRead();
        try {
            boolean bl = this.myDirty;
            return bl;
        }
        finally {
            this.unlockStorageRead();
        }
    }

    public boolean isCorrupted() {
        this.lockStorageRead();
        try {
            boolean bl = this.myCorrupted;
            return bl;
        }
        finally {
            this.unlockStorageRead();
        }
    }

    protected void doFlush() throws IOException {
        this.markDirty(false);
        this.myStorage.force();
    }

    @Override
    public void force() {
        this.getWriteLock().lock();
        try {
            this.lockStorageWrite();
            try {
                this.myKeyStorage.force();
                if (this.myStorage.isDirty() || this.isDirty()) {
                    this.doFlush();
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            finally {
                this.unlockStorageWrite();
            }
        }
        finally {
            this.getWriteLock().unlock();
        }
    }

    protected final void markDirty(boolean dirty) throws IOException {
        if (dirty && this.myDirty && !this.myDirtyStatusUpdateInProgress) {
            return;
        }
        this.lockStorageWrite();
        try {
            if (this.myDirty) {
                if (!dirty) {
                    this.myDirtyStatusUpdateInProgress = true;
                    if (this.myMarkCleanCallback != null) {
                        this.myMarkCleanCallback.flush();
                    }
                    if (!this.myCorrupted) {
                        this.myStorage.putInt(0L, this.myVersion.correctlyClosedMagic);
                        this.myDirty = false;
                    }
                    this.myDirtyStatusUpdateInProgress = false;
                }
            } else if (dirty) {
                this.myDirtyStatusUpdateInProgress = true;
                this.myStorage.putInt(0L, this.myVersion.dirtyMagic);
                this.myDirtyStatusUpdateInProgress = false;
                this.myDirty = true;
            }
        }
        finally {
            this.unlockStorageWrite();
        }
    }

    protected void markCorrupted() {
        if (IndexDebugProperties.IS_UNIT_TEST_MODE) {
            this.dumpKeysOnCorruption();
        }
        this.lockStorageWrite();
        try {
            if (!this.myCorrupted) {
                this.myCorrupted = true;
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Marking corrupted:" + this.myFile, new Throwable());
                }
                try {
                    this.markDirty(true);
                    this.force();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
        finally {
            this.unlockStorageWrite();
        }
    }

    protected void dumpKeysOnCorruption() {
    }

    protected boolean trySelfHeal() {
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @VisibleForTesting
    protected <V> V catchCorruption(ThrowableComputable<V, IOException> operation) throws IOException {
        if (this.isCorrupted()) {
            throw new CorruptedException(this.myFile);
        }
        try {
            try {
                return operation.compute();
            }
            catch (Throwable th) {
                try {
                    if (!(th instanceof NoDataException) && this.trySelfHeal()) {
                        return operation.compute();
                    }
                    throw th;
                }
                catch (Throwable e) {
                    this.markCorrupted();
                    throw new RuntimeException(e);
                }
            }
        }
        catch (NoDataException e) {
            return null;
        }
        catch (IOException io) {
            this.markCorrupted();
            throw io;
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 11: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 11: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "storage";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataDescriptor";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "version";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "recordBufferHandler";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/io/PersistentEnumeratorBase";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "recordHandler";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "markCleanCallback";
                break;
            }
            case 10: 
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/io/PersistentEnumeratorBase";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getWriteLock";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getReadLock";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getRecordHandler";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllDataObjects";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 11: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "setRecordHandler";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "setMarkCleanCallback";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "processAllDataObject";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "iterateData";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "doIterateData";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 11: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }

    public static abstract class RecordsProcessor {
        private int myKey;

        public abstract boolean process(int var1) throws IOException;

        void setCurrentKey(int key) {
            this.myKey = key;
        }

        int getCurrentKey() {
            return this.myKey;
        }
    }

    public static interface DataFilter {
        public boolean accept(int var1) throws IOException;
    }

    @Deprecated
    public static class CorruptedException
    extends com.intellij.util.io.CorruptedException {
        public CorruptedException(Path file2) {
            super("PersistentEnumerator storage corrupted " + file2);
        }

        protected CorruptedException(String message2) {
            super(message2);
        }
    }

    static abstract class RecordBufferHandler<T extends PersistentEnumeratorBase<?>> {
        RecordBufferHandler() {
        }

        abstract int recordWriteOffset(T var1, byte[] var2) throws IOException;

        abstract byte @NotNull [] getRecordBuffer(T var1);

        abstract void setupRecord(T var1, int var2, int var3, byte[] var4);
    }

    public static class Version {
        private static final int DIRTY_MAGIC = -1161946761;
        private static final int CORRECTLY_CLOSED_MAGIC = 247118589;
        private final int correctlyClosedMagic;
        private final int dirtyMagic;

        public Version(int version) {
            this(247118589 + version, -1161946761);
        }

        private Version(int _correctlyClosedMagic, int _dirtyMagic) {
            this.correctlyClosedMagic = _correctlyClosedMagic;
            this.dirtyMagic = _dirtyMagic;
            assert (this.correctlyClosedMagic != this.dirtyMagic);
        }
    }
}

