/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.ui;

import java.awt.GridBagConstraints;

public class GridBagConstraintBuilder {
    private final GridBagConstraints constraint = new GridBagConstraints();

    public GridBagConstraintBuilder() {
        this.constraint.gridx = -1;
        this.constraint.gridy = 0;
    }

    public GridBagConstraints get() {
        return this.constraint;
    }

    public GridBagConstraintBuilder fillX() {
        this.constraint.fill = 2;
        return this;
    }

    public GridBagConstraintBuilder fillY() {
        this.constraint.fill = 3;
        return this;
    }

    public GridBagConstraintBuilder fillXY() {
        this.constraint.fill = 1;
        return this;
    }

    public GridBagConstraintBuilder noFill() {
        this.constraint.fill = 0;
        return this;
    }

    public GridBagConstraintBuilder newLine() {
        ++this.constraint.gridy;
        return this;
    }

    public GridBagConstraintBuilder growX() {
        this.constraint.weightx = 1.0;
        this.constraint.weighty = 0.0;
        return this;
    }

    public GridBagConstraintBuilder weight(double weightx, double weighty) {
        this.constraint.weightx = weightx;
        this.constraint.weighty = weighty;
        return this;
    }

    public GridBagConstraintBuilder growY() {
        this.constraint.weightx = 0.0;
        this.constraint.weighty = 1.0;
        return this;
    }

    public GridBagConstraintBuilder growXY() {
        this.constraint.weightx = 1.0;
        this.constraint.weighty = 1.0;
        return this;
    }

    public GridBagConstraintBuilder noGrow() {
        this.constraint.weightx = 0.0;
        this.constraint.weighty = 0.0;
        return this;
    }

    public GridBagConstraintBuilder width(int w) {
        this.constraint.gridwidth = w;
        return this;
    }

    public GridBagConstraintBuilder noInsets() {
        this.constraint.insets.set(0, 0, 0, 0);
        return this;
    }

    public GridBagConstraintBuilder insets(int top, int left, int bottom, int right) {
        this.constraint.insets.set(top, left, bottom, right);
        return this;
    }

    public GridBagConstraintBuilder anchorEnd() {
        this.constraint.anchor = 22;
        return this;
    }

    public GridBagConstraintBuilder anchorStart() {
        this.constraint.anchor = 21;
        return this;
    }

    public GridBagConstraintBuilder anchorCenter() {
        this.constraint.anchor = 10;
        return this;
    }

    public GridBagConstraintBuilder anchorTrailing() {
        this.constraint.anchor = 768;
        return this;
    }
}

