/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.ui;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.ui.StyleSheetUtil;
import java.awt.GraphicsEnvironment;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import javax.swing.UIManager;
import javax.swing.text.html.StyleSheet;
import kotlin.Deprecated;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\t\u001a\u00020\u0004H\u0007J\u001c\u0010\n\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\f2\n\b\u0002\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0007J\u0012\u0010\n\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u000f\u001a\u00020\u000eH\u0007J\u0010\u0010\n\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\u0010H\u0007R\u001b\u0010\u0003\u001a\u00020\u00048GX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0007\u0010\b\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0011"}, d2={"Lcom/intellij/util/ui/StyleSheetUtil;", "", "()V", "NO_GAPS_BETWEEN_PARAGRAPHS_STYLE", "Ljavax/swing/text/html/StyleSheet;", "getNO_GAPS_BETWEEN_PARAGRAPHS_STYLE", "()Ljavax/swing/text/html/StyleSheet;", "NO_GAPS_BETWEEN_PARAGRAPHS_STYLE$delegate", "Lkotlin/Lazy;", "getDefaultStyleSheet", "loadStyleSheet", "input", "Ljava/io/InputStream;", "ref", "Ljava/net/URL;", "url", "", "intellij.platform.util.ui"})
public final class StyleSheetUtil {
    @NotNull
    private static final Lazy NO_GAPS_BETWEEN_PARAGRAPHS_STYLE$delegate;
    @NotNull
    public static final StyleSheetUtil INSTANCE;

    @ApiStatus.Internal
    @NotNull
    public final StyleSheet getNO_GAPS_BETWEEN_PARAGRAPHS_STYLE() {
        Lazy lazy = NO_GAPS_BETWEEN_PARAGRAPHS_STYLE$delegate;
        StyleSheetUtil styleSheetUtil = this;
        Object var3_3 = null;
        return (StyleSheet)lazy.getValue();
    }

    @JvmStatic
    @NotNull
    public static final StyleSheet getDefaultStyleSheet() {
        StyleSheet globalStyleSheet;
        StyleSheet sheet = new StyleSheet();
        Object object = UIManager.getDefaults().get("HTMLEditorKit.jbStyleSheet");
        if (!(object instanceof StyleSheet)) {
            object = null;
        }
        if ((globalStyleSheet = (StyleSheet)object) == null) {
            if (!GraphicsEnvironment.isHeadless()) {
                StyleSheetUtil $this$thisLogger$iv = INSTANCE;
                boolean $i$f$thisLogger = false;
                Logger logger = Logger.getInstance(StyleSheetUtil.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"Logger.getInstance(T::class.java)");
                logger.warn("Missing global CSS sheet");
            }
            return sheet;
        }
        sheet.addStyleSheet(globalStyleSheet);
        return sheet;
    }

    @JvmStatic
    @NotNull
    public static final StyleSheet loadStyleSheet(@NotNull String input) {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        StyleSheet styleSheet = new StyleSheet();
        try {
            styleSheet.loadRules(new StringReader(input), null);
        }
        catch (IOException e) {
            throw (Throwable)new RuntimeException(e);
        }
        return styleSheet;
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final StyleSheet loadStyleSheet(@NotNull InputStream input, @Nullable URL ref) throws IOException {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        StyleSheet result2 = new StyleSheet();
        result2.loadRules(new InputStreamReader(input, StandardCharsets.UTF_8), ref);
        return result2;
    }

    public static /* synthetic */ StyleSheet loadStyleSheet$default(InputStream inputStream, URL uRL, int n, Object object) throws IOException {
        if ((n & 2) != 0) {
            uRL = null;
        }
        return StyleSheetUtil.loadStyleSheet(inputStream, uRL);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final StyleSheet loadStyleSheet(@NotNull InputStream input) throws IOException {
        return StyleSheetUtil.loadStyleSheet$default(input, null, 2, null);
    }

    @Deprecated(message="Use loadStyleSheet(InputStream)")
    @Nullable
    public final StyleSheet loadStyleSheet(@NotNull URL url) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        try {
            StyleSheet result2 = new StyleSheet();
            result2.loadRules(new InputStreamReader(url.openStream(), StandardCharsets.UTF_8), url);
            return result2;
        }
        catch (IOException e) {
            StyleSheetUtil $this$thisLogger$iv = this;
            boolean $i$f$thisLogger = false;
            Logger logger = Logger.getInstance(StyleSheetUtil.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"Logger.getInstance(T::class.java)");
            logger.warn(url + " loading failed", e);
            return null;
        }
    }

    private StyleSheetUtil() {
    }

    static {
        StyleSheetUtil styleSheetUtil;
        INSTANCE = styleSheetUtil = new StyleSheetUtil();
        NO_GAPS_BETWEEN_PARAGRAPHS_STYLE$delegate = LazyKt.lazy((Function0)NO_GAPS_BETWEEN_PARAGRAPHS_STYLE.2.INSTANCE);
    }
}

