/*
 * Decompiled with CFR 0.152.
 */
package app.softwork.kobol.flowgraph;

import app.softwork.kobol.fir.CobolFIRTree;
import app.softwork.kobol.fir.FirCodeGenerator;
import app.softwork.kobol.flowgraph.PlantumlFlowGraphKt;
import java.io.File;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0016\u0010\t\u001a\u00020\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fH\u0016J\b\u0010\u000e\u001a\u00020\nH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lapp/softwork/kobol/flowgraph/PlantumlFlowGraph;", "Lapp/softwork/kobol/fir/FirCodeGenerator;", "outputFolder", "Ljava/io/File;", "<init>", "(Ljava/io/File;)V", "content", "", "", "generate", "", "fir", "", "Lapp/softwork/kobol/fir/CobolFIRTree;", "close", "plugin-flow-graph-plantuml"})
@SourceDebugExtension(value={"SMAP\nPlantumlFlowGraph.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PlantumlFlowGraph.kt\napp/softwork/kobol/flowgraph/PlantumlFlowGraph\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,130:1\n1187#2,2:131\n1261#2,4:133\n*S KotlinDebug\n*F\n+ 1 PlantumlFlowGraph.kt\napp/softwork/kobol/flowgraph/PlantumlFlowGraph\n*L\n14#1:131,2\n14#1:133,4\n*E\n"})
public final class PlantumlFlowGraph
implements FirCodeGenerator {
    @NotNull
    private final File outputFolder;
    @NotNull
    private Map<String, String> content;

    public PlantumlFlowGraph(@NotNull File outputFolder) {
        Intrinsics.checkNotNullParameter((Object)outputFolder, (String)"outputFolder");
        this.outputFolder = outputFolder;
        this.content = MapsKt.emptyMap();
    }

    /*
     * WARNING - void declaration
     */
    public void generate(@NotNull Iterable<CobolFIRTree> fir) {
        void $this$associateTo$iv$iv;
        void $this$associate$iv;
        Intrinsics.checkNotNullParameter(fir, (String)"fir");
        Iterable<CobolFIRTree> iterable = fir;
        PlantumlFlowGraph plantumlFlowGraph = this;
        boolean $i$f$associate = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
        void var5_6 = $this$associate$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateTo = false;
        for (Object element$iv$iv : $this$associateTo$iv$iv) {
            Map map = destination$iv$iv;
            CobolFIRTree it = (CobolFIRTree)element$iv$iv;
            boolean bl = false;
            String string = it.getId().getProgramID().toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
            Pair pair = TuplesKt.to((Object)string, (Object)PlantumlFlowGraphKt.createFlowGraph(it));
            map.put(pair.getFirst(), pair.getSecond());
        }
        plantumlFlowGraph.content = destination$iv$iv;
    }

    public void close() {
        for (Map.Entry<String, String> entry : this.content.entrySet()) {
            File file;
            String program = entry.getKey();
            String flow = entry.getValue();
            File $this$close_u24lambda_u241 = file = new File(this.outputFolder, program + ".puml");
            boolean bl = false;
            if (!$this$close_u24lambda_u241.exists()) {
                $this$close_u24lambda_u241.createNewFile();
            }
            FilesKt.writeText$default((File)file, (String)flow, null, (int)2, null);
        }
    }
}

