/*
 * Decompiled with CFR 0.152.
 */
package app.softwork.kobol.plugins;

import app.softwork.kobol.fir.CobolFIRTree;
import app.softwork.kobol.fir.FirCodeGenerator;
import app.softwork.kobol.plugins.Results;
import app.softwork.kobol.plugins.StatisticsKt;
import java.io.File;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.StringCompanionObject;
import kotlin.ranges.RangesKt;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.SerializationStrategy;
import kotlinx.serialization.StringFormat;
import kotlinx.serialization.builtins.BuiltinSerializersKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u000e\u001a\u00020\u000fH\u0016J\u0016\u0010\u0010\u001a\u00020\u000f2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R6\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\b2\u0012\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\b@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0014"}, d2={"Lapp/softwork/kobol/plugins/Statistics;", "Lapp/softwork/kobol/fir/FirCodeGenerator;", "outputFolder", "Ljava/io/File;", "format", "Lkotlinx/serialization/StringFormat;", "(Ljava/io/File;Lkotlinx/serialization/StringFormat;)V", "<set-?>", "", "", "Lapp/softwork/kobol/plugins/Results;", "results", "getResults", "()Ljava/util/Map;", "close", "", "generate", "fir", "", "Lapp/softwork/kobol/fir/CobolFIRTree;", "plugin-statistic"})
@SourceDebugExtension(value={"SMAP\nStatistics.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Statistics.kt\napp/softwork/kobol/plugins/Statistics\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,151:1\n1179#2,2:152\n1253#2,4:154\n*S KotlinDebug\n*F\n+ 1 Statistics.kt\napp/softwork/kobol/plugins/Statistics\n*L\n16#1:152,2\n16#1:154,4\n*E\n"})
public final class Statistics
implements FirCodeGenerator {
    @NotNull
    private final File outputFolder;
    @NotNull
    private final StringFormat format;
    @NotNull
    private Map<String, Results> results;

    public Statistics(@NotNull File outputFolder, @NotNull StringFormat format) {
        Intrinsics.checkNotNullParameter((Object)outputFolder, (String)"outputFolder");
        Intrinsics.checkNotNullParameter((Object)format, (String)"format");
        this.outputFolder = outputFolder;
        this.format = format;
        this.results = MapsKt.emptyMap();
    }

    @NotNull
    public final Map<String, Results> getResults() {
        return this.results;
    }

    /*
     * WARNING - void declaration
     */
    public void generate(@NotNull Iterable<CobolFIRTree> fir) {
        void $this$associateTo$iv$iv;
        void $this$associate$iv;
        Intrinsics.checkNotNullParameter(fir, (String)"fir");
        Iterable<CobolFIRTree> iterable = fir;
        Statistics statistics = this;
        boolean $i$f$associate = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
        void var5_6 = $this$associate$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateTo = false;
        for (Object element$iv$iv : $this$associateTo$iv$iv) {
            Map map = destination$iv$iv;
            CobolFIRTree it = (CobolFIRTree)element$iv$iv;
            boolean bl = false;
            Map<String, Integer> complexity2 = StatisticsKt.complexity(it);
            String string = it.getId().getProgramID().toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
            Pair pair = TuplesKt.to((Object)string, (Object)new Results(complexity2));
            map.put(pair.getFirst(), pair.getSecond());
        }
        statistics.results = destination$iv$iv;
    }

    public void close() {
        File file;
        File $this$close_u24lambda_u241 = file = new File(this.outputFolder, "results.json");
        boolean bl = false;
        if (!$this$close_u24lambda_u241.exists()) {
            $this$close_u24lambda_u241.createNewFile();
        }
        FilesKt.writeText$default((File)file, (String)this.format.encodeToString((SerializationStrategy)BuiltinSerializersKt.MapSerializer((KSerializer)BuiltinSerializersKt.serializer((StringCompanionObject)StringCompanionObject.INSTANCE), Results.Companion.serializer()), this.results), null, (int)2, null);
    }
}

