/*
 * Decompiled with CFR 0.152.
 */
package app.softwork.serialization.csv;

import app.softwork.serialization.csv.CSVConfiguration;
import app.softwork.serialization.csv.CSVDecoder;
import app.softwork.serialization.csv.CSVFormat;
import app.softwork.serialization.csv.CSVNode;
import app.softwork.serialization.csv.CSVParserKt;
import app.softwork.serialization.csv.StatefulIterator;
import java.util.List;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import kotlinx.serialization.DeserializationStrategy;
import kotlinx.serialization.ExperimentalSerializationApi;
import kotlinx.serialization.SerializationException;
import kotlinx.serialization.descriptors.PolymorphicKind;
import kotlinx.serialization.descriptors.SerialDescriptor;
import kotlinx.serialization.descriptors.SerialDescriptorKt;
import kotlinx.serialization.descriptors.SerialKind;
import kotlinx.serialization.descriptors.StructureKind;
import kotlinx.serialization.encoding.AbstractDecoder;
import kotlinx.serialization.encoding.CompositeDecoder;
import kotlinx.serialization.modules.SerializersModule;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ExperimentalSerializationApi
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0092\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0001\n\u0002\b\u0002\n\u0002\u0010\u0005\n\u0000\n\u0002\u0010\n\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\f\n\u0002\b\b\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0001\u0018\u00002\u00020\u00012\u00020\u0002B;\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\r\u001a\u00020\u000e\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u0010\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eH\u0016J\b\u0010\u001f\u001a\u00020\fH\u0016J\u0011\u0010 \u001a\u00020!2\u0006\u0010\u001d\u001a\u00020\u001eH\u0096\u0010J\n\u0010\"\u001a\u0004\u0018\u00010#H\u0016J\b\u0010$\u001a\u00020\fH\u0016J\b\u0010%\u001a\u00020&H\u0016J\b\u0010'\u001a\u00020(H\u0016J\b\u0010)\u001a\u00020\u000eH\u0016J\b\u0010*\u001a\u00020+H\u0016J\b\u0010,\u001a\u00020-H\u0016J\b\u0010.\u001a\u00020\u0005H\u0002J\b\u0010/\u001a\u000200H\u0016J\b\u00101\u001a\u000202H\u0016J\b\u00103\u001a\u00020\u0005H\u0016J\b\u00104\u001a\u00020#H\u0002J\u0010\u00105\u001a\u00020\u000e2\u0006\u00106\u001a\u00020\u001eH\u0016J\b\u00107\u001a\u00020\fH\u0016J\u0010\u00108\u001a\u00020\u000e2\u0006\u0010\u001d\u001a\u00020\u001eH\u0016J)\u00109\u001a\u0004\u0018\u0001H:\"\b\b\u0000\u0010:*\u00020;2\u000e\u0010<\u001a\n\u0012\u0006\u0012\u0004\u0018\u0001H:0=H\u0016\u00a2\u0006\u0002\u0010>R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\u00020\nX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0017\u001a\u00020\u00188VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u001a\u00a8\u0006?"}, d2={"Lapp/softwork/serialization/csv/CSVDecoderImpl;", "Lkotlinx/serialization/encoding/AbstractDecoder;", "Lapp/softwork/serialization/csv/CSVDecoder;", "header", "", "", "nodes", "Lapp/softwork/serialization/csv/StatefulIterator;", "Lapp/softwork/serialization/csv/CSVNode;", "configuration", "Lapp/softwork/serialization/csv/CSVConfiguration;", "decodesSequentially", "", "level", "", "<init>", "(Ljava/util/List;Lapp/softwork/serialization/csv/StatefulIterator;Lapp/softwork/serialization/csv/CSVConfiguration;ZI)V", "getConfiguration", "()Lapp/softwork/serialization/csv/CSVConfiguration;", "getDecodesSequentially", "()Z", "index", "currentRow", "serializersModule", "Lkotlinx/serialization/modules/SerializersModule;", "getSerializersModule", "()Lkotlinx/serialization/modules/SerializersModule;", "beginStructure", "Lkotlinx/serialization/encoding/CompositeDecoder;", "descriptor", "Lkotlinx/serialization/descriptors/SerialDescriptor;", "decodeNotNullMark", "endStructure", "", "decodeNull", "", "decodeBoolean", "decodeByte", "", "decodeShort", "", "decodeInt", "decodeLong", "", "decodeFloat", "", "decodeNumber", "decodeDouble", "", "decodeChar", "", "decodeString", "throwUnknownValue", "decodeEnum", "enumDescriptor", "decodeSequentially", "decodeElementIndex", "decodeNullableSerializableValue", "T", "", "deserializer", "Lkotlinx/serialization/DeserializationStrategy;", "(Lkotlinx/serialization/DeserializationStrategy;)Ljava/lang/Object;", "kotlinx-serialization-csv"})
public final class CSVDecoderImpl
extends AbstractDecoder
implements CSVDecoder {
    @NotNull
    private final List<String> header;
    @NotNull
    private final StatefulIterator<CSVNode> nodes;
    @NotNull
    private final CSVConfiguration configuration;
    private final boolean decodesSequentially;
    private final int level;
    private int index;
    private int currentRow;

    public CSVDecoderImpl(@NotNull List<String> header, @NotNull StatefulIterator<? extends CSVNode> nodes, @NotNull CSVConfiguration configuration, boolean decodesSequentially, int level) {
        Intrinsics.checkNotNullParameter(header, (String)"header");
        Intrinsics.checkNotNullParameter(nodes, (String)"nodes");
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
        this.header = header;
        this.nodes = nodes;
        this.configuration = configuration;
        this.decodesSequentially = decodesSequentially;
        this.level = level;
    }

    @Override
    @NotNull
    public CSVConfiguration getConfiguration() {
        return this.configuration;
    }

    public final boolean getDecodesSequentially() {
        return this.decodesSequentially;
    }

    @NotNull
    public SerializersModule getSerializersModule() {
        return this.getConfiguration().getSerializersModule();
    }

    @NotNull
    public CompositeDecoder beginStructure(@NotNull SerialDescriptor descriptor) {
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        SerialKind serialKind = descriptor.getKind();
        if (Intrinsics.areEqual((Object)serialKind, (Object)StructureKind.CLASS.INSTANCE)) {
            Pair pair;
            List nextHeaders;
            if (this.getConfiguration().getIncludeHeader()) {
                nextHeaders = this.header.subList(this.index, this.header.size());
                pair = TuplesKt.to((Object)nextHeaders, (Object)CSVParserKt.isSequentially(nextHeaders, descriptor));
            } else {
                pair = TuplesKt.to(this.header, (Object)true);
            }
            Pair pair2 = pair;
            nextHeaders = (List)pair2.component1();
            boolean isSequentially = (Boolean)pair2.component2();
            return new CSVDecoderImpl(nextHeaders, this.nodes, this.getConfiguration(), isSequentially, this.level + 1);
        }
        if (Intrinsics.areEqual((Object)serialKind, (Object)PolymorphicKind.SEALED.INSTANCE)) {
            return new CSVDecoderImpl(this.header, this.nodes, this.getConfiguration(), true, this.level);
        }
        return new CSVDecoderImpl(this.header, this.nodes, this.getConfiguration(), false, this.level);
    }

    public boolean decodeNotNullMark() {
        boolean bl;
        CSVNode nextValue = this.nodes.peek();
        if (nextValue instanceof CSVNode.Element) {
            bl = ((CharSequence)((CSVNode.Element)nextValue).unbox-impl()).length() > 0;
        } else if (Intrinsics.areEqual((Object)nextValue, (Object)CSVNode.NewLine.INSTANCE)) {
            bl = false;
        } else if (nextValue == null) {
            bl = false;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        boolean isNotNull = bl;
        return isNotNull;
    }

    public void endStructure(@NotNull SerialDescriptor descriptor) {
        CSVNode next;
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        CSVNode cSVNode = next = this.nodes.peek();
        if (cSVNode instanceof CSVNode.Element) {
            if (this.level == 0) {
                this.nodes.next();
                this.endStructure(descriptor);
            }
        } else if (Intrinsics.areEqual((Object)cSVNode, (Object)CSVNode.NewLine.INSTANCE)) {
            this.nodes.next();
        } else if (cSVNode != null) {
            throw new NoWhenBranchMatchedException();
        }
    }

    @Nullable
    public Void decodeNull() {
        if (this.nodes.hasNext()) {
            this.nodes.next();
        }
        ++this.index;
        return null;
    }

    public boolean decodeBoolean() {
        return Boolean.parseBoolean(this.decodeString());
    }

    public byte decodeByte() {
        return Byte.parseByte(this.decodeString());
    }

    public short decodeShort() {
        return Short.parseShort(this.decodeString());
    }

    public int decodeInt() {
        String s = this.decodeString();
        return Integer.parseInt(s);
    }

    public long decodeLong() {
        return Long.parseLong(this.decodeString());
    }

    public float decodeFloat() {
        return Float.parseFloat(this.decodeNumber());
    }

    private final String decodeNumber() {
        String string;
        String data = this.decodeString();
        switch (WhenMappings.$EnumSwitchMapping$0[this.getConfiguration().getNumberFormat().ordinal()]) {
            case 1: {
                string = data;
                break;
            }
            case 2: {
                string = StringsKt.replace$default((String)data, (String)",", (String)".", (boolean)false, (int)4, null);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return string;
    }

    public double decodeDouble() {
        return Double.parseDouble(this.decodeNumber());
    }

    public char decodeChar() {
        return StringsKt.single((CharSequence)this.decodeString());
    }

    @NotNull
    public String decodeString() {
        ++this.index;
        CSVNode nextNode = (CSVNode)this.nodes.next();
        if (!(nextNode instanceof CSVNode.Element)) {
            if (Intrinsics.areEqual((Object)nextNode, (Object)CSVNode.NewLine.INSTANCE)) {
                this.throwUnknownValue();
                throw new KotlinNothingValueException();
            }
            throw new NoWhenBranchMatchedException();
        }
        return ((CSVNode.Element)nextNode).unbox-impl();
    }

    private final Void throwUnknownValue() {
        throw new SerializationException("Missing value at the end of line " + (this.currentRow + 1 + 1));
    }

    public int decodeEnum(@NotNull SerialDescriptor enumDescriptor) {
        Intrinsics.checkNotNullParameter((Object)enumDescriptor, (String)"enumDescriptor");
        return CollectionsKt.indexOf((Iterable)SerialDescriptorKt.getElementNames((SerialDescriptor)enumDescriptor), (Object)this.decodeString());
    }

    public boolean decodeSequentially() {
        boolean r = this.decodesSequentially;
        return r;
    }

    public int decodeElementIndex(@NotNull SerialDescriptor descriptor) {
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        if (descriptor.getKind() instanceof StructureKind.LIST) {
            int n;
            CSVNode nextValue = this.nodes.peek();
            if (nextValue == null) {
                n = -1;
            } else {
                int n2 = this.currentRow;
                this.currentRow = n2 + 1;
                n = n2;
            }
            return n;
        }
        String string = (String)CollectionsKt.getOrNull(this.header, (int)this.index);
        if (string == null) {
            return -1;
        }
        String headerName = string;
        int index = descriptor.getElementIndex(headerName);
        if (index == -3) {
            this.throwUnknownValue();
            throw new KotlinNothingValueException();
        }
        return index;
    }

    @Nullable
    public <T> T decodeNullableSerializableValue(@NotNull DeserializationStrategy<? extends T> deserializer) {
        Intrinsics.checkNotNullParameter(deserializer, (String)"deserializer");
        return (T)super.decodeNullableSerializableValue(deserializer);
    }

    @Metadata(mv={2, 1, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[CSVFormat.NumberFormat.values().length];
            try {
                nArray[CSVFormat.NumberFormat.Dot.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CSVFormat.NumberFormat.Comma.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

