/*
 * Decompiled with CFR 0.152.
 */
package app.softwork.serialization.csv;

import app.softwork.serialization.csv.CSVConfiguration;
import app.softwork.serialization.csv.CSVEncoder;
import app.softwork.serialization.csv.CSVFormat;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import kotlinx.serialization.ExperimentalSerializationApi;
import kotlinx.serialization.descriptors.SerialDescriptor;
import kotlinx.serialization.encoding.AbstractEncoder;
import kotlinx.serialization.encoding.CompositeEncoder;
import kotlinx.serialization.encoding.Encoder;
import kotlinx.serialization.modules.SerializersModule;
import org.jetbrains.annotations.NotNull;

@ExperimentalSerializationApi
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\u0004\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0001\u0018\u00002\u00020\u00012\u00020\u0002B\u001b\u0012\n\u0010\u0003\u001a\u00060\u0004j\u0002`\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\u0010\u0010\u0018\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0019H\u0016J\u0010\u0010\u001a\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u001bH\u0016J\u0010\u0010\u001c\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u001dH\u0002J\b\u0010\u001e\u001a\u00020\u0015H\u0016J\u0010\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"H\u0016J\u0018\u0010#\u001a\u00020 2\u0006\u0010!\u001a\u00020\"2\u0006\u0010$\u001a\u00020\u0013H\u0016J\u0010\u0010%\u001a\u00020\u00152\u0006\u0010!\u001a\u00020\"H\u0016J\u0010\u0010&\u001a\u00020'2\u0006\u0010!\u001a\u00020\"H\u0016J\u0018\u0010(\u001a\u00020\u00152\u0006\u0010)\u001a\u00020\"2\u0006\u0010*\u001a\u00020\u0013H\u0016R\u0012\u0010\u0003\u001a\u00060\u0004j\u0002`\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\u00020\r8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006+"}, d2={"Lapp/softwork/serialization/csv/CSVEncoderImpl;", "Lkotlinx/serialization/encoding/AbstractEncoder;", "Lapp/softwork/serialization/csv/CSVEncoder;", "builder", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "configuration", "Lapp/softwork/serialization/csv/CSVConfiguration;", "<init>", "(Ljava/lang/StringBuilder;Lapp/softwork/serialization/csv/CSVConfiguration;)V", "getConfiguration", "()Lapp/softwork/serialization/csv/CSVConfiguration;", "serializersModule", "Lkotlinx/serialization/modules/SerializersModule;", "getSerializersModule", "()Lkotlinx/serialization/modules/SerializersModule;", "afterFirst", "", "level", "", "encodeValue", "", "value", "", "encodeDouble", "", "encodeFloat", "", "encodeNumber", "", "encodeNull", "beginStructure", "Lkotlinx/serialization/encoding/CompositeEncoder;", "descriptor", "Lkotlinx/serialization/descriptors/SerialDescriptor;", "beginCollection", "collectionSize", "endStructure", "encodeInline", "Lkotlinx/serialization/encoding/Encoder;", "encodeEnum", "enumDescriptor", "index", "kotlinx-serialization-csv"})
public final class CSVEncoderImpl
extends AbstractEncoder
implements CSVEncoder {
    @NotNull
    private final StringBuilder builder;
    @NotNull
    private final CSVConfiguration configuration;
    private boolean afterFirst;
    private int level;

    public CSVEncoderImpl(@NotNull StringBuilder builder, @NotNull CSVConfiguration configuration) {
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
        this.builder = builder;
        this.configuration = configuration;
    }

    @Override
    @NotNull
    public CSVConfiguration getConfiguration() {
        return this.configuration;
    }

    @NotNull
    public SerializersModule getSerializersModule() {
        return this.getConfiguration().getSerializersModule();
    }

    public void encodeValue(@NotNull Object value) {
        boolean quote;
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        if (this.afterFirst) {
            this.builder.append(this.getConfiguration().getSeparator());
        }
        String valueToAppend = value.toString();
        boolean bl = quote = this.getConfiguration().getAlwaysEmitQuotes() || StringsKt.contains$default((CharSequence)valueToAppend, (char)this.getConfiguration().getSeparator(), (boolean)false, (int)2, null) || StringsKt.contains$default((CharSequence)valueToAppend, (CharSequence)this.getConfiguration().getLineSeparator(), (boolean)false, (int)2, null);
        if (quote) {
            this.builder.append('\"');
        }
        this.builder.append(valueToAppend);
        if (quote) {
            this.builder.append('\"');
        }
        this.afterFirst = true;
    }

    public void encodeDouble(double value) {
        this.encodeNumber(value);
    }

    public void encodeFloat(float value) {
        this.encodeNumber(Float.valueOf(value));
    }

    private final void encodeNumber(Number value) {
        switch (WhenMappings.$EnumSwitchMapping$0[this.getConfiguration().getNumberFormat().ordinal()]) {
            case 1: {
                this.encodeValue(value);
                break;
            }
            case 2: {
                this.encodeValue(StringsKt.replace$default((String)value.toString(), (String)".", (String)",", (boolean)false, (int)4, null));
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
    }

    public void encodeNull() {
        if (this.afterFirst) {
            this.builder.append(this.getConfiguration().getSeparator());
        }
        this.afterFirst = true;
    }

    @NotNull
    public CompositeEncoder beginStructure(@NotNull SerialDescriptor descriptor) {
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        if (this.level == 0) {
            if (((CharSequence)this.builder).length() > 0) {
                this.builder.append(this.getConfiguration().getLineSeparator());
            }
            this.afterFirst = false;
        }
        int n = this.level;
        this.level = n + 1;
        return this;
    }

    @NotNull
    public CompositeEncoder beginCollection(@NotNull SerialDescriptor descriptor, int collectionSize) {
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        return this;
    }

    public void endStructure(@NotNull SerialDescriptor descriptor) {
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        int n = this.level;
        this.level = n + -1;
    }

    @NotNull
    public Encoder encodeInline(@NotNull SerialDescriptor descriptor) {
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        if (this.level == 0) {
            this.builder.append(this.getConfiguration().getLineSeparator());
            this.afterFirst = false;
        }
        return this;
    }

    public void encodeEnum(@NotNull SerialDescriptor enumDescriptor, int index) {
        Intrinsics.checkNotNullParameter((Object)enumDescriptor, (String)"enumDescriptor");
        this.encodeValue(enumDescriptor.getElementName(index));
    }

    @Metadata(mv={2, 1, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[CSVFormat.NumberFormat.values().length];
            try {
                nArray[CSVFormat.NumberFormat.Dot.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CSVFormat.NumberFormat.Comma.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

