/*
 * Decompiled with CFR 0.152.
 */
package app.softwork.serialization.flf;

import app.softwork.serialization.flf.Ebcdic;
import app.softwork.serialization.flf.FailingPrimitiveEncoder;
import app.softwork.serialization.flf.FixedLengthFormatKt;
import app.softwork.serialization.flf.FixedLengthPrimitiveEncoder;
import app.softwork.serialization.flf.FixedLengthSealedClassDiscriminator;
import app.softwork.serialization.flf.FixedLengthSealedEncoder;
import java.lang.annotation.Annotation;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlinx.serialization.ExperimentalSerializationApi;
import kotlinx.serialization.SerializationStrategy;
import kotlinx.serialization.descriptors.PolymorphicKind;
import kotlinx.serialization.descriptors.SerialDescriptor;
import kotlinx.serialization.descriptors.StructureKind;
import kotlinx.serialization.encoding.CompositeEncoder;
import kotlinx.serialization.encoding.Encoder;
import kotlinx.serialization.modules.SerializersModule;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ExperimentalSerializationApi
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0084\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0010\u0005\n\u0000\n\u0002\u0010\f\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\n\n\u0002\b\u0004\b\u0007\u0018\u00002\u00020\u00012\u00020\u0002B)\u0012\n\u0010\u0003\u001a\u00060\u0004j\u0002`\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\u0018\u0010\u0012\u001a\u00020\u00022\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u000fH\u0016J\u0010\u0010\u0016\u001a\u00020\u00022\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u001d\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\t2\u0006\u0010\u001a\u001a\u00020\u000fH\u0000\u00a2\u0006\u0002\b\u001bJ \u0010\u001c\u001a\u00020\u00182\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u001d\u001a\u00020\u000f2\u0006\u0010\u0019\u001a\u00020\u000bH\u0016J \u0010\u001e\u001a\u00020\u00182\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u001d\u001a\u00020\u000f2\u0006\u0010\u0019\u001a\u00020\u001fH\u0016J \u0010 \u001a\u00020\u00182\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u001d\u001a\u00020\u000f2\u0006\u0010\u0019\u001a\u00020!H\u0016J \u0010\"\u001a\u00020\u00182\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u001d\u001a\u00020\u000f2\u0006\u0010\u0019\u001a\u00020#H\u0016J\u0018\u0010$\u001a\u00020\u00182\u0006\u0010%\u001a\u00020\u00142\u0006\u0010\u001d\u001a\u00020\u000fH\u0016J \u0010&\u001a\u00020\u00182\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u001d\u001a\u00020\u000f2\u0006\u0010\u0019\u001a\u00020'H\u0016J\u0010\u0010(\u001a\u00020)2\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0018\u0010*\u001a\u00020)2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u001d\u001a\u00020\u000fH\u0016J \u0010+\u001a\u00020\u00182\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u001d\u001a\u00020\u000f2\u0006\u0010\u0019\u001a\u00020\u000fH\u0016J \u0010,\u001a\u00020\u00182\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u001d\u001a\u00020\u000f2\u0006\u0010\u0019\u001a\u00020-H\u0016J?\u0010.\u001a\u00020\u0018\"\b\b\u0000\u0010/*\u0002002\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u001d\u001a\u00020\u000f2\f\u00101\u001a\b\u0012\u0004\u0012\u0002H/022\b\u0010\u0019\u001a\u0004\u0018\u0001H/H\u0017\u00a2\u0006\u0002\u00103J\u0018\u00104\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\t2\u0006\u0010\u001a\u001a\u00020\u000fH\u0002J9\u00105\u001a\u00020\u0018\"\u0004\b\u0000\u0010/2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u001d\u001a\u00020\u000f2\f\u00101\u001a\b\u0012\u0004\u0012\u0002H/022\u0006\u0010\u0019\u001a\u0002H/H\u0016\u00a2\u0006\u0002\u00103J \u00106\u001a\u00020\u00182\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u001d\u001a\u00020\u000f2\u0006\u0010\u0019\u001a\u000207H\u0016J \u00108\u001a\u00020\u00182\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u001d\u001a\u00020\u000f2\u0006\u0010\u0019\u001a\u00020\tH\u0016J\u0010\u00109\u001a\u00020\u00182\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\b\u0010:\u001a\u00020\u0018H\u0002R\u000e\u0010\r\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0003\u001a\u00060\u0004j\u0002`\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006;"}, d2={"Lapp/softwork/serialization/flf/FixedLengthEncoder;", "Lapp/softwork/serialization/flf/FailingPrimitiveEncoder;", "Lkotlinx/serialization/encoding/CompositeEncoder;", "builder", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "serializersModule", "Lkotlinx/serialization/modules/SerializersModule;", "lineSeparator", "", "fillLeadingZero", "", "(Ljava/lang/StringBuilder;Lkotlinx/serialization/modules/SerializersModule;Ljava/lang/String;Z)V", "afterFirst", "level", "", "getSerializersModule", "()Lkotlinx/serialization/modules/SerializersModule;", "beginCollection", "descriptor", "Lkotlinx/serialization/descriptors/SerialDescriptor;", "collectionSize", "beginStructure", "encode", "", "value", "length", "encode$kotlinx_serialization_flf", "encodeBooleanElement", "index", "encodeByteElement", "", "encodeCharElement", "", "encodeDoubleElement", "", "encodeEnum", "enumDescriptor", "encodeFloatElement", "", "encodeInline", "Lkotlinx/serialization/encoding/Encoder;", "encodeInlineElement", "encodeIntElement", "encodeLongElement", "", "encodeNullableSerializableElement", "T", "", "serializer", "Lkotlinx/serialization/SerializationStrategy;", "(Lkotlinx/serialization/descriptors/SerialDescriptor;ILkotlinx/serialization/SerializationStrategy;Ljava/lang/Object;)V", "encodeNumber", "encodeSerializableElement", "encodeShortElement", "", "encodeStringElement", "endStructure", "maybeAddLine", "kotlinx-serialization-flf"})
@SourceDebugExtension(value={"SMAP\nFixedLengthEncoder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FixedLengthEncoder.kt\napp/softwork/serialization/flf/FixedLengthEncoder\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,167:1\n1#2:168\n*E\n"})
public final class FixedLengthEncoder
implements FailingPrimitiveEncoder,
CompositeEncoder {
    @NotNull
    private final StringBuilder builder;
    @NotNull
    private final SerializersModule serializersModule;
    @NotNull
    private final String lineSeparator;
    private final boolean fillLeadingZero;
    private int level;
    private boolean afterFirst;

    public FixedLengthEncoder(@NotNull StringBuilder builder, @NotNull SerializersModule serializersModule, @NotNull String lineSeparator, boolean fillLeadingZero) {
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        Intrinsics.checkNotNullParameter((Object)serializersModule, (String)"serializersModule");
        Intrinsics.checkNotNullParameter((Object)lineSeparator, (String)"lineSeparator");
        this.builder = builder;
        this.serializersModule = serializersModule;
        this.lineSeparator = lineSeparator;
        this.fillLeadingZero = fillLeadingZero;
    }

    @NotNull
    public SerializersModule getSerializersModule() {
        return this.serializersModule;
    }

    private final void maybeAddLine() {
        if (this.level == 0 && this.afterFirst) {
            this.builder.append(this.lineSeparator);
        }
    }

    public final void encode$kotlinx_serialization_flf(@NotNull String value, int length) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        if (!(value.length() <= length)) {
            boolean bl = false;
            String string = value + " was longer as " + length;
            throw new IllegalArgumentException(string.toString());
        }
        this.builder.append(StringsKt.padEnd$default((String)value, (int)length, (char)'\u0000', (int)2, null));
        this.afterFirst = true;
    }

    private final void encodeNumber(String value, int length) {
        if (this.fillLeadingZero) {
            boolean sign = StringsKt.startsWith$default((String)value, (String)"-", (boolean)false, (int)2, null);
            if (sign) {
                this.encode$kotlinx_serialization_flf('-' + StringsKt.padStart((String)StringsKt.drop((String)value, (int)1), (int)(length - 1), (char)'0'), length);
            } else {
                this.encode$kotlinx_serialization_flf(StringsKt.padStart((String)value, (int)length, (char)'0'), length);
            }
        } else {
            this.encode$kotlinx_serialization_flf(value, length);
        }
    }

    public void encodeBooleanElement(@NotNull SerialDescriptor descriptor, int index, boolean value) {
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        this.encode$kotlinx_serialization_flf(String.valueOf(value), FixedLengthFormatKt.fixedLength(descriptor, index));
    }

    public void encodeByteElement(@NotNull SerialDescriptor descriptor, int index, byte value) {
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        this.encodeNumber(String.valueOf(value), FixedLengthFormatKt.fixedLength(descriptor, index));
    }

    public void encodeCharElement(@NotNull SerialDescriptor descriptor, int index, char value) {
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        this.encode$kotlinx_serialization_flf(String.valueOf(value), FixedLengthFormatKt.fixedLength(descriptor, index));
    }

    public void encodeDoubleElement(@NotNull SerialDescriptor descriptor, int index, double value) {
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        this.encodeNumber(String.valueOf(value), FixedLengthFormatKt.fixedLength(descriptor, index));
    }

    public void encodeFloatElement(@NotNull SerialDescriptor descriptor, int index, float value) {
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        this.encodeNumber(String.valueOf(value), FixedLengthFormatKt.fixedLength(descriptor, index));
    }

    @NotNull
    public Encoder encodeInlineElement(@NotNull SerialDescriptor descriptor, int index) {
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        return this.encodeInline(descriptor.getElementDescriptor(index));
    }

    public void encodeIntElement(@NotNull SerialDescriptor descriptor, int index, int value) {
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        Object object = FixedLengthFormatKt.ebcdic(descriptor, index);
        if (object == null || (object = object.format()) == null || (object = ((Ebcdic.Format)((Object)object)).toString$kotlinx_serialization_flf(value)) == null) {
            object = String.valueOf(value);
        }
        Object stringValue = object;
        this.encodeNumber(stringValue.toString(), FixedLengthFormatKt.fixedLength(descriptor, index));
    }

    public void encodeLongElement(@NotNull SerialDescriptor descriptor, int index, long value) {
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        Object object = FixedLengthFormatKt.ebcdic(descriptor, index);
        if (object == null || (object = object.format()) == null || (object = ((Ebcdic.Format)((Object)object)).toString$kotlinx_serialization_flf(value)) == null) {
            object = String.valueOf(value);
        }
        Object stringValue = object;
        this.encodeNumber(stringValue.toString(), FixedLengthFormatKt.fixedLength(descriptor, index));
    }

    @ExperimentalSerializationApi
    public <T> void encodeNullableSerializableElement(@NotNull SerialDescriptor descriptor, int index, @NotNull SerializationStrategy<? super T> serializer, @Nullable T value) {
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        Intrinsics.checkNotNullParameter(serializer, (String)"serializer");
        FixedLengthPrimitiveEncoder encoder = new FixedLengthPrimitiveEncoder(this.getSerializersModule(), FixedLengthFormatKt.fixedLength(descriptor, index), this.builder, this.fillLeadingZero, FixedLengthFormatKt.ebcdic(descriptor, index));
        if (value == null) {
            encoder.encodeNull();
        } else {
            serializer.serialize((Encoder)encoder, value);
        }
    }

    public <T> void encodeSerializableElement(@NotNull SerialDescriptor descriptor, int index, @NotNull SerializationStrategy<? super T> serializer, T value) {
        boolean isInnerClass;
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        Intrinsics.checkNotNullParameter(serializer, (String)"serializer");
        boolean bl = isInnerClass = this.level != 0 && serializer.getDescriptor().getKind() instanceof StructureKind.CLASS && !serializer.getDescriptor().isInline();
        if (serializer.getDescriptor().getKind() instanceof PolymorphicKind.SEALED) {
            Integer length = FixedLengthFormatKt.getFixedLengthType(serializer.getDescriptor());
            for (Annotation anno : descriptor.getElementAnnotations(index)) {
                if (!(anno instanceof FixedLengthSealedClassDiscriminator)) continue;
                length = null;
                break;
            }
            serializer.serialize((Encoder)new FixedLengthSealedEncoder(length, this), value);
        } else if (descriptor.getKind() instanceof StructureKind.LIST || serializer.getDescriptor().getKind() instanceof StructureKind.LIST || isInnerClass) {
            serializer.serialize((Encoder)this, value);
        } else {
            serializer.serialize((Encoder)new FixedLengthPrimitiveEncoder(this.getSerializersModule(), FixedLengthFormatKt.fixedLength(descriptor, index), this.builder, this.fillLeadingZero, FixedLengthFormatKt.ebcdic(descriptor, index)), value);
        }
    }

    public void encodeShortElement(@NotNull SerialDescriptor descriptor, int index, short value) {
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        this.encodeNumber(String.valueOf(value), FixedLengthFormatKt.fixedLength(descriptor, index));
    }

    public void encodeStringElement(@NotNull SerialDescriptor descriptor, int index, @NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this.encode$kotlinx_serialization_flf(value, FixedLengthFormatKt.fixedLength(descriptor, index));
    }

    @NotNull
    public CompositeEncoder beginStructure(@NotNull SerialDescriptor descriptor) {
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        this.maybeAddLine();
        int n = this.level;
        this.level = n + 1;
        return this;
    }

    @NotNull
    public CompositeEncoder beginCollection(@NotNull SerialDescriptor descriptor, int collectionSize) {
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        return this;
    }

    public void endStructure(@NotNull SerialDescriptor descriptor) {
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        int n = this.level;
        this.level = n + -1;
    }

    public void encodeEnum(@NotNull SerialDescriptor enumDescriptor, int index) {
        Intrinsics.checkNotNullParameter((Object)enumDescriptor, (String)"enumDescriptor");
        String value = enumDescriptor.getElementName(index);
        this.encode$kotlinx_serialization_flf(value, FixedLengthFormatKt.fixedLength(enumDescriptor, index));
    }

    @NotNull
    public Encoder encodeInline(@NotNull SerialDescriptor descriptor) {
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        this.maybeAddLine();
        int fixedLength = FixedLengthFormatKt.getFixedLength(descriptor);
        return new FixedLengthPrimitiveEncoder(this.getSerializersModule(), fixedLength, this.builder, this.fillLeadingZero, FixedLengthFormatKt.getEbcdic(descriptor));
    }

    @Override
    public void encodeBoolean(boolean value) {
        FailingPrimitiveEncoder.DefaultImpls.encodeBoolean(this, value);
    }

    @Override
    public void encodeByte(byte value) {
        FailingPrimitiveEncoder.DefaultImpls.encodeByte(this, value);
    }

    @Override
    public void encodeChar(char value) {
        FailingPrimitiveEncoder.DefaultImpls.encodeChar(this, value);
    }

    @Override
    public void encodeDouble(double value) {
        FailingPrimitiveEncoder.DefaultImpls.encodeDouble(this, value);
    }

    @Override
    public void encodeFloat(float value) {
        FailingPrimitiveEncoder.DefaultImpls.encodeFloat(this, value);
    }

    @Override
    public void encodeInt(int value) {
        FailingPrimitiveEncoder.DefaultImpls.encodeInt(this, value);
    }

    @Override
    public void encodeLong(long value) {
        FailingPrimitiveEncoder.DefaultImpls.encodeLong(this, value);
    }

    @Override
    @ExperimentalSerializationApi
    public void encodeNull() {
        FailingPrimitiveEncoder.DefaultImpls.encodeNull(this);
    }

    @Override
    public void encodeShort(short value) {
        FailingPrimitiveEncoder.DefaultImpls.encodeShort(this, value);
    }

    @Override
    public void encodeString(@NotNull String value) {
        FailingPrimitiveEncoder.DefaultImpls.encodeString(this, value);
    }

    @ExperimentalSerializationApi
    public void encodeNotNullMark() {
        FailingPrimitiveEncoder.DefaultImpls.encodeNotNullMark(this);
    }

    @ExperimentalSerializationApi
    public <T> void encodeNullableSerializableValue(@NotNull SerializationStrategy<? super T> serializer, @Nullable T value) {
        FailingPrimitiveEncoder.DefaultImpls.encodeNullableSerializableValue(this, serializer, value);
    }

    public <T> void encodeSerializableValue(@NotNull SerializationStrategy<? super T> serializer, T value) {
        FailingPrimitiveEncoder.DefaultImpls.encodeSerializableValue(this, serializer, value);
    }

    @ExperimentalSerializationApi
    public boolean shouldEncodeElementDefault(@NotNull SerialDescriptor descriptor, int index) {
        return CompositeEncoder.DefaultImpls.shouldEncodeElementDefault((CompositeEncoder)this, (SerialDescriptor)descriptor, (int)index);
    }
}

