/*
 * Decompiled with CFR 0.152.
 */
package app.softwork.serialization.flf;

import app.softwork.serialization.flf.Ebcdic;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlinx.serialization.ExperimentalSerializationApi;
import kotlinx.serialization.SerializationStrategy;
import kotlinx.serialization.descriptors.SerialDescriptor;
import kotlinx.serialization.encoding.CompositeEncoder;
import kotlinx.serialization.encoding.Encoder;
import kotlinx.serialization.modules.SerializersModule;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ExperimentalSerializationApi
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0001\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0005\n\u0000\n\u0002\u0010\f\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0004\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\n\n\u0002\b\u0002\b\u0001\u0018\u00002\u00020\u0001B3\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\n\u0010\u0006\u001a\u00060\u0007j\u0002`\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\b\u0010\u000b\u001a\u0004\u0018\u00010\f\u00a2\u0006\u0002\u0010\rJ\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0018\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0004\u001a\u00020\u0005H\u0002J\u0010\u0010\u0018\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\nH\u0016J\u0010\u0010\u0019\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u001aH\u0016J\u0010\u0010\u001b\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u001cH\u0016J\u0010\u0010\u001d\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u001eH\u0016J\u0018\u0010\u001f\u001a\u00020\u00152\u0006\u0010 \u001a\u00020\u00132\u0006\u0010!\u001a\u00020\u0005H\u0016J\u0010\u0010\"\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020#H\u0016J\u0010\u0010$\u001a\u00020\u00002\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0010\u0010%\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0005H\u0016J\u0010\u0010&\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020'H\u0016J\b\u0010(\u001a\u00020\u0015H\u0017J\u0018\u0010)\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0004\u001a\u00020\u0005H\u0002J\u0010\u0010*\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020+H\u0016J\u0010\u0010,\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0016R\u0012\u0010\u0006\u001a\u00060\u0007j\u0002`\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006-"}, d2={"Lapp/softwork/serialization/flf/FixedLengthPrimitiveEncoder;", "Lkotlinx/serialization/encoding/Encoder;", "serializersModule", "Lkotlinx/serialization/modules/SerializersModule;", "length", "", "builder", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "fillLeadingZero", "", "ebcdic", "Lapp/softwork/serialization/flf/Ebcdic;", "(Lkotlinx/serialization/modules/SerializersModule;ILjava/lang/StringBuilder;ZLapp/softwork/serialization/flf/Ebcdic;)V", "getSerializersModule", "()Lkotlinx/serialization/modules/SerializersModule;", "beginStructure", "", "descriptor", "Lkotlinx/serialization/descriptors/SerialDescriptor;", "encode", "", "value", "", "encodeBoolean", "encodeByte", "", "encodeChar", "", "encodeDouble", "", "encodeEnum", "enumDescriptor", "index", "encodeFloat", "", "encodeInline", "encodeInt", "encodeLong", "", "encodeNull", "encodeNumber", "encodeShort", "", "encodeString", "kotlinx-serialization-flf"})
@SourceDebugExtension(value={"SMAP\nFixedLengthPrimitiveEncoder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FixedLengthPrimitiveEncoder.kt\napp/softwork/serialization/flf/FixedLengthPrimitiveEncoder\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,85:1\n1#2:86\n*E\n"})
public final class FixedLengthPrimitiveEncoder
implements Encoder {
    @NotNull
    private final SerializersModule serializersModule;
    private final int length;
    @NotNull
    private final StringBuilder builder;
    private final boolean fillLeadingZero;
    @Nullable
    private final Ebcdic ebcdic;

    public FixedLengthPrimitiveEncoder(@NotNull SerializersModule serializersModule, int length, @NotNull StringBuilder builder, boolean fillLeadingZero, @Nullable Ebcdic ebcdic) {
        Intrinsics.checkNotNullParameter((Object)serializersModule, (String)"serializersModule");
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        this.serializersModule = serializersModule;
        this.length = length;
        this.builder = builder;
        this.fillLeadingZero = fillLeadingZero;
        this.ebcdic = ebcdic;
    }

    @NotNull
    public SerializersModule getSerializersModule() {
        return this.serializersModule;
    }

    private final void encode(String value, int length) {
        if (!(value.length() <= length)) {
            boolean bl = false;
            String string = value + " was longer as " + length;
            throw new IllegalArgumentException(string.toString());
        }
        this.builder.append(StringsKt.padEnd$default((String)value, (int)length, (char)'\u0000', (int)2, null));
    }

    private final void encodeNumber(String value, int length) {
        if (this.fillLeadingZero) {
            boolean sign = StringsKt.startsWith$default((String)value, (String)"-", (boolean)false, (int)2, null);
            if (sign) {
                this.encode('-' + StringsKt.padStart((String)StringsKt.drop((String)value, (int)1), (int)(length - 1), (char)'0'), length);
            } else {
                this.encode(StringsKt.padStart((String)value, (int)length, (char)'0'), length);
            }
        } else {
            this.encode(value, length);
        }
    }

    @NotNull
    public Void beginStructure(@NotNull SerialDescriptor descriptor) {
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        throw new IllegalStateException("Not supported".toString());
    }

    public void encodeBoolean(boolean value) {
        this.encode(String.valueOf(value), this.length);
    }

    public void encodeByte(byte value) {
        this.encodeNumber(String.valueOf(value), this.length);
    }

    public void encodeChar(char value) {
        this.encode(String.valueOf(value), this.length);
    }

    public void encodeDouble(double value) {
        this.encodeNumber(String.valueOf(value), this.length);
    }

    public void encodeEnum(@NotNull SerialDescriptor enumDescriptor, int index) {
        Intrinsics.checkNotNullParameter((Object)enumDescriptor, (String)"enumDescriptor");
        String value = enumDescriptor.getElementName(index);
        this.encode(value, this.length);
    }

    public void encodeFloat(float value) {
        this.encodeNumber(String.valueOf(value), this.length);
    }

    @NotNull
    public FixedLengthPrimitiveEncoder encodeInline(@NotNull SerialDescriptor descriptor) {
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        return this;
    }

    public void encodeInt(int value) {
        Object object = this.ebcdic;
        if (object == null || (object = object.format()) == null || (object = ((Ebcdic.Format)((Object)object)).toString$kotlinx_serialization_flf(value)) == null) {
            object = String.valueOf(value);
        }
        Object stringValue = object;
        this.encodeNumber(stringValue.toString(), this.length);
    }

    public void encodeLong(long value) {
        Object object = this.ebcdic;
        if (object == null || (object = object.format()) == null || (object = ((Ebcdic.Format)((Object)object)).toString$kotlinx_serialization_flf(value)) == null) {
            object = String.valueOf(value);
        }
        Object stringValue = object;
        this.encodeNumber(stringValue.toString(), this.length);
    }

    @ExperimentalSerializationApi
    public void encodeNull() {
        this.encode("", this.length);
    }

    public void encodeShort(short value) {
        this.encodeNumber(String.valueOf(value), this.length);
    }

    public void encodeString(@NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this.encode(value, this.length);
    }

    @NotNull
    public CompositeEncoder beginCollection(@NotNull SerialDescriptor descriptor, int collectionSize) {
        return Encoder.DefaultImpls.beginCollection((Encoder)this, (SerialDescriptor)descriptor, (int)collectionSize);
    }

    @ExperimentalSerializationApi
    public void encodeNotNullMark() {
        Encoder.DefaultImpls.encodeNotNullMark((Encoder)this);
    }

    @ExperimentalSerializationApi
    public <T> void encodeNullableSerializableValue(@NotNull SerializationStrategy<? super T> serializer, @Nullable T value) {
        Encoder.DefaultImpls.encodeNullableSerializableValue((Encoder)this, serializer, value);
    }

    public <T> void encodeSerializableValue(@NotNull SerializationStrategy<? super T> serializer, T value) {
        Encoder.DefaultImpls.encodeSerializableValue((Encoder)this, serializer, value);
    }
}

