/*
 * Decompiled with CFR 0.152.
 */
package app.softwork.serialization.flf;

import app.softwork.serialization.flf.FailingPrimitiveEncoder;
import app.softwork.serialization.flf.FixedLengthFormatKt;
import app.softwork.serialization.flf.FixedLengthPrimitiveEncoder;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import kotlinx.serialization.ExperimentalSerializationApi;
import kotlinx.serialization.SerializationStrategy;
import kotlinx.serialization.descriptors.SerialDescriptor;
import kotlinx.serialization.descriptors.StructureKind;
import kotlinx.serialization.encoding.CompositeEncoder;
import kotlinx.serialization.encoding.Encoder;
import kotlinx.serialization.modules.SerializersModule;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ExperimentalSerializationApi
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0084\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u0005\n\u0000\n\u0002\u0010\f\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\n\n\u0002\b\u0004\b\u0001\u0018\u00002\u00020\u00012\u00020\u0002B\u0019\u0012\n\u0010\u0003\u001a\u00060\u0004j\u0002`\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0018\u0010\u000f\u001a\u00020\u00022\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\fH\u0016J\u0010\u0010\u0013\u001a\u00020\u00022\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0018\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\fH\u0002J \u0010\u0019\u001a\u00020\u00152\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u001a\u001a\u00020\f2\u0006\u0010\u0016\u001a\u00020\nH\u0016J \u0010\u001b\u001a\u00020\u00152\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u001a\u001a\u00020\f2\u0006\u0010\u0016\u001a\u00020\u001cH\u0016J \u0010\u001d\u001a\u00020\u00152\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u001a\u001a\u00020\f2\u0006\u0010\u0016\u001a\u00020\u001eH\u0016J \u0010\u001f\u001a\u00020\u00152\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u001a\u001a\u00020\f2\u0006\u0010\u0016\u001a\u00020 H\u0016J\u0018\u0010!\u001a\u00020\u00152\u0006\u0010\"\u001a\u00020\u00112\u0006\u0010\u001a\u001a\u00020\fH\u0016J \u0010#\u001a\u00020\u00152\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u001a\u001a\u00020\f2\u0006\u0010\u0016\u001a\u00020$H\u0016J\u0010\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020\u0011H\u0017J\u0018\u0010(\u001a\u00020&2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u001a\u001a\u00020\fH\u0017J \u0010)\u001a\u00020\u00152\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u001a\u001a\u00020\f2\u0006\u0010\u0016\u001a\u00020\fH\u0016J \u0010*\u001a\u00020\u00152\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u001a\u001a\u00020\f2\u0006\u0010\u0016\u001a\u00020+H\u0016J?\u0010,\u001a\u00020\u0015\"\b\b\u0000\u0010-*\u00020.2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u001a\u001a\u00020\f2\f\u0010/\u001a\b\u0012\u0004\u0012\u0002H-002\b\u0010\u0016\u001a\u0004\u0018\u0001H-H\u0017\u00a2\u0006\u0002\u00101J9\u00102\u001a\u00020\u0015\"\u0004\b\u0000\u0010-2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u001a\u001a\u00020\f2\f\u0010/\u001a\b\u0012\u0004\u0012\u0002H-002\u0006\u0010\u0016\u001a\u0002H-H\u0016\u00a2\u0006\u0002\u00101J \u00103\u001a\u00020\u00152\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u001a\u001a\u00020\f2\u0006\u0010\u0016\u001a\u000204H\u0016J \u00105\u001a\u00020\u00152\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u001a\u001a\u00020\f2\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\u0010\u00106\u001a\u00020\u00152\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\b\u00107\u001a\u00020\u0015H\u0002R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0003\u001a\u00060\u0004j\u0002`\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u00068"}, d2={"Lapp/softwork/serialization/flf/FixedLengthEncoder;", "Lapp/softwork/serialization/flf/FailingPrimitiveEncoder;", "Lkotlinx/serialization/encoding/CompositeEncoder;", "builder", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "serializersModule", "Lkotlinx/serialization/modules/SerializersModule;", "(Ljava/lang/StringBuilder;Lkotlinx/serialization/modules/SerializersModule;)V", "afterFirst", "", "level", "", "getSerializersModule", "()Lkotlinx/serialization/modules/SerializersModule;", "beginCollection", "descriptor", "Lkotlinx/serialization/descriptors/SerialDescriptor;", "collectionSize", "beginStructure", "encode", "", "value", "", "length", "encodeBooleanElement", "index", "encodeByteElement", "", "encodeCharElement", "", "encodeDoubleElement", "", "encodeEnum", "enumDescriptor", "encodeFloatElement", "", "encodeInline", "Lkotlinx/serialization/encoding/Encoder;", "inlineDescriptor", "encodeInlineElement", "encodeIntElement", "encodeLongElement", "", "encodeNullableSerializableElement", "T", "", "serializer", "Lkotlinx/serialization/SerializationStrategy;", "(Lkotlinx/serialization/descriptors/SerialDescriptor;ILkotlinx/serialization/SerializationStrategy;Ljava/lang/Object;)V", "encodeSerializableElement", "encodeShortElement", "", "encodeStringElement", "endStructure", "maybeAddLine", "kotlinx-serialization-flf"})
public final class FixedLengthEncoder
implements FailingPrimitiveEncoder,
CompositeEncoder {
    @NotNull
    private final StringBuilder builder;
    @NotNull
    private final SerializersModule serializersModule;
    private int level;
    private boolean afterFirst;

    public FixedLengthEncoder(@NotNull StringBuilder builder, @NotNull SerializersModule serializersModule) {
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        Intrinsics.checkNotNullParameter((Object)serializersModule, (String)"serializersModule");
        this.builder = builder;
        this.serializersModule = serializersModule;
    }

    @NotNull
    public SerializersModule getSerializersModule() {
        return this.serializersModule;
    }

    private final void maybeAddLine() {
        if (this.level == 0 && this.afterFirst) {
            Intrinsics.checkNotNullExpressionValue((Object)this.builder.append('\n'), (String)"append('\\n')");
        }
    }

    private final void encode(String value, int length) {
        if (!(value.length() <= length)) {
            boolean bl = false;
            String string = value + " was longer as " + length;
            throw new IllegalArgumentException(string.toString());
        }
        this.builder.append(StringsKt.padEnd$default((String)value, (int)length, (char)'\u0000', (int)2, null));
        this.afterFirst = true;
    }

    public void encodeBooleanElement(@NotNull SerialDescriptor descriptor, int index, boolean value) {
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        this.encode(String.valueOf(value), FixedLengthFormatKt.fixedLength(descriptor, index));
    }

    public void encodeByteElement(@NotNull SerialDescriptor descriptor, int index, byte value) {
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        this.encode(String.valueOf(value), FixedLengthFormatKt.fixedLength(descriptor, index));
    }

    public void encodeCharElement(@NotNull SerialDescriptor descriptor, int index, char value) {
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        this.encode(String.valueOf(value), FixedLengthFormatKt.fixedLength(descriptor, index));
    }

    public void encodeDoubleElement(@NotNull SerialDescriptor descriptor, int index, double value) {
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        this.encode(String.valueOf(value), FixedLengthFormatKt.fixedLength(descriptor, index));
    }

    public void encodeFloatElement(@NotNull SerialDescriptor descriptor, int index, float value) {
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        this.encode(String.valueOf(value), FixedLengthFormatKt.fixedLength(descriptor, index));
    }

    @ExperimentalSerializationApi
    @NotNull
    public Encoder encodeInlineElement(@NotNull SerialDescriptor descriptor, int index) {
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        return this.encodeInline(descriptor.getElementDescriptor(index));
    }

    public void encodeIntElement(@NotNull SerialDescriptor descriptor, int index, int value) {
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        this.encode(String.valueOf(value), FixedLengthFormatKt.fixedLength(descriptor, index));
    }

    public void encodeLongElement(@NotNull SerialDescriptor descriptor, int index, long value) {
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        this.encode(String.valueOf(value), FixedLengthFormatKt.fixedLength(descriptor, index));
    }

    @ExperimentalSerializationApi
    public <T> void encodeNullableSerializableElement(@NotNull SerialDescriptor descriptor, int index, @NotNull SerializationStrategy<? super T> serializer, @Nullable T value) {
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        Intrinsics.checkNotNullParameter(serializer, (String)"serializer");
        FixedLengthPrimitiveEncoder encoder = new FixedLengthPrimitiveEncoder(this.getSerializersModule(), FixedLengthFormatKt.fixedLength(descriptor, index), this.builder);
        if (value == null) {
            encoder.encodeNull();
        } else {
            serializer.serialize((Encoder)encoder, value);
        }
    }

    public <T> void encodeSerializableElement(@NotNull SerialDescriptor descriptor, int index, @NotNull SerializationStrategy<? super T> serializer, T value) {
        boolean isInnerClass;
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        Intrinsics.checkNotNullParameter(serializer, (String)"serializer");
        boolean bl = isInnerClass = this.level != 0 && serializer.getDescriptor().getKind() instanceof StructureKind.CLASS && !serializer.getDescriptor().isInline();
        if (descriptor.getKind() instanceof StructureKind.LIST || isInnerClass) {
            serializer.serialize((Encoder)this, value);
        } else {
            serializer.serialize((Encoder)new FixedLengthPrimitiveEncoder(this.getSerializersModule(), FixedLengthFormatKt.fixedLength(descriptor, index), this.builder), value);
        }
    }

    public void encodeShortElement(@NotNull SerialDescriptor descriptor, int index, short value) {
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        this.encode(String.valueOf(value), FixedLengthFormatKt.fixedLength(descriptor, index));
    }

    public void encodeStringElement(@NotNull SerialDescriptor descriptor, int index, @NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this.encode(value, FixedLengthFormatKt.fixedLength(descriptor, index));
    }

    @NotNull
    public CompositeEncoder beginStructure(@NotNull SerialDescriptor descriptor) {
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        this.maybeAddLine();
        int n = this.level;
        this.level = n + 1;
        return this;
    }

    @NotNull
    public CompositeEncoder beginCollection(@NotNull SerialDescriptor descriptor, int collectionSize) {
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        return this;
    }

    public void endStructure(@NotNull SerialDescriptor descriptor) {
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        int n = this.level;
        this.level = n + -1;
    }

    public void encodeEnum(@NotNull SerialDescriptor enumDescriptor, int index) {
        Intrinsics.checkNotNullParameter((Object)enumDescriptor, (String)"enumDescriptor");
        String value = enumDescriptor.getElementName(index);
        this.encode(value, FixedLengthFormatKt.fixedLength(enumDescriptor, index));
    }

    @ExperimentalSerializationApi
    @NotNull
    public Encoder encodeInline(@NotNull SerialDescriptor inlineDescriptor) {
        Intrinsics.checkNotNullParameter((Object)inlineDescriptor, (String)"inlineDescriptor");
        this.maybeAddLine();
        int fixedLength = FixedLengthFormatKt.getFixedLength(inlineDescriptor);
        return new FixedLengthPrimitiveEncoder(this.getSerializersModule(), fixedLength, this.builder);
    }

    @Override
    public void encodeBoolean(boolean value) {
        FailingPrimitiveEncoder.DefaultImpls.encodeBoolean(this, value);
    }

    @Override
    public void encodeByte(byte value) {
        FailingPrimitiveEncoder.DefaultImpls.encodeByte(this, value);
    }

    @Override
    public void encodeChar(char value) {
        FailingPrimitiveEncoder.DefaultImpls.encodeChar(this, value);
    }

    @Override
    public void encodeDouble(double value) {
        FailingPrimitiveEncoder.DefaultImpls.encodeDouble(this, value);
    }

    @Override
    public void encodeFloat(float value) {
        FailingPrimitiveEncoder.DefaultImpls.encodeFloat(this, value);
    }

    @Override
    public void encodeInt(int value) {
        FailingPrimitiveEncoder.DefaultImpls.encodeInt(this, value);
    }

    @Override
    public void encodeLong(long value) {
        FailingPrimitiveEncoder.DefaultImpls.encodeLong(this, value);
    }

    @Override
    @ExperimentalSerializationApi
    public void encodeNull() {
        FailingPrimitiveEncoder.DefaultImpls.encodeNull(this);
    }

    @Override
    public void encodeShort(short value) {
        FailingPrimitiveEncoder.DefaultImpls.encodeShort(this, value);
    }

    @Override
    public void encodeString(@NotNull String value) {
        FailingPrimitiveEncoder.DefaultImpls.encodeString(this, value);
    }

    @ExperimentalSerializationApi
    public void encodeNotNullMark() {
        FailingPrimitiveEncoder.DefaultImpls.encodeNotNullMark(this);
    }

    @ExperimentalSerializationApi
    public <T> void encodeNullableSerializableValue(@NotNull SerializationStrategy<? super T> serializer, @Nullable T value) {
        FailingPrimitiveEncoder.DefaultImpls.encodeNullableSerializableValue(this, serializer, value);
    }

    public <T> void encodeSerializableValue(@NotNull SerializationStrategy<? super T> serializer, T value) {
        FailingPrimitiveEncoder.DefaultImpls.encodeSerializableValue(this, serializer, value);
    }

    @ExperimentalSerializationApi
    public boolean shouldEncodeElementDefault(@NotNull SerialDescriptor descriptor, int index) {
        return CompositeEncoder.DefaultImpls.shouldEncodeElementDefault((CompositeEncoder)this, (SerialDescriptor)descriptor, (int)index);
    }
}

