/*
 * Decompiled with CFR 0.152.
 */
package app.softwork.serialization.flf;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import kotlinx.serialization.ExperimentalSerializationApi;
import kotlinx.serialization.SerializationStrategy;
import kotlinx.serialization.descriptors.SerialDescriptor;
import kotlinx.serialization.encoding.CompositeEncoder;
import kotlinx.serialization.encoding.Encoder;
import kotlinx.serialization.modules.SerializersModule;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ExperimentalSerializationApi
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0001\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0005\n\u0000\n\u0002\u0010\f\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0004\n\u0002\u0010\u0007\n\u0002\b\u0004\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\n\n\u0002\b\u0002\b\u0001\u0018\u00002\u00020\u0001B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\n\u0010\u0006\u001a\u00060\u0007j\u0002`\b\u00a2\u0006\u0002\u0010\tJ\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0018\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0004\u001a\u00020\u0005H\u0002J\u0010\u0010\u0014\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0015H\u0016J\u0010\u0010\u0016\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0017H\u0016J\u0010\u0010\u0018\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0019H\u0016J\u0010\u0010\u001a\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u001bH\u0016J\u0018\u0010\u001c\u001a\u00020\u00112\u0006\u0010\u001d\u001a\u00020\u000f2\u0006\u0010\u001e\u001a\u00020\u0005H\u0016J\u0010\u0010\u001f\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020 H\u0016J\u0010\u0010!\u001a\u00020\u00002\u0006\u0010\"\u001a\u00020\u000fH\u0017J\u0010\u0010#\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0005H\u0016J\u0010\u0010$\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020%H\u0016J\b\u0010&\u001a\u00020\u0011H\u0017J\u0010\u0010'\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020(H\u0016J\u0010\u0010)\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016R\u0012\u0010\u0006\u001a\u00060\u0007j\u0002`\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006*"}, d2={"Lapp/softwork/serialization/flf/FixedLengthPrimitiveEncoder;", "Lkotlinx/serialization/encoding/Encoder;", "serializersModule", "Lkotlinx/serialization/modules/SerializersModule;", "length", "", "builder", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "(Lkotlinx/serialization/modules/SerializersModule;ILjava/lang/StringBuilder;)V", "getSerializersModule", "()Lkotlinx/serialization/modules/SerializersModule;", "beginStructure", "", "descriptor", "Lkotlinx/serialization/descriptors/SerialDescriptor;", "encode", "", "value", "", "encodeBoolean", "", "encodeByte", "", "encodeChar", "", "encodeDouble", "", "encodeEnum", "enumDescriptor", "index", "encodeFloat", "", "encodeInline", "inlineDescriptor", "encodeInt", "encodeLong", "", "encodeNull", "encodeShort", "", "encodeString", "kotlinx-serialization-flf"})
public final class FixedLengthPrimitiveEncoder
implements Encoder {
    @NotNull
    private final SerializersModule serializersModule;
    private final int length;
    @NotNull
    private final StringBuilder builder;

    public FixedLengthPrimitiveEncoder(@NotNull SerializersModule serializersModule, int length, @NotNull StringBuilder builder) {
        Intrinsics.checkNotNullParameter((Object)serializersModule, (String)"serializersModule");
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        this.serializersModule = serializersModule;
        this.length = length;
        this.builder = builder;
    }

    @NotNull
    public SerializersModule getSerializersModule() {
        return this.serializersModule;
    }

    private final void encode(String value, int length) {
        if (!(value.length() <= length)) {
            boolean bl = false;
            String string = value + " was longer as " + length;
            throw new IllegalArgumentException(string.toString());
        }
        this.builder.append(StringsKt.padEnd$default((String)value, (int)length, (char)'\u0000', (int)2, null));
    }

    @NotNull
    public Void beginStructure(@NotNull SerialDescriptor descriptor) {
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        throw new IllegalStateException("Not supported".toString());
    }

    public void encodeBoolean(boolean value) {
        this.encode(String.valueOf(value), this.length);
    }

    public void encodeByte(byte value) {
        this.encode(String.valueOf(value), this.length);
    }

    public void encodeChar(char value) {
        this.encode(String.valueOf(value), this.length);
    }

    public void encodeDouble(double value) {
        this.encode(String.valueOf(value), this.length);
    }

    public void encodeEnum(@NotNull SerialDescriptor enumDescriptor, int index) {
        Intrinsics.checkNotNullParameter((Object)enumDescriptor, (String)"enumDescriptor");
        String value = enumDescriptor.getElementName(index);
        this.encode(value, this.length);
    }

    public void encodeFloat(float value) {
        this.encode(String.valueOf(value), this.length);
    }

    @ExperimentalSerializationApi
    @NotNull
    public FixedLengthPrimitiveEncoder encodeInline(@NotNull SerialDescriptor inlineDescriptor) {
        Intrinsics.checkNotNullParameter((Object)inlineDescriptor, (String)"inlineDescriptor");
        return this;
    }

    public void encodeInt(int value) {
        this.encode(String.valueOf(value), this.length);
    }

    public void encodeLong(long value) {
        this.encode(String.valueOf(value), this.length);
    }

    @ExperimentalSerializationApi
    public void encodeNull() {
        this.encode("", this.length);
    }

    public void encodeShort(short value) {
        this.encode(String.valueOf(value), this.length);
    }

    public void encodeString(@NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this.encode(value, this.length);
    }

    @NotNull
    public CompositeEncoder beginCollection(@NotNull SerialDescriptor descriptor, int collectionSize) {
        return Encoder.DefaultImpls.beginCollection((Encoder)this, (SerialDescriptor)descriptor, (int)collectionSize);
    }

    @ExperimentalSerializationApi
    public void encodeNotNullMark() {
        Encoder.DefaultImpls.encodeNotNullMark((Encoder)this);
    }

    @ExperimentalSerializationApi
    public <T> void encodeNullableSerializableValue(@NotNull SerializationStrategy<? super T> serializer, @Nullable T value) {
        Encoder.DefaultImpls.encodeNullableSerializableValue((Encoder)this, serializer, value);
    }

    public <T> void encodeSerializableValue(@NotNull SerializationStrategy<? super T> serializer, T value) {
        Encoder.DefaultImpls.encodeSerializableValue((Encoder)this, serializer, value);
    }
}

