/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.uuid.exposed;

import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.text.Charsets;
import kotlinx.uuid.ConvertingKt;
import kotlinx.uuid.UUID;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.exposed.sql.ColumnType;
import org.jetbrains.exposed.sql.vendors.DefaultKt;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\b\u0010\b\u001a\u00020\u0004H\u0016J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0015\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0005\u001a\u00020\u0006H\u0000\u00a2\u0006\u0002\b\r\u00a8\u0006\u000e"}, d2={"Lkotlinx/uuid/exposed/UUIDColumnType;", "Lorg/jetbrains/exposed/sql/ColumnType;", "()V", "nonNullValueToString", "", "value", "", "notNullValueToDB", "sqlType", "valueFromDB", "Lkotlinx/uuid/UUID;", "valueToUUID", "Ljava/util/UUID;", "valueToUUID$kotlinx_uuid_exposed", "kotlinx-uuid-exposed"})
public final class UUIDColumnType
extends ColumnType {
    public UUIDColumnType() {
        super(false, 1, null);
    }

    @NotNull
    public String sqlType() {
        return DefaultKt.getCurrentDialect().getDataTypeProvider().uuidType();
    }

    @NotNull
    public UUID valueFromDB(@NotNull Object value) {
        UUID uUID;
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        if (value instanceof java.util.UUID) {
            uUID = ConvertingKt.toKotlinUUID((java.util.UUID)((java.util.UUID)value));
        } else if (value instanceof UUID) {
            uUID = (UUID)value;
        } else if (value instanceof byte[]) {
            ByteBuffer byteBuffer = ByteBuffer.wrap((byte[])value);
            boolean bl = false;
            boolean bl2 = false;
            ByteBuffer b = byteBuffer;
            boolean bl3 = false;
            uUID = this.valueFromDB(new java.util.UUID(b.getLong(), b.getLong()));
        } else if (value instanceof String && UUID.Companion.isValidUUIDString((String)value)) {
            uUID = new UUID((String)value);
        } else if (value instanceof String) {
            String string = (String)value;
            Charset charset = Charsets.UTF_8;
            boolean bl = false;
            byte[] byArray = string.getBytes(charset);
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
            uUID = this.valueFromDB(byArray);
        } else {
            String string = "Unexpected value of type UUID: " + value + " of " + Reflection.getOrCreateKotlinClass(value.getClass()).getQualifiedName();
            boolean bl = false;
            throw (Throwable)new IllegalStateException(string.toString());
        }
        return uUID;
    }

    @NotNull
    public Object notNullValueToDB(@NotNull Object value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        return DefaultKt.getCurrentDialect().getDataTypeProvider().uuidToDB(this.valueToUUID$kotlinx_uuid_exposed(value));
    }

    @NotNull
    public String nonNullValueToString(@NotNull Object value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        return "" + '\'' + this.valueToUUID$kotlinx_uuid_exposed(value) + '\'';
    }

    @NotNull
    public final java.util.UUID valueToUUID$kotlinx_uuid_exposed(@NotNull Object value) {
        java.util.UUID uUID;
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        Object object = value;
        if (object instanceof java.util.UUID) {
            uUID = (java.util.UUID)value;
        } else if (object instanceof UUID) {
            uUID = ConvertingKt.toJavaUUID((UUID)((UUID)value));
        } else if (object instanceof String) {
            java.util.UUID uUID2 = java.util.UUID.fromString((String)value);
            Intrinsics.checkNotNullExpressionValue((Object)uUID2, (String)"fromString(value)");
            uUID = uUID2;
        } else if (object instanceof byte[]) {
            ByteBuffer byteBuffer = ByteBuffer.wrap((byte[])value);
            boolean bl = false;
            boolean bl2 = false;
            ByteBuffer it = byteBuffer;
            boolean bl3 = false;
            uUID = new java.util.UUID(it.getLong(), it.getLong());
        } else {
            String string = Intrinsics.stringPlus((String)"Unexpected value of type UUID: ", (Object)value.getClass().getCanonicalName());
            boolean bl = false;
            throw (Throwable)new IllegalStateException(string.toString());
        }
        return uUID;
    }
}

