/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.uuid.exposed;

import java.nio.ByteBuffer;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import kotlinx.uuid.ConvertingKt;
import kotlinx.uuid.UUID;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.exposed.sql.ColumnType;
import org.jetbrains.exposed.sql.vendors.DatabaseDialectKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\b\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\n\u001a\u00020\t2\u0006\u0010\b\u001a\u00020\u0002H\u0016J\u0010\u0010\u000b\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\u0002H\u0016J\u0015\u0010\f\u001a\u00020\r2\u0006\u0010\b\u001a\u00020\tH\u0000\u00a2\u0006\u0002\b\u000e\u00a8\u0006\u000f"}, d2={"Lkotlinx/uuid/exposed/UUIDColumnType;", "Lorg/jetbrains/exposed/sql/ColumnType;", "Lkotlinx/uuid/UUID;", "<init>", "()V", "sqlType", "", "valueFromDB", "value", "", "notNullValueToDB", "nonNullValueToString", "valueToUUID", "Ljava/util/UUID;", "valueToUUID$kotlinx_uuid_exposed", "kotlinx-uuid-exposed"})
@SourceDebugExtension(value={"SMAP\nUUIDColumnType.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UUIDColumnType.kt\nkotlinx/uuid/exposed/UUIDColumnType\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,40:1\n1#2:41\n*E\n"})
public final class UUIDColumnType
extends ColumnType<UUID> {
    public UUIDColumnType() {
        super(false, 1, null);
    }

    @NotNull
    public String sqlType() {
        return DatabaseDialectKt.getCurrentDialect().getDataTypeProvider().uuidType();
    }

    @NotNull
    public UUID valueFromDB(@NotNull Object value) {
        UUID uUID;
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        if (value instanceof java.util.UUID) {
            uUID = ConvertingKt.toKotlinUUID((java.util.UUID)((java.util.UUID)value));
        } else if (value instanceof UUID) {
            uUID = (UUID)value;
        } else if (value instanceof byte[]) {
            ByteBuffer b = ByteBuffer.wrap((byte[])value);
            boolean bl = false;
            uUID = this.valueFromDB(new java.util.UUID(b.getLong(), b.getLong()));
        } else if (value instanceof String && UUID.Companion.isValidUUIDString((String)value)) {
            uUID = new UUID((String)value);
        } else if (value instanceof String) {
            String string = (String)value;
            byte[] byArray = string.getBytes(Charsets.UTF_8);
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
            uUID = this.valueFromDB(byArray);
        } else {
            throw new IllegalStateException(("Unexpected value of type UUID: " + value + " of " + Reflection.getOrCreateKotlinClass(value.getClass()).getQualifiedName()).toString());
        }
        return uUID;
    }

    @NotNull
    public Object notNullValueToDB(@NotNull UUID value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        return DatabaseDialectKt.getCurrentDialect().getDataTypeProvider().uuidToDB(this.valueToUUID$kotlinx_uuid_exposed(value));
    }

    @NotNull
    public String nonNullValueToString(@NotNull UUID value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        return "'" + this.valueToUUID$kotlinx_uuid_exposed(value) + "'";
    }

    @NotNull
    public final java.util.UUID valueToUUID$kotlinx_uuid_exposed(@NotNull Object value) {
        java.util.UUID uUID;
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        Object object = value;
        if (object instanceof java.util.UUID) {
            uUID = (java.util.UUID)value;
        } else if (object instanceof UUID) {
            uUID = ConvertingKt.toJavaUUID((UUID)((UUID)value));
        } else if (object instanceof String) {
            java.util.UUID uUID2 = java.util.UUID.fromString((String)value);
            uUID = uUID2;
            Intrinsics.checkNotNullExpressionValue((Object)uUID2, (String)"fromString(...)");
        } else if (object instanceof byte[]) {
            ByteBuffer it = ByteBuffer.wrap((byte[])value);
            boolean bl = false;
            uUID = new java.util.UUID(it.getLong(), it.getLong());
        } else {
            throw new IllegalStateException(("Unexpected value of type UUID: " + value.getClass().getCanonicalName()).toString());
        }
        return uUID;
    }
}

