package app.softwork.sqldelight.oracledialect.grammar

import app.softwork.sqldelight.oracledialect.grammar.psi.OracleTypes
import com.alecstrong.sql.psi.core.SqlParserUtil
import com.intellij.lang.ASTNode
import com.intellij.lang.PsiBuilder
import com.intellij.lang.parser.GeneratedParserUtilBase
import com.intellij.psi.PsiElement
import java.lang.AssertionError
import kotlin.Boolean
import kotlin.Int
import kotlin.jvm.JvmStatic

public object OracleParserUtil : GeneratedParserUtilBase() {
  public var createElement: (ASTNode) -> PsiElement = { OracleTypes.Factory.createElement(it) }

  public var overrides: GeneratedParserUtilBase.Parser? = null

  public var type_name: GeneratedParserUtilBase.Parser? = null

  public var small_int_data_type: GeneratedParserUtilBase.Parser? = null

  public var int_data_type: GeneratedParserUtilBase.Parser? = null

  public var big_int_data_type: GeneratedParserUtilBase.Parser? = null

  public var fixed_point_data_type: GeneratedParserUtilBase.Parser? = null

  public var approximate_numeric_data_type: GeneratedParserUtilBase.Parser? = null

  public var precision: GeneratedParserUtilBase.Parser? = null

  public var scale: GeneratedParserUtilBase.Parser? = null

  public var boolean_data_type: GeneratedParserUtilBase.Parser? = null

  public var character_string_data_type: GeneratedParserUtilBase.Parser? = null

  public var character_large_object_data_type: GeneratedParserUtilBase.Parser? = null

  public var character_large_object_length: GeneratedParserUtilBase.Parser? = null

  public var multiplier: GeneratedParserUtilBase.Parser? = null

  public var char_length_units: GeneratedParserUtilBase.Parser? = null

  public var binary_string_data_type: GeneratedParserUtilBase.Parser? = null

  public var binary_large_object_string_data_type: GeneratedParserUtilBase.Parser? = null

  public var bit_string_data_type: GeneratedParserUtilBase.Parser? = null

  public var date_data_type: GeneratedParserUtilBase.Parser? = null

  public var interval_data_type: GeneratedParserUtilBase.Parser? = null

  public var interval_qualifier: GeneratedParserUtilBase.Parser? = null

  public var start_field: GeneratedParserUtilBase.Parser? = null

  public var end_field: GeneratedParserUtilBase.Parser? = null

  public var single_datetime_field: GeneratedParserUtilBase.Parser? = null

  public var non_second_primary_datetime_field: GeneratedParserUtilBase.Parser? = null

  public var bind_parameter: GeneratedParserUtilBase.Parser? = null

  public var generated_clause: GeneratedParserUtilBase.Parser? = null

  public var default_constraint: GeneratedParserUtilBase.Parser? = null

  public var literal_value: GeneratedParserUtilBase.Parser? = null

  public var extension_stmt: GeneratedParserUtilBase.Parser? = null

  public var createUser: GeneratedParserUtilBase.Parser? = null

  public var grantTable: GeneratedParserUtilBase.Parser? = null

  public var grantSession: GeneratedParserUtilBase.Parser? = null

  public var alterTablespace: GeneratedParserUtilBase.Parser? = null

  public var merge: GeneratedParserUtilBase.Parser? = null

  public var merge_on: GeneratedParserUtilBase.Parser? = null

  public var merge_update_clause: GeneratedParserUtilBase.Parser? = null

  public var merge_update_column_clause: GeneratedParserUtilBase.Parser? = null

  public var merge_update_column_clause_single: GeneratedParserUtilBase.Parser? = null

  public var merge_insert_clause: GeneratedParserUtilBase.Parser? = null

  @JvmStatic
  public fun overridesExt(
    builder: PsiBuilder,
    level: Int,
    overrides: GeneratedParserUtilBase.Parser,
  ): Boolean = (this.overrides ?: overrides).parse(builder, level)

  @JvmStatic
  public fun typeNameExt(
    builder: PsiBuilder,
    level: Int,
    type_name: GeneratedParserUtilBase.Parser,
  ): Boolean = (this.type_name ?: type_name).parse(builder, level)

  @JvmStatic
  public fun smallIntDataTypeExt(
    builder: PsiBuilder,
    level: Int,
    small_int_data_type: GeneratedParserUtilBase.Parser,
  ): Boolean = (this.small_int_data_type ?: small_int_data_type).parse(builder, level)

  @JvmStatic
  public fun intDataTypeExt(
    builder: PsiBuilder,
    level: Int,
    int_data_type: GeneratedParserUtilBase.Parser,
  ): Boolean = (this.int_data_type ?: int_data_type).parse(builder, level)

  @JvmStatic
  public fun bigIntDataTypeExt(
    builder: PsiBuilder,
    level: Int,
    big_int_data_type: GeneratedParserUtilBase.Parser,
  ): Boolean = (this.big_int_data_type ?: big_int_data_type).parse(builder, level)

  @JvmStatic
  public fun fixedPointDataTypeExt(
    builder: PsiBuilder,
    level: Int,
    fixed_point_data_type: GeneratedParserUtilBase.Parser,
  ): Boolean = (this.fixed_point_data_type ?: fixed_point_data_type).parse(builder, level)

  @JvmStatic
  public fun approximateNumericDataTypeExt(
    builder: PsiBuilder,
    level: Int,
    approximate_numeric_data_type: GeneratedParserUtilBase.Parser,
  ): Boolean = (this.approximate_numeric_data_type ?: approximate_numeric_data_type).parse(builder,
      level)

  @JvmStatic
  public fun precisionExt(
    builder: PsiBuilder,
    level: Int,
    precision: GeneratedParserUtilBase.Parser,
  ): Boolean = (this.precision ?: precision).parse(builder, level)

  @JvmStatic
  public fun scaleExt(
    builder: PsiBuilder,
    level: Int,
    scale: GeneratedParserUtilBase.Parser,
  ): Boolean = (this.scale ?: scale).parse(builder, level)

  @JvmStatic
  public fun booleanDataTypeExt(
    builder: PsiBuilder,
    level: Int,
    boolean_data_type: GeneratedParserUtilBase.Parser,
  ): Boolean = (this.boolean_data_type ?: boolean_data_type).parse(builder, level)

  @JvmStatic
  public fun characterStringDataTypeExt(
    builder: PsiBuilder,
    level: Int,
    character_string_data_type: GeneratedParserUtilBase.Parser,
  ): Boolean = (this.character_string_data_type ?: character_string_data_type).parse(builder, level)

  @JvmStatic
  public fun characterLargeObjectDataTypeExt(
    builder: PsiBuilder,
    level: Int,
    character_large_object_data_type: GeneratedParserUtilBase.Parser,
  ): Boolean = (this.character_large_object_data_type ?:
      character_large_object_data_type).parse(builder, level)

  @JvmStatic
  public fun characterLargeObjectLengthExt(
    builder: PsiBuilder,
    level: Int,
    character_large_object_length: GeneratedParserUtilBase.Parser,
  ): Boolean = (this.character_large_object_length ?: character_large_object_length).parse(builder,
      level)

  @JvmStatic
  public fun multiplierExt(
    builder: PsiBuilder,
    level: Int,
    multiplier: GeneratedParserUtilBase.Parser,
  ): Boolean = (this.multiplier ?: multiplier).parse(builder, level)

  @JvmStatic
  public fun charLengthUnitsExt(
    builder: PsiBuilder,
    level: Int,
    char_length_units: GeneratedParserUtilBase.Parser,
  ): Boolean = (this.char_length_units ?: char_length_units).parse(builder, level)

  @JvmStatic
  public fun binaryStringDataTypeExt(
    builder: PsiBuilder,
    level: Int,
    binary_string_data_type: GeneratedParserUtilBase.Parser,
  ): Boolean = (this.binary_string_data_type ?: binary_string_data_type).parse(builder, level)

  @JvmStatic
  public fun binaryLargeObjectStringDataTypeExt(
    builder: PsiBuilder,
    level: Int,
    binary_large_object_string_data_type: GeneratedParserUtilBase.Parser,
  ): Boolean = (this.binary_large_object_string_data_type ?:
      binary_large_object_string_data_type).parse(builder, level)

  @JvmStatic
  public fun bitStringDataTypeExt(
    builder: PsiBuilder,
    level: Int,
    bit_string_data_type: GeneratedParserUtilBase.Parser,
  ): Boolean = (this.bit_string_data_type ?: bit_string_data_type).parse(builder, level)

  @JvmStatic
  public fun dateDataTypeExt(
    builder: PsiBuilder,
    level: Int,
    date_data_type: GeneratedParserUtilBase.Parser,
  ): Boolean = (this.date_data_type ?: date_data_type).parse(builder, level)

  @JvmStatic
  public fun intervalDataTypeExt(
    builder: PsiBuilder,
    level: Int,
    interval_data_type: GeneratedParserUtilBase.Parser,
  ): Boolean = (this.interval_data_type ?: interval_data_type).parse(builder, level)

  @JvmStatic
  public fun intervalQualifierExt(
    builder: PsiBuilder,
    level: Int,
    interval_qualifier: GeneratedParserUtilBase.Parser,
  ): Boolean = (this.interval_qualifier ?: interval_qualifier).parse(builder, level)

  @JvmStatic
  public fun startFieldExt(
    builder: PsiBuilder,
    level: Int,
    start_field: GeneratedParserUtilBase.Parser,
  ): Boolean = (this.start_field ?: start_field).parse(builder, level)

  @JvmStatic
  public fun endFieldExt(
    builder: PsiBuilder,
    level: Int,
    end_field: GeneratedParserUtilBase.Parser,
  ): Boolean = (this.end_field ?: end_field).parse(builder, level)

  @JvmStatic
  public fun singleDatetimeFieldExt(
    builder: PsiBuilder,
    level: Int,
    single_datetime_field: GeneratedParserUtilBase.Parser,
  ): Boolean = (this.single_datetime_field ?: single_datetime_field).parse(builder, level)

  @JvmStatic
  public fun nonSecondPrimaryDatetimeFieldExt(
    builder: PsiBuilder,
    level: Int,
    non_second_primary_datetime_field: GeneratedParserUtilBase.Parser,
  ): Boolean = (this.non_second_primary_datetime_field ?:
      non_second_primary_datetime_field).parse(builder, level)

  @JvmStatic
  public fun bindParameterExt(
    builder: PsiBuilder,
    level: Int,
    bind_parameter: GeneratedParserUtilBase.Parser,
  ): Boolean = (this.bind_parameter ?: bind_parameter).parse(builder, level)

  @JvmStatic
  public fun generatedClauseExt(
    builder: PsiBuilder,
    level: Int,
    generated_clause: GeneratedParserUtilBase.Parser,
  ): Boolean = (this.generated_clause ?: generated_clause).parse(builder, level)

  @JvmStatic
  public fun defaultConstraintExt(
    builder: PsiBuilder,
    level: Int,
    default_constraint: GeneratedParserUtilBase.Parser,
  ): Boolean = (this.default_constraint ?: default_constraint).parse(builder, level)

  @JvmStatic
  public fun literalValueExt(
    builder: PsiBuilder,
    level: Int,
    literal_value: GeneratedParserUtilBase.Parser,
  ): Boolean = (this.literal_value ?: literal_value).parse(builder, level)

  @JvmStatic
  public fun extensionStmtExt(
    builder: PsiBuilder,
    level: Int,
    extension_stmt: GeneratedParserUtilBase.Parser,
  ): Boolean = (this.extension_stmt ?: extension_stmt).parse(builder, level)

  @JvmStatic
  public fun createUserExt(
    builder: PsiBuilder,
    level: Int,
    createUser: GeneratedParserUtilBase.Parser,
  ): Boolean = (this.createUser ?: createUser).parse(builder, level)

  @JvmStatic
  public fun grantTableExt(
    builder: PsiBuilder,
    level: Int,
    grantTable: GeneratedParserUtilBase.Parser,
  ): Boolean = (this.grantTable ?: grantTable).parse(builder, level)

  @JvmStatic
  public fun grantSessionExt(
    builder: PsiBuilder,
    level: Int,
    grantSession: GeneratedParserUtilBase.Parser,
  ): Boolean = (this.grantSession ?: grantSession).parse(builder, level)

  @JvmStatic
  public fun alterTablespaceExt(
    builder: PsiBuilder,
    level: Int,
    alterTablespace: GeneratedParserUtilBase.Parser,
  ): Boolean = (this.alterTablespace ?: alterTablespace).parse(builder, level)

  @JvmStatic
  public fun mergeExt(
    builder: PsiBuilder,
    level: Int,
    merge: GeneratedParserUtilBase.Parser,
  ): Boolean = (this.merge ?: merge).parse(builder, level)

  @JvmStatic
  public fun mergeOnExt(
    builder: PsiBuilder,
    level: Int,
    merge_on: GeneratedParserUtilBase.Parser,
  ): Boolean = (this.merge_on ?: merge_on).parse(builder, level)

  @JvmStatic
  public fun mergeUpdateClauseExt(
    builder: PsiBuilder,
    level: Int,
    merge_update_clause: GeneratedParserUtilBase.Parser,
  ): Boolean = (this.merge_update_clause ?: merge_update_clause).parse(builder, level)

  @JvmStatic
  public fun mergeUpdateColumnClauseExt(
    builder: PsiBuilder,
    level: Int,
    merge_update_column_clause: GeneratedParserUtilBase.Parser,
  ): Boolean = (this.merge_update_column_clause ?: merge_update_column_clause).parse(builder, level)

  @JvmStatic
  public fun mergeUpdateColumnClauseSingleExt(
    builder: PsiBuilder,
    level: Int,
    merge_update_column_clause_single: GeneratedParserUtilBase.Parser,
  ): Boolean = (this.merge_update_column_clause_single ?:
      merge_update_column_clause_single).parse(builder, level)

  @JvmStatic
  public fun mergeInsertClauseExt(
    builder: PsiBuilder,
    level: Int,
    merge_insert_clause: GeneratedParserUtilBase.Parser,
  ): Boolean = (this.merge_insert_clause ?: merge_insert_clause).parse(builder, level)

  public fun reset() {
    createElement = { OracleTypes.Factory.createElement(it) }
    overrides = null
    type_name = null
    small_int_data_type = null
    int_data_type = null
    big_int_data_type = null
    fixed_point_data_type = null
    approximate_numeric_data_type = null
    precision = null
    scale = null
    boolean_data_type = null
    character_string_data_type = null
    character_large_object_data_type = null
    character_large_object_length = null
    multiplier = null
    char_length_units = null
    binary_string_data_type = null
    binary_large_object_string_data_type = null
    bit_string_data_type = null
    date_data_type = null
    interval_data_type = null
    interval_qualifier = null
    start_field = null
    end_field = null
    single_datetime_field = null
    non_second_primary_datetime_field = null
    bind_parameter = null
    generated_clause = null
    default_constraint = null
    literal_value = null
    extension_stmt = null
    createUser = null
    grantTable = null
    grantSession = null
    alterTablespace = null
    merge = null
    merge_on = null
    merge_update_clause = null
    merge_update_column_clause = null
    merge_update_column_clause_single = null
    merge_insert_clause = null
  }

  public fun overrideSqlParser() {
    SqlParserUtil.type_name = Parser { psiBuilder, i -> type_name?.parse(psiBuilder, i) ?:
        OracleParser.type_name_real(psiBuilder, i) }
    SqlParserUtil.bind_parameter = Parser { psiBuilder, i -> bind_parameter?.parse(psiBuilder, i) ?:
        OracleParser.bind_parameter_real(psiBuilder, i) }
    SqlParserUtil.generated_clause = Parser { psiBuilder, i -> generated_clause?.parse(psiBuilder,
        i) ?: OracleParser.generated_clause_real(psiBuilder, i) }
    SqlParserUtil.default_constraint = Parser { psiBuilder, i ->
        default_constraint?.parse(psiBuilder, i) ?: OracleParser.default_constraint_real(psiBuilder,
        i) }
    SqlParserUtil.literal_value = Parser { psiBuilder, i -> literal_value?.parse(psiBuilder, i) ?:
        OracleParser.literal_value_real(psiBuilder, i) }
    SqlParserUtil.extension_stmt = Parser { psiBuilder, i -> extension_stmt?.parse(psiBuilder, i) ?:
        OracleParser.extension_stmt_real(psiBuilder, i) }
    val currentCreateElement = SqlParserUtil.createElement
    SqlParserUtil.createElement = {
      try {
        createElement(it)
      } catch(e: AssertionError) {
        currentCreateElement(it)
      }
    }
  }
}
