/*
 * Decompiled with CFR 0.152.
 */
package app.softwork.sqldelightwriter;

import app.softwork.sqldelightwriter.SqFile;
import app.softwork.sqldelightwriter.SqMigrationFile;
import app.softwork.sqldelightwriter.SqQueryFile;
import java.io.File;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B!\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00060\u0003\u00a2\u0006\u0002\u0010\u0007J\u0013\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\b\u0010\u000e\u001a\u00020\u000fH\u0016J\u0011\u0010\u0010\u001a\u00020\u00002\u0006\u0010\u0011\u001a\u00020\u0000H\u0086\u0002J\u000e\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015J\u0014\u0010\u0016\u001a\u00020\u0015*\u00020\u00172\u0006\u0010\u0014\u001a\u00020\u0015H\u0002R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00060\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\t\u00a8\u0006\u0018"}, d2={"Lapp/softwork/sqldelightwriter/SqFiles;", "", "migrations", "", "Lapp/softwork/sqldelightwriter/SqMigrationFile;", "queries", "Lapp/softwork/sqldelightwriter/SqQueryFile;", "(Ljava/util/Set;Ljava/util/Set;)V", "getMigrations", "()Ljava/util/Set;", "getQueries", "equals", "", "other", "hashCode", "", "plus", "new", "writeTo", "", "folder", "Ljava/io/File;", "createPackageFolder", "Lapp/softwork/sqldelightwriter/SqFile;", "sqldelight-writer"})
public final class SqFiles {
    @NotNull
    private final Set<SqMigrationFile> migrations;
    @NotNull
    private final Set<SqQueryFile> queries;

    public SqFiles(@NotNull Set<SqMigrationFile> migrations, @NotNull Set<SqQueryFile> queries) {
        Intrinsics.checkNotNullParameter(migrations, (String)"migrations");
        Intrinsics.checkNotNullParameter(queries, (String)"queries");
        this.migrations = migrations;
        this.queries = queries;
    }

    @NotNull
    public final Set<SqMigrationFile> getMigrations() {
        return this.migrations;
    }

    @NotNull
    public final Set<SqQueryFile> getQueries() {
        return this.queries;
    }

    @NotNull
    public final SqFiles plus(@NotNull SqFiles sqFiles) {
        Intrinsics.checkNotNullParameter((Object)sqFiles, (String)"new");
        return new SqFiles(SetsKt.plus(sqFiles.migrations, (Iterable)this.migrations), SetsKt.plus(sqFiles.queries, (Iterable)this.queries));
    }

    public final void writeTo(@NotNull File folder) {
        File file;
        Intrinsics.checkNotNullParameter((Object)folder, (String)"folder");
        for (SqMigrationFile migration : this.migrations) {
            file = new File(this.createPackageFolder(migration, folder), migration.getVersion() + ".sqm");
            FilesKt.writeText$default((File)file, (String)migration.toString(), null, (int)2, null);
        }
        for (SqQueryFile query : this.queries) {
            file = new File(this.createPackageFolder(query, folder), query.getFileName() + ".sq");
            FilesKt.writeText$default((File)file, (String)query.toString(), null, (int)2, null);
        }
    }

    private final File createPackageFolder(SqFile $this$createPackageFolder, File folder) {
        String packageName = StringsKt.replace$default((String)$this$createPackageFolder.getPackageName(), (String)".", (String)"/", (boolean)false, (int)4, null);
        File packageFolder = new File(folder, packageName);
        packageFolder.mkdirs();
        return packageFolder;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        Object object = other;
        if (!Intrinsics.areEqual(this.getClass(), object != null ? object.getClass() : null)) {
            return false;
        }
        Intrinsics.checkNotNull((Object)other, (String)"null cannot be cast to non-null type app.softwork.sqldelightwriter.SqFiles");
        SqFiles cfr_ignored_0 = (SqFiles)other;
        if (!Intrinsics.areEqual(this.migrations, ((SqFiles)other).migrations)) {
            return false;
        }
        return Intrinsics.areEqual(this.queries, ((SqFiles)other).queries);
    }

    public int hashCode() {
        int result = ((Object)this.migrations).hashCode();
        result = 31 * result + ((Object)this.queries).hashCode();
        return result;
    }
}

