/*
 * Decompiled with CFR 0.152.
 */
package app.tozzi.mail.pec.parser;

import app.tozzi.mail.pec.exception.PECParserException;
import app.tozzi.mail.pec.model.Allegato;
import app.tozzi.mail.pec.model.Busta;
import app.tozzi.mail.pec.model.DataPEC;
import app.tozzi.mail.pec.model.DatiCertificazione;
import app.tozzi.mail.pec.model.DestinatarioPEC;
import app.tozzi.mail.pec.model.ErrorePEC;
import app.tozzi.mail.pec.model.Mail;
import app.tozzi.mail.pec.model.Messaggio;
import app.tozzi.mail.pec.model.PEC;
import app.tozzi.mail.pec.model.RicevutaPEC;
import app.tozzi.mail.pec.model.TipoPostaCert;
import app.tozzi.mail.pec.model.TipoRicevuta;
import app.tozzi.mail.pec.util.IOUtils;
import app.tozzi.mail.pec.util.MimeMessageUtils;
import app.tozzi.mail.pec.util.Tupla;
import app.tozzi.mail.pec.util.XMLDocumentUtils;
import app.tozzi.uudecoder.UUDecoder;
import app.tozzi.uudecoder.exception.UUDecoderException;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.activation.DataSource;
import javax.mail.Address;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.Part;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimePart;
import javax.mail.internet.MimeUtility;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class PECMessageParser {
    private static final Logger log = LoggerFactory.getLogger(PECMessageParser.class);
    private final DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
    private Properties properties;

    public static PECMessageParser getInstance() throws PECParserException {
        return new PECMessageParser(null);
    }

    public static PECMessageParser getInstance(Properties properties) throws PECParserException {
        return new PECMessageParser(properties);
    }

    public Messaggio parse(File eml) throws PECParserException {
        Messaggio messaggio;
        if (eml == null) {
            throw new PECParserException("Il file \u00e8 nullo", null);
        }
        if (!eml.exists()) {
            throw new PECParserException("Il file " + eml.getName() + " non esiste", null);
        }
        FileInputStream is = new FileInputStream(eml);
        try {
            messaggio = this.parse(is);
        }
        catch (Throwable throwable) {
            try {
                try {
                    ((InputStream)is).close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                log.error("Errore IO: {}", (Object)e.getLocalizedMessage(), (Object)e);
                throw new PECParserException(null, e);
            }
        }
        ((InputStream)is).close();
        return messaggio;
    }

    private PECMessageParser(Properties properties) throws PECParserException {
        this.properties = properties;
    }

    public Messaggio parse(InputStream eml) throws PECParserException {
        return this.parse(MimeMessageUtils.createMimeMessage(eml, this.properties));
    }

    public Messaggio parse(MimeMessage mimeMessage) throws PECParserException {
        Busta busta;
        String xTrasporto = null;
        String xRicevuta = null;
        String xRiferimentoMessageID = null;
        String xTipoRicevuta = null;
        String xVerificaSicurezza = null;
        Messaggio messaggio = new Messaggio();
        try {
            xTrasporto = mimeMessage.getHeader("X-Trasporto", ",");
            xRicevuta = mimeMessage.getHeader("X-Ricevuta", ",");
            xRiferimentoMessageID = mimeMessage.getHeader("X-Riferimento-Message-ID", ",");
            xTipoRicevuta = mimeMessage.getHeader("X-TipoRicevuta", ",");
            xVerificaSicurezza = mimeMessage.getHeader("X-VerificaSicurezza", ",");
        }
        catch (MessagingException e) {
            log.error("Errore durante la lettura degli header di trasporto", (Throwable)e);
            throw new PECParserException("Errore durante la lettura degli header di trasporto", (Exception)((Object)e));
        }
        try {
            busta = PECMessageParser.estraiBusta(mimeMessage, xTrasporto != null || xRicevuta != null);
            busta.setXRicevuta(xRicevuta);
            busta.setXRiferimentoMessageID(xRiferimentoMessageID);
            busta.setXTrasporto(xTrasporto);
            busta.setXTipoRicevuta(xTipoRicevuta);
            busta.setXVerificaSicurezza(xVerificaSicurezza);
        }
        catch (PECParserException e) {
            log.error("Errore durante l'elaborazione della busta");
            throw e;
        }
        messaggio.setBusta(busta);
        if (xTrasporto != null) {
            try {
                messaggio.setPec(this.estraiPEC(busta, xTrasporto));
            }
            catch (PECParserException e) {
                log.error("Errore durante l'elaborazione della PEC");
                throw e;
            }
        }
        if (xRicevuta != null) {
            try {
                messaggio.setRicevuta(this.estraiRicevuta(busta));
            }
            catch (PECParserException e) {
                log.error("Errore durante l'elaborazione della ricevuta");
                throw e;
            }
        }
        return messaggio;
    }

    private static Busta estraiBusta(MimeMessage mimeMessage, boolean elaboraPEC) throws PECParserException {
        Busta busta = new Busta();
        Tupla<DataSource, DataSource> tupla = new Tupla<DataSource, DataSource>();
        PECMessageParser.parse(mimeMessage, busta, tupla, elaboraPEC);
        busta.setPostaCert(tupla.getElementA());
        busta.setDatiCert(tupla.getElementB());
        return busta;
    }

    private RicevutaPEC estraiRicevuta(Busta busta) throws PECParserException {
        try {
            RicevutaPEC ricevutaPEC = new RicevutaPEC();
            ricevutaPEC.setDatiCertificazione(this.estraiDatiCertificazione(busta.getDatiCert().getInputStream()));
            if (busta.getPostaCert() != null) {
                PEC pec = PECMessageParser.estraiPEC(MimeMessageUtils.createMimeMessage(busta.getPostaCert().getInputStream(), this.properties));
                ricevutaPEC.setMessaggioOriginale(pec);
            }
            return ricevutaPEC;
        }
        catch (Exception e) {
            throw new PECParserException("Errore durante l'elaborazione della ricevuta", e);
        }
    }

    private PEC estraiPEC(Busta busta, String xTrasporto) throws PECParserException {
        try {
            MimeMessage postaCertMimeMessage = MimeMessageUtils.createMimeMessage(busta.getPostaCert().getInputStream(), this.properties);
            PEC pec = PECMessageParser.estraiPEC(postaCertMimeMessage);
            if (busta.getDatiCert() != null && (TipoPostaCert.POSTA_CERTIFICATA.getDescrizione().equals(xTrasporto) || TipoPostaCert.ERRORE.getDescrizione().equals(xTrasporto))) {
                pec.setDatiCertificazione(this.estraiDatiCertificazione(busta.getDatiCert().getInputStream()));
            }
            return pec;
        }
        catch (Exception e) {
            throw new PECParserException("Errore durante l'elaborazione della PEC", e);
        }
    }

    private static PEC estraiPEC(MimeMessage postaCertMimeMessage) throws PECParserException {
        PEC pec = new PEC();
        PECMessageParser.parse(postaCertMimeMessage, pec, null, false);
        return pec;
    }

    private DatiCertificazione estraiDatiCertificazione(InputStream inputStream) throws PECParserException {
        Document datiCertDocument;
        try {
            datiCertDocument = this.documentBuilderFactory.newDocumentBuilder().parse(inputStream);
        }
        catch (IOException | SAXException e) {
            log.error("Errore durante il parsing del daticert.xml", (Throwable)e);
            throw new PECParserException("Errore durante il parsing del daticert.xml", e);
        }
        catch (ParserConfigurationException e) {
            log.error("Errore durante l'inizializzazione del DocumentBuilder XML", (Throwable)e);
            throw new PECParserException("Errore durante l'inizializzazione del DocumentBuilder XML", e);
        }
        DatiCertificazione datiCertificazione = new DatiCertificazione();
        datiCertificazione.setMittente(XMLDocumentUtils.getTextContent(datiCertDocument, "/postacert/intestazione/mittente", false));
        Map<String, String> destinatari = XMLDocumentUtils.getTextAndAttribute(datiCertDocument, "/postacert/intestazione/destinatari", "tipo", false);
        destinatari.entrySet().stream().forEach(d -> datiCertificazione.getDestinatari().add(new DestinatarioPEC((String)d.getKey(), DestinatarioPEC.TipoDestinatario.from((String)d.getValue()))));
        datiCertificazione.setRisposte(XMLDocumentUtils.getTextContent(datiCertDocument, "/postacert/intestazione/risposte", false));
        datiCertificazione.setOggetto(XMLDocumentUtils.getTextContent(datiCertDocument, "/postacert/intestazione/oggetto", true));
        datiCertificazione.setGestoreEmittente(XMLDocumentUtils.getTextContent(datiCertDocument, "/postacert/dati/gestore-emittente", false));
        datiCertificazione.setData(new DataPEC(XMLDocumentUtils.getAttribute(datiCertDocument, "/postacert/dati/data", "zona", false), XMLDocumentUtils.getTextContent(datiCertDocument, "/postacert/dati/data/giorno", false), XMLDocumentUtils.getTextContent(datiCertDocument, "/postacert/dati/data/ora", false)));
        datiCertificazione.setTipoRicevuta(TipoRicevuta.from(XMLDocumentUtils.getAttribute(datiCertDocument, "/postacert/dati/ricevuta", "tipo", true)));
        datiCertificazione.setErrore(ErrorePEC.from(XMLDocumentUtils.getAttribute(datiCertDocument, "/postacert", "errore", false)));
        datiCertificazione.setErroreEsteso(XMLDocumentUtils.getTextContent(datiCertDocument, "/postacert/dati/errore-esteso", true));
        datiCertificazione.setConsegna(XMLDocumentUtils.getTextContent(datiCertDocument, "/postacert/dati/consegna", true));
        datiCertificazione.setRicezione(XMLDocumentUtils.getTextContent(datiCertDocument, "/postacert/dati/ricezione", true));
        datiCertificazione.setMessageID(XMLDocumentUtils.getTextContent(datiCertDocument, "/postacert/dati/msgid", true));
        datiCertificazione.setIdentificativo(XMLDocumentUtils.getTextContent(datiCertDocument, "/postacert/dati/identificativo", true));
        datiCertificazione.setTipo(TipoPostaCert.from(XMLDocumentUtils.getAttribute(datiCertDocument, "/postacert", "tipo", false)));
        return datiCertificazione;
    }

    private static void parse(MimeMessage mimeMessage, Mail mail, Tupla<DataSource, DataSource> tupla, boolean elaboraPEC) throws PECParserException {
        Address[] destinatari;
        try {
            Address[] mittenti = mimeMessage.getFrom();
            if (mittenti != null) {
                mail.getMittenti().addAll(Stream.of(mittenti).filter(m -> m != null && m instanceof InternetAddress).map(m -> ((InternetAddress)m).getAddress()).distinct().collect(Collectors.toList()));
            }
        }
        catch (MessagingException e) {
            log.error("Errore durante l'elaborazione dei mittenti della mail", (Throwable)e);
            throw new PECParserException("Errore durante l'elaborazione dei mittenti della mail", (Exception)((Object)e));
        }
        try {
            destinatari = mimeMessage.getRecipients(MimeMessage.RecipientType.TO);
            if (destinatari != null) {
                mail.getDestinatari().addAll(Stream.of(destinatari).filter(m -> m != null && m instanceof InternetAddress).map(m -> ((InternetAddress)m).getAddress()).distinct().collect(Collectors.toList()));
            }
        }
        catch (MessagingException e) {
            log.error("Errore durante l'elaborazione dei destinatari della mail", (Throwable)e);
            throw new PECParserException("Errore durante l'elaborazione dei destinatari della mail", (Exception)((Object)e));
        }
        try {
            destinatari = mimeMessage.getRecipients(MimeMessage.RecipientType.CC);
            if (destinatari != null) {
                mail.getDestinatariCopiaConoscenza().addAll(Stream.of(destinatari).filter(m -> m != null && m instanceof InternetAddress).map(m -> ((InternetAddress)m).getAddress()).distinct().collect(Collectors.toList()));
            }
        }
        catch (MessagingException e) {
            log.error("Errore durante l'elaborazione dei destinatari in copia conoscenza della mail", (Throwable)e);
            throw new PECParserException("Errore durante l'elaborazione dei destinatari in copia conoscenza della mail", (Exception)((Object)e));
        }
        try {
            destinatari = mimeMessage.getRecipients(MimeMessage.RecipientType.BCC);
            if (destinatari != null) {
                mail.getDestinatariCopiaConoscenzaNascosta().addAll(Stream.of(destinatari).filter(m -> m != null && m instanceof InternetAddress).map(m -> ((InternetAddress)m).getAddress()).distinct().collect(Collectors.toList()));
            }
        }
        catch (MessagingException e) {
            log.error("Errore durante l'elaborazione dei destinatari in copia conoscenza nascosta della mail", (Throwable)e);
            throw new PECParserException("Errore durante l'elaborazione dei destinatari in copia conoscenza nascosta della mail", (Exception)((Object)e));
        }
        try {
            mail.setDataInvio(mimeMessage.getSentDate());
        }
        catch (MessagingException e) {
            log.error("Errore durante l'elaborazione della data di invio della mail", (Throwable)e);
            throw new PECParserException("Errore durante l'elaborazione della data di invio della mail", (Exception)((Object)e));
        }
        try {
            mail.setDataRicezione(mimeMessage.getReceivedDate());
        }
        catch (MessagingException e) {
            log.error("Errore durante l'elaborazione della data di ricezione della mail", (Throwable)e);
            throw new PECParserException("Errore durante l'elaborazione della data di ricezione della mail", (Exception)((Object)e));
        }
        try {
            String oggetto = mimeMessage.getSubject();
            if (oggetto != null) {
                mail.setOggetto(MimeUtility.decodeText((String)oggetto));
            }
        }
        catch (UnsupportedEncodingException | MessagingException e) {
            log.error("Errore durante l'elaborazione dell'oggetto della mail", e);
            throw new PECParserException("Errore durante l'elaborazione dell'oggetto della mail", (Exception)e);
        }
        try {
            String messageID = null;
            messageID = mimeMessage.getMessageID();
            if (messageID != null) {
                messageID = messageID.replaceAll("<", "").replaceAll(">", "");
            }
            if (messageID == null || messageID.isEmpty()) {
                messageID = MimeMessageUtils.getUniqueMessageID(mimeMessage);
            }
            mail.setMessageID(messageID);
        }
        catch (PECParserException e) {
            log.error("Errore durante l'elaborazione del messageID", (Throwable)e);
            throw e;
        }
        catch (MessagingException e) {
            log.error("Errore durante l'elaborazione del messageID", (Throwable)e);
            throw new PECParserException("Errore durante l'elaborazione del messageID della mail", (Exception)((Object)e));
        }
        try {
            String[] inReplyTO = mimeMessage.getHeader("In-Reply-To");
            if (inReplyTO != null) {
                mail.setReplyToMessageID(((String)Stream.of(inReplyTO).collect(Collectors.toList()).get(0)).replaceAll("<", "").replaceAll(">", ""));
            }
        }
        catch (MessagingException e) {
            log.error("Errore durante l'elaborazione del reply to", (Throwable)e);
            throw new PECParserException("Errore durante l'elaborazione del reply to della mail", (Exception)((Object)e));
        }
        try {
            String[] referencesHeader = mimeMessage.getHeader("References");
            if (referencesHeader != null) {
                mail.getReplyToHistoryMessagesID().addAll(Stream.of(((String)Stream.of(referencesHeader).collect(Collectors.toList()).get(0)).split(" ")).map(r -> r.replaceAll("<", "").replaceAll(">", "")).collect(Collectors.toList()));
            }
        }
        catch (MessagingException e) {
            log.error("Errore durante l'elaborazione del reply to", (Throwable)e);
            throw new PECParserException("Errore durante l'elaborazione del reply to della mail", (Exception)((Object)e));
        }
        PECMessageParser.parseContent((MimePart)mimeMessage, mail, tupla, elaboraPEC);
    }

    private static void parseContent(MimePart part, Mail mail, Tupla<DataSource, DataSource> tupla, boolean elaboraPEC) throws PECParserException {
        Object content = MimeMessageUtils.getContent((Part)part);
        if (MimeMessageUtils.isMimeType((Part)part, "text/plain") && !"attachment".equalsIgnoreCase(MimeMessageUtils.getDisposition((Part)part)) && mail.getCorpoTesto() == null) {
            String corpo;
            block50: {
                corpo = content.toString();
                try {
                    if (!UUDecoder.containsUUEncodedAttachments((String)content.toString())) break block50;
                    corpo = corpo.substring(0, UUDecoder.getNextBeginIndex((String)corpo));
                    List decodedAttachments = null;
                    try {
                        decodedAttachments = UUDecoder.getUUDecodedAttachments((String)content.toString());
                    }
                    catch (UUDecoderException e) {
                        log.error("Errore durante l'estrazione degli allegati codificati in uuencoding", (Throwable)e);
                        throw new PECParserException("Errore durante l'estrazione degli allegati codificati in uuencoding", (Exception)((Object)e));
                    }
                    for (UUDecoder.UUDecodedAttachment uda : decodedAttachments) {
                        mail.getAllegati().add(new Allegato(uda.getFileName(), uda.getDataSource(), null, null, false));
                    }
                }
                catch (UUDecoderException e) {
                    log.error("Errore durante la verifica di allegati codificati in uuencoding", (Throwable)e);
                    throw new PECParserException("Errore durante la verifica di allegati codificati in uuencoding", (Exception)((Object)e));
                }
            }
            mail.setCorpoTesto(MimeMessageUtils.decodeText(corpo));
        } else if (MimeMessageUtils.isMimeType((Part)part, "text/html") && !"attachment".equalsIgnoreCase(MimeMessageUtils.getDisposition((Part)part))) {
            if (mail.getCorpoHTML() == null) {
                mail.setCorpoHTML(MimeMessageUtils.decodeText(content.toString()));
            } else {
                mail.setCorpoHTML(mail.getCorpoHTML() + MimeMessageUtils.decodeText(content.toString()));
            }
        } else if (MimeMessageUtils.isMimeType((Part)part, "multipart/*")) {
            Multipart multipart = (Multipart)content;
            for (int i = 0; i < MimeMessageUtils.getCount(multipart); ++i) {
                PECMessageParser.parseContent((MimePart)((MimeBodyPart)MimeMessageUtils.getBodyPart(multipart, i)), mail, tupla, elaboraPEC);
            }
        } else if (MimeMessageUtils.isMimeType((Part)part, "message/delivery-status")) {
            mail.setDeliveryStatus(true);
            Mail.DeliveryStatus deliveryStatus = new Mail.DeliveryStatus();
            try (BufferedReader br = new BufferedReader(new InputStreamReader(part.getInputStream()));){
                String line = br.readLine();
                while (line != null) {
                    if (line.toLowerCase().startsWith("action".toLowerCase() + ":")) {
                        String action = line.substring("action".length() + 1).trim();
                        deliveryStatus.setAction(Mail.DeliveryStatus.Action.from(action));
                    } else if (line.toLowerCase().startsWith("status".toLowerCase() + ":")) {
                        char first;
                        int prefix;
                        String status = line.substring("status".length() + 1).trim();
                        deliveryStatus.setStatus(status);
                        if (status != null && !status.isEmpty() && (prefix = Character.getNumericValue(first = status.charAt(0))) > 0) {
                            deliveryStatus.setTipoStato(Mail.DeliveryStatus.TipoStato.from(prefix));
                        }
                    } else if (line.toLowerCase().startsWith("Diagnostic-Code".toLowerCase() + ":")) {
                        String diagnosticCode = line.substring("Diagnostic-Code".length() + 1).trim();
                        Mail.DeliveryStatus.DiagnosticCode dc = new Mail.DeliveryStatus.DiagnosticCode();
                        if (diagnosticCode.contains(";")) {
                            dc.setType(diagnosticCode.substring(0, diagnosticCode.indexOf(";")));
                            dc.setDescription(diagnosticCode.substring(diagnosticCode.indexOf(";") + 1));
                        } else {
                            dc.setDescription(diagnosticCode);
                        }
                        deliveryStatus.setDiagnosticCode(dc);
                    } else if (line.toLowerCase().startsWith("Remote-MTA".toLowerCase() + ":")) {
                        String remoteMta = line.substring("Remote-MTA".length() + 1).trim();
                        deliveryStatus.setRemoteMTA(remoteMta);
                    } else if (line.toLowerCase().startsWith("Reporting-MTA".toLowerCase() + ":")) {
                        String reportingMTA = line.substring("Reporting-MTA".length() + 1).trim();
                        deliveryStatus.setReportingMTA(reportingMTA);
                    } else if (line.toLowerCase().startsWith("Received-From-MTA".toLowerCase() + ":")) {
                        String recivedFromMTA = line.substring("Received-From-MTA".length() + 1).trim();
                        deliveryStatus.setReceivedFromMTA(recivedFromMTA);
                    } else if (line.toLowerCase().startsWith("Final-Recipient".toLowerCase() + ":")) {
                        String finalRecipient = line.substring("Final-Recipient".length() + 1).trim();
                        deliveryStatus.setFinalRecipient(finalRecipient);
                    }
                    line = br.readLine();
                }
            }
            catch (Exception e) {
                log.error("Errore durante il parsing degli header di delivery status", (Throwable)e);
            }
            mail.setDeliveryStatusInfo(deliveryStatus);
        } else {
            boolean pec = false;
            if (elaboraPEC && tupla != null && !tupla.isComplete() && MimeMessageUtils.getDisposition((Part)part) != null && MimeMessageUtils.getFileName((Part)part) != null) {
                if (tupla.getElementA() == null && ("postacert.eml".equalsIgnoreCase(MimeMessageUtils.decodeText(MimeMessageUtils.getFileName((Part)part))) || "postacert.eml".equals(MimeMessageUtils.getFileName((Part)part))) && MimeMessageUtils.isMimeType((Part)part, "message/rfc822")) {
                    pec = true;
                    try {
                        tupla.setElementA(IOUtils.createDataSource(part));
                    }
                    catch (PECParserException | IOException e) {
                        log.error("Errore durante l'estrazione del file {}", (Object)"postacert.eml", (Object)e);
                        throw new PECParserException("Errore durante l'estrazione del file postacert.eml", e);
                    }
                }
                if (tupla.getElementB() == null && ("daticert.xml".equalsIgnoreCase(MimeMessageUtils.decodeText(MimeMessageUtils.getFileName((Part)part))) || "daticert.xml".equals(MimeMessageUtils.getFileName((Part)part))) && MimeMessageUtils.isMimeType((Part)part, "application/xml")) {
                    pec = true;
                    try {
                        tupla.setElementB(IOUtils.createDataSource(part));
                    }
                    catch (PECParserException | IOException e) {
                        log.error("Errore durante l'estrazione del file {}", (Object)"daticert.xml", (Object)e);
                        throw new PECParserException("Errore durante l'estrazione del file daticert.xml", e);
                    }
                }
            }
            if (!pec) {
                DataSource dataSource;
                try {
                    dataSource = IOUtils.createDataSource(part);
                }
                catch (PECParserException | IOException e) {
                    log.error("Errore durante l'estrazione dell'allegato {}", (Object)MimeMessageUtils.getFileName((Part)part), (Object)e);
                    throw new PECParserException("Errore durante l'estrazione dell'allegato " + MimeMessageUtils.getFileName((Part)part), e);
                }
                mail.getAllegati().add(new Allegato(dataSource.getName(), dataSource, MimeMessageUtils.getHeaderValue("Content-ID", (Part)part), MimeMessageUtils.getHeaderValue("X-Attachment-Id", (Part)part), "inline".equals(MimeMessageUtils.getDisposition((Part)part))));
            }
        }
    }
}

