/*
 * Decompiled with CFR 0.152.
 */
package app.ubie.spannerkase;

import app.ubie.spannerkase.MigrationData;
import app.ubie.spannerkase.MigrationDataScanner;
import app.ubie.spannerkase.SpannerKaseDatabaseClient;
import app.ubie.spannerkase.internal.SchemeHistory;
import app.ubie.spannerkase.internal.SchemeHistoryRepository;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u0012B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J&\u0010\u0007\u001a\u0004\u0018\u00010\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\b0\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\f0\nH\u0002J.\u0010\r\u001a\u0004\u0018\u00010\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\b0\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\f0\n2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0006\u0010\u0010\u001a\u00020\u0011R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0013"}, d2={"Lapp/ubie/spannerkase/SpannerKase;", "", "configure", "Lapp/ubie/spannerkase/SpannerKase$Configure;", "(Lapp/ubie/spannerkase/SpannerKase$Configure;)V", "getConfigure", "()Lapp/ubie/spannerkase/SpannerKase$Configure;", "findInvalidChecksumMigrationData", "Lapp/ubie/spannerkase/MigrationData;", "migrationDataList", "", "versionHistories", "Lapp/ubie/spannerkase/internal/SchemeHistory;", "findInvalidVersionMigrationData", "currentVersion", "", "migrate", "", "Configure", "spanner-kase"})
public final class SpannerKase {
    @NotNull
    private final Configure configure;

    /*
     * WARNING - void declaration
     */
    public final void migrate() {
        void $this$filterTo$iv$iv;
        SpannerKaseDatabaseClient databaseClient = this.configure.getDatabaseClient();
        MigrationDataScanner migrationDataScanner = this.configure.getMigrationDataScanner();
        SchemeHistoryRepository schemeHistoryRepository = this.configure.createSchemeHistoryRepository$spanner_kase();
        List<MigrationData> migrationDataList = migrationDataScanner.scan();
        if (migrationDataList.isEmpty()) {
            return;
        }
        List<SchemeHistory> versionHistories = schemeHistoryRepository.versionHistories();
        MigrationData migrationData = this.findInvalidChecksumMigrationData(migrationDataList, versionHistories);
        if (migrationData != null) {
            MigrationData migrationData2 = migrationData;
            boolean bl = false;
            boolean bl2 = false;
            MigrationData it = migrationData2;
            boolean bl3 = false;
            throw (Throwable)new IllegalStateException("checksum is different. " + it.getName());
        }
        SchemeHistory schemeHistory = schemeHistoryRepository.currentVersion();
        long currentVersion = schemeHistory != null ? schemeHistory.getVersion() : 0L;
        MigrationData migrationData3 = this.findInvalidVersionMigrationData(migrationDataList, versionHistories, currentVersion);
        if (migrationData3 != null) {
            MigrationData migrationData4 = migrationData3;
            boolean it = false;
            boolean bl3 = false;
            MigrationData it2 = migrationData4;
            boolean bl = false;
            throw (Throwable)new IllegalStateException("find a migration file that older than current version. " + it2.getName());
        }
        Iterable $this$filter$iv = migrationDataList;
        boolean $i$f$filter = false;
        Iterable bl3 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            MigrationData it = (MigrationData)element$iv$iv;
            boolean bl = false;
            if (!(it.getVersion() > currentVersion)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$forEach$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            MigrationData migrationData5 = (MigrationData)element$iv;
            boolean bl = false;
            String sql2 = migrationData5.getSql();
            databaseClient.executeSql(sql2);
            long l = migrationData5.getVersion();
            long l2 = migrationData5.getVersion();
            String string = migrationData5.getName();
            long l3 = migrationData5.getChecksum();
            LocalDateTime localDateTime = LocalDateTime.now();
            Intrinsics.checkExpressionValueIsNotNull((Object)localDateTime, (String)"LocalDateTime.now()");
            databaseClient.insertSchemeHistory$spanner_kase(new SchemeHistory(l, l2, string, l3, localDateTime));
        }
    }

    private final MigrationData findInvalidChecksumMigrationData(List<? extends MigrationData> migrationDataList, List<SchemeHistory> versionHistories) {
        return (MigrationData)SequencesKt.firstOrNull((Sequence)SequencesKt.mapNotNull((Sequence)CollectionsKt.asSequence((Iterable)versionHistories), (Function1)((Function1)new Function1<SchemeHistory, MigrationData>(migrationDataList){
            final /* synthetic */ List $migrationDataList;

            @Nullable
            public final MigrationData invoke(@NotNull SchemeHistory history) {
                Object v0;
                block1: {
                    Intrinsics.checkParameterIsNotNull((Object)history, (String)"history");
                    Iterable iterable = this.$migrationDataList;
                    boolean bl = false;
                    Iterable iterable2 = iterable;
                    boolean bl2 = false;
                    for (T t : iterable2) {
                        MigrationData it = (MigrationData)t;
                        boolean bl3 = false;
                        if (!(it.getVersion() == history.getVersion() && it.getChecksum() != history.getChecksum())) continue;
                        v0 = t;
                        break block1;
                    }
                    v0 = null;
                }
                return v0;
            }
            {
                this.$migrationDataList = list;
                super(1);
            }
        })));
    }

    /*
     * Enabled aggressive block sorting
     */
    private final MigrationData findInvalidVersionMigrationData(List<? extends MigrationData> migrationDataList, List<SchemeHistory> versionHistories, long currentVersion) {
        Object t;
        Object v0;
        boolean bl;
        Iterable iterable = migrationDataList;
        boolean bl2 = false;
        Iterable iterable2 = iterable;
        boolean bl3 = false;
        Iterator iterator = iterable2.iterator();
        do {
            if (!iterator.hasNext()) {
                v0 = null;
                return v0;
            }
            t = iterator.next();
            MigrationData migrationData = (MigrationData)t;
            boolean bl4 = false;
            if (migrationData.getVersion() < currentVersion) {
                boolean bl5;
                block7: {
                    Iterable $this$any$iv = versionHistories;
                    boolean $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl5 = false;
                    } else {
                        for (Object element$iv : $this$any$iv) {
                            SchemeHistory it = (SchemeHistory)element$iv;
                            boolean bl6 = false;
                            if (!(migrationData.getVersion() == it.getVersion())) continue;
                            bl5 = true;
                            break block7;
                        }
                        bl5 = false;
                    }
                }
                if (!bl5) {
                    bl = true;
                    continue;
                }
            }
            bl = false;
        } while (!bl);
        v0 = t;
        return v0;
    }

    @NotNull
    public final Configure getConfigure() {
        return this.configure;
    }

    public SpannerKase(@NotNull Configure configure) {
        Intrinsics.checkParameterIsNotNull((Object)configure, (String)"configure");
        this.configure = configure;
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\r\u0010\u000b\u001a\u00020\fH\u0000\u00a2\u0006\u0002\b\rR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u000e"}, d2={"Lapp/ubie/spannerkase/SpannerKase$Configure;", "", "databaseClient", "Lapp/ubie/spannerkase/SpannerKaseDatabaseClient;", "migrationDataScanner", "Lapp/ubie/spannerkase/MigrationDataScanner;", "(Lapp/ubie/spannerkase/SpannerKaseDatabaseClient;Lapp/ubie/spannerkase/MigrationDataScanner;)V", "getDatabaseClient", "()Lapp/ubie/spannerkase/SpannerKaseDatabaseClient;", "getMigrationDataScanner", "()Lapp/ubie/spannerkase/MigrationDataScanner;", "createSchemeHistoryRepository", "Lapp/ubie/spannerkase/internal/SchemeHistoryRepository;", "createSchemeHistoryRepository$spanner_kase", "spanner-kase"})
    public static final class Configure {
        @NotNull
        private final SpannerKaseDatabaseClient databaseClient;
        @NotNull
        private final MigrationDataScanner migrationDataScanner;

        @NotNull
        public final SchemeHistoryRepository createSchemeHistoryRepository$spanner_kase() {
            SchemeHistoryRepository schemeHistoryRepository = new SchemeHistoryRepository(this.databaseClient);
            boolean bl = false;
            boolean bl2 = false;
            SchemeHistoryRepository $this$apply = schemeHistoryRepository;
            boolean bl3 = false;
            $this$apply.createSchemeHistory();
            return schemeHistoryRepository;
        }

        @NotNull
        public final SpannerKaseDatabaseClient getDatabaseClient() {
            return this.databaseClient;
        }

        @NotNull
        public final MigrationDataScanner getMigrationDataScanner() {
            return this.migrationDataScanner;
        }

        public Configure(@NotNull SpannerKaseDatabaseClient databaseClient, @NotNull MigrationDataScanner migrationDataScanner) {
            Intrinsics.checkParameterIsNotNull((Object)databaseClient, (String)"databaseClient");
            Intrinsics.checkParameterIsNotNull((Object)migrationDataScanner, (String)"migrationDataScanner");
            this.databaseClient = databaseClient;
            this.migrationDataScanner = migrationDataScanner;
        }
    }
}

