package app.valuationcontrol.multimodule.library.entities;

import app.valuationcontrol.multimodule.library.helpers.PercentageFloatDeserializer;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import jakarta.persistence.Column;
import jakarta.persistence.Embeddable;
import java.util.Map;
import java.util.function.IntConsumer;
import lombok.Data;

/**
 * Helper class to a Model Supports the storage of the information related to Key Parameters of the
 * Model
 *
 * @author thoma
 */
@Embeddable
@Data
public class KeyParam {

  @Column(name = "keyoutput_1_id")
  private Long keyOutput1Id;

  @Column(name = "keyoutput_2_id")
  private Long keyOutput2Id;

  @Column(name = "keyoutput_1_period")
  private Integer keyOutput1Period;

  @Column(name = "keyoutput_2_period")
  private Integer keyOutput2Period;

  @Column(name = "keyparam_1_id")
  private Long keyParam1Id;

  @Column(name = "keyparam_1_period")
  private Integer keyParam1Period;

  @Column(name = "keyparam_1_type")
  private String keyParam1Type;

  @Column(name = "keyparam_1_start_value")
  @JsonDeserialize(using = PercentageFloatDeserializer.class)
  private Float keyParam1StartValue;

  @Column(name = "keyparam_1_stop_value")
  @JsonDeserialize(using = PercentageFloatDeserializer.class)
  private Float keyParam1StopValue;

  @Column(name = "keyparam_2_id")
  private Long keyParam2Id;

  @Column(name = "keyparam_2_period")
  private Integer keyParam2Period;

  @Column(name = "keyparam_2_type")
  private String keyParam2Type;

  @Column(name = "keyparam_2_start_value")
  @JsonDeserialize(using = PercentageFloatDeserializer.class)
  private Float keyParam2StartValue;

  @Column(name = "keyparam_2_stop_value")
  @JsonDeserialize(using = PercentageFloatDeserializer.class)
  private Float keyParam2StopValue;

  @Column(name = "keyparam_3_id")
  private Long keyParam3Id;

  @Column(name = "keyparam_3_period")
  private Integer keyParam3Period;

  @Column(name = "keyparam_3_type")
  private String keyParam3Type;

  @Column(name = "keyparam_3_start_value")
  @JsonDeserialize(using = PercentageFloatDeserializer.class)
  private Float keyParam3StartValue;

  @Column(name = "keyparam_3_stop_value")
  @JsonDeserialize(using = PercentageFloatDeserializer.class)
  private Float keyParam3StopValue;

  @Column(name = "keyparam_4_id")
  private Long keyParam4Id;

  @Column(name = "keyparam_4_period")
  private Integer keyParam4Period;

  @Column(name = "keyparam_4_type")
  private String keyParam4Type;

  @Column(name = "keyparam_4_start_value")
  @JsonDeserialize(using = PercentageFloatDeserializer.class)
  private Float keyParam4StartValue;

  @Column(name = "keyparam_4_stop_value")
  @JsonDeserialize(using = PercentageFloatDeserializer.class)
  private Float keyParam4StopValue;

  public void copyFromExisting(KeyParam keyParam, Model model) {
    if (keyParam == null) {
      return;
    }

    smartSet(keyParam.getKeyOutput1Period(), this::setKeyOutput1Period, model);
    smartSet(keyParam.getKeyOutput2Period(), this::setKeyOutput2Period, model);
    smartSet(keyParam.getKeyParam1Period(), this::setKeyParam1Period, model);
    smartSet(keyParam.getKeyParam2Period(), this::setKeyParam2Period, model);
    smartSet(keyParam.getKeyParam3Period(), this::setKeyParam3Period, model);
    smartSet(keyParam.getKeyParam4Period(), this::setKeyParam4Period, model);

    this.keyOutput1Id = keyParam.getKeyOutput1Id();
    this.keyOutput2Id = keyParam.getKeyOutput2Id();
    this.keyParam1Id = keyParam.getKeyParam1Id();
    this.keyParam2Id = keyParam.getKeyParam2Id();
    this.keyParam3Id = keyParam.getKeyParam3Id();
    this.keyParam4Id = keyParam.getKeyParam4Id();
    this.keyParam1StartValue = keyParam.getKeyParam1StartValue();
    this.keyParam2StartValue = keyParam.getKeyParam2StartValue();
    this.keyParam3StartValue = keyParam.getKeyParam3StartValue();
    this.keyParam4StartValue = keyParam.getKeyParam4StartValue();
    this.keyParam1StopValue = keyParam.getKeyParam1StopValue();
    this.keyParam2StopValue = keyParam.getKeyParam2StopValue();
    this.keyParam3StopValue = keyParam.getKeyParam3StopValue();
    this.keyParam4StopValue = keyParam.getKeyParam4StopValue();
    this.keyParam1Type = keyParam.getKeyParam1Type();
    this.keyParam2Type = keyParam.getKeyParam2Type();
    this.keyParam3Type = keyParam.getKeyParam3Type();
    this.keyParam4Type = keyParam.getKeyParam4Type();
  }

  private void smartSet(Integer period, IntConsumer setPeriod, Model model) {
    final Integer modelYear = Sensitivity.asModelYear(period, model);

    try {

      final Integer yearIndex = Sensitivity.fromYear(modelYear, model);
      if (yearIndex != null) {
        setPeriod.accept(yearIndex);
      }

    } catch (IllegalArgumentException e) {
      // If the selected period is before the new models period, set to earlies historical period
      // period = -5 and model only has 3 historical periods then we set -3 instead
      if (period < -model.getNbHistoricalPeriod()) {
        setPeriod.accept(-model.getNbHistoricalPeriod());
      }

      if (period > (model.getNbProjectionPeriod() - 1)) {
        setPeriod.accept(model.getNbProjectionPeriod() - 1);
      }
    }
  }

  /**
   * Function that replace old IDS with new ids when creating a model
   *
   * @param oldToNewIds a hashmap that contains old and new ids
   */
  public void replaceIds(Map<Long, Long> oldToNewIds) {
    this.keyOutput1Id = oldToNewIds.get(this.keyOutput1Id);
    this.keyOutput2Id = oldToNewIds.get(this.keyOutput2Id);
    this.keyParam1Id = oldToNewIds.get(this.keyParam1Id);
    this.keyParam2Id = oldToNewIds.get(this.keyParam2Id);
    this.keyParam3Id = oldToNewIds.get(this.keyParam3Id);
    this.keyParam4Id = oldToNewIds.get(this.keyParam4Id);
  }

  /**
   * Deletes a variable from KeyParam if it is among the KeyParams
   *
   * @param variableId is the id of the variable to be deleted
   */
  public void deleteVariableFromKeyParam(Long variableId) {
    if (variableId == null) {
      return;
    }

    if (variableId.equals(this.keyOutput1Id)) {
      this.keyOutput1Id = null;
      this.keyOutput1Period = null;
    }

    if (variableId.equals(this.keyOutput2Id)) {
      this.keyOutput2Id = null;
      this.keyOutput2Period = null;
    }

    if (variableId.equals(this.keyParam1Id)) {
      this.keyParam1Id = null;
      this.keyParam1Period = null;
      this.keyParam1StartValue = null;
      this.keyParam1StopValue = null;
      this.keyParam1Type = null;
    }

    if (variableId.equals(this.keyParam2Id)) {
      this.keyParam2Id = null;
      this.keyParam2Period = null;
      this.keyParam2StartValue = null;
      this.keyParam2StopValue = null;
      this.keyParam2Type = null;
    }

    if (variableId.equals(this.keyParam3Id)) {
      this.keyParam3Id = null;
      this.keyParam3Period = null;
      this.keyParam3StartValue = null;
      this.keyParam3StopValue = null;
      this.keyParam3Type = null;
    }

    if (variableId.equals(this.keyParam4Id)) {
      this.keyParam4Id = null;
      this.keyParam4Period = null;
      this.keyParam4StartValue = null;
      this.keyParam4StopValue = null;
      this.keyParam4Type = null;
    }
  }
}
