package app.valuationcontrol.multimodule.library.helpers;

import java.util.List;

public abstract class EntityDTOConverter {
  private EntityDTOConverter() {}

  public static <T, M extends DataTransformer<T>> T asData(M model) {
    return model.asData();
  }

  public static <T, M extends DataTransformer<T>> List<T> asData(List<M> listOfDataTransformers) {
    return listOfDataTransformers.stream().map(DataTransformer::asData).toList();
  }
}
