package app.valuationcontrol.multimodule.library.helpers;

import app.valuationcontrol.multimodule.library.entities.LogEntry;
import app.valuationcontrol.multimodule.library.entities.Sensitivity;
import jakarta.persistence.PostPersist;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.messaging.simp.SimpMessagingTemplate;
import org.springframework.stereotype.Component;

@Component
public class LogEntryNotifier {
  private final SimpMessagingTemplate websocket;

  @Autowired
  public LogEntryNotifier(@Lazy SimpMessagingTemplate websocket) {
    this.websocket = websocket;
  }

  @PostPersist
  void onPostPersist(LogEntry logEntry) {
    Integer periodBefore = logEntry.getPeriod();
    try {
      logEntry.setPeriod(
          Sensitivity.asModelYear(periodBefore, logEntry.getAttachedModel().getStartYear()));

      websocket.convertAndSend(
          "/topic/changelog/" + logEntry.getAttachedModel().getId(), logEntry.asData());
    } finally {
      logEntry.setPeriod(periodBefore);
    }
  }
}
