package app.valuationcontrol.multimodule.library.helpers;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import java.io.IOException;
import java.text.ParseException;
import lombok.extern.log4j.Log4j2;

@Log4j2
public class PercentageFloatDeserializer extends JsonDeserializer<Float> {

  @Override
  public Float deserialize(JsonParser jsonParser, DeserializationContext deserializationContext)
      throws IOException {
    final JsonNode treeNode = jsonParser.readValueAsTree();

    if (treeNode.asText().contains("%")) {
      try {
        return MyCustomFloatEditor.PERCENT_INSTANCE.parse(treeNode.asText()).floatValue();
      } catch (ParseException e) {
        log.debug(e);
      }
    }

    if (treeNode.asText().isEmpty()) {
      return null;
    }

    return Float.valueOf(treeNode.asText());
  }
}
