/*
 * Decompiled with CFR 0.152.
 */
package app.valuationcontrol.multimodule.library.entities;

import app.valuationcontrol.multimodule.library.entities.Model;
import app.valuationcontrol.multimodule.library.helpers.DataTransformer;
import app.valuationcontrol.multimodule.library.helpers.LogEntryNotifier;
import app.valuationcontrol.multimodule.library.records.LogEntryData;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.EntityListeners;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.ManyToOne;
import java.time.LocalDateTime;

@Entity
@EntityListeners(value={LogEntryNotifier.class})
public class LogEntry
implements DataTransformer<LogEntryData> {
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    private long id;
    @ManyToOne
    private Model attachedModel;
    private String action;
    private String username;
    private Boolean isModelChange;
    @Column(length=500)
    private String fromFormula;
    @Column(length=500)
    private String toFormula;
    private Float fromValue;
    private Float toValue;
    private LocalDateTime changeDate;
    private Integer period;
    private Long variableId;

    public LogEntry() {
    }

    @Override
    public LogEntryData asData() {
        return new LogEntryData(this.id, this.action, this.username, this.isModelChange, this.fromFormula, this.toFormula, this.fromValue, this.toValue, this.changeDate, this.period, this.variableId);
    }

    public static LogEntryBuilder builder() {
        return new LogEntryBuilder();
    }

    public LogEntry(long id, Model attachedModel, String action, String username, Boolean isModelChange, String fromFormula, String toFormula, Float fromValue, Float toValue, LocalDateTime changeDate, Integer period, Long variableId) {
        this.id = id;
        this.attachedModel = attachedModel;
        this.action = action;
        this.username = username;
        this.isModelChange = isModelChange;
        this.fromFormula = fromFormula;
        this.toFormula = toFormula;
        this.fromValue = fromValue;
        this.toValue = toValue;
        this.changeDate = changeDate;
        this.period = period;
        this.variableId = variableId;
    }

    public long getId() {
        return this.id;
    }

    public Model getAttachedModel() {
        return this.attachedModel;
    }

    public String getAction() {
        return this.action;
    }

    public String getUsername() {
        return this.username;
    }

    public Boolean getIsModelChange() {
        return this.isModelChange;
    }

    public String getFromFormula() {
        return this.fromFormula;
    }

    public String getToFormula() {
        return this.toFormula;
    }

    public Float getFromValue() {
        return this.fromValue;
    }

    public Float getToValue() {
        return this.toValue;
    }

    public LocalDateTime getChangeDate() {
        return this.changeDate;
    }

    public Integer getPeriod() {
        return this.period;
    }

    public Long getVariableId() {
        return this.variableId;
    }

    public void setId(long id) {
        this.id = id;
    }

    public void setAttachedModel(Model attachedModel) {
        this.attachedModel = attachedModel;
    }

    public void setAction(String action) {
        this.action = action;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public void setIsModelChange(Boolean isModelChange) {
        this.isModelChange = isModelChange;
    }

    public void setFromFormula(String fromFormula) {
        this.fromFormula = fromFormula;
    }

    public void setToFormula(String toFormula) {
        this.toFormula = toFormula;
    }

    public void setFromValue(Float fromValue) {
        this.fromValue = fromValue;
    }

    public void setToValue(Float toValue) {
        this.toValue = toValue;
    }

    public void setChangeDate(LocalDateTime changeDate) {
        this.changeDate = changeDate;
    }

    public void setPeriod(Integer period) {
        this.period = period;
    }

    public void setVariableId(Long variableId) {
        this.variableId = variableId;
    }

    public static class LogEntryBuilder {
        private long id;
        private Model attachedModel;
        private String action;
        private String username;
        private Boolean isModelChange;
        private String fromFormula;
        private String toFormula;
        private Float fromValue;
        private Float toValue;
        private LocalDateTime changeDate;
        private Integer period;
        private Long variableId;

        LogEntryBuilder() {
        }

        public LogEntryBuilder id(long id) {
            this.id = id;
            return this;
        }

        public LogEntryBuilder attachedModel(Model attachedModel) {
            this.attachedModel = attachedModel;
            return this;
        }

        public LogEntryBuilder action(String action) {
            this.action = action;
            return this;
        }

        public LogEntryBuilder username(String username) {
            this.username = username;
            return this;
        }

        public LogEntryBuilder isModelChange(Boolean isModelChange) {
            this.isModelChange = isModelChange;
            return this;
        }

        public LogEntryBuilder fromFormula(String fromFormula) {
            this.fromFormula = fromFormula;
            return this;
        }

        public LogEntryBuilder toFormula(String toFormula) {
            this.toFormula = toFormula;
            return this;
        }

        public LogEntryBuilder fromValue(Float fromValue) {
            this.fromValue = fromValue;
            return this;
        }

        public LogEntryBuilder toValue(Float toValue) {
            this.toValue = toValue;
            return this;
        }

        public LogEntryBuilder changeDate(LocalDateTime changeDate) {
            this.changeDate = changeDate;
            return this;
        }

        public LogEntryBuilder period(Integer period) {
            this.period = period;
            return this;
        }

        public LogEntryBuilder variableId(Long variableId) {
            this.variableId = variableId;
            return this;
        }

        public LogEntry build() {
            return new LogEntry(this.id, this.attachedModel, this.action, this.username, this.isModelChange, this.fromFormula, this.toFormula, this.fromValue, this.toValue, this.changeDate, this.period, this.variableId);
        }

        public String toString() {
            return "LogEntry.LogEntryBuilder(id=" + this.id + ", attachedModel=" + String.valueOf(this.attachedModel) + ", action=" + this.action + ", username=" + this.username + ", isModelChange=" + this.isModelChange + ", fromFormula=" + this.fromFormula + ", toFormula=" + this.toFormula + ", fromValue=" + this.fromValue + ", toValue=" + this.toValue + ", changeDate=" + String.valueOf(this.changeDate) + ", period=" + this.period + ", variableId=" + this.variableId + ")";
        }
    }
}

