/*
 * Decompiled with CFR 0.152.
 */
package app.valuationcontrol.multimodule.library.entities;

import app.valuationcontrol.multimodule.library.entities.Segment;
import app.valuationcontrol.multimodule.library.entities.Variable;
import app.valuationcontrol.multimodule.library.helpers.DataTransformer;
import app.valuationcontrol.multimodule.library.helpers.ModelProvider;
import app.valuationcontrol.multimodule.library.records.VariableValueData;
import jakarta.persistence.Entity;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.Table;
import jakarta.persistence.UniqueConstraint;
import java.time.LocalDateTime;

@Entity
@Table(uniqueConstraints={@UniqueConstraint(columnNames={"attached_variable_id", "period", "attached_segment_id", "scenarioNumber"})})
public class VariableValue
implements DataTransformer<VariableValueData>,
ModelProvider {
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    private long id;
    private Integer period;
    private Float value;
    private LocalDateTime lastChanged;
    private Integer scenarioNumber;
    private String editor;
    private String sourceFile;
    @ManyToOne
    private Variable attachedVariable;
    @ManyToOne
    private Segment attachedSegment;

    public VariableValue() {
    }

    public VariableValue(VariableValueData variableData, Variable variable) {
        this.period = variableData.period();
        this.value = variableData.value();
        this.lastChanged = LocalDateTime.now();
        this.scenarioNumber = variableData.scenarioNumber() != null ? variableData.scenarioNumber() : 0;
        this.attachedVariable = variable;
        this.editor = variableData.user();
        this.sourceFile = variableData.sourceFile();
    }

    private Long getAttachedSegmentId() {
        if (this.attachedSegment != null) {
            return this.attachedSegment.getId();
        }
        return null;
    }

    @Override
    public VariableValueData asData() {
        return new VariableValueData(this.id, this.period, this.value, this.lastChanged, this.scenarioNumber, this.getAttachedSegmentId(), this.getAttachedVariable().getId(), this.editor, this.sourceFile);
    }

    @Override
    public Long getModelId() {
        return this.getAttachedVariable().getModelId();
    }

    public long getId() {
        return this.id;
    }

    public Integer getPeriod() {
        return this.period;
    }

    public Float getValue() {
        return this.value;
    }

    public LocalDateTime getLastChanged() {
        return this.lastChanged;
    }

    public Integer getScenarioNumber() {
        return this.scenarioNumber;
    }

    public String getEditor() {
        return this.editor;
    }

    public String getSourceFile() {
        return this.sourceFile;
    }

    public Variable getAttachedVariable() {
        return this.attachedVariable;
    }

    public Segment getAttachedSegment() {
        return this.attachedSegment;
    }

    public void setPeriod(Integer period) {
        this.period = period;
    }

    public void setValue(Float value) {
        this.value = value;
    }

    public void setLastChanged(LocalDateTime lastChanged) {
        this.lastChanged = lastChanged;
    }

    public void setScenarioNumber(Integer scenarioNumber) {
        this.scenarioNumber = scenarioNumber;
    }

    public void setEditor(String editor) {
        this.editor = editor;
    }

    public void setSourceFile(String sourceFile) {
        this.sourceFile = sourceFile;
    }

    public void setAttachedVariable(Variable attachedVariable) {
        this.attachedVariable = attachedVariable;
    }

    public void setAttachedSegment(Segment attachedSegment) {
        this.attachedSegment = attachedSegment;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof VariableValue)) {
            return false;
        }
        VariableValue other = (VariableValue)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getId() != other.getId()) {
            return false;
        }
        Integer this$period = this.getPeriod();
        Integer other$period = other.getPeriod();
        if (this$period == null ? other$period != null : !((Object)this$period).equals(other$period)) {
            return false;
        }
        Float this$value = this.getValue();
        Float other$value = other.getValue();
        if (this$value == null ? other$value != null : !((Object)this$value).equals(other$value)) {
            return false;
        }
        Integer this$scenarioNumber = this.getScenarioNumber();
        Integer other$scenarioNumber = other.getScenarioNumber();
        if (this$scenarioNumber == null ? other$scenarioNumber != null : !((Object)this$scenarioNumber).equals(other$scenarioNumber)) {
            return false;
        }
        LocalDateTime this$lastChanged = this.getLastChanged();
        LocalDateTime other$lastChanged = other.getLastChanged();
        if (this$lastChanged == null ? other$lastChanged != null : !((Object)this$lastChanged).equals(other$lastChanged)) {
            return false;
        }
        String this$editor = this.getEditor();
        String other$editor = other.getEditor();
        if (this$editor == null ? other$editor != null : !this$editor.equals(other$editor)) {
            return false;
        }
        String this$sourceFile = this.getSourceFile();
        String other$sourceFile = other.getSourceFile();
        if (this$sourceFile == null ? other$sourceFile != null : !this$sourceFile.equals(other$sourceFile)) {
            return false;
        }
        Variable this$attachedVariable = this.getAttachedVariable();
        Variable other$attachedVariable = other.getAttachedVariable();
        if (this$attachedVariable == null ? other$attachedVariable != null : !((Object)this$attachedVariable).equals(other$attachedVariable)) {
            return false;
        }
        Segment this$attachedSegment = this.getAttachedSegment();
        Segment other$attachedSegment = other.getAttachedSegment();
        return !(this$attachedSegment == null ? other$attachedSegment != null : !this$attachedSegment.equals(other$attachedSegment));
    }

    protected boolean canEqual(Object other) {
        return other instanceof VariableValue;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $id = this.getId();
        result = result * 59 + (int)($id >>> 32 ^ $id);
        Integer $period = this.getPeriod();
        result = result * 59 + ($period == null ? 43 : ((Object)$period).hashCode());
        Float $value = this.getValue();
        result = result * 59 + ($value == null ? 43 : ((Object)$value).hashCode());
        Integer $scenarioNumber = this.getScenarioNumber();
        result = result * 59 + ($scenarioNumber == null ? 43 : ((Object)$scenarioNumber).hashCode());
        LocalDateTime $lastChanged = this.getLastChanged();
        result = result * 59 + ($lastChanged == null ? 43 : ((Object)$lastChanged).hashCode());
        String $editor = this.getEditor();
        result = result * 59 + ($editor == null ? 43 : $editor.hashCode());
        String $sourceFile = this.getSourceFile();
        result = result * 59 + ($sourceFile == null ? 43 : $sourceFile.hashCode());
        Variable $attachedVariable = this.getAttachedVariable();
        result = result * 59 + ($attachedVariable == null ? 43 : ((Object)$attachedVariable).hashCode());
        Segment $attachedSegment = this.getAttachedSegment();
        result = result * 59 + ($attachedSegment == null ? 43 : $attachedSegment.hashCode());
        return result;
    }

    public String toString() {
        return "VariableValue(id=" + this.getId() + ", period=" + this.getPeriod() + ", value=" + this.getValue() + ", lastChanged=" + String.valueOf(this.getLastChanged()) + ", scenarioNumber=" + this.getScenarioNumber() + ", editor=" + this.getEditor() + ", sourceFile=" + this.getSourceFile() + ", attachedVariable=" + String.valueOf(this.getAttachedVariable()) + ", attachedSegment=" + String.valueOf(this.getAttachedSegment()) + ")";
    }
}

