/*
 * Decompiled with CFR 0.152.
 */
package app.valuationcontrol.multimodule.library.helpers;

import app.valuationcontrol.multimodule.library.constraints.EvenBrackets;
import jakarta.validation.ConstraintValidator;
import jakarta.validation.ConstraintValidatorContext;
import jakarta.validation.constraints.NotNull;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class BracketsValidatorImpl
implements ConstraintValidator<EvenBrackets, String> {
    private static final Pattern LEFT_BRACKET = Pattern.compile("\\[");
    private static final Pattern RIGHT_BRACKET = Pattern.compile("\\]");

    public boolean isValid(String value, ConstraintValidatorContext context) {
        if (value == null) {
            return false;
        }
        return BracketsValidatorImpl.count(value, LEFT_BRACKET) == BracketsValidatorImpl.count(value, RIGHT_BRACKET);
    }

    static int count(@NotNull String value, Pattern pattern) {
        int occurrences = 0;
        Matcher matcher = pattern.matcher(value);
        while (matcher.find()) {
            ++occurrences;
        }
        return occurrences;
    }
}

