/*
 * Decompiled with CFR 0.152.
 */
package app.valuationcontrol.multimodule.library.powerpoint;

import app.valuationcontrol.multimodule.library.entities.Model;
import app.valuationcontrol.multimodule.library.entities.ModelGraph;
import app.valuationcontrol.multimodule.library.entities.Segment;
import app.valuationcontrol.multimodule.library.entities.SensitivityResult;
import app.valuationcontrol.multimodule.library.entities.Variable;
import app.valuationcontrol.multimodule.library.entities.VariableValue;
import app.valuationcontrol.multimodule.library.helpers.exceptions.ResourceException;
import app.valuationcontrol.multimodule.library.helpers.openai.OpenAIHelperFunctions;
import app.valuationcontrol.multimodule.library.helpers.openai.OpenAiServiceImplementation;
import app.valuationcontrol.multimodule.library.records.CalculationData;
import app.valuationcontrol.multimodule.library.records.ScenarioComparison;
import app.valuationcontrol.multimodule.library.records.SensitivityData;
import app.valuationcontrol.multimodule.library.records.VariableData;
import app.valuationcontrol.multimodule.library.xlhandler.SCENARIO;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.theokanning.openai.completion.chat.ChatMessage;
import com.theokanning.openai.completion.chat.ChatMessageRole;
import java.awt.Color;
import java.awt.Rectangle;
import java.awt.geom.Rectangle2D;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.poi.sl.usermodel.TableCell;
import org.apache.poi.sl.usermodel.TextParagraph;
import org.apache.poi.sl.usermodel.TextShape;
import org.apache.poi.sl.usermodel.VerticalAlignment;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.xddf.usermodel.XDDFLineProperties;
import org.apache.poi.xddf.usermodel.XDDFShapeProperties;
import org.apache.poi.xddf.usermodel.chart.AxisCrossBetween;
import org.apache.poi.xddf.usermodel.chart.AxisCrosses;
import org.apache.poi.xddf.usermodel.chart.AxisPosition;
import org.apache.poi.xddf.usermodel.chart.AxisTickLabelPosition;
import org.apache.poi.xddf.usermodel.chart.BarDirection;
import org.apache.poi.xddf.usermodel.chart.BarGrouping;
import org.apache.poi.xddf.usermodel.chart.ChartTypes;
import org.apache.poi.xddf.usermodel.chart.LegendPosition;
import org.apache.poi.xddf.usermodel.chart.XDDFBarChartData;
import org.apache.poi.xddf.usermodel.chart.XDDFCategoryAxis;
import org.apache.poi.xddf.usermodel.chart.XDDFCategoryDataSource;
import org.apache.poi.xddf.usermodel.chart.XDDFChart;
import org.apache.poi.xddf.usermodel.chart.XDDFChartAxis;
import org.apache.poi.xddf.usermodel.chart.XDDFChartData;
import org.apache.poi.xddf.usermodel.chart.XDDFChartLegend;
import org.apache.poi.xddf.usermodel.chart.XDDFDataSource;
import org.apache.poi.xddf.usermodel.chart.XDDFDataSourcesFactory;
import org.apache.poi.xddf.usermodel.chart.XDDFLineChartData;
import org.apache.poi.xddf.usermodel.chart.XDDFNumericalDataSource;
import org.apache.poi.xddf.usermodel.chart.XDDFValueAxis;
import org.apache.poi.xddf.usermodel.text.TextContainer;
import org.apache.poi.xddf.usermodel.text.XDDFTextBody;
import org.apache.poi.xslf.usermodel.XMLSlideShow;
import org.apache.poi.xslf.usermodel.XSLFChart;
import org.apache.poi.xslf.usermodel.XSLFSlide;
import org.apache.poi.xslf.usermodel.XSLFSlideLayout;
import org.apache.poi.xslf.usermodel.XSLFSlideMaster;
import org.apache.poi.xslf.usermodel.XSLFTable;
import org.apache.poi.xslf.usermodel.XSLFTableCell;
import org.apache.poi.xslf.usermodel.XSLFTableRow;
import org.apache.poi.xslf.usermodel.XSLFTextParagraph;
import org.apache.poi.xslf.usermodel.XSLFTextRun;
import org.apache.poi.xslf.usermodel.XSLFTextShape;
import org.openxmlformats.schemas.drawingml.x2006.chart.CTDLbls;
import org.openxmlformats.schemas.drawingml.x2006.chart.CTDispBlanksAs;
import org.openxmlformats.schemas.drawingml.x2006.chart.CTValAx;
import org.openxmlformats.schemas.drawingml.x2006.chart.STDLblPos;
import org.openxmlformats.schemas.drawingml.x2006.chart.STDispBlanksAs;
import org.springframework.http.HttpStatus;
import org.testcontainers.shaded.org.apache.commons.lang3.ArrayUtils;

public class PresentationManager {
    private static final Logger log = LogManager.getLogger(PresentationManager.class);
    XMLSlideShow slideShow;
    Model model;
    CalculationData calculationData;
    OpenAiServiceImplementation openAiServiceImplementation;
    final Double FONT_SIZE = 8.0;
    final Double FULL_WIDTH = 640.0;
    final Double FIRST_COLUMN = 120.0;

    public PresentationManager(Model model, CalculationData calculationData, OpenAiServiceImplementation openAiServiceImplementation) throws IOException {
        InputStream templateFile = this.getClass().getClassLoader().getResourceAsStream("VC_Template.pptx");
        if (templateFile != null) {
            log.debug("Found template");
            this.slideShow = new XMLSlideShow(templateFile);
        } else {
            log.debug("Didn't find template");
            this.slideShow = new XMLSlideShow();
        }
        this.model = model;
        this.calculationData = calculationData;
        this.openAiServiceImplementation = openAiServiceImplementation;
        XSLFSlideMaster slideMaster = (XSLFSlideMaster)this.slideShow.getSlideMasters().get(0);
        XSLFSlideLayout titleLayout = slideMaster.getLayout("TITLE_SLIDE");
        XSLFSlide slide = this.slideShow.createSlide(titleLayout);
        slide.getPlaceholder(0).setText("Valuation report for " + this.model.getCompany() + " - " + this.model.getStartYear());
        titleLayout = slideMaster.getLayout("DISCLAIMER_SLIDE");
        slide = this.slideShow.createSlide(titleLayout);
        String templateText = "[Valuer] has been engaged by [SHORT_NAME]('[SHORT_NAME]', 'the Company') to conduct a valuation of the company. This report can only be used by [SHORT_NAME] and cannot be shared further without our written consent.\nValuation is a subjective exercise and may result in different outcomes under different assumptions. This report is based on our own choices, and when we specify a value, it is to be considered as a midpoint in a range. Estimates and forecasts are our own and not those of the company, and they should not be used in any context other than in this report.\nThe financial statements of [SHORT_NAME] for 2023 have not been audited, and we have assumed that, in all material respects, they represent a good starting point for a valuation. We have reflected this in our discount rate. [Valuer] is not responsible for the financial statements of [SHORT_NAME] and has not conducted a due diligence on them.\n";
        slide.getPlaceholder(0).setText("Disclaimer");
        slide.getPlaceholder(1).setText(templateText);
    }

    public void writeToByteArray(ByteArrayOutputStream byteArrayOutputStream) throws IOException {
        this.slideShow.write((OutputStream)byteArrayOutputStream);
    }

    private int addVariableToChart(HashMap<String, XDDFChartData> dataHashMap, XDDFChart chart, VariableData variableData, String graphType, XDDFCategoryAxis bottomAxis, XDDFValueAxis valueAxis, XDDFCategoryDataSource categoryData, int colOffset, boolean useSegment, boolean includeHistorical) {
        if (variableData != null) {
            XDDFChartData data;
            int nbOfSeries = 1;
            if (variableData.modelledAtSegment() && !useSegment) {
                nbOfSeries = 1 + this.model.getSegments().size();
            }
            boolean ignoreTotal = false;
            if (dataHashMap.containsKey(graphType.toLowerCase())) {
                data = dataHashMap.get(graphType.toLowerCase());
            } else {
                if (graphType.equals("line")) {
                    data = chart.createData(ChartTypes.LINE, (XDDFChartAxis)bottomAxis, valueAxis);
                } else {
                    data = chart.createData(ChartTypes.BAR, (XDDFChartAxis)bottomAxis, valueAxis);
                    ((XDDFBarChartData)data).setBarDirection(BarDirection.COL);
                    ((XDDFBarChartData)data).setGapWidth(Integer.valueOf(50));
                    if (nbOfSeries == 1) {
                        ((XDDFBarChartData)data).setBarGrouping(BarGrouping.CLUSTERED);
                    } else {
                        ((XDDFBarChartData)data).setBarGrouping(BarGrouping.STACKED);
                        ((XDDFBarChartData)data).setOverlap(Byte.valueOf((byte)100));
                    }
                }
                data.setVaryColors(Boolean.valueOf(false));
                dataHashMap.put(graphType.toLowerCase(), data);
            }
            int startAt = 0;
            if (nbOfSeries > 1 && graphType.equalsIgnoreCase("bar")) {
                startAt = 1;
            }
            for (int i = startAt; i < nbOfSeries; ++i) {
                Object[] allValues;
                if (!useSegment) {
                    Double[] historicalValues;
                    int j;
                    Double[] projectionValues;
                    if (variableData.projectionValues() != null) {
                        projectionValues = new Double[this.model.getNbProjectionPeriod().intValue()];
                        for (j = 0; j < variableData.projectionValues().get(i).length; ++j) {
                            try {
                                projectionValues[j] = Double.parseDouble(String.valueOf(variableData.projectionValues().get(i)[j]));
                                continue;
                            }
                            catch (Exception e) {
                                projectionValues[j] = null;
                            }
                        }
                    } else {
                        projectionValues = new Double[]{};
                    }
                    if (includeHistorical && variableData.historicalValues() != null) {
                        historicalValues = new Double[this.model.getNbHistoricalPeriod().intValue()];
                        for (j = 0; j < variableData.historicalValues().get(i).length; ++j) {
                            try {
                                historicalValues[j] = Double.parseDouble(String.valueOf(variableData.historicalValues().get(i)[j]));
                                continue;
                            }
                            catch (Exception e) {
                                historicalValues[j] = null;
                            }
                        }
                    } else {
                        historicalValues = new Double[]{};
                    }
                    allValues = Arrays.copyOf(historicalValues, projectionValues.length + historicalValues.length);
                    System.arraycopy(projectionValues, 0, allValues, historicalValues.length, projectionValues.length);
                } else if (useSegment) {
                    try {
                        allValues = (Double[])Arrays.copyOf(variableData.singleOrConstantValue().toArray(), this.model.getSegments().size() + 1, Double[].class);
                    }
                    catch (ArrayStoreException e) {
                        allValues = new Double[this.model.getSegments().size() + 1];
                        Arrays.fill(allValues, (Object)0.0);
                    }
                } else {
                    throw new ResourceException(HttpStatus.INTERNAL_SERVER_ERROR, "Graph data is not valid for " + variableData.variableName());
                }
                String valuesDataRange = chart.formatRange(new CellRangeAddress(1, allValues.length, colOffset, colOffset));
                XDDFNumericalDataSource valueData = XDDFDataSourcesFactory.fromArray((Number[])allValues, (String)valuesDataRange, (int)colOffset);
                XDDFChartData.Series series = data.addSeries((XDDFDataSource)categoryData, valueData);
                String segmentName = i == 0 ? "Total" : this.model.getSegments().get(i - 1).getSegmentName();
                String title = nbOfSeries > 1 ? variableData.variableName() + " " + segmentName : variableData.variableName();
                series.setTitle(title, chart.setSheetTitle(title, colOffset));
                ++colOffset;
                if (graphType.equals("bar")) {
                    ((XDDFBarChartData.Series)series).setInvertIfNegative(false);
                    continue;
                }
                try {
                    XDDFShapeProperties shapeProperties = Objects.requireNonNullElse(series.getShapeProperties(), new XDDFShapeProperties());
                    XDDFLineProperties lineProperties = new XDDFLineProperties();
                    lineProperties.setWidth(Double.valueOf(1.0));
                    shapeProperties.setLineProperties(lineProperties);
                    series.setShapeProperties(shapeProperties);
                    ((XDDFLineChartData.Series)series).setMarkerSize((short)4);
                    continue;
                }
                catch (Exception e) {
                    log.debug((Object)e);
                }
            }
        }
        return colOffset;
    }

    public void createCharts(boolean includeAIcomments) {
        XSLFSlideMaster slideMaster = (XSLFSlideMaster)this.slideShow.getSlideMasters().get(0);
        XSLFSlideLayout titleLayout = slideMaster.getLayout("FIFTY_FIFTY_DIAGRAM");
        ArrayList<Future<JsonNode>> gptComments = new ArrayList<Future<JsonNode>>();
        boolean allAiRequestsComplete = false;
        if (includeAIcomments) {
            try {
                ExecutorService executorService = Executors.newFixedThreadPool(2);
                for (ModelGraph graph : this.model.getGraphs()) {
                    if (graph.getGraphVariable1Id() <= 0L || !this.model.getVariableWithID(graph.getGraphVariable1Id()).isPresent()) continue;
                    Variable variable = this.model.getVariableWithID(graph.getGraphVariable1Id()).get();
                    Objects.requireNonNull(variable);
                    ObjectNode returnObject = OpenAIHelperFunctions.prepareSingleVariable(this.calculationData, this.model, variable, true);
                    Object prompt = "You are a financial analyst describing a forecast. Do not list values but comment on their overall development. Please describe the financial development of ";
                    if (variable.isModelledAtSegment() && variable.isSingleOrConstantValue()) {
                        prompt = "Comment on the segment composition of ";
                    } else if (variable.isSingleOrConstantValue()) {
                        prompt = "Using segmentValues and values (do not mention word 'segmentValues'), comment on the development of values and segment composition of ";
                    }
                    prompt = (String)prompt + variable.getVariableName();
                    ChatMessage systemMessage = new ChatMessage(ChatMessageRole.SYSTEM.value(), (String)prompt);
                    ChatMessage firstMsg = new ChatMessage(ChatMessageRole.USER.value(), returnObject.toPrettyString());
                    ArrayList<ChatMessage> messages = new ArrayList<ChatMessage>();
                    messages.add(systemMessage);
                    messages.add(firstMsg);
                    Future<JsonNode> request = executorService.submit(() -> OpenAIHelperFunctions.doRequest(this.openAiServiceImplementation, messages, null, null));
                    gptComments.add(request);
                }
                executorService.shutdown();
                allAiRequestsComplete = executorService.awaitTermination(1L, TimeUnit.MINUTES);
            }
            catch (Exception e) {
                throw new ResourceException(HttpStatus.BAD_REQUEST, "Couldn't fetch comments for presentation");
            }
        }
        int index = 0;
        for (ModelGraph graph : this.model.getGraphs()) {
            HashMap<String, XDDFChartData> dataHashMap = new HashMap<String, XDDFChartData>();
            if (graph.getGraphVariable1Id() > 0L || graph.getGraphVariable2Id() > 0L || graph.getGraphVariable3Id() > 0L) {
                XDDFCategoryAxis bottomAxis;
                XDDFValueAxis plotAxis;
                String[] categories;
                boolean useSegment;
                XSLFSlide slide = this.slideShow.createSlide(titleLayout);
                slide.getPlaceholder(0).setText("Graph (" + (index + 1) + "/" + this.model.getGraphs().size() + ")");
                slide.getPlaceholder(1).setText(graph.getGraphName());
                slide.getPlaceholder(2).setText("Description");
                XSLFChart chart = this.slideShow.createChart();
                XDDFChartLegend legend = chart.getOrAddLegend();
                legend.setPosition(LegendPosition.BOTTOM);
                CTDispBlanksAs disp = (CTDispBlanksAs)CTDispBlanksAs.Factory.newInstance();
                disp.setVal(STDispBlanksAs.GAP);
                chart.getCTChart().setDispBlanksAs(disp);
                XDDFTextBody legendTextBody = new XDDFTextBody((TextContainer)legend);
                legendTextBody.getXmlObject().addNewBodyPr();
                legendTextBody.addNewParagraph().addDefaultRunProperties().setFontSize(this.FONT_SIZE);
                legend.setTextBody(legendTextBody);
                XDDFCategoryAxis leftBottomAxis = chart.createCategoryAxis(AxisPosition.BOTTOM);
                XDDFCategoryAxis rightBottomAxis = null;
                XDDFValueAxis leftAxis = chart.createValueAxis(AxisPosition.LEFT);
                XDDFValueAxis rightAxis = null;
                leftBottomAxis.crossAxis((XDDFChartAxis)leftAxis);
                leftBottomAxis.setTickLabelPosition(AxisTickLabelPosition.LOW);
                leftAxis.crossAxis((XDDFChartAxis)leftBottomAxis);
                leftAxis.setCrosses(AxisCrosses.AUTO_ZERO);
                leftAxis.setCrossBetween(AxisCrossBetween.BETWEEN);
                VariableData variableData1 = this.calculationData.getVariables().stream().filter(v -> Objects.equals(v.id(), graph.getGraphVariable1Id())).findFirst().orElse(null);
                VariableData variableData2 = this.calculationData.getVariables().stream().filter(v -> Objects.equals(v.id(), graph.getGraphVariable2Id())).findFirst().orElse(null);
                VariableData variableData3 = this.calculationData.getVariables().stream().filter(v -> Objects.equals(v.id(), graph.getGraphVariable3Id())).findFirst().orElse(null);
                if (graph.useTwoAxis() && variableData1 != null && graph.getGraphVariable1Axis().equalsIgnoreCase("secondary") || variableData2 != null && graph.getGraphVariable2Axis().equalsIgnoreCase("secondary") || variableData3 != null && graph.getGraphVariable3Axis().equalsIgnoreCase("secondary")) {
                    rightAxis = chart.createValueAxis(AxisPosition.RIGHT);
                    rightAxis.setCrosses(AxisCrosses.MAX);
                    rightAxis.setCrossBetween(AxisCrossBetween.BETWEEN);
                    rightBottomAxis = chart.createCategoryAxis(AxisPosition.BOTTOM);
                    rightBottomAxis.setVisible(false);
                    rightBottomAxis.crossAxis((XDDFChartAxis)rightAxis);
                    rightAxis.crossAxis((XDDFChartAxis)rightBottomAxis);
                }
                if (useSegment = graph.useSegmentAxis()) {
                    categories = (String[])ArrayUtils.addAll((Object[])new String[]{"Total"}, (Object[])((String[])this.model.getSegments().stream().map(Segment::getSegmentName).toArray(String[]::new)));
                } else {
                    int startOffset = graph.getGraphIncludeHistoricals() != false ? -this.model.getNbHistoricalPeriod().intValue() : 0;
                    int arraySize = graph.getGraphIncludeHistoricals() != false ? this.model.getNbHistoricalPeriod() + this.model.getNbProjectionPeriod() : this.model.getNbProjectionPeriod();
                    categories = new String[arraySize];
                    for (int i = startOffset; i < this.model.getNbProjectionPeriod(); ++i) {
                        categories[i - startOffset] = Integer.toString(this.model.getStartYear() + i);
                    }
                }
                String categoryDataRange = chart.formatRange(new CellRangeAddress(1, categories.length, 0, 0));
                XDDFCategoryDataSource categoryData = XDDFDataSourcesFactory.fromArray((String[])categories, (String)categoryDataRange, (int)0);
                if (graph.useTwoAxis() && graph.getGraphVariable1Axis().equalsIgnoreCase("secondary") && rightAxis != null) {
                    plotAxis = rightAxis;
                    bottomAxis = rightBottomAxis;
                } else {
                    plotAxis = leftAxis;
                    bottomAxis = leftBottomAxis;
                }
                int colOffset = 1;
                colOffset = this.addVariableToChart(dataHashMap, (XDDFChart)chart, variableData1, graph.getGraphVariable1Type(), bottomAxis, plotAxis, categoryData, colOffset, useSegment, graph.getGraphIncludeHistoricals());
                if (!useSegment) {
                    if (graph.useTwoAxis() && graph.getGraphVariable2Axis().equalsIgnoreCase("secondary") && rightAxis != null) {
                        plotAxis = rightAxis;
                        bottomAxis = rightBottomAxis;
                    } else {
                        plotAxis = leftAxis;
                        bottomAxis = leftBottomAxis;
                    }
                    colOffset = this.addVariableToChart(dataHashMap, (XDDFChart)chart, variableData2, graph.getGraphVariable2Type(), bottomAxis, plotAxis, categoryData, colOffset, false, graph.getGraphIncludeHistoricals());
                    if (graph.useTwoAxis() && graph.getGraphVariable3Axis().equalsIgnoreCase("secondary") && rightAxis != null) {
                        plotAxis = rightAxis;
                        bottomAxis = rightBottomAxis;
                    } else {
                        plotAxis = leftAxis;
                        bottomAxis = leftBottomAxis;
                    }
                    this.addVariableToChart(dataHashMap, (XDDFChart)chart, variableData3, graph.getGraphVariable3Type(), bottomAxis, plotAxis, categoryData, colOffset, false, graph.getGraphIncludeHistoricals());
                }
                dataHashMap.forEach((key, data) -> {
                    data.getCategoryAxis().getOrAddTextProperties().setFontSize(this.FONT_SIZE);
                    data.getValueAxes().forEach(v -> v.getOrAddTextProperties().setFontSize(this.FONT_SIZE));
                    chart.plot(data);
                });
                try {
                    leftAxis.setNumberFormat("#,##0.0;(#,##0.0)");
                    CTValAx valAx = chart.getCTChart().getPlotArea().getValAxArray(0);
                    if (variableData1 != null && variableData1.variableFormat().contains("percent")) {
                        valAx.getNumFmt().setFormatCode("#,##0.0%;(#,##0.0)%");
                        valAx.getNumFmt().setSourceLinked(false);
                    } else {
                        valAx.getNumFmt().setFormatCode("#,##0.0;(#,##0.0)");
                        valAx.getNumFmt().setSourceLinked(false);
                    }
                }
                catch (Exception e) {
                    log.info((Object)e);
                }
                Rectangle chartDimensions = new Rectangle(482600, 1206500, 0x3E0300, 2286000);
                slide.addChart(chart, (Rectangle2D)chartDimensions);
                if (includeAIcomments && allAiRequestsComplete) {
                    XSLFTextShape textShape = slide.getPlaceholder(3);
                    try {
                        JsonNode response = ((JsonNode)((Future)gptComments.get(index)).get()).get("response");
                        textShape.setText(response.asText());
                    }
                    catch (InterruptedException | ExecutionException e) {
                        throw new RuntimeException(e);
                    }
                }
            }
            ++index;
        }
    }

    private VariableData[] getVariableDataArrayFromScenarioComparison(ScenarioComparison comparison, Long variableId) {
        return ((List)comparison.comparisons().stream().filter(c -> !c.isEmpty() && ((VariableData)c.get(0)).id().equals(variableId)).findFirst().orElse(new ArrayList())).toArray(new VariableData[0]);
    }

    public void createComparison(ScenarioComparison comparison, boolean includeAIcomments) {
        XSLFSlideMaster slideMaster = (XSLFSlideMaster)this.slideShow.getSlideMasters().get(0);
        XSLFSlideLayout titleLayout = slideMaster.getLayout("FIFTY_FIFTY_DIAGRAM");
        VariableData[] variable1DataArray = this.getVariableDataArrayFromScenarioComparison(comparison, this.model.getKeyParam().getKeyOutput1Id());
        VariableData[] variable2DataArray = this.getVariableDataArrayFromScenarioComparison(comparison, this.model.getKeyParam().getKeyOutput2Id());
        Hashtable<Integer, VariableData[]> comparisons = new Hashtable<Integer, VariableData[]>();
        if (variable1DataArray.length > 0) {
            comparisons.put(1, variable1DataArray);
        }
        if (variable2DataArray.length > 0) {
            comparisons.put(2, variable2DataArray);
        }
        comparisons.forEach((index, variableDataArray) -> {
            XSLFSlide slide = this.slideShow.createSlide(titleLayout);
            VariableData variableData = variableDataArray[0];
            slide.getPlaceholder(1).setText(variableData.variableName());
            slide.getPlaceholder(2).setText("Comparison of scenarios");
            XSLFChart chart = this.slideShow.createChart();
            XDDFCategoryAxis leftBottomAxis = chart.createCategoryAxis(AxisPosition.BOTTOM);
            XDDFValueAxis leftAxis = chart.createValueAxis(AxisPosition.LEFT);
            leftBottomAxis.crossAxis((XDDFChartAxis)leftAxis);
            leftAxis.crossAxis((XDDFChartAxis)leftBottomAxis);
            leftAxis.setCrosses(AxisCrosses.AUTO_ZERO);
            leftAxis.setCrossBetween(AxisCrossBetween.BETWEEN);
            String[] categories = new String[]{SCENARIO.BASE.name(), SCENARIO.POSITIVE.name(), SCENARIO.NEGATIVE.name(), SCENARIO.SYNERGY.name(), SCENARIO.TEST.name()};
            String categoryDataRange = chart.formatRange(new CellRangeAddress(1, categories.length, 0, 0));
            XDDFCategoryDataSource categoryData = XDDFDataSourcesFactory.fromArray((String[])categories, (String)categoryDataRange, (int)0);
            XDDFChartData data = chart.createData(ChartTypes.BAR, (XDDFChartAxis)leftBottomAxis, leftAxis);
            ((XDDFBarChartData)data).setBarDirection(BarDirection.COL);
            ((XDDFBarChartData)data).setBarGrouping(BarGrouping.CLUSTERED);
            int periodToCheck = index.equals(1) ? this.model.getKeyParam().getKeyOutput1Period() : this.model.getKeyParam().getKeyOutput2Period();
            Number[] values = ArrayUtils.toObject((double[])Arrays.stream(variableDataArray).mapToDouble(vd -> Objects.requireNonNullElse(vd.getValueInPeriod(periodToCheck, 0), 0.0)).toArray());
            String valuesDataRange = chart.formatRange(new CellRangeAddress(1, values.length, 1, 1));
            XDDFNumericalDataSource valueData = XDDFDataSourcesFactory.fromArray((Number[])values, (String)valuesDataRange, (int)1);
            XDDFChartData.Series series = data.addSeries((XDDFDataSource)categoryData, valueData);
            series.setTitle("Comparison 1", chart.setSheetTitle("Comparison 1", 1));
            ((XDDFBarChartData.Series)series).setInvertIfNegative(false);
            series.setShowLeaderLines(true);
            CTDLbls ctdLbls = chart.getCTChart().getPlotArea().getBarChartArray(0).getSerArray(0).getDLbls();
            ctdLbls.addNewDLblPos().setVal(STDLblPos.OUT_END);
            ctdLbls.addNewShowVal().setVal(true);
            ctdLbls.addNewShowLegendKey().setVal(false);
            ctdLbls.addNewShowCatName().setVal(false);
            ctdLbls.addNewShowSerName().setVal(false);
            chart.plot(data);
            Rectangle chartDimensions = new Rectangle(482600, 1206500, 0x3E0300, 2286000);
            slide.addChart(chart, (Rectangle2D)chartDimensions);
            ObjectMapper objectMapper = new ObjectMapper();
            ObjectNode allDifferences = objectMapper.createObjectNode();
            ArrayNode positiveDifference = objectMapper.createArrayNode();
            ArrayNode negativeDifference = objectMapper.createArrayNode();
            ArrayNode synergiesDifference = objectMapper.createArrayNode();
            ArrayNode testDifference = objectMapper.createArrayNode();
            allDifferences.set(SCENARIO.POSITIVE.name(), (JsonNode)positiveDifference);
            allDifferences.set(SCENARIO.NEGATIVE.name(), (JsonNode)negativeDifference);
            allDifferences.set(SCENARIO.SYNERGY.name(), (JsonNode)synergiesDifference);
            allDifferences.set(SCENARIO.TEST.name(), (JsonNode)testDifference);
            List<VariableValue> inputs = this.model.getVariableValuesUsedInScenarios();
            inputs.forEach(variableValue -> {
                try {
                    Variable variable = variableValue.getAttachedVariable();
                    List variableArray = comparison.comparisons().stream().filter(c -> ((VariableData)c.get(0)).id() == variable.getId()).findFirst().get();
                    if (!variableArray.isEmpty()) {
                        boolean checkSingleEntryOnly = variable.isSingleOrConstantValue();
                        for (int i = 1; i < variableArray.size(); ++i) {
                            String segmentName;
                            Integer segmentIndex = variable.isModelledAtSegment() ? 1 + this.model.getSegments().indexOf(variableValue.getAttachedSegment()) : 0;
                            String string = segmentName = variableValue.getAttachedSegment() != null ? variableValue.getAttachedSegment().getSegmentName() : "overall";
                            if (checkSingleEntryOnly) {
                                Objects.requireNonNull(((VariableData)variableArray.get(0)).singleOrConstantValue());
                                Double baseScenarioValue = OpenAIHelperFunctions.getDoubleFromObject(((VariableData)variableArray.get(0)).singleOrConstantValue().get(segmentIndex), ((VariableData)variableArray.get(0)).variableFormat());
                                Double currentScenarioValue = OpenAIHelperFunctions.getDoubleFromObject(((VariableData)variableArray.get(i)).singleOrConstantValue().get(segmentIndex), ((VariableData)variableArray.get(0)).variableFormat());
                                if (baseScenarioValue == null || baseScenarioValue.equals(currentScenarioValue)) continue;
                                ObjectNode differenceNode = objectMapper.createObjectNode();
                                differenceNode.put("Variable", variable.getVariableName());
                                differenceNode.put("Segment", segmentName);
                                differenceNode.put("BaseValue", baseScenarioValue);
                                differenceNode.put("ScenarioValue", currentScenarioValue);
                                ArrayNode scenarioArray = (ArrayNode)allDifferences.get(SCENARIO.from(i).name());
                                scenarioArray.add((JsonNode)differenceNode);
                                continue;
                            }
                            for (int j = 0; j < ((VariableData)variableArray.get(i)).projectionValues().get(segmentIndex).length; ++j) {
                                Double baseScenarioValue = OpenAIHelperFunctions.getDoubleFromObject(((VariableData)variableArray.get(0)).projectionValues().get(segmentIndex)[j], ((VariableData)variableArray.get(0)).variableFormat());
                                Double currentScenarioValue = OpenAIHelperFunctions.getDoubleFromObject(((VariableData)variableArray.get(i)).projectionValues().get(segmentIndex)[j], ((VariableData)variableArray.get(0)).variableFormat());
                                if (baseScenarioValue == null || baseScenarioValue.equals(currentScenarioValue)) continue;
                                ObjectNode differenceNode = objectMapper.createObjectNode();
                                differenceNode.put("Variable", variable.getVariableName());
                                differenceNode.put("Year", this.model.getStartYear() + j);
                                differenceNode.put("Segment", segmentName);
                                differenceNode.put("BaseValue", baseScenarioValue);
                                differenceNode.put("ScenarioValue", currentScenarioValue);
                                ArrayNode scenarioArray = (ArrayNode)allDifferences.get(SCENARIO.from(i).name());
                                scenarioArray.add((JsonNode)differenceNode);
                            }
                        }
                    }
                }
                catch (Exception e) {
                    log.debug((Object)e);
                }
            });
            if (includeAIcomments) {
                String prompt = "Please comment on the differences between the scenarios, do not list variables but comment specifically for each scenario having variations to BaseValue";
                ChatMessage systemMessage = new ChatMessage(ChatMessageRole.SYSTEM.value(), prompt);
                ChatMessage firstMsg = new ChatMessage(ChatMessageRole.USER.value(), allDifferences.toPrettyString());
                ArrayList<ChatMessage> messages = new ArrayList<ChatMessage>();
                messages.add(systemMessage);
                messages.add(firstMsg);
                JsonNode request = OpenAIHelperFunctions.doRequest(this.openAiServiceImplementation, messages, null, null);
                slide.getPlaceholder(3).setText(request.get("response").asText());
            }
        });
    }

    public void addTextToCell(XSLFTableRow row, String text, Double fontSize, TextParagraph.TextAlign textAlign, boolean isTotal, boolean isHeader) {
        XSLFTableCell cell = row.addCell();
        XSLFTextRun textRun = cell.setText(text);
        textRun.setFontSize(fontSize);
        XSLFTextParagraph textParagraph = textRun.getParagraph();
        textParagraph.setTextAlign(textAlign);
        row.setHeight(15.0);
        cell.setBottomInset(1.0);
        cell.setTopInset(1.0);
        cell.setLeftInset(0.0);
        cell.setRightInset(1.0);
        cell.setVerticalAlignment(VerticalAlignment.MIDDLE);
        if (isTotal) {
            cell.setBorderWidth(TableCell.BorderEdge.bottom, 0.5);
            cell.setBorderColor(TableCell.BorderEdge.bottom, Color.black);
            textRun.setBold(true);
        }
        if (isHeader) {
            cell.setFillColor(Color.LIGHT_GRAY);
            textRun.setBold(true);
        }
    }

    public void createTable(Long subAreaId, SCENARIO scenario, String slideTitle) {
        long numberOfVariablesInSubArea = this.calculationData.getVariables().stream().filter(v -> v.variableSubAreaId().equals(subAreaId)).count();
        if (numberOfVariablesInSubArea > 0L) {
            int i;
            XSLFSlideMaster slideMaster = (XSLFSlideMaster)this.slideShow.getSlideMasters().get(0);
            XSLFSlideLayout titleLayout = slideMaster.getLayout("MASTER_SLIDE");
            XSLFSlide slide = this.slideShow.createSlide(titleLayout);
            slide.getPlaceholder(0).setText(slideTitle);
            XSLFTable table = slide.createTable();
            table.setAnchor((Rectangle2D)new Rectangle(38, 98, 100, 600));
            XSLFTableRow firstRow = table.addRow();
            this.addTextToCell(firstRow, "Item", this.FONT_SIZE, TextParagraph.TextAlign.LEFT, false, true);
            this.addTextToCell(firstRow, "Value", this.FONT_SIZE, TextParagraph.TextAlign.RIGHT, false, true);
            for (i = 0; i < this.model.getNbHistoricalPeriod(); ++i) {
                this.addTextToCell(firstRow, String.valueOf(this.model.getStartYear() - this.model.getNbHistoricalPeriod() + i), this.FONT_SIZE, TextParagraph.TextAlign.RIGHT, false, true);
            }
            for (i = 0; i < this.model.getNbProjectionPeriod(); ++i) {
                this.addTextToCell(firstRow, String.valueOf(this.model.getStartYear() + i), this.FONT_SIZE, TextParagraph.TextAlign.RIGHT, false, true);
            }
            this.calculationData.getVariables().stream().filter(v -> v.variableSubAreaId().equals(subAreaId)).forEach(v -> {
                String value;
                int i;
                XSLFTableRow row = table.addRow();
                boolean isTotal = v.variableType().toLowerCase().contains("total");
                this.addTextToCell(row, v.variableName(), this.FONT_SIZE, TextParagraph.TextAlign.LEFT, isTotal, false);
                if (v.isSingleEntry()) {
                    String value2 = null;
                    if (v.singleOrConstantValue() != null) {
                        value2 = !v.singleOrConstantValue().isEmpty() ? OpenAIHelperFunctions.getFormattedValueAsString(v.singleOrConstantValue().get(scenario.ordinal()), v) : null;
                    }
                    this.addTextToCell(row, Objects.requireNonNullElse(value2, " "), this.FONT_SIZE, TextParagraph.TextAlign.RIGHT, isTotal, false);
                } else {
                    this.addTextToCell(row, " ", this.FONT_SIZE, TextParagraph.TextAlign.RIGHT, isTotal, false);
                }
                for (i = 0; i < this.model.getNbHistoricalPeriod(); ++i) {
                    value = null;
                    if (v.historicalValues() != null) {
                        value = !v.historicalValues().isEmpty() ? OpenAIHelperFunctions.getFormattedValueAsString(v.historicalValues().get(scenario.ordinal())[i], v) : null;
                    }
                    this.addTextToCell(row, Objects.requireNonNullElse(value, " "), this.FONT_SIZE, TextParagraph.TextAlign.RIGHT, isTotal, false);
                }
                for (i = 0; i < this.model.getNbProjectionPeriod(); ++i) {
                    value = null;
                    if (v.projectionValues() != null) {
                        value = !v.projectionValues().isEmpty() ? OpenAIHelperFunctions.getFormattedValueAsString(v.projectionValues().get(scenario.ordinal())[i], v) : null;
                    }
                    this.addTextToCell(row, Objects.requireNonNullElse(value, " "), this.FONT_SIZE, TextParagraph.TextAlign.RIGHT, isTotal, false);
                }
            });
            table.setColumnWidth(0, this.FIRST_COLUMN.doubleValue());
            int nbOfColumns = 1 + this.model.getNbHistoricalPeriod() + this.model.getNbProjectionPeriod();
            double columnWidth = (this.FULL_WIDTH - this.FIRST_COLUMN) / (double)nbOfColumns;
            for (int i2 = 1; i2 <= nbOfColumns; ++i2) {
                table.setColumnWidth(i2, columnWidth);
            }
        }
    }

    public void createSensitivities(boolean includeAIcomments) {
        int chunkSize = 2;
        boolean hasSegment = this.calculationData.getSensitivities().stream().reduce(false, (result, s) -> this.model.getVariableWithID(s.measurementVariableId()).orElse(new Variable()).isModelledAtSegment(), Boolean::logicalAnd);
        double numberOfSegments = hasSegment ? (double)this.model.getSegments().size() : 0.0;
        double numberOfChunks = Math.ceil((double)this.calculationData.getSensitivities().size() / (double)chunkSize);
        XSLFSlideMaster slideMaster = (XSLFSlideMaster)this.slideShow.getSlideMasters().get(0);
        XSLFSlideLayout titleLayout = slideMaster.getLayout("FIFTY_FIFTY_SUBTITLE_ONLY");
        int segIndex = 0;
        while ((double)segIndex <= numberOfSegments) {
            XSLFSlide slide = this.slideShow.createSlide(titleLayout);
            String segmentTitle = segIndex > 0 ? " for segment " + this.calculationData.getSegments().get(segIndex - 1).segmentName() : "";
            slide.getPlaceholder(0).setText("Sensitivities (1/" + Double.valueOf(numberOfChunks).intValue() + ")" + segmentTitle);
            for (int i = 0; i < this.calculationData.getSensitivities().size(); ++i) {
                int j;
                if (i > 0 && i % 2 == 0) {
                    double chunkIndex = Math.ceil((double)(i + 1) / 2.0);
                    slide = this.slideShow.createSlide(titleLayout);
                    slide.getPlaceholder(0).setText("Sensitivities (" + Double.valueOf(chunkIndex).intValue() + "/" + Double.valueOf(numberOfChunks).intValue() + ")" + segmentTitle);
                }
                int oneTwoIndex = i % 2 + 1;
                SensitivityData sensitivity = this.calculationData.getSensitivities().get(i);
                SensitivityResult sensitivityResult = this.calculationData.getSensitivityResults().get(i);
                VariableData measurement = this.calculationData.getVariables().stream().filter(v -> v.id().equals(sensitivity.measurementVariableId())).findFirst().orElseThrow(() -> new ResourceException(HttpStatus.INTERNAL_SERVER_ERROR, "Could find sensitivity variable"));
                VariableData variable1 = this.calculationData.getVariables().stream().filter(v -> v.id().equals(sensitivity.variable1Id())).findFirst().orElseThrow(() -> new ResourceException(HttpStatus.INTERNAL_SERVER_ERROR, "Could find sensitivity variable"));
                VariableData variable2 = this.calculationData.getVariables().stream().filter(v -> v.id().equals(sensitivity.variable2Id())).findFirst().orElseThrow(() -> new ResourceException(HttpStatus.INTERNAL_SERVER_ERROR, "Could find sensitivity variable"));
                if (hasSegment && !measurement.modelledAtSegment()) {
                    throw new ResourceException(HttpStatus.INTERNAL_SERVER_ERROR, "Error in the use of segment in sensitivities");
                }
                XSLFTable table = slide.createTable();
                XSLFTableRow row = table.addRow();
                this.addTextToCell(row, "", this.FONT_SIZE, TextParagraph.TextAlign.LEFT, false, true);
                this.addTextToCell(row, "", this.FONT_SIZE, TextParagraph.TextAlign.LEFT, false, true);
                this.addTextToCell(row, variable2.variableName(), this.FONT_SIZE, TextParagraph.TextAlign.CENTER, false, true);
                for (j = 1; j < sensitivityResult.getVariable2Values().length; ++j) {
                    this.addTextToCell(row, "", this.FONT_SIZE, TextParagraph.TextAlign.CENTER, false, true);
                }
                row.mergeCells(2, 2 + sensitivityResult.getVariable2Values().length - 1);
                row = table.addRow();
                this.addTextToCell(row, "", this.FONT_SIZE, TextParagraph.TextAlign.LEFT, false, true);
                this.addTextToCell(row, "", this.FONT_SIZE, TextParagraph.TextAlign.LEFT, false, true);
                for (j = 0; j < sensitivityResult.getVariable2Values().length; ++j) {
                    this.addTextToCell(row, OpenAIHelperFunctions.getFormattedValueAsString(sensitivityResult.getVariable2Values()[j], variable2), this.FONT_SIZE, TextParagraph.TextAlign.RIGHT, false, true);
                }
                for (j = 0; j < sensitivityResult.getVariable1Values().length; ++j) {
                    row = table.addRow();
                    if (j == 0) {
                        this.addTextToCell(row, variable1.variableName(), this.FONT_SIZE, TextParagraph.TextAlign.CENTER, false, true);
                    } else {
                        this.addTextToCell(row, "", this.FONT_SIZE, TextParagraph.TextAlign.CENTER, false, true);
                    }
                    this.addTextToCell(row, OpenAIHelperFunctions.getFormattedValueAsString(sensitivityResult.getVariable1Values()[j], variable1), this.FONT_SIZE, TextParagraph.TextAlign.RIGHT, false, true);
                    for (int k = 0; k < sensitivityResult.getVariable2Values().length; ++k) {
                        String value = OpenAIHelperFunctions.getFormattedValueAsString(sensitivityResult.getMyResultArray()[segIndex][j][k], measurement);
                        this.addTextToCell(row, value, this.FONT_SIZE, TextParagraph.TextAlign.RIGHT, false, false);
                    }
                }
                slide.getPlaceholder(oneTwoIndex).setText(sensitivity.description());
                Rectangle2D anchor = titleLayout.getPlaceholder(oneTwoIndex).getAnchor();
                table.setAnchor((Rectangle2D)new Rectangle((int)anchor.getX(), (int)anchor.getY() + 45, 0, 0));
                table.mergeCells(2, 2 + sensitivityResult.getVariable1Values().length - 1, 0, 0);
                table.getCell(2, 0).setTextDirection(TextShape.TextDirection.VERTICAL_270);
                table.getCell(2, 0).setVerticalAlignment(VerticalAlignment.MIDDLE);
                table.setColumnWidth(0, 30.0);
                table.setColumnWidth(1, 40.0);
                double column_width = 246.0 / (double)sensitivityResult.getVariable2Values().length;
                for (int l = 0; l < sensitivityResult.getVariable2Values().length; ++l) {
                    table.setColumnWidth(2 + l, column_width);
                }
            }
            ++segIndex;
        }
    }

    public void createSummary() {
        XSLFSlideMaster slideMaster = (XSLFSlideMaster)this.slideShow.getSlideMasters().get(0);
        XSLFSlideLayout titleLayout = slideMaster.getLayout("FIFTY_FIFTY_TEXT");
        XSLFSlide slide = this.slideShow.createSlide(titleLayout);
        String templateText = "This report is a valuation report for %s. It is built on a DCF model using a %s years projection period. While the valuation is presented as a single value, it should be read as the mid-point estimate in a range. Refer to sensitivities for more details.";
        Object text = String.format(templateText, this.model.getCompany(), this.model.getNbProjectionPeriod());
        slide.getPlaceholder(0).setText("Disclaimer");
        slide.getPlaceholder(1).setText("Methodology");
        slide.getPlaceholder(2).setText("Key Assumptions");
        slide.getPlaceholder(3).setText((String)text);
        VariableData keyOutputVariable1 = this.calculationData.getVariables().stream().filter(v -> v.id().equals(this.model.getKeyParam().getKeyOutput1Id())).findFirst().orElse(null);
        VariableData keyOutputVariable2 = this.calculationData.getVariables().stream().filter(v -> v.id().equals(this.model.getKeyParam().getKeyOutput2Id())).findFirst().orElse(null);
        VariableData keyParam1Variable = this.calculationData.getVariables().stream().filter(v -> v.id().equals(this.model.getKeyParam().getKeyParam1Id())).findFirst().orElse(null);
        VariableData keyParam2Variable = this.calculationData.getVariables().stream().filter(v -> v.id().equals(this.model.getKeyParam().getKeyParam2Id())).findFirst().orElse(null);
        VariableData keyParam3Variable = this.calculationData.getVariables().stream().filter(v -> v.id().equals(this.model.getKeyParam().getKeyParam3Id())).findFirst().orElse(null);
        VariableData keyParam4Variable = this.calculationData.getVariables().stream().filter(v -> v.id().equals(this.model.getKeyParam().getKeyParam4Id())).findFirst().orElse(null);
        String keyOutputVariable1Value = keyOutputVariable1 != null ? OpenAIHelperFunctions.getFormattedValueAsString(keyOutputVariable1.getValueInPeriod(this.model.getKeyParam().getKeyOutput1Period(), 0), keyOutputVariable1) : "";
        String keyOutputVariable2Value = keyOutputVariable2 != null ? OpenAIHelperFunctions.getFormattedValueAsString(keyOutputVariable2.getValueInPeriod(this.model.getKeyParam().getKeyOutput2Period(), 0), keyOutputVariable2) : "";
        String keyParam1VariableValue = keyParam1Variable != null ? OpenAIHelperFunctions.getFormattedValueAsString(keyParam1Variable.getValueInPeriod(this.model.getKeyParam().getKeyParam1Period(), 0), keyParam1Variable) : "";
        String keyParam2VariableValue = keyParam2Variable != null ? OpenAIHelperFunctions.getFormattedValueAsString(keyParam2Variable.getValueInPeriod(this.model.getKeyParam().getKeyParam2Period(), 0), keyParam2Variable) : "";
        String keyParam3VariableValue = keyParam3Variable != null ? OpenAIHelperFunctions.getFormattedValueAsString(keyParam3Variable.getValueInPeriod(this.model.getKeyParam().getKeyParam3Period(), 0), keyParam3Variable) : "";
        String keyParam4VariableValue = keyParam4Variable != null ? OpenAIHelperFunctions.getFormattedValueAsString(keyParam4Variable.getValueInPeriod(this.model.getKeyParam().getKeyParam4Period(), 0), keyParam4Variable) : "";
        XSLFTextParagraph textParagraph = (XSLFTextParagraph)slide.getPlaceholder(4).getTextParagraphs().get(0);
        XSLFTextRun textRun = textParagraph.addNewTextRun();
        text = "The key outputs of the model are:";
        textRun.setText((String)text);
        textParagraph = slide.getPlaceholder(4).addNewTextParagraph();
        textParagraph.setBullet(true);
        textParagraph.setIndent(Double.valueOf(1.0));
        text = (String)(keyOutputVariable1 != null ? keyOutputVariable1.variableName() + " : " + keyOutputVariable1Value + "\n " : "") + (String)(keyOutputVariable2 != null ? keyOutputVariable2.variableName() + " : " + keyOutputVariable2Value : "");
        textRun = textParagraph.addNewTextRun();
        textRun.setText((String)text);
        textParagraph = slide.getPlaceholder(4).addNewTextParagraph();
        textRun = textParagraph.addNewTextRun();
        textRun.setText("\n\nThe main value drivers for these values are: ");
        textParagraph = slide.getPlaceholder(4).addNewTextParagraph();
        textParagraph.setBullet(true);
        textParagraph.setIndent(Double.valueOf(1.0));
        text = (String)(keyParam1Variable != null ? keyParam1Variable.variableName() + " : " + keyParam1VariableValue + "\n " : "") + (String)(keyParam2Variable != null ? keyParam2Variable.variableName() + " : " + keyParam2VariableValue + "\n " : "") + (String)(keyParam3Variable != null ? keyParam3Variable.variableName() + " : " + keyParam3VariableValue + "\n " : "") + (String)(keyParam4Variable != null ? keyParam4Variable.variableName() + " : " + keyParam4VariableValue : "");
        textRun = textParagraph.addNewTextRun();
        textRun.setText((String)text);
    }

    public XMLSlideShow getSlideShow() {
        return this.slideShow;
    }

    public Model getModel() {
        return this.model;
    }

    public CalculationData getCalculationData() {
        return this.calculationData;
    }

    public OpenAiServiceImplementation getOpenAiServiceImplementation() {
        return this.openAiServiceImplementation;
    }

    public Double getFONT_SIZE() {
        return this.FONT_SIZE;
    }

    public Double getFULL_WIDTH() {
        return this.FULL_WIDTH;
    }

    public Double getFIRST_COLUMN() {
        return this.FIRST_COLUMN;
    }
}

