/*
 * Decompiled with CFR 0.152.
 */
package app.valuationcontrol.multimodule.library.records;

import app.valuationcontrol.multimodule.library.constraints.EvenBrackets;
import app.valuationcontrol.multimodule.library.constraints.EvenParenthesis;
import app.valuationcontrol.multimodule.library.entities.Variable;
import app.valuationcontrol.multimodule.library.helpers.openai.OpenAIHelperFunctions;
import app.valuationcontrol.multimodule.library.records.VariableValueData;
import jakarta.validation.constraints.NotEmpty;
import jakarta.validation.constraints.Pattern;
import java.util.List;

public record VariableData(Long id, @NotEmpty @Pattern(regexp="^(?:[A-z]|[0-9]|[ ]|[%])*") @NotEmpty @Pattern(regexp="^(?:[A-z]|[0-9]|[ ]|[%])*") String variableName, String variableDescription, Long variableAreaId, Long variableSubAreaId, @EvenParenthesis @EvenBrackets String variableFormula, @NotEmpty @Pattern(regexp="input|calc|constant|check|single_result|kpi|sub_total_row|total_row", flags={Pattern.Flag.CASE_INSENSITIVE}) @NotEmpty @Pattern(regexp="input|calc|constant|check|single_result|kpi|sub_total_row|total_row", flags={Pattern.Flag.CASE_INSENSITIVE}) String variableType, Integer row, Integer variableOrder, Integer variableDepth, boolean variableApplyToHistoricals, @NotEmpty @Pattern(regexp="decimal|integer|percent|date", flags={Pattern.Flag.CASE_INSENSITIVE}) @NotEmpty @Pattern(regexp="decimal|integer|percent|date", flags={Pattern.Flag.CASE_INSENSITIVE}) String variableFormat, List<VariableValueData> variableValues, List<Long> variableDependencies, String evaluatedVariableFormula, Long originalId, String evaluatedXLformula, List<Object[]> historicalValues, List<Object[]> projectionValues, boolean modelledAtSegment, List<Object> singleOrConstantValue, List<Object> yearToDateValue, List<Object> yearToGoValue) {
    public boolean isSingleEntry() {
        return Variable.CONSTANT_OR_SINGLE.contains(this.variableType);
    }

    public Double getValueInPeriod(Integer period, Integer segmentIndex) {
        if (this.isSingleEntry() && !this.singleOrConstantValue.isEmpty()) {
            return OpenAIHelperFunctions.getDoubleFromObject(this.singleOrConstantValue.get(segmentIndex), this.variableFormat);
        }
        if (period >= 0 && !this.projectionValues().isEmpty() && this.projectionValues().get(segmentIndex) != null) {
            return OpenAIHelperFunctions.getDoubleFromObject(this.projectionValues.get(segmentIndex)[period], this.variableFormat);
        }
        if (period < 0 && !this.historicalValues().isEmpty() && this.historicalValues().get(segmentIndex) != null) {
            return OpenAIHelperFunctions.getDoubleFromObject(this.historicalValues.get(segmentIndex)[period], this.variableFormat);
        }
        return null;
    }
}

