/*
 * Decompiled with CFR 0.152.
 */
package app.valuationcontrol.multimodule.library.xlhandler;

import app.valuationcontrol.multimodule.library.entities.Area;
import app.valuationcontrol.multimodule.library.entities.Model;
import app.valuationcontrol.multimodule.library.entities.Sensitivity;
import app.valuationcontrol.multimodule.library.entities.SensitivityResult;
import app.valuationcontrol.multimodule.library.entities.SubArea;
import app.valuationcontrol.multimodule.library.entities.Variable;
import app.valuationcontrol.multimodule.library.entities.VariableValue;
import app.valuationcontrol.multimodule.library.helpers.CellError;
import app.valuationcontrol.multimodule.library.helpers.DataPeriod;
import app.valuationcontrol.multimodule.library.records.CalculationData;
import app.valuationcontrol.multimodule.library.xlhandler.CalcDocument;
import app.valuationcontrol.multimodule.library.xlhandler.CellValueHelper;
import app.valuationcontrol.multimodule.library.xlhandler.GenericSheet;
import app.valuationcontrol.multimodule.library.xlhandler.POICalcDocument;
import app.valuationcontrol.multimodule.library.xlhandler.POISheet;
import app.valuationcontrol.multimodule.library.xlhandler.SCENARIO;
import app.valuationcontrol.multimodule.library.xlhandler.ScenarioDataProvider;
import app.valuationcontrol.multimodule.library.xlhandler.SensitivityRunner;
import app.valuationcontrol.multimodule.library.xlhandler.VariableEvaluator;
import java.io.InputStream;
import java.text.MessageFormat;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;

public class XLInstance
implements ScenarioDataProvider {
    private static final Logger log = LogManager.getLogger(XLInstance.class);
    public static final String INPUT = "input";
    public static final String PERCENT = "percent";
    public static final int YTD_PERIOD = -500;
    private final CalcDocument calcDocument;
    private Model attachedModel;
    private final Map<Long, List<CellError>> formulaErrors = new ConcurrentHashMap<Long, List<CellError>>();
    private final Map<SCENARIO, Map<Long, List<CellError>>> variableCellErrorsByScenario = new ConcurrentHashMap<SCENARIO, Map<Long, List<CellError>>>();
    private final Map<SCENARIO, Object[][]> cacheValues = new ConcurrentHashMap<SCENARIO, Object[][]>();
    private List<SensitivityResult> sensitivityResults = new ArrayList<SensitivityResult>();
    private final AtomicLong lastUsed = new AtomicLong();

    public XLInstance(Model attachedModel, CalcDocument calcDocument, boolean preloadModel) {
        this.attachedModel = attachedModel;
        this.calcDocument = calcDocument;
        this.lastUsed.set(System.currentTimeMillis());
        if (preloadModel) {
            this.reloadWholeBaseContentIfNoCache();
        }
    }

    @Override
    public InputStream saveAs() {
        this.createPrettyContent();
        return this.calcDocument.saveAs();
    }

    @Override
    public void reloadAndUpdateClients() {
        log.debug("Entering reloadAndUpdateClients " + String.valueOf(this.calcDocument));
        this.reloadWholeBaseContentIfNoCache();
        log.debug("Exiting reloadAndUpdateClients" + String.valueOf(this.calcDocument));
    }

    public void setSingleValue(VariableValue variableValue) {
        if (variableValue != null && variableValue.getValue() != null) {
            this.calcDocument.getSheet(SCENARIO.from(variableValue.getScenarioNumber())).setCellValues(CellValueHelper.cellValueOf(variableValue));
        }
    }

    @Override
    public void runSensitivities(List<Sensitivity> sensitivities, SCENARIO scenario) {
        this.calcDocument.assertConnected(() -> {
            log.debug("CacheValues: Force Reloading base");
            this.cacheValues.clear();
            this.reloadWholeBaseContentIfNoCache();
        });
        SensitivityRunner sensitivityRunner = new SensitivityRunner(this.calcDocument, sensitivities, scenario, this.attachedModel);
        this.sensitivityResults = sensitivityRunner.runSensitivities();
    }

    public void updateCacheValues(SCENARIO scenario) {
        if (this.attachedModel.getVariables().isEmpty()) {
            return;
        }
        log.debug("Entering updateCacheValues" + String.valueOf(this.calcDocument));
        try {
            this.lastUsed.set(System.currentTimeMillis());
            long millis = System.currentTimeMillis();
            if (!scenario.equals((Object)SCENARIO.BASE) && this.cacheValues.get((Object)SCENARIO.BASE) == null) {
                this.reloadWholeBaseContentIfNoCache();
            }
            this.calcDocument.assertConnected(() -> {
                log.debug("CacheValues: Force Reloading base");
                this.cacheValues.clear();
                this.reloadWholeBaseContentIfNoCache();
            });
            log.debug("CacheValues: Opening sheet in cacheValues " + String.valueOf((Object)scenario));
            GenericSheet scenarioGenericSheet = this.calcDocument.getSheet(scenario);
            this.setScenarioVariableValues(scenario, scenarioGenericSheet, null);
            Object[][] xlObject = scenarioGenericSheet.getValues(this.attachedModel.indexOfLastColumn(), this.attachedModel.getNumberOfVariables() - 1);
            this.cacheValues.put(scenario, xlObject);
            log.debug("CacheContent for scenario {} was defined in {}", (Object)scenario, (Object)(System.currentTimeMillis() - millis + "ms"));
            log.debug("Exiting updateCacheValues" + String.valueOf(this.calcDocument));
        }
        catch (Exception e) {
            log.error("Couldn't get content " + String.valueOf(e));
        }
    }

    @Override
    public synchronized CalculationData getContent(SCENARIO scenario) {
        log.debug("Entering getContent" + String.valueOf(this.calcDocument));
        this.lastUsed.set(System.currentTimeMillis());
        long millis = System.currentTimeMillis();
        try {
            if (this.attachedModel.getVariables().isEmpty()) {
                return new CalculationData(this.attachedModel, new ArrayList<SensitivityResult>(), new HashMap<Long, List<CellError>>(), new HashMap<Long, List<CellError>>(), scenario.ordinal());
            }
            if (this.cacheValues.get((Object)scenario) == null) {
                log.debug("updating cacheValues in getContent");
                this.updateCacheValues(scenario);
            }
            Object[][] xlObject = this.cacheValues.get((Object)scenario);
            log.debug("CacheValues is of size" + xlObject.length);
            for (Variable variable : this.attachedModel.getVariables()) {
                int row = variable.getRow();
                if (variable.isSingleOrConstantValue()) {
                    ArrayList<Object> singleOrConstantValues = new ArrayList<Object>();
                    singleOrConstantValues.add(xlObject[row][this.attachedModel.getConstantColumn()]);
                    if (variable.isModelledAtSegment()) {
                        for (int i = 1; i <= this.attachedModel.getSegments().size(); ++i) {
                            column = variable.columnOfSegmentAndPeriod(i - 1, (Integer)0);
                            singleOrConstantValues.add(xlObject[row][column]);
                        }
                    }
                    variable.setSingleOrConstantValue(singleOrConstantValues);
                } else {
                    ArrayList<Object[]> historicalValues = new ArrayList<Object[]>();
                    ArrayList<Object[]> projectionValues = new ArrayList<Object[]>();
                    if (this.attachedModel.isIncludeYTD()) {
                        column = variable.columnOfSegmentAndPeriod(-1, this.attachedModel.getNbProjectionPeriod());
                        variable.getYearToDateValue().add(xlObject[row][column]);
                        variable.getYearToGoValue().add(xlObject[row][column + 1]);
                    }
                    historicalValues.add(Arrays.copyOfRange(xlObject[row], variable.columnOfSegmentAndPeriod(-1, (Integer)(-this.attachedModel.getNbHistoricalPeriod().intValue())), variable.columnOfSegmentAndPeriod(-1, (Integer)0)));
                    projectionValues.add(Arrays.copyOfRange(xlObject[row], variable.columnOfSegmentAndPeriod(-1, (Integer)0), variable.columnOfSegmentAndPeriod(-1, this.attachedModel.getNbProjectionPeriod())));
                    if (variable.isModelledAtSegment()) {
                        for (int i = 0; i < this.attachedModel.getSegments().size(); ++i) {
                            if (this.attachedModel.isIncludeYTD()) {
                                int column = variable.columnOfSegmentAndPeriod(i, this.attachedModel.getNbProjectionPeriod());
                                variable.getYearToDateValue().add(xlObject[row][column]);
                                variable.getYearToGoValue().add(xlObject[row][column + 1]);
                            }
                            int historicalStart = variable.columnOfSegmentAndPeriod(i, (Integer)(-this.attachedModel.getNbHistoricalPeriod().intValue()));
                            int historicalEnd = variable.columnOfSegmentAndPeriod(i, (Integer)0);
                            historicalValues.add(Arrays.copyOfRange(xlObject[row], historicalStart, historicalEnd));
                            int projectionStart = variable.columnOfSegmentAndPeriod(i, (Integer)0);
                            int projectionEnd = variable.columnOfSegmentAndPeriod(i, this.attachedModel.getNbProjectionPeriod());
                            projectionValues.add(Arrays.copyOfRange(xlObject[row], projectionStart, projectionEnd));
                        }
                    }
                    variable.setHistoricalValues(historicalValues);
                    variable.setProjectionValues(projectionValues);
                }
                this.getCellErrors(variable, scenario);
            }
            CalculationData returnObject = new CalculationData(this.attachedModel, this.getSensitivityResults(), this.formulaErrors, this.variableCellErrorsByScenario.get((Object)scenario), scenario.ordinal());
            log.debug("Content for scenario {} was fetched in {}", (Object)scenario, (Object)(System.currentTimeMillis() - millis + "ms"));
            this.lastUsed.set(System.currentTimeMillis());
            log.debug("Exiting getContent" + String.valueOf(this.calcDocument));
            return returnObject;
        }
        catch (Exception e) {
            log.error("Couldn't get content " + String.valueOf(e));
            return null;
        }
    }

    private void setScenarioVariableValues(SCENARIO scenario, GenericSheet scenarioGenericSheet, Area filterArea) {
        List cellValues = this.attachedModel.getVariables().stream().flatMap(variable -> variable.getVariableValuesForAScenario(scenario).stream().filter(v -> v.getValue() != null).filter(v -> filterArea == null || v.getAttachedVariable().getVariableArea().equals(filterArea)).filter(v -> v.getAttachedVariable().getAttachedModel().isIncludeYTD() || !Objects.requireNonNullElse(v.getPeriod(), 0).equals(-500)).map(CellValueHelper::cellValueOf)).toList();
        if (!cellValues.isEmpty()) {
            scenarioGenericSheet.setCellValues(cellValues.toArray(new GenericSheet.CellValue[0]));
        }
    }

    public String[] generateVariableArray(Variable variable) {
        String[] dumpArrayRow = new String[variable.getAttachedModel().getArraySize().intValue()];
        this.formulaErrors.remove(variable.getId());
        this.initVariableRow(dumpArrayRow, variable);
        boolean segmentExists = this.checkSegmentsExist(variable);
        if (variable.isSingleOrConstantValue()) {
            this.performSingleEntryReplication(variable, dumpArrayRow);
            String summaryFormula = "=";
            if (segmentExists && !variable.getVariableFormat().equals("date")) {
                String divider = variable.getVariableFormat().equals(PERCENT) ? String.valueOf(Math.max(1, this.attachedModel.getSegments().size())) : "1";
                for (int j = 0; j < this.attachedModel.getSegments().size(); ++j) {
                    DataPeriod dataPeriod = new DataPeriod(this.attachedModel, 1, j + 1, variable.isConstant());
                    summaryFormula = MessageFormat.format("{0}+{1}/{2}", summaryFormula, CellValueHelper.generateAddress(variable, dataPeriod), divider);
                }
                dumpArrayRow[variable.getPrimaryColumn()] = summaryFormula;
            }
        } else {
            boolean performHistoricalReplication = this.shouldReplicateHistorical(variable);
            if (performHistoricalReplication) {
                this.performHistoricalReplication(variable, dumpArrayRow, segmentExists);
            }
            this.performForecastReplication(variable, dumpArrayRow, segmentExists);
            if (this.attachedModel.isIncludeYTD()) {
                this.performYTDReplication(variable, dumpArrayRow, segmentExists);
            }
            if (segmentExists && !variable.getVariableFormat().equals("date") && !variable.getVariableType().equals(INPUT)) {
                int start = -this.getAttachedModel().getNbHistoricalPeriod().intValue();
                int stop = this.getAttachedModel().getNbProjectionPeriod();
                for (int i = start; i < stop; ++i) {
                    String summaryFormula = "=";
                    if (variable.isPercentOrKPI()) {
                        DataPeriod segmentConstantPeriod = new DataPeriod(this.getAttachedModel(), i, 0, variable.isSingleOrConstantValue());
                        summaryFormula = VariableEvaluator.evaluateVariable(variable, segmentConstantPeriod, this.formulaErrors);
                    } else {
                        for (int j = 0; j < this.attachedModel.getSegments().size(); ++j) {
                            DataPeriod dataPeriod = new DataPeriod(this.attachedModel, i, j + 1, variable.isConstant());
                            summaryFormula = MessageFormat.format("{0}+{1}", summaryFormula, CellValueHelper.generateAddress(variable, dataPeriod));
                        }
                    }
                    dumpArrayRow[variable.getPrimaryColumn() + i] = summaryFormula;
                }
                if (variable.getVariableFormat().equals(PERCENT)) {
                    variable.getVariableDependencies().stream().filter(variable1 -> variable1.getVariableType().equals(INPUT)).forEach(variable2 -> {
                        CellError e = new CellError(0, "Dependency to input", "You should change the formula to avoid the use of input variables (" + variable2.getVariableName() + " ) in an aggregated segment value");
                        this.formulaErrors.computeIfAbsent(variable.getId(), l -> new ArrayList()).add(e);
                    });
                }
            }
        }
        return dumpArrayRow;
    }

    private void performSingleEntryReplication(Variable variable, String[] dumpArrayRow) {
        if (variable.isSingleOrConstantValue()) {
            if (variable.isModelledAtSegment() && this.attachedModel.getSegments() != null && !this.attachedModel.getSegments().isEmpty()) {
                for (int i = 1; i <= this.attachedModel.getSegments().size(); ++i) {
                    DataPeriod segmentConstantPeriod = new DataPeriod(this.getAttachedModel(), 0, i, variable.isSingleOrConstantValue());
                    int cellColumn = variable.columnOfSegmentAndPeriod(i - 1, (Integer)0);
                    dumpArrayRow[cellColumn] = VariableEvaluator.evaluateVariable(variable, segmentConstantPeriod, this.formulaErrors);
                }
            } else {
                DataPeriod dataPeriod = new DataPeriod(this.getAttachedModel(), 0, 0, variable.isSingleOrConstantValue());
                dumpArrayRow[variable.columnOfSegmentAndPeriod((int)-1, (Integer)Integer.valueOf((int)0))] = VariableEvaluator.evaluateVariable(variable, dataPeriod, this.formulaErrors);
            }
        }
    }

    private void performYTDReplication(Variable variable, String[] dumpArrayRow, boolean segmentReplicationShouldBePerformed) {
        int YearToDatePeriod = this.attachedModel.getNbProjectionPeriod();
        int YearToGoPeriod = YearToDatePeriod + 1;
        if (segmentReplicationShouldBePerformed) {
            for (int segmentIndex = 0; segmentIndex < this.attachedModel.getSegments().size(); ++segmentIndex) {
                Object ytgFormula;
                String ytdFormula = null;
                if (variable.isPercentOrKPI() || variable.isTypeTotal()) {
                    DataPeriod YTDdataPeriod = new DataPeriod(this.attachedModel, YearToDatePeriod, segmentIndex + 1, variable.isSingleOrConstantValue());
                    DataPeriod YTGdataPeriod = new DataPeriod(this.attachedModel, YearToGoPeriod, segmentIndex + 1, variable.isSingleOrConstantValue());
                    ytdFormula = VariableEvaluator.evaluateVariable(variable, YTDdataPeriod, this.formulaErrors);
                    ytgFormula = VariableEvaluator.evaluateVariable(variable, YTGdataPeriod, this.formulaErrors);
                } else {
                    DataPeriod dataPeriod1 = new DataPeriod(this.attachedModel, 0, segmentIndex + 1, variable.isConstant());
                    DataPeriod dataPeriod2 = new DataPeriod(this.attachedModel, YearToGoPeriod - 1, segmentIndex + 1, variable.isConstant());
                    ytgFormula = "=" + MessageFormat.format("{0}-{1}", CellValueHelper.generateAddress(variable, dataPeriod1), CellValueHelper.generateAddress(variable, dataPeriod2));
                }
                if (ytdFormula != null) {
                    dumpArrayRow[variable.columnOfSegmentAndPeriod((int)segmentIndex, (Integer)Integer.valueOf((int)YearToDatePeriod))] = ytdFormula;
                }
                dumpArrayRow[variable.columnOfSegmentAndPeriod((int)segmentIndex, (Integer)Integer.valueOf((int)YearToGoPeriod))] = ytgFormula;
            }
        } else {
            Object ytgFormula;
            String ytdFormula = null;
            if (variable.isPercentOrKPI() || variable.isTypeTotal()) {
                DataPeriod YTDdataPeriod = new DataPeriod(this.getAttachedModel(), YearToDatePeriod, 0, variable.isSingleOrConstantValue());
                DataPeriod YTGdataPeriod = new DataPeriod(this.getAttachedModel(), YearToGoPeriod, 0, variable.isSingleOrConstantValue());
                ytdFormula = VariableEvaluator.evaluateVariable(variable, YTDdataPeriod, this.formulaErrors);
                ytgFormula = VariableEvaluator.evaluateVariable(variable, YTGdataPeriod, this.formulaErrors);
            } else {
                DataPeriod dataPeriod1 = new DataPeriod(this.attachedModel, 0, 0, variable.isConstant());
                DataPeriod dataPeriod2 = new DataPeriod(this.attachedModel, YearToGoPeriod - 1, 0, variable.isConstant());
                ytgFormula = "=" + MessageFormat.format("{0}-{1}", CellValueHelper.generateAddress(variable, dataPeriod1), CellValueHelper.generateAddress(variable, dataPeriod2));
            }
            if (ytdFormula != null) {
                dumpArrayRow[variable.columnOfSegmentAndPeriod((int)-1, (Integer)Integer.valueOf((int)YearToDatePeriod))] = ytdFormula;
            }
            dumpArrayRow[variable.columnOfSegmentAndPeriod((int)-1, (Integer)Integer.valueOf((int)YearToGoPeriod))] = ytgFormula;
        }
    }

    private void performForecastReplication(Variable variable, String[] dumpArrayRow, boolean segmentReplicationShouldBePerformed) {
        for (int period = 0; period < this.getAttachedModel().getNbProjectionPeriod(); ++period) {
            if (segmentReplicationShouldBePerformed) {
                for (int segmentIndex = 0; segmentIndex < this.attachedModel.getSegments().size(); ++segmentIndex) {
                    DataPeriod dataPeriod = new DataPeriod(this.getAttachedModel(), period, segmentIndex + 1, variable.isSingleOrConstantValue());
                    dumpArrayRow[variable.columnOfSegmentAndPeriod((int)segmentIndex, (Integer)Integer.valueOf((int)period))] = VariableEvaluator.evaluateVariable(variable, dataPeriod, this.formulaErrors);
                }
                continue;
            }
            DataPeriod dataPeriod = new DataPeriod(this.getAttachedModel(), period, 0, variable.isSingleOrConstantValue());
            dumpArrayRow[variable.columnOfSegmentAndPeriod((int)-1, (Integer)Integer.valueOf((int)period))] = VariableEvaluator.evaluateVariable(variable, dataPeriod, this.formulaErrors);
        }
    }

    private void performHistoricalReplication(Variable variable, String[] dumpArrayRow, boolean segmentReplicationShouldBePerformed) {
        for (int period = -this.getAttachedModel().getNbHistoricalPeriod().intValue(); period < 0; ++period) {
            if (segmentReplicationShouldBePerformed) {
                for (int segmentIndex = 0; segmentIndex < this.attachedModel.getSegments().size(); ++segmentIndex) {
                    DataPeriod dataPeriod = new DataPeriod(this.getAttachedModel(), period, segmentIndex + 1, variable.isSingleOrConstantValue());
                    int column = variable.columnOfSegmentAndPeriod(segmentIndex, (Integer)period);
                    dumpArrayRow[column] = VariableEvaluator.evaluateVariable(variable, dataPeriod, this.formulaErrors);
                }
                continue;
            }
            DataPeriod dataPeriod = new DataPeriod(this.getAttachedModel(), period, 0, variable.isSingleOrConstantValue());
            dumpArrayRow[variable.columnOfSegmentAndPeriod((int)-1, (Integer)Integer.valueOf((int)period))] = VariableEvaluator.evaluateVariable(variable, dataPeriod, this.formulaErrors);
        }
    }

    private void initVariableRow(String[] dumpArrayRow, Variable variable) {
        if (this.attachedModel.getColBeforeDataStart() > 1) {
            dumpArrayRow[0] = String.valueOf(variable.getId());
        }
        if (this.attachedModel.getColBeforeDataStart() > 2) {
            dumpArrayRow[1] = variable.getVariableName();
        }
        if (this.attachedModel.getColBeforeDataStart() > 3) {
            dumpArrayRow[2] = variable.getVariableFormula();
        }
        if (this.attachedModel.getColBeforeDataStart() > 4) {
            dumpArrayRow[3] = variable.getVariableType();
        }
        if (this.attachedModel.getColBeforeDataStart() > 5) {
            dumpArrayRow[4] = String.valueOf(variable.getVariableArea().getId());
        }
        if (this.attachedModel.getColBeforeDataStart() > 6) {
            dumpArrayRow[5] = String.valueOf(variable.getVariableSubArea().getId());
        }
        if (this.attachedModel.getColBeforeDataStart() > 7) {
            dumpArrayRow[6] = variable.getVariableFormat();
        }
        if (this.attachedModel.getColBeforeDataStart() > 8) {
            dumpArrayRow[7] = String.valueOf(variable.getVariableOrder());
        }
        if (this.attachedModel.getColBeforeDataStart() > 9) {
            dumpArrayRow[8] = String.valueOf(variable.getVariableDepth());
        }
    }

    private void createHeader(String[] dumpArrayRow, Area area) {
        if (this.attachedModel.getColBeforeDataStart() > 1) {
            dumpArrayRow[0] = "VariableID";
        }
        if (this.attachedModel.getColBeforeDataStart() > 2) {
            dumpArrayRow[1] = "Name";
        }
        if (this.attachedModel.getColBeforeDataStart() > 3) {
            dumpArrayRow[2] = "Formula";
        }
        if (this.attachedModel.getColBeforeDataStart() > 4) {
            dumpArrayRow[3] = "Variable type";
        }
        if (this.attachedModel.getColBeforeDataStart() > 5) {
            dumpArrayRow[4] = "AreaID";
        }
        if (this.attachedModel.getColBeforeDataStart() > 6) {
            dumpArrayRow[5] = "SubAreaID";
        }
        if (this.attachedModel.getColBeforeDataStart() > 7) {
            dumpArrayRow[6] = "Format";
        }
        if (this.attachedModel.getColBeforeDataStart() > 8) {
            dumpArrayRow[7] = "Order";
        }
        if (this.attachedModel.getColBeforeDataStart() > 9) {
            dumpArrayRow[8] = "Detail level";
        }
        dumpArrayRow[this.attachedModel.getConstantColumn()] = "Value";
        for (int i = -this.attachedModel.getNbHistoricalPeriod().intValue(); i < this.attachedModel.getNbProjectionPeriod(); ++i) {
            int arrayIndex = this.attachedModel.getColBeforeDataStart() + i + this.attachedModel.getNbHistoricalPeriod();
            dumpArrayRow[arrayIndex] = String.valueOf(this.attachedModel.getStartYear() + i);
        }
    }

    private boolean shouldReplicateHistorical(Variable myVariable) {
        return this.getAttachedModel().getNbHistoricalPeriod() > 0 && (myVariable.isVariableApplyToHistoricals() || myVariable.getVariableType().contains("total") || myVariable.getVariableType().contains("kpi"));
    }

    private boolean checkSegmentsExist(Variable myVariable) {
        return myVariable.isModelledAtSegment() && !this.attachedModel.getSegments().isEmpty();
    }

    public synchronized void cleanAndUpdateAdditionalSheets() {
        log.debug("Entering cleanAndUpdateAdditionalSheets" + String.valueOf(this.calcDocument));
        this.calcDocument.closeAllButBase();
        log.debug("Exiting cleanAndUpdateAdditionalSheets" + String.valueOf(this.calcDocument));
    }

    @Override
    public void refreshValue(Variable myVariable, VariableValue myVariableValue) {
        long millis = System.currentTimeMillis();
        this.calcDocument.preventScreenUpdating(true);
        this.calcDocument.assertConnected(() -> {
            log.debug("refreshValue: Force Reloading base");
            this.cacheValues.clear();
            this.reloadWholeBaseContentIfNoCache();
        });
        if (Objects.equals(myVariableValue.getScenarioNumber(), SCENARIO.BASE.ordinal())) {
            this.reloadVariableAndUpdateCache(myVariable);
        } else {
            this.cacheValues.remove((Object)SCENARIO.from(myVariableValue.getScenarioNumber()));
            this.setSingleValue(myVariableValue);
        }
        this.calcDocument.preventScreenUpdating(false);
        log.debug("Model was refreshed in : " + (System.currentTimeMillis() - millis) + "ms");
    }

    @Override
    public void reloadVariableAndUpdateCache(Variable variable) {
        log.debug("Entering reloadVariableAndUpdateCache " + String.valueOf(this.calcDocument));
        this.calcDocument.assertConnected(() -> {
            log.debug("reloadVariableAndUpdateCache: Force Reloading base");
            this.cacheValues.clear();
            this.reloadWholeBaseContentIfNoCache();
        });
        int arraySize = variable.getAttachedModel().getArraySize();
        String[][] dumpArray = new String[1][arraySize];
        for (int j = 0; j < arraySize; ++j) {
            dumpArray[0][j] = "";
        }
        this.calcDocument.preventScreenUpdating(true);
        dumpArray[0] = this.generateVariableArray(variable);
        GenericSheet baseGenericSheet = this.calcDocument.getSheet(SCENARIO.BASE);
        baseGenericSheet.setRowValues(variable.getRow(), dumpArray[0]);
        this.cacheValues.clear();
        this.updateCacheValues(SCENARIO.BASE);
        this.cleanAndUpdateAdditionalSheets();
        this.calcDocument.preventScreenUpdating(false);
        log.debug("Exiting reloadVariableAndUpdateCache " + String.valueOf(this.calcDocument));
    }

    public void reloadWholeBaseContentIfNoCache() {
        log.debug("Entering reloadWholeBaseContentIfNoCache " + String.valueOf(this.calcDocument));
        if (this.cacheValues.get((Object)SCENARIO.BASE) == null) {
            int numberOfVariables = this.getAttachedModel().getNumberOfVariables();
            long millis = System.currentTimeMillis();
            if (numberOfVariables > 0) {
                int arraySize = this.getAttachedModel().getArraySize();
                String[][] dumpArray = new String[numberOfVariables][arraySize];
                this.calcDocument.preventScreenUpdating(true);
                this.calcDocument.closeAllSheets();
                this.formulaErrors.clear();
                long before = System.currentTimeMillis();
                for (Variable myVariable : this.attachedModel.getVariables()) {
                    dumpArray[myVariable.getRow()] = this.generateVariableArray(myVariable);
                }
                log.debug("Logic was loaded in : " + (System.currentTimeMillis() - before) + "ms");
                GenericSheet baseGenericSheet = this.calcDocument.getSheet(SCENARIO.BASE);
                baseGenericSheet.setValue(dumpArray, Math.max(arraySize - 1, 0), Math.max(this.attachedModel.getNumberOfVariables() - 1, 0));
                this.setScenarioVariableValues(SCENARIO.BASE, baseGenericSheet, null);
                this.updateCacheValues(SCENARIO.BASE);
                this.calcDocument.preventScreenUpdating(false);
                log.debug("Model was refreshed and cached in : " + (System.currentTimeMillis() - millis) + "ms");
            } else {
                log.debug("No variables so model was not reloaded");
            }
        }
    }

    public void createPrettyContent() {
        this.attachedModel.setUseAreaAddress(true);
        this.attachedModel.getAreas().forEach(area -> {
            GenericSheet prettySheet = this.calcDocument.createPrettySheet(area.getAreaName());
            List<Variable> areaVariables = this.attachedModel.getVariables().stream().filter(v -> area.equals(v.getVariableArea())).toList();
            int numberOfVariables = areaVariables.size() + 1 + area.getSubAreas().size() * 2;
            int arraySize = this.getAttachedModel().getArraySize();
            if (numberOfVariables > 0) {
                String[][] dumpArray = new String[numberOfVariables][arraySize];
                for (SubArea subArea : area.getSubAreas()) {
                    List<Variable> subAreaVariables = this.attachedModel.getVariables().stream().filter(v -> subArea.equals(v.getVariableSubArea())).toList();
                    int variableIndex = 0;
                    for (Variable myVariable : subAreaVariables) {
                        int currentRow = myVariable.getRow();
                        if (variableIndex == 0) {
                            dumpArray[currentRow - 1][0] = subArea.getSubAreaName();
                        }
                        ++variableIndex;
                        dumpArray[currentRow] = this.generateVariableArray(myVariable);
                        this.attachedModel.getAreaStringHashMap().forEach((searchArea, randomString) -> {
                            for (int i = 0; i < dumpArray[currentRow].length; ++i) {
                                dumpArray[currentRow][i] = Objects.nonNull(dumpArray[currentRow][i]) ? dumpArray[currentRow][i].replace((CharSequence)randomString, searchArea.getAreaName()) : null;
                            }
                        });
                    }
                }
                this.createHeader(dumpArray[0], (Area)area);
                prettySheet.setValue(dumpArray, Math.max(arraySize - 1, 0), Math.max(numberOfVariables - 1, 0));
                this.setScenarioVariableValues(SCENARIO.BASE, prettySheet, (Area)area);
                for (Variable variable : areaVariables) {
                    for (int i = 0; i < arraySize; ++i) {
                        boolean isValue = variable.isSingleOrConstantValue() ? i == this.attachedModel.getConstantColumn() : i >= this.attachedModel.getColBeforeDataStart();
                        XSSFCellStyle style = ((POICalcDocument)this.calcDocument).getStyle(variable.getVariableType(), variable.getVariableFormat(), isValue);
                        ((POISheet)prettySheet).formatCell(i, variable.getRow(), style);
                    }
                }
                for (int i = 0; i < arraySize; ++i) {
                    boolean isValue = false;
                    XSSFCellStyle style = ((POICalcDocument)this.calcDocument).getStyle("header", null, isValue);
                    ((POISheet)prettySheet).formatCell(i, 0, style);
                }
            }
        });
        this.attachedModel.setUseAreaAddress(false);
    }

    private void getCellErrors(Variable myVariable, SCENARIO scenario) {
        GenericSheet genericSheet = this.calcDocument.getSheet(scenario);
        ArrayList<CellError> cellErrors = new ArrayList<CellError>();
        this.variableCellErrorsByScenario.computeIfAbsent(scenario, i -> new ConcurrentHashMap()).put(myVariable.getId(), cellErrors);
        int historicalPeriods = myVariable.isSingleOrConstantValue() ? 0 : this.attachedModel.getNbHistoricalPeriod();
        int startIndex = myVariable.getPrimaryColumn() - historicalPeriods;
        int periodIndex = -historicalPeriods;
        int i2 = startIndex;
        while (i2 < myVariable.getAttachedModel().getArraySize()) {
            try {
                String error = genericSheet.getErrorInCell(i2, myVariable.getRow());
                if (error != null) {
                    CellError e = new CellError(periodIndex, "CalculationError", error);
                    cellErrors.add(e);
                }
            }
            catch (Exception e) {
                log.debug((Object)e);
            }
            ++i2;
            ++periodIndex;
        }
    }

    public void setAttachedModel(Model attachedModel) {
        this.attachedModel = attachedModel;
    }

    @Override
    public boolean isUnusedFor(Duration inactivityThreshold) {
        return System.currentTimeMillis() - inactivityThreshold.toMillis() > this.lastUsed.get();
    }

    @Override
    public void sleep() {
        this.calcDocument.close();
    }

    @Override
    public void clearCacheAndReloadAndUpdateClients() {
        this.cacheValues.clear();
        this.reloadAndUpdateClients();
    }

    public Model getAttachedModel() {
        return this.attachedModel;
    }

    @Override
    public List<SensitivityResult> getSensitivityResults() {
        return this.sensitivityResults;
    }
}

