package app.valuationcontrol.multimodule.library.constraints;

import static java.lang.annotation.ElementType.FIELD;
import static java.lang.annotation.RetentionPolicy.RUNTIME;

import app.valuationcontrol.multimodule.library.helpers.BracketsValidatorImpl;
import jakarta.validation.Constraint;
import jakarta.validation.Payload;
import java.lang.annotation.Documented;
import java.lang.annotation.Retention;
import java.lang.annotation.Target;

@SuppressWarnings("unused")
@Target({FIELD})
@Retention(RUNTIME)
@Constraint(validatedBy = BracketsValidatorImpl.class)
@Documented
public @interface EvenBrackets {

  String message() default "formula.contains.odd.number.of.brackets";

  Class<?>[] groups() default {};

  Class<? extends Payload>[] payload() default {};
}
