package app.valuationcontrol.multimodule.library.entities;

import app.valuationcontrol.multimodule.library.helpers.DataTransformer;
import app.valuationcontrol.multimodule.library.helpers.LogEntryNotifier;
import app.valuationcontrol.multimodule.library.records.LogEntryData;
import jakarta.persistence.*;
import java.time.LocalDateTime;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Getter;
import lombok.Setter;

@Entity
@Builder
@AllArgsConstructor
@Getter
@Setter
@EntityListeners(LogEntryNotifier.class)
public class LogEntry implements DataTransformer<LogEntryData> {
  @Id
  @GeneratedValue(strategy = GenerationType.IDENTITY)
  private long id;

  @ManyToOne private Model attachedModel;
  private String action;
  private String username;
  private Boolean isModelChange;

  @Column(length = 500)
  private String fromFormula;

  @Column(length = 500)
  private String toFormula;

  private Float fromValue;
  private Float toValue;
  private LocalDateTime changeDate;
  private Integer period;
  private Long variableId;

  public LogEntry() {}

  @Override
  public LogEntryData asData() {
    return new LogEntryData(
        this.id,
        this.action,
        this.username,
        this.isModelChange,
        this.fromFormula,
        this.toFormula,
        this.fromValue,
        this.toValue,
        this.changeDate,
        this.period,
        this.variableId);
  }
}
